/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.ObjectPaths;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.models.MergedDasModel;
import com.intellij.database.view.models.SqlFileModel;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseEditorContext {
    @Nullable
    private final Project myProject;
    @NotNull
    private final DatabaseDialectEx myDialect;
    @NotNull
    private final DasModel myModel;
    @Nullable
    private final DbDataSource myDataSource;
    @Nullable
    private final SearchPath mySearchPath;
    @Nullable
    private final VirtualFile myVirtualFile;

    public DatabaseEditorContext(@NotNull DbElement element, @Nullable VirtualFile virtualFile) {
        if (element == null) {
            DatabaseEditorContext.$$$reportNull$$$0(0);
        }
        this(element.getDataSource().getProject(), DbImplUtil.getDatabaseDialect((DbElement)element.getDataSource()), element.getDataSource().getModel(), element.getDataSource(), ObjectPaths.searchPathOf((DasObject)DbImplUtil.getSearchPathObjectForSwitch(element)), virtualFile);
    }

    public DatabaseEditorContext(@NotNull DbDataSource dataSource, @Nullable DasNamespace namespace, @Nullable VirtualFile virtualFile) {
        if (dataSource == null) {
            DatabaseEditorContext.$$$reportNull$$$0(1);
        }
        this(dataSource.getProject(), DbImplUtil.getDatabaseDialect((DbElement)dataSource), dataSource.getModel(), dataSource, ObjectPaths.searchPathOf((DasObject)DbImplUtil.getSearchPathObjectForSwitch(dataSource, (DasObject)namespace)), virtualFile);
    }

    public DatabaseEditorContext(@NotNull SqlFile file) {
        if (file == null) {
            DatabaseEditorContext.$$$reportNull$$$0(2);
        }
        this(file, DbImplUtil.getForcedDataSource((PsiFile)file), new SqlFileModel(file));
    }

    public DatabaseEditorContext(@NotNull SqlFile file, @Nullable DbDataSource dataSource, @NotNull DasModel model) {
        if (file == null) {
            DatabaseEditorContext.$$$reportNull$$$0(3);
        }
        if (model == null) {
            DatabaseEditorContext.$$$reportNull$$$0(4);
        }
        this(file.getProject(), (DatabaseDialectEx)file.getSqlLanguage().getDatabaseDialect(), model, dataSource, DatabaseEditorHelper.getSearchPath((PsiFile)file), file.getVirtualFile().isWritable() ? file.getVirtualFile() : null);
    }

    @NotNull
    public static DatabaseEditorContext forFile(@NotNull SqlFile file) {
        DbDataSource dataSource2;
        DbDataSource forced;
        if (file == null) {
            DatabaseEditorContext.$$$reportNull$$$0(5);
        }
        JBIterable<DbDataSource> dataSources2 = (forced = DbImplUtil.getForcedDataSource((PsiFile)file)) == null ? DbSqlUtil.getAppropriateDataSources((PsiFile)file, false, true) : JBIterable.of((Object)forced);
        for (DbDataSource dataSource2 : dataSources2) {
            SqlDataSource sqlSource = (SqlDataSource)ObjectUtils.tryCast((Object)dataSource2.getDelegate(), SqlDataSource.class);
            if (sqlSource == null || !sqlSource.containsFile(PsiUtilCore.getVirtualFile((PsiElement)file))) continue;
            DatabaseEditorContext databaseEditorContext = new DatabaseEditorContext((DbElement)dataSource2, file.getVirtualFile());
            if (databaseEditorContext == null) {
                DatabaseEditorContext.$$$reportNull$$$0(6);
            }
            return databaseEditorContext;
        }
        if (dataSources2.isEmpty()) {
            DatabaseEditorContext databaseEditorContext = new DatabaseEditorContext(file);
            if (databaseEditorContext == null) {
                DatabaseEditorContext.$$$reportNull$$$0(7);
            }
            return databaseEditorContext;
        }
        MergedDasModel model = new MergedDasModel((Iterable<? extends DasModel>)dataSources2.transform(DbDataSource::getModel).append((Object)new SqlFileModel(file)));
        dataSource2 = dataSources2.size() == 1 ? (DbDataSource)dataSources2.first() : null;
        DatabaseEditorContext databaseEditorContext = new DatabaseEditorContext(file, dataSource2, model);
        if (databaseEditorContext == null) {
            DatabaseEditorContext.$$$reportNull$$$0(8);
        }
        return databaseEditorContext;
    }

    public DatabaseEditorContext(@Nullable Project project, @NotNull DatabaseDialectEx dialect, @NotNull DasModel model, @Nullable DbDataSource dataSource, @Nullable SearchPath searchPath, @Nullable VirtualFile virtualFile) {
        if (dialect == null) {
            DatabaseEditorContext.$$$reportNull$$$0(9);
        }
        if (model == null) {
            DatabaseEditorContext.$$$reportNull$$$0(10);
        }
        this.myProject = project;
        this.myDialect = dialect;
        this.myModel = model;
        this.myDataSource = dataSource;
        this.mySearchPath = searchPath;
        this.myVirtualFile = virtualFile;
    }

    @Nullable
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public DatabaseDialectEx getDialect() {
        DatabaseDialectEx databaseDialectEx = this.myDialect;
        if (databaseDialectEx == null) {
            DatabaseEditorContext.$$$reportNull$$$0(11);
        }
        return databaseDialectEx;
    }

    @NotNull
    public SqlLanguageDialect getSqlDialect() {
        SqlLanguageDialect dialect;
        if (this.myDataSource != null) {
            SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect((DbElement)this.myDataSource);
            if (sqlLanguageDialect == null) {
                DatabaseEditorContext.$$$reportNull$$$0(12);
            }
            return sqlLanguageDialect;
        }
        if (this.myVirtualFile != null && (dialect = this.myProject != null ? (SqlLanguageDialect)ObjectUtils.tryCast((Object)LanguageUtil.getLanguageForPsi((Project)this.myProject, (VirtualFile)this.myVirtualFile), SqlLanguageDialect.class) : (SqlLanguageDialect)ObjectUtils.tryCast((Object)LanguageUtil.getFileLanguage((VirtualFile)this.myVirtualFile), SqlLanguageDialect.class)) != null) {
            SqlLanguageDialect sqlLanguageDialect = dialect;
            if (sqlLanguageDialect == null) {
                DatabaseEditorContext.$$$reportNull$$$0(13);
            }
            return sqlLanguageDialect;
        }
        SqlLanguageDialect sqlLanguageDialect = DbSqlUtil.getSqlDialect(this.myDialect);
        if (sqlLanguageDialect == null) {
            DatabaseEditorContext.$$$reportNull$$$0(14);
        }
        return sqlLanguageDialect;
    }

    @NotNull
    public DasModel getModel() {
        DasModel dasModel = this.myModel;
        if (dasModel == null) {
            DatabaseEditorContext.$$$reportNull$$$0(15);
        }
        return dasModel;
    }

    @Nullable
    public DbDataSource getDataSource() {
        return this.myDataSource;
    }

    @Nullable
    public SearchPath getSearchPath() {
        return this.mySearchPath;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    @Nullable
    public VirtualFile getOrCreateVirtualFile() {
        if (this.myVirtualFile != null) {
            return this.myVirtualFile;
        }
        if (this.myDataSource != null) {
            return DatabaseEditorHelper.getConsoleVirtualFile((DatabaseSystem)this.myDataSource);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataSource";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/editors/DatabaseEditorContext";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialect";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/editors/DatabaseEditorContext";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "forFile";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDialect";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlDialect";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "forFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

