/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.generators;

import com.intellij.database.DatabasePluginId;
import com.intellij.database.extensions.ExtensionScriptsUtil;
import com.intellij.database.model.DasObject;
import com.intellij.database.psi.DbElement;
import com.intellij.database.view.DatabaseStructure;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.generators.Clipboard;
import com.intellij.database.view.generators.Files;
import com.intellij.database.view.generators.Logger;
import com.intellij.database.view.generators.SchemaScriptBindings;
import com.intellij.ide.extensionResources.ExtensionsRootType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.GuiUtils;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.TextTransferable;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.script.IdeScriptEngine;

public class SchemaScripts {
    private static final String SCRIPT_DIR = "schema";

    private SchemaScripts() {
    }

    @NotNull
    public static List<File> getScriptFiles() {
        File scriptDir = SchemaScripts.getScriptsDirectoryImpl(false);
        List list = JBIterable.of((Object[])(scriptDir == null ? null : scriptDir.listFiles())).filter(ExtensionsRootType.regularFileFilter()).toList();
        if (list == null) {
            SchemaScripts.$$$reportNull$$$0(0);
        }
        return list;
    }

    @Nullable
    public static File getScriptsDirectory() {
        return SchemaScripts.getScriptsDirectoryImpl(true);
    }

    @Nullable
    private static File getScriptsDirectoryImpl(boolean createIfMissing) {
        try {
            return ExtensionsRootType.getInstance().findResourceDirectory(DatabasePluginId.get(), SCRIPT_DIR, createIfMissing);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static boolean areAvailableIn(@NotNull DataContext context) {
        if (context == null) {
            SchemaScripts.$$$reportNull$$$0(1);
        }
        return !SchemaScripts.getSelection(context).isEmpty();
    }

    public static void runScript(@NotNull DataContext context, final @NotNull File scriptFile) {
        JBIterable selection;
        Project project;
        IdeScriptEngine engine;
        if (context == null) {
            SchemaScripts.$$$reportNull$$$0(2);
        }
        if (scriptFile == null) {
            SchemaScripts.$$$reportNull$$$0(3);
        }
        if ((engine = SchemaScripts.prepareEngine(project = (Project)CommonDataKeys.PROJECT.getData(context), scriptFile, (JBIterable<DasObject>)(selection = SchemaScripts.getSelection(context).filter(DasObject.class)))) == null) {
            return;
        }
        ExtensionScriptsUtil.prepareScript(scriptFile);
        Task.Backgroundable task = new Task.Backgroundable(project, "Running '" + scriptFile.getName() + "'", true){

            public boolean shouldStartInBackground() {
                return true;
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (project != null && project.isDisposed() || selection.find(o -> !((DbElement)o).isValid()) != null) {
                    return;
                }
                try {
                    String script = ExtensionScriptsUtil.loadScript(project, scriptFile);
                    ExtensionScriptsUtil.evalScript(project, engine, script);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/view/generators/SchemaScripts$1", "run"));
            }
        };
        ProgressManager.getInstance().run((Task)task);
    }

    @Nullable
    private static IdeScriptEngine prepareEngine(@Nullable Project project, @NotNull File scriptFile, @NotNull JBIterable<DasObject> selection) {
        IdeScriptEngine engine;
        if (scriptFile == null) {
            SchemaScripts.$$$reportNull$$$0(4);
        }
        if (selection == null) {
            SchemaScripts.$$$reportNull$$$0(5);
        }
        if ((engine = ExtensionScriptsUtil.getEngineFor(project, scriptFile)) != null) {
            ExtensionScriptsUtil.setBindings(engine).bind(SchemaScriptBindings.PROJECT, project).bind(SchemaScriptBindings.SELECTION, selection).bind(SchemaScriptBindings.CLIPBOARD, new ClipboardImpl()).bind(SchemaScriptBindings.LOG, new LoggerImpl(engine)).bind(SchemaScriptBindings.FILES, new FilesImpl(project));
        }
        return engine;
    }

    @NotNull
    private static JBIterable<DbElement> getSelection(@NotNull DataContext context) {
        if (context == null) {
            SchemaScripts.$$$reportNull$$$0(6);
        }
        JBIterable<DbElement> jBIterable = DatabaseView.getSelectedElements(context, (Condition<DatabaseStructure.Group>)Conditions.alwaysTrue());
        if (jBIterable == null) {
            SchemaScripts.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/view/generators/SchemaScripts";
                break;
            }
            case 1: 
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getScriptFiles";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/view/generators/SchemaScripts";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "areAvailableIn";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runScript";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "prepareEngine";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSelection";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FilesImpl
    implements Files {
        private final Project myProject;

        private FilesImpl(@Nullable Project project) {
            this.myProject = project;
        }

        public void chooseFileAndSave(@NotNull String title, @NotNull String description, @NotNull Consumer<File> saveAction) {
            if (title == null) {
                FilesImpl.$$$reportNull$$$0(0);
            }
            if (description == null) {
                FilesImpl.$$$reportNull$$$0(1);
            }
            if (saveAction == null) {
                FilesImpl.$$$reportNull$$$0(2);
            }
            FileSaverDescriptor descriptor = new FileSaverDescriptor(title, description, new String[0]);
            this.chooseFileAndSaveImpl((FileChooserDescriptor)descriptor, saveAction);
        }

        public void chooseDirectoryAndSave(@NotNull String title, @NotNull String description, @NotNull Consumer<File> saveAction) {
            if (title == null) {
                FilesImpl.$$$reportNull$$$0(3);
            }
            if (description == null) {
                FilesImpl.$$$reportNull$$$0(4);
            }
            if (saveAction == null) {
                FilesImpl.$$$reportNull$$$0(5);
            }
            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(title).withDescription(description);
            this.chooseFileAndSaveImpl(descriptor, saveAction);
        }

        public void refresh(@NotNull File file) {
            if (file == null) {
                FilesImpl.$$$reportNull$$$0(6);
            }
            VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualFile});
        }

        private void chooseFileAndSaveImpl(@NotNull FileChooserDescriptor descriptor, @NotNull Consumer<File> saveAction) {
            if (descriptor == null) {
                FilesImpl.$$$reportNull$$$0(7);
            }
            if (saveAction == null) {
                FilesImpl.$$$reportNull$$$0(8);
            }
            Ref fileRef = Ref.create();
            Runnable runnable = () -> {
                if (descriptor == null) {
                    FilesImpl.$$$reportNull$$$0(9);
                }
                FileChooserFactory.getInstance().createPathChooser(descriptor, this.myProject, null).choose(null, files -> fileRef.set(ContainerUtil.getFirstItem((List)files)));
            };
            try {
                GuiUtils.runOrInvokeAndWait((Runnable)runnable);
                if (!fileRef.isNull()) {
                    File file = VfsUtilCore.virtualToIoFile((VirtualFile)((VirtualFile)fileRef.get()));
                    saveAction.consume((Object)file);
                    this.refresh(file);
                }
            }
            catch (Throwable t) {
                ExceptionUtil.rethrowAllAsUnchecked((Throwable)t);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "title";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 2: 
                case 5: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "saveAction";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 7: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/view/generators/SchemaScripts$FilesImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "chooseFileAndSave";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "chooseDirectoryAndSave";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "refresh";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[2] = "chooseFileAndSaveImpl";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$chooseFileAndSaveImpl$1";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class LoggerImpl
    implements Logger {
        private final IdeScriptEngine myEngine;

        private LoggerImpl(@NotNull IdeScriptEngine engine) {
            if (engine == null) {
                LoggerImpl.$$$reportNull$$$0(0);
            }
            this.myEngine = engine;
        }

        public void print(@NotNull String message) {
            if (message == null) {
                LoggerImpl.$$$reportNull$$$0(1);
            }
            try {
                this.myEngine.getStdOut().append(message);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void error(@NotNull String message) {
            if (message == null) {
                LoggerImpl.$$$reportNull$$$0(2);
            }
            this.error(message, null);
        }

        public void error(@NotNull String message, @Nullable Throwable th) {
            if (message == null) {
                LoggerImpl.$$$reportNull$$$0(3);
            }
            try {
                Writer err = this.myEngine.getStdErr();
                err.append(message).append("\n");
                if (th != null) {
                    err.append(ExceptionUtil.getThrowableText((Throwable)th));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "engine";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/view/generators/SchemaScripts$LoggerImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "print";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "error";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class ClipboardImpl
    implements Clipboard {
        private ClipboardImpl() {
        }

        @NotNull
        public String get() {
            String string;
            try {
                Transferable contents = CopyPasteManager.getInstance().getContents();
                string = contents != null ? (String)contents.getTransferData(DataFlavor.stringFlavor) : "";
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (string == null) {
                ClipboardImpl.$$$reportNull$$$0(0);
            }
            return string;
            if ("" == null) {
                ClipboardImpl.$$$reportNull$$$0(1);
            }
            return "";
        }

        public void set(@Nullable String text) {
            CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable(StringUtil.notNullize((String)text)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/generators/SchemaScripts$ClipboardImpl", "get"));
        }
    }
}

