/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.database;

import com.intellij.database.dataSource.AbstractDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.database.SqlDataSourceUpdateQueue;
import com.intellij.sql.database.SqlModelBuilder;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlElement;
import com.intellij.sql.psi.SqlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import icons.DatabaseIcons;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlDataSourceImpl
extends AbstractDataSource
implements SqlDataSource,
PersistentStateComponent<State>,
Iconable {
    private final Project myProject;
    private String myParentID;
    private final Map<String, SmartPsiElementPointer<PsiFile>> myFiles;
    private volatile ComputedModel myComputedModel;

    public SqlDataSourceImpl(@NotNull String name, @NotNull Project project, @Nullable DatabaseSystem parent) {
        if (name == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(0);
        }
        if (project == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(1);
        }
        this.myFiles = ContainerUtil.newLinkedHashMap();
        this.setName(name);
        this.myProject = project;
        this.myParentID = parent == null ? null : parent.getUniqueId();
    }

    @Nullable
    public RawConnectionConfig getConnectionConfig() {
        return null;
    }

    public void resetCaches() {
        ReadAction.run(() -> {
            for (Map.Entry<String, SmartPsiElementPointer<PsiFile>> entry : this.myFiles.entrySet()) {
                SmartPsiElementPointer<PsiFile> v = entry.getValue();
                if (v != null && v.getElement() != null) continue;
                entry.setValue(this.createPointer(entry.getKey()));
            }
        });
        this.myComputedModel.check();
    }

    public String getDatabaseProductName() {
        DbDataSource parent = this.getParentDataSource();
        return parent != null ? parent.getDatabaseProductName() : null;
    }

    public String getDatabaseProductVersion() {
        DbDataSource parent = this.getParentDataSource();
        return parent != null ? parent.getDatabaseProductVersion() : null;
    }

    @Nullable
    public DbDataSource getParentDataSource() {
        return this.myParentID == null ? null : DbPsiFacade.getInstance((Project)this.myProject).findDataSource(this.myParentID);
    }

    public void setParentDataSource(DatabaseSystem parent) {
        this.myParentID = parent == null ? null : parent.getUniqueId();
    }

    public String getParentID() {
        return this.myParentID;
    }

    @NotNull
    public List<String> getUrls() {
        List list = JBIterable.from(this.myFiles.keySet()).toList();
        if (list == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(2);
        }
        return list;
    }

    public void setUrls(@NotNull List<String> urls) {
        if (urls == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(3);
        }
        this.incModificationCount();
        ComputedModel model = this.myComputedModel;
        if (model != null) {
            model.incModificationCount();
        }
        ReadAction.run(() -> {
            if (urls == null) {
                SqlDataSourceImpl.$$$reportNull$$$0(13);
            }
            this.myFiles.clear();
            for (String url : urls) {
                this.myFiles.put(url, this.createPointer(url));
            }
        });
    }

    @Nullable
    private SmartPsiElementPointer<PsiFile> createPointer(@NotNull String url) {
        if (url == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(4);
        }
        VirtualFileManager vfsManager = VirtualFileManager.getInstance();
        PsiManager psiManager = PsiManager.getInstance((Project)this.myProject);
        SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)this.myProject);
        VirtualFile file = vfsManager.findFileByUrl(url);
        PsiFile psiFile = file == null ? null : psiManager.findFile(file);
        return psiFile == null ? null : pointerManager.createSmartPsiElementPointer((PsiElement)psiFile);
    }

    @NotNull
    public List<SqlFile> getSqlFiles() {
        List list = this.getPsiFilesInner().filter(SqlFile.class).toList();
        if (list == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(5);
        }
        return list;
    }

    @NotNull
    public List<VirtualFile> getFiles() {
        List list = this.getFilesInner().toList();
        if (list == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private JBIterable<VirtualFile> getFilesInner() {
        JBIterable jBIterable = JBIterable.from(this.myFiles.values()).filterMap(o -> o == null ? null : o.getVirtualFile());
        if (jBIterable == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(7);
        }
        return jBIterable;
    }

    @NotNull
    private JBIterable<PsiFile> getPsiFilesInner() {
        JBIterable jBIterable = JBIterable.from(this.myFiles.values()).filterMap(o -> o == null ? null : o.getContainingFile());
        if (jBIterable == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(8);
        }
        return jBIterable;
    }

    public boolean containsFile(@Nullable VirtualFile file) {
        return file != null && this.myFiles.containsKey(file.getUrl());
    }

    @NotNull
    public DasModel getModel() {
        DasModel dasModel = this.myComputedModel == null ? DasUtil.emptyModel() : this.myComputedModel.getModel();
        if (dasModel == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(9);
        }
        return dasModel;
    }

    public void setFiles(VirtualFile[] virtualFiles) {
        this.setUrls(JBIterable.of((Object[])virtualFiles).filterMap(VirtualFile::getUrl).toList());
    }

    public SqlDataSourceImpl copy() {
        SqlDataSourceImpl result2 = new SqlDataSourceImpl(this.getName(), this.myProject, null);
        result2.myParentID = this.myParentID;
        result2.myFiles.putAll(this.myFiles);
        return result2;
    }

    public State getState() {
        State state = new State();
        state.id = this.getUniqueId();
        state.name = this.getName();
        state.parent = this.myParentID;
        state.urls = ArrayUtil.toStringArray(this.getUrls());
        state.remarks = this.getComment();
        state.group = this.getGroupName();
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(10);
        }
        this.setUniqueId(state.id);
        this.setName(state.name);
        this.setComment(state.remarks);
        this.setGroupName(StringUtil.nullize((String)state.group));
        this.setUrls(JBIterable.of((Object[])state.urls).toList());
        this.myParentID = state.parent;
    }

    void onRemovedFromStorage() {
        if (this.myComputedModel != null) {
            Disposer.dispose((Disposable)this.myComputedModel);
            this.myComputedModel = null;
        }
    }

    void onAddedToStorage() {
        if (this.myComputedModel != null) {
            throw new AssertionError((Object)"already added");
        }
        Disposer.register((Disposable)this.myProject, () -> this.onRemovedFromStorage());
        this.myComputedModel = new ComputedModel();
    }

    @Nullable
    public DatabaseDialectEx getDatabaseDialect() {
        SqlLanguageDialect dialect = this.getSqlDialectFromFiles();
        if (dialect != null) {
            return (DatabaseDialectEx)dialect.getDatabaseDialect();
        }
        DbDataSource parent = this.getParentDataSource();
        return parent == null ? null : DbImplUtil.getDatabaseDialect((DbElement)parent);
    }

    @Nullable
    public SqlLanguageDialect getSqlDialect() {
        SqlLanguageDialect dialect = this.getSqlDialectFromFiles();
        if (dialect != null) {
            return dialect;
        }
        DbDataSource parent = this.getParentDataSource();
        return parent == null ? null : DbSqlUtil.getSqlDialect((DbElement)parent);
    }

    @Nullable
    private SqlLanguageDialect getSqlDialectFromFiles() {
        return (SqlLanguageDialect)this.getFilesInner().filterMap(o -> LanguageUtil.getLanguageForPsi((Project)this.myProject, (VirtualFile)o)).filter(SqlLanguageDialect.class).first();
    }

    public Icon getIcon(int flags) {
        return DatabaseIcons.DdlDbms;
    }

    private static long getPartialVersion(@NotNull Iterable<? extends PsiFile> files, @Nullable SqlFile latest) {
        if (files == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(11);
        }
        long result2 = 0L;
        for (PsiFile psiFile : files) {
            result2 += 1000L + psiFile.getModificationStamp();
            if (psiFile != latest) continue;
            break;
        }
        return result2;
    }

    public long getModificationCount() {
        ComputedModel model = this.myComputedModel;
        return super.getModificationCount() + (model == null ? 0L : model.getModificationCount());
    }

    public boolean equalConfiguration(@NotNull SqlDataSourceImpl o) {
        if (o == null) {
            SqlDataSourceImpl.$$$reportNull$$$0(12);
        }
        if (!StringUtil.equals((CharSequence)this.getComment(), (CharSequence)o.getComment())) {
            return false;
        }
        if (!StringUtil.equals((CharSequence)this.myParentID, (CharSequence)o.myParentID)) {
            return false;
        }
        return this.getUrls().equals(o.getUrls());
    }

    @Nullable
    public SqlElement fromModel(@Nullable DasObject delegate) {
        if (delegate == null || this.myComputedModel == null) {
            return null;
        }
        return this.myComputedModel.fromModel(delegate);
    }

    public void waitComputed() {
        ComputedModel model = this.myComputedModel;
        if (model == null) {
            return;
        }
        while (!model.isReady()) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
        }
        return;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/database/SqlDataSourceImpl";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/database/SqlDataSourceImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUrls";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSqlFiles";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesInner";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiFilesInner";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setUrls";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createPointer";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getPartialVersion";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "equalConfiguration";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lambda$setUrls$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class ComputedModel
    extends SqlDataSourceUpdateQueue.ComputedModel {
        private ComputedModel() {
        }

        public long getModificationCount() {
            return SqlDataSourceImpl.getPartialVersion((Iterable)SqlDataSourceImpl.this.getPsiFilesInner(), null) + super.getModificationCount();
        }

        protected boolean introspectPortion(SqlModelBuilder builder) {
            List<SqlFile> files = SqlDataSourceImpl.this.getSqlFiles();
            Pair prev = this.myIncomplete;
            int doneIdx = -1;
            if (prev != null && (doneIdx = files.indexOf(prev.first)) != -1 && SqlDataSourceImpl.getPartialVersion(files, (SqlFile)prev.first) != (Long)prev.second) {
                doneIdx = -1;
                builder.end();
                builder.begin(false);
            }
            int fromIdx = doneIdx + 1;
            this.myIncomplete = null;
            if (files.isEmpty()) {
                this.myElements = Collections.emptyMap();
                return true;
            }
            try {
                fromIdx = builder.introspect(files, fromIdx, fromIdx == 0, 2000L);
                SqlFile done = files.get(fromIdx - 1);
                this.myIncomplete = Pair.create((Object)done, (Object)SqlDataSourceImpl.getPartialVersion(files, done));
                this.myElements = builder.getMapping();
                SqlDataSourceImpl.this.incModificationCount();
                if (fromIdx == files.size()) {
                    this.myIncomplete = null;
                }
            }
            catch (RuntimeException pce) {
                if (this.myIncomplete == null) {
                    this.myIncomplete = prev;
                }
                throw pce;
            }
            return this.myIncomplete == null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean introspect(@NotNull ProgressIndicator indicator) {
            boolean bl;
            if (indicator == null) {
                ComputedModel.$$$reportNull$$$0(0);
            }
            Ref sqlDialect = Ref.create();
            Ref dbDialect = Ref.create();
            ReadAction.run(() -> {
                if (SqlDataSourceImpl.this.myProject.isDisposed()) {
                    return;
                }
                sqlDialect.set(ObjectUtils.chooseNotNull((Object)SqlDataSourceImpl.this.getSqlDialect(), (Object)DbSqlUtil.getGenericDialect()));
                dbDialect.set((Object)SqlDataSourceImpl.this.getDatabaseDialect());
            });
            if (sqlDialect.isNull()) {
                return false;
            }
            SqlModelBuilder builder = new SqlModelBuilder(SqlDataSourceImpl.this.myProject, (SqlLanguageDialect)sqlDialect.get(), this.ensureProperModel((DatabaseDialectEx)dbDialect.get()), (Map<BasicElement, SmartPsiElementPointer<SqlElement>>)this.myElements);
            try {
                builder.begin(false);
                indicator.setText("Building `" + SqlDataSourceImpl.this.getName() + "`");
                Ref finished = Ref.create((Object)false);
                while (!((Boolean)finished.get()).booleanValue()) {
                    if (indicator.isCanceled()) {
                        bl = false;
                        return bl;
                    }
                    boolean ok = ProgressManager.getInstance().runInReadActionWithWriteActionPriority(() -> finished.set((Object)this.introspectPortion(builder)), indicator);
                    if (!ok) {
                        boolean bl2 = false;
                        return bl2;
                    }
                    if (((Boolean)finished.get()).booleanValue()) continue;
                    this.changed();
                }
            }
            catch (ProcessCanceledException pce) {
                indicator.setText2("Interrupted");
                bl = false;
                return bl;
            }
            finally {
                builder.end();
            }
            return true;
        }

        @Override
        protected Project getProject() {
            return SqlDataSourceImpl.this.myProject;
        }

        @Override
        protected void changed() {
            ApplicationManager.getApplication().invokeAndWait(() -> {
                if (SqlDataSourceImpl.this.myProject.isDisposed()) {
                    return;
                }
                DbPsiFacade facade = DbPsiFacade.getInstance((Project)SqlDataSourceImpl.this.myProject);
                DbDataSource dataSource = facade.findDataSource(SqlDataSourceImpl.this.getUniqueId());
                if (dataSource != null) {
                    facade.clearCaches(dataSource);
                }
            }, ModalityState.NON_MODAL);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/sql/database/SqlDataSourceImpl$ComputedModel", "introspect"));
        }
    }

    public static class State {
        public String id;
        public String name;
        public String parent;
        public String[] urls;
        public String remarks;
        public String group;
    }
}

