/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.h2;

import com.intellij.lexer.Lexer;
import com.intellij.sql.dialects.h2.H2ElementTypes;
import com.intellij.sql.dialects.h2.H2OptionalKeywords;
import com.intellij.sql.dialects.h2.H2ReservedKeywords;
import com.intellij.sql.dialects.h2.H2Tokens;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.impl.lexer.SqlLexer;
import com.intellij.sql.psi.impl.lexer._H2Lexer;
import org.jetbrains.annotations.Nullable;

public class H2Lexer
extends SqlLexer {
    public H2Lexer() {
        super(H2Tokens.class, H2ReservedKeywords.class, new _H2Lexer());
    }

    @Override
    protected void lookAhead(Lexer baseLexer) {
        if (!this.lookAheadCustomQuotation(baseLexer)) {
            super.lookAhead(baseLexer);
        }
    }

    private boolean lookAheadCustomQuotation(Lexer baseLexer) {
        String ident = H2Lexer.getDollarQuotingIdent(baseLexer);
        if (ident == null) {
            return false;
        }
        int identLen = ident.length();
        int stringStart = baseLexer.getTokenStart() + identLen;
        baseLexer.advance();
        return this.processCustomQuotation(baseLexer, ident, stringStart);
    }

    @Nullable
    private static String getDollarQuotingIdent(Lexer baseLexer) {
        if (baseLexer.getTokenType() != SqlTokens.SQL_IDENT_DELIMITED) {
            return null;
        }
        String identText = baseLexer.getTokenText();
        return "$$".equals(identText) ? identText : null;
    }

    static {
        H2Lexer.initTokensAndFunctions(H2ElementTypes.H2_SQL_FILE, H2Tokens.class, H2ReservedKeywords.class, H2OptionalKeywords.class);
    }
}

