/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mssql;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.ObjectName;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.vfs.SearchPath;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveState;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.dialects.ReservedEntity;
import com.intellij.sql.dialects.SqlDialectImplUtil;
import com.intellij.sql.dialects.SqlImportUtil;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.TreePattern;
import com.intellij.sql.dialects.TreePatternNode;
import com.intellij.sql.dialects.TreePatternUtils;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.functions.SqlFunctionsUtil;
import com.intellij.sql.dialects.mssql.MssqlElementTypes;
import com.intellij.sql.dialects.mssql.MssqlReservedKeywords;
import com.intellij.sql.dialects.mssql.MssqlTokens;
import com.intellij.sql.dialects.mssql.MssqlTypes;
import com.intellij.sql.dialects.sybase.SybaseDialect;
import com.intellij.sql.editor.SqlCloseBlockProcessorImpl;
import com.intellij.sql.editor.SqlEnterHandlerImpl;
import com.intellij.sql.editor.SubstitutionDescriptorImpl;
import com.intellij.sql.psi.SqlDbElementType;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlElementTypes;
import com.intellij.sql.psi.SqlExpressionList;
import com.intellij.sql.psi.SqlFunctionCallExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStatement;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.sql.psi.SqlType;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlKeywordTokenType;
import com.intellij.sql.psi.impl.SqlNamedParameterValueExpression;
import com.intellij.sql.psi.impl.SqlScopeProcessor;
import com.intellij.sql.util.SqlTokenRegistry;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MssqlDialect
extends SqlLanguageDialectEx {
    public static final MssqlDialect INSTANCE = new MssqlDialect();

    public MssqlDialect() {
        super("TSQL");
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "hierarchyid", "hierarchyid", (SqlLanguageDialectEx)this);
        SqlFunctionDefinition.addSimpleType((Map<String, SqlFunctionDefinition.Type>)this.myTypes, "xml", "xml", (SqlLanguageDialectEx)this);
    }

    @NotNull
    public String getDisplayName() {
        if ("SQL Server" == null) {
            MssqlDialect.$$$reportNull$$$0(0);
        }
        return "SQL Server";
    }

    @Override
    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        com.intellij.database.dialects.MssqlDialect mssqlDialect = com.intellij.database.dialects.MssqlDialect.INSTANCE;
        if (mssqlDialect == null) {
            MssqlDialect.$$$reportNull$$$0(1);
        }
        return mssqlDialect;
    }

    public boolean isReservedKeyword(IElementType tokenType) {
        return tokenType instanceof SqlKeywordTokenType && LazyData.ourReservedTokens.fun((Object)tokenType.toString()) != null;
    }

    @Override
    @NotNull
    public Map<String, SqlFunctionDefinition> getSupportedFunctions() {
        Map<String, SqlFunctionDefinition> map = Collections.unmodifiableMap(LazyData.ourFunctionMap);
        if (map == null) {
            MssqlDialect.$$$reportNull$$$0(2);
        }
        return map;
    }

    public boolean isOperatorSupported(IElementType tokenType) {
        return LazyData.ourSupportedOperators.contains(tokenType);
    }

    @NotNull
    public Set<String> getKeywords() {
        Set set = SqlTokenRegistry.getTokens(MssqlTokens.class);
        if (set == null) {
            MssqlDialect.$$$reportNull$$$0(3);
        }
        return set;
    }

    @NotNull
    public Set<String> getSystemVariables() {
        Set<String> set = LazyData.ourSystemVars;
        if (set == null) {
            MssqlDialect.$$$reportNull$$$0(4);
        }
        return set;
    }

    @Override
    public boolean processReservedEntitiesWithType(@Nullable String name, @NotNull PsiElement element, boolean resolve, @NotNull SqlScopeProcessor processor) {
        if (element == null) {
            MssqlDialect.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            MssqlDialect.$$$reportNull$$$0(6);
        }
        if (SqlImplUtil.equalsInsensitiveOrTrue(name, LazyData.RE_ACTION.name, resolve) && !processor.executeTarget(LazyData.RE_ACTION, element, this.STRING, false, ResolveState.initial())) {
            return false;
        }
        if (SqlImplUtil.equalsInsensitiveOrTrue(name, LazyData.RE_IDENTITY.name, resolve) && !processor.executeTarget(LazyData.RE_IDENTITY, element, this.STRING, false, ResolveState.initial())) {
            return false;
        }
        if (SqlImplUtil.equalsInsensitiveOrTrue(name, LazyData.RE_ROWGUID.name, resolve) && !processor.executeTarget(LazyData.RE_ROWGUID, element, this.STRING, false, ResolveState.initial())) {
            return false;
        }
        if (SqlImplUtil.equalsInsensitiveOrTrue(name, LazyData.RE_XML.name, resolve) && !processor.executeTarget(LazyData.RE_XML, element, null, false, ResolveState.initial())) {
            return false;
        }
        return super.processReservedEntitiesWithType(name, element, resolve, processor);
    }

    @Override
    public TokenSet getStatementSeparators() {
        return LazyData.ourClosingTokens;
    }

    @Override
    public String quoteIdentifier(@NotNull SqlIdentifier identifier, @NotNull String newElementName) {
        ObjectKind type;
        PsiElement parent;
        if (identifier == null) {
            MssqlDialect.$$$reportNull$$$0(7);
        }
        if (newElementName == null) {
            MssqlDialect.$$$reportNull$$$0(8);
        }
        Object object = (parent = identifier.getParent()) instanceof SqlReferenceExpression ? ((SqlReferenceExpression)parent).getReferenceElementType().getTargetKind() : (type = parent instanceof SqlDefinition ? ((SqlDefinition)parent).getKind() : null);
        if (type == ObjectKind.VARIABLE) {
            return newElementName.replace(' ', '_');
        }
        return super.quoteIdentifier(identifier, newElementName);
    }

    @Override
    public boolean shallResolve(@Nullable SqlReferenceExpression o, ObjectKind type) {
        if (type == SqlDbElementType.ANY && MssqlDialect.isExecArg(o)) {
            return false;
        }
        return MssqlElementTypes.Extra.FILEGROUP != type && MssqlElementTypes.Extra.FILE != type && super.shallResolve(o, type);
    }

    public static boolean isExecArg(@Nullable SqlReferenceExpression o) {
        if (o == null) {
            return false;
        }
        PsiElement top = (PsiElement)SqlImplUtil.sqlParents((PsiElement)o).skipWhile(x -> x == o || x instanceof SqlNamedParameterValueExpression || x instanceof SqlExpressionList || x instanceof SqlFunctionCallExpression).first();
        return top instanceof SqlStatement;
    }

    @Override
    public <T extends Collection<ObjectKind>> T getParentDbTypes(T result2, ObjectKind type) {
        super.getParentDbTypes(result2, type);
        if (type == ObjectKind.INDEX) {
            result2.add((ObjectKind)ObjectKind.TABLE);
        }
        if (type == ObjectKind.ROUTINE) {
            result2.add((ObjectKind)ObjectKind.COLUMN);
        }
        return result2;
    }

    @Override
    public boolean shouldQuotedTypeReferenceBeChecked(@NotNull String ref) {
        if (ref == null) {
            MssqlDialect.$$$reportNull$$$0(9);
        }
        return !this.getKeywords().contains(ref);
    }

    @Override
    @Nullable
    public EnterHandlerDelegate getEnterHandler() {
        return LazyData.ENTER_HANDLER;
    }

    @Override
    public boolean isMajorChild(@NotNull ObjectKind kind) {
        if (kind == null) {
            MssqlDialect.$$$reportNull$$$0(10);
        }
        return kind == ObjectKind.TRIGGER;
    }

    @Override
    @NotNull
    public TreePattern getBaseImports(@Nullable DbDataSource dataSource, @Nullable ObjectName[] dsNames) {
        List<ObjectName> schemas = MssqlDialect.getSchemaNames(dataSource);
        ObjectName dbname = MssqlDialect.getDatabaseName(dataSource);
        DasNamespace namespace = MssqlDialect.getDefaultNamespace(dataSource, dbname);
        if (namespace != null) {
            TreePattern treePattern = SqlDialectImplUtil.createObjectPattern(dsNames, (DasObject)namespace, namespace.getKind() == ObjectKind.SCHEMA ? null : TreePatternUtils.create(schemas, ObjectKind.SCHEMA, new TreePatternNode.Group[0]));
            if (treePattern == null) {
                MssqlDialect.$$$reportNull$$$0(11);
            }
            return treePattern;
        }
        TreePattern treePattern = new TreePattern(SqlImportUtil.createDataSources(dsNames, SqlImportUtil.optAr(SqlImportUtil.createPositiveDatabase(dataSource == null, dbname, TreePatternUtils.create(schemas, ObjectKind.SCHEMA, new TreePatternNode.Group[0])))));
        if (treePattern == null) {
            MssqlDialect.$$$reportNull$$$0(12);
        }
        return treePattern;
    }

    @Nullable
    private static ObjectName getDatabaseName(@Nullable DbDataSource dataSource) {
        return ObjectName.plain((String)((String)ObjectUtils.chooseNotNull((Object)SqlDialectImplUtil.getDatabaseName(SqlImportUtil.getConnectionConfig(dataSource)), (Object)"master")));
    }

    @NotNull
    private static List<ObjectName> getSchemaNames(@Nullable DbDataSource dataSource) {
        List schemas = ContainerUtil.newSmartList((Object)ObjectName.quoted((String)"dbo"));
        String username = SqlDialectImplUtil.getUserName(SqlImportUtil.getConnectionConfig(dataSource));
        if (username != null) {
            schemas.add(ObjectName.plain((String)username));
        }
        List list = schemas;
        if (list == null) {
            MssqlDialect.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Override
    @NotNull
    public TreePattern forcedContextPattern(@Nullable DbDataSource dataSource, @Nullable SearchPath searchPath) {
        TreePatternNode.Group[] schemas = (TreePatternNode.Group[])ContainerUtil.ar((Object[])new TreePatternNode.Group[]{TreePatternUtils.create(MssqlDialect.getSchemaNames(dataSource), ObjectKind.SCHEMA, new TreePatternNode.Group[0])});
        TreePatternNode.Group[] databases = (TreePatternNode.Group[])ContainerUtil.ar((Object[])new TreePatternNode.Group[]{TreePatternUtils.create(MssqlDialect.getDatabaseName(dataSource), ObjectKind.DATABASE, schemas)});
        TreePattern treePattern = SybaseDialect.forcedContextExpandedToSchemas(dataSource, this.getDatabaseDialect(), searchPath, schemas, databases);
        if (treePattern == null) {
            MssqlDialect.$$$reportNull$$$0(14);
        }
        return treePattern;
    }

    @Override
    @NotNull
    public TreePattern srcFilePattern(@Nullable DbDataSource dataSource, @NotNull SearchPath searchPath) {
        if (searchPath == null) {
            MssqlDialect.$$$reportNull$$$0(15);
        }
        TreePattern treePattern = this.forcedContextPattern(dataSource, searchPath);
        if (treePattern == null) {
            MssqlDialect.$$$reportNull$$$0(16);
        }
        return treePattern;
    }

    @Override
    @Nullable
    public String getDefaultTypeName(@NotNull SqlType.Category cat) {
        if (cat == null) {
            MssqlDialect.$$$reportNull$$$0(17);
        }
        switch (cat) {
            case INTEGER: {
                return "int";
            }
            case REAL: {
                return "numeric";
            }
            case STRING: {
                return "varchar";
            }
            case BOOLEAN: {
                return "int";
            }
            case DATE_TIME: {
                return "datetime";
            }
            case DATE: {
                return "date";
            }
            case TIME: {
                return "time";
            }
            case TIMESTAMP: {
                return "timestamp";
            }
            case INTERVAL: {
                return "datetimeoffset";
            }
            case BYTES: {
                return "binary";
            }
            case TABLE: {
                return "table";
            }
        }
        return null;
    }

    @Override
    @NotNull
    public String getNormalizedTypeName(@NotNull String name) {
        if (name == null) {
            MssqlDialect.$$$reportNull$$$0(18);
        }
        if ((name = super.getNormalizedTypeName(name)).equals("integer")) {
            if ("int" == null) {
                MssqlDialect.$$$reportNull$$$0(19);
            }
            return "int";
        }
        if (name.equals("dec")) {
            if ("decimal" == null) {
                MssqlDialect.$$$reportNull$$$0(20);
            }
            return "decimal";
        }
        if (name.equals("binary varying")) {
            if ("varbinary" == null) {
                MssqlDialect.$$$reportNull$$$0(21);
            }
            return "varbinary";
        }
        if (name.equals("double precision")) {
            if ("float" == null) {
                MssqlDialect.$$$reportNull$$$0(22);
            }
            return "float";
        }
        if (name.equals("character")) {
            if ("char" == null) {
                MssqlDialect.$$$reportNull$$$0(23);
            }
            return "char";
        }
        if (name.equals("char varying")) {
            if ("varchar" == null) {
                MssqlDialect.$$$reportNull$$$0(24);
            }
            return "varchar";
        }
        if (name.equals("character varying")) {
            if ("varchar" == null) {
                MssqlDialect.$$$reportNull$$$0(25);
            }
            return "varchar";
        }
        if (name.equals("national char")) {
            if ("nchar" == null) {
                MssqlDialect.$$$reportNull$$$0(26);
            }
            return "nchar";
        }
        if (name.equals("national character")) {
            if ("nchar" == null) {
                MssqlDialect.$$$reportNull$$$0(27);
            }
            return "nchar";
        }
        if (name.equals("national char varying")) {
            if ("nvarchar" == null) {
                MssqlDialect.$$$reportNull$$$0(28);
            }
            return "nvarchar";
        }
        if (name.equals("national character varying")) {
            if ("nvarchar" == null) {
                MssqlDialect.$$$reportNull$$$0(29);
            }
            return "nvarchar";
        }
        if (name.equals("national text")) {
            if ("ntext" == null) {
                MssqlDialect.$$$reportNull$$$0(30);
            }
            return "ntext";
        }
        if (name.equals("rowversion")) {
            if ("timestamp" == null) {
                MssqlDialect.$$$reportNull$$$0(31);
            }
            return "timestamp";
        }
        String string = name;
        if (string == null) {
            MssqlDialect.$$$reportNull$$$0(32);
        }
        return string;
    }

    @Override
    @NotNull
    public SqlType.Category getTypeCategoryByName(@NotNull String typeName) {
        if (typeName == null) {
            MssqlDialect.$$$reportNull$$$0(33);
        }
        if ("money".equals(typeName)) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                MssqlDialect.$$$reportNull$$$0(34);
            }
            return category;
        }
        if ("smallmoney".equals(typeName)) {
            SqlType.Category category = SqlType.Category.REAL;
            if (category == null) {
                MssqlDialect.$$$reportNull$$$0(35);
            }
            return category;
        }
        if ("datetimeoffset".equals(typeName)) {
            SqlType.Category category = SqlType.Category.INTERVAL;
            if (category == null) {
                MssqlDialect.$$$reportNull$$$0(36);
            }
            return category;
        }
        if ("sysname".equals(typeName)) {
            SqlType.Category category = SqlType.Category.STRING;
            if (category == null) {
                MssqlDialect.$$$reportNull$$$0(37);
            }
            return category;
        }
        SqlType.Category category = super.getTypeCategoryByName(typeName);
        if (category == null) {
            MssqlDialect.$$$reportNull$$$0(38);
        }
        return category;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 33: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 33: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/dialects/mssql/MssqlDialect";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newElementName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchPath";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cat";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDatabaseDialect";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedFunctions";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemVariables";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/dialects/mssql/MssqlDialect";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getBaseImports";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchemaNames";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "forcedContextPattern";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "srcFilePattern";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getNormalizedTypeName";
                break;
            }
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeCategoryByName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processReservedEntitiesWithType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "quoteIdentifier";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "shouldQuotedTypeReferenceBeChecked";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isMajorChild";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "srcFilePattern";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTypeName";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getNormalizedTypeName";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "getTypeCategoryByName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 15: 
            case 17: 
            case 18: 
            case 33: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class LazyData {
        static final Map<String, SqlFunctionDefinition> ourFunctionMap = Collections.unmodifiableMap(SqlFunctionsUtil.loadFunctionDefinition(INSTANCE));
        static final Set<String> ourSystemVars = Collections.unmodifiableSet(SqlDialectImplUtil.loadSystemVars(INSTANCE));
        static final NullableFunction<String, IElementType> ourReservedTokens = SqlTokenRegistry.getTokenProvider(MssqlReservedKeywords.class);
        static final TokenSet ourClosingTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{SqlTokens.STATEMENT_SEPARATORS, TokenSet.create((IElementType[])new IElementType[]{MssqlTypes.MSSQL_GO})});
        static final Set<IElementType> ourSupportedOperators = ContainerUtil.newTroveSet((Object[])new IElementType[]{SqlElementTypes.SQL_OP_PLUS, SqlElementTypes.SQL_OP_MINUS, SqlElementTypes.SQL_OP_MUL, SqlElementTypes.SQL_OP_DIV, SqlElementTypes.SQL_OP_NEQ, SqlElementTypes.SQL_OP_LE, SqlElementTypes.SQL_OP_LT, SqlElementTypes.SQL_OP_GE, SqlElementTypes.SQL_OP_EQ, SqlElementTypes.SQL_OP_GT, SqlElementTypes.SQL_OP_CONCAT, SqlElementTypes.SQL_AND, SqlElementTypes.SQL_NOT, SqlElementTypes.SQL_OR, SqlElementTypes.SQL_IS, SqlElementTypes.SQL_LIKE, SqlElementTypes.SQL_COLLATE, SqlElementTypes.SQL_IN, SqlElementTypes.SQL_OP_LOGICAL_AND, SqlElementTypes.SQL_OP_BITWISE_AND, SqlElementTypes.SQL_OP_BITWISE_NOT, SqlElementTypes.SQL_OP_BITWISE_OR, SqlElementTypes.SQL_OP_LOGICAL_OR, SqlElementTypes.SQL_OP_BITWISE_XOR, SqlElementTypes.SQL_OP_MODULO, SqlElementTypes.SQL_OP_NEQ2, SqlElementTypes.SQL_OP_NOT_LT, SqlElementTypes.SQL_OP_NOT_GT, SqlElementTypes.SQL_OP_PLUS_EQ, SqlElementTypes.SQL_OP_MINUS_EQ, SqlElementTypes.SQL_OP_MUL_EQ, SqlElementTypes.SQL_OP_DIV_EQ, SqlElementTypes.SQL_OP_MODULO_EQ, SqlElementTypes.SQL_OP_BITWISE_AND_EQ, SqlElementTypes.SQL_OP_BITWISE_OR_EQ, SqlElementTypes.SQL_OP_BITWISE_XOR_EQ});
        static final ReservedEntity RE_ACTION = new ReservedEntity("$action", ObjectKind.COLUMN);
        static final ReservedEntity RE_IDENTITY = new ReservedEntity("$IDENTITY", ObjectKind.COLUMN);
        static final ReservedEntity RE_ROWGUID = new ReservedEntity("$ROWGUID", ObjectKind.COLUMN);
        static final ReservedEntity RE_XML = new ReservedEntity("XML", ObjectKind.OBJECT_TYPE);
        private static final EnterHandlerDelegate ENTER_HANDLER = new SqlEnterHandlerImpl(new SqlCloseBlockProcessorImpl(new SubstitutionDescriptorImpl(new IElementType[]{SqlElementTypes.SQL_BEGIN, SqlElementTypes.SQL_BLOCK_STATEMENT}, "", "end", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, SqlElementTypes.SQL_SEMICOLON}).mask(true, false)), new SubstitutionDescriptorImpl(new IElementType[]{MssqlTypes.MSSQL_TRY, MssqlElementTypes.MSSQL_TRY_CATCH_STATEMENT}, "", "end try\nbegin catch\nend catch", 1, SubstitutionDescriptorImpl.TailCheck.builder().man(new IElementType[]{SqlElementTypes.SQL_END}).man(MssqlTypes.MSSQL_TRY).opt(new IElementType[]{MssqlElementTypes.MSSQL_CATCH_CLAUSE, SqlElementTypes.SQL_SEMICOLON}).build()), new SubstitutionDescriptorImpl(new IElementType[]{MssqlTypes.MSSQL_CATCH, MssqlElementTypes.MSSQL_CATCH_CLAUSE}, "", "end catch", 1, SubstitutionDescriptorImpl.TailCheck.tail(new IElementType[]{SqlElementTypes.SQL_END, MssqlTypes.MSSQL_CATCH, SqlElementTypes.SQL_SEMICOLON}).mask(true, true, false))));

        private LazyData() {
        }
    }
}

