/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.intentions;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.sql.SqlMessages;
import com.intellij.sql.intentions.SqlIntentionUtil;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class SqlUnquoteIdentifierIntention
extends BaseElementAtCaretIntentionAction {
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            SqlUnquoteIdentifierIntention.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = SqlMessages.message("quickfix.name.unquote.identifier", new Object[0]);
        if (string == null) {
            SqlUnquoteIdentifierIntention.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            SqlUnquoteIdentifierIntention.$$$reportNull$$$0(2);
        }
        if (element == null) {
            SqlUnquoteIdentifierIntention.$$$reportNull$$$0(3);
        }
        PsiFile file = element.getContainingFile();
        if (editor == null || !(file instanceof SqlFile)) {
            return false;
        }
        SqlIdentifier identifier = SqlIntentionUtil.getIdentifier(element);
        if (identifier == null) {
            return false;
        }
        return identifier.isQuotedIdentifier() && SqlImplUtil.canUnquote(identifier.getName(), SqlImplUtil.getSqlDialectSafe((PsiElement)identifier).getDatabaseDialect());
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        SqlIdentifier identifier;
        if (project == null) {
            SqlUnquoteIdentifierIntention.$$$reportNull$$$0(4);
        }
        if (element == null) {
            SqlUnquoteIdentifierIntention.$$$reportNull$$$0(5);
        }
        if ((identifier = SqlIntentionUtil.getIdentifier(element)) != null) {
            SqlImplUtil.unquoteIdentifier(project, identifier, SqlImplUtil.getSqlDialectSafe((PsiElement)identifier));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/intentions/SqlUnquoteIdentifierIntention";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/intentions/SqlUnquoteIdentifierIntention";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

