/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.psi.stubs;

import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.psi.DbPresentation;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveState;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlCreateStatement;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlExpression;
import com.intellij.sql.psi.SqlIdentifier;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.sql.psi.SqlReferenceElementType;
import com.intellij.sql.psi.SqlReferenceExpression;
import com.intellij.sql.psi.SqlStringLiteralExpression;
import com.intellij.sql.psi.SqlTargetContextProvider;
import com.intellij.sql.psi.SqlVisitor;
import com.intellij.sql.psi.impl.SqlFileImpl;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.sql.psi.impl.SqlOnTargetClauseImpl;
import com.intellij.sql.psi.impl.SqlStringLiteralManipulator;
import com.intellij.sql.psi.impl.SqlStringTokenElement;
import com.intellij.sql.psi.stubs.SqlNamedChildElementStub;
import com.intellij.sql.psi.stubs.SqlNamedElementStub;
import com.intellij.sql.psi.stubs.SqlSpecificChildStubElementType;
import com.intellij.sql.psi.stubs.SqlSpecificStubElementType;
import com.intellij.sql.psi.stubs.SqlStubbedElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SqlStubbedDefinitionImpl<T extends SqlNamedElementStub<?>>
extends SqlStubbedElement<T>
implements SqlDefinition,
ItemPresentation,
StubBasedPsiElement<T> {
    private static final Logger LOG = Logger.getInstance(SqlStubbedDefinitionImpl.class);
    private volatile String myCachedName;
    private volatile short myCachedPosition;

    public SqlStubbedDefinitionImpl(@NotNull ASTNode node) {
        if (node == null) {
            SqlStubbedDefinitionImpl.$$$reportNull$$$0(0);
        }
        super(node);
        this.myCachedPosition = (short)-1;
    }

    public SqlStubbedDefinitionImpl(T stub) {
        super(stub, stub.getStubType());
        this.myCachedPosition = (short)-1;
    }

    public SqlStubbedDefinitionImpl(T stub, @NotNull IStubElementType nodeType) {
        if (nodeType == null) {
            SqlStubbedDefinitionImpl.$$$reportNull$$$0(1);
        }
        super(stub, nodeType);
        this.myCachedPosition = (short)-1;
    }

    public ItemPresentation getPresentation() {
        return this;
    }

    @Override
    @Nullable
    public Icon getIcon() {
        return DbPresentation.getIcon((DasObject)this);
    }

    @Override
    public void accept(SqlVisitor visitor) {
        if (this instanceof SqlCreateStatement) {
            visitor.visitSqlCreateStatement((SqlCreateStatement)this);
        } else {
            visitor.visitSqlDefinition((SqlDefinition)this);
        }
    }

    public void subtreeChanged() {
        super.subtreeChanged();
        this.myCachedName = null;
        this.myCachedPosition = (short)-1;
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            SqlStubbedDefinitionImpl.$$$reportNull$$$0(2);
        }
        this.getNode();
        SqlNameElement element = this.getNameElement();
        if (element != null) {
            element.setName(name);
        }
        return this;
    }

    @Override
    @NotNull
    public String getName() {
        String cached = this.myCachedName;
        if (cached != null) {
            String string = cached;
            if (string == null) {
                SqlStubbedDefinitionImpl.$$$reportNull$$$0(3);
            }
            return string;
        }
        SqlNameElement element = this.getNameElement();
        String name = element == null ? null : element.getName();
        this.myCachedName = (String)ObjectUtils.notNull((Object)name, (Object)SqlImplUtil.NULL_STRING);
        if (this.myCachedName == null) {
            SqlStubbedDefinitionImpl.$$$reportNull$$$0(4);
        }
        return this.myCachedName;
    }

    public short getPosition() {
        short cached = this.myCachedPosition;
        if (cached >= 0) {
            return cached;
        }
        short count2 = 1;
        for (PsiElement element : SqlImplUtil.childrenIt(this.getParent())) {
            if (element == this) {
                short s = count2;
                this.myCachedPosition = s;
                return s;
            }
            count2 = (short)(count2 + 1);
        }
        this.myCachedPosition = 0;
        return 0;
    }

    @NotNull
    public String getDisplayOrder() {
        String string = String.valueOf(this.getPosition());
        if (string == null) {
            SqlStubbedDefinitionImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    protected SqlReferenceElementType getExpectedNameReferenceElementType() {
        SqlSpecificStubElementType type = (SqlSpecificStubElementType)((Object)ObjectUtils.tryCast((Object)PsiUtilCore.getElementType((PsiElement)this), SqlSpecificStubElementType.class));
        return type == null ? null : type.getType();
    }

    public SqlNameElement getNameElement() {
        SqlNamedElementStub stub = (SqlNamedElementStub)this.getStub();
        SqlReferenceElementType refType = this.getExpectedNameReferenceElementType();
        if (stub != null) {
            return refType == null ? null : stub.getNameReference(refType);
        }
        if (refType != null) {
            return (SqlNameElement)this.findChildByType((IElementType)refType);
        }
        return (SqlNameElement)this.findChildByClass(SqlReferenceExpression.class);
    }

    @NotNull
    public ObjectKind getKind() {
        SqlReferenceElementType refType = this.getExpectedNameReferenceElementType();
        if (refType != null) {
            ObjectKind objectKind = refType.getTargetKind();
            if (objectKind == null) {
                SqlStubbedDefinitionImpl.$$$reportNull$$$0(6);
            }
            return objectKind;
        }
        SqlNameElement element = this.getNameElement();
        if (!(element instanceof SqlReferenceExpression)) {
            String msg = this.getContainingFile().getLanguage() + "/" + ((Object)((Object)this)).getClass().getSimpleName() + "/" + this.getNode().getElementType() + ": " + element;
            Application app = ApplicationManager.getApplication();
            if (app == null || app.isUnitTestMode()) {
                throw new AssertionError((Object)(msg + "\n" + this.getText()));
            }
            LOG.warn(msg);
            ObjectKind objectKind = ObjectKind.NONE;
            if (objectKind == null) {
                SqlStubbedDefinitionImpl.$$$reportNull$$$0(7);
            }
            return objectKind;
        }
        ObjectKind objectKind = ((SqlReferenceExpression)element).getReferenceElementType().getTargetKind();
        if (objectKind == null) {
            SqlStubbedDefinitionImpl.$$$reportNull$$$0(8);
        }
        return objectKind;
    }

    public String getPresentableText() {
        return StringUtil.notNullize((String)this.getName(), (String)"<unknown>");
    }

    public String getLocationString() {
        return this.getContainingFile().getName();
    }

    public Icon getIcon(boolean open) {
        return this.getIcon();
    }

    public int getTextOffset() {
        this.getNode();
        SqlNameElement nameElement = this.getNameElement();
        if (nameElement != null) {
            return nameElement.getTextOffset();
        }
        return super.getTextOffset();
    }

    @Nullable
    public PsiElement getNameIdentifier() {
        return this.getNameElement();
    }

    @Override
    public boolean processImplicitContextDeclarations(PsiScopeProcessor processor, ResolveState state, PsiElement lastParent, PsiElement place) {
        SqlExpression qualifier;
        SqlNameElement nameElement = this.getNameElement();
        if (lastParent != nameElement && nameElement instanceof SqlReferenceExpression && PsiTreeUtil.isContextAncestor((PsiElement)this, (PsiElement)lastParent, (boolean)true) && (qualifier = ((SqlReferenceExpression)nameElement).getQualifierExpression()) instanceof SqlReferenceExpression && !SqlImplUtil.processQualifier((SqlReferenceExpression)qualifier, processor, state, place)) {
            return false;
        }
        return super.processImplicitContextDeclarations(processor, state, lastParent, place);
    }

    @Nullable
    public String getComment() {
        if (this.getStub() != null) {
            return null;
        }
        SqlStringLiteralExpression comment = (SqlStringLiteralExpression)PsiTreeUtil.findChildOfType((PsiElement)this.findChildByType((IElementType)SqlCompositeElementTypes.SQL_COMMENT_CLAUSE), SqlStringLiteralExpression.class);
        if (comment == null) {
            return null;
        }
        SqlStringTokenElement token = SqlStringLiteralManipulator.getStringToken(comment);
        return token == null ? null : token.getTokenText();
    }

    @Nullable
    public SqlReferenceExpression getParentRef() {
        SqlNamedElementStub stub = (SqlNamedElementStub)this.getStub();
        if (this instanceof SqlTargetContextProvider) {
            return ((SqlTargetContextProvider)this).getTargetContextExpression();
        }
        if (stub != null) {
            SqlNamedChildElementStub childStub = (SqlNamedChildElementStub)((Object)ObjectUtils.tryCast((Object)((Object)stub), SqlNamedChildElementStub.class));
            SqlSpecificChildStubElementType type = (SqlSpecificChildStubElementType)((Object)ObjectUtils.tryCast((Object)PsiUtilCore.getElementType((PsiElement)this), SqlSpecificChildStubElementType.class));
            if (childStub != null && type != null) {
                return childStub.getParentReference(type.getParentType());
            }
            return null;
        }
        SqlOnTargetClauseImpl targetClause = (SqlOnTargetClauseImpl)PsiTreeUtil.getChildOfType((PsiElement)this, SqlOnTargetClauseImpl.class);
        return targetClause != null ? (SqlReferenceExpression)ObjectUtils.tryCast((Object)targetClause.getTargetExpression(), SqlReferenceExpression.class) : null;
    }

    public DasObject getDasParent() {
        DasTable table;
        PsiElement resolved;
        SqlReferenceExpression ref = this.getParentRef();
        PsiElement psiElement = resolved = ref == null ? null : ref.resolve();
        if (resolved != null) {
            return (DasObject)ObjectUtils.tryCast((Object)resolved, DasObject.class);
        }
        if (this instanceof DasTableChild && (table = ((DasTableChild)this).getTable()) != null && table != SqlImplUtil.NO_TABLE) {
            return table;
        }
        return SqlStubbedDefinitionImpl.getParentImpl(this);
    }

    @Nullable
    public static DasObject getParentImpl(@NotNull SqlDefinition def2) {
        if (def2 == null) {
            SqlStubbedDefinitionImpl.$$$reportNull$$$0(9);
        }
        Couple<SqlFileImpl.FakeDefinition> m = SqlImplUtil.getMirror(def2);
        if (m.first != null) {
            return (DasObject)m.first;
        }
        if (m.second != null) {
            return ((SqlFileImpl.FakeDefinition)((Object)m.second)).getDasParent();
        }
        for (PsiElement e = def2.getContext(); e != null; e = e.getContext()) {
            if (e instanceof SqlDefinition) {
                m = SqlImplUtil.getMirror((SqlDefinition)e);
                return m.second != null ? (DasObject)m.second : (DasObject)e;
            }
            if (e instanceof DasObject) {
                return (DasObject)e;
            }
            if (e instanceof SqlFileImpl) {
                return ((SqlFileImpl)e).findDbParent(def2);
            }
            if (e instanceof PsiFile) break;
        }
        return null;
    }

    @NotNull
    public JBIterable<? extends DasObject> getDasChildren(@Nullable ObjectKind kind) {
        if (this instanceof DasTableChild) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                SqlStubbedDefinitionImpl.$$$reportNull$$$0(10);
            }
            return jBIterable;
        }
        JBIterable jBIterable = SqlImplUtil.childrenIt((PsiElement)this).filter(DasObject.class).filter(DasUtil.byKind((ObjectKind)kind));
        if (jBIterable == null) {
            SqlStubbedDefinitionImpl.$$$reportNull$$$0(11);
        }
        return jBIterable;
    }

    @Nullable
    public PsiReference getReference() {
        SqlIdentifier nameElement = (SqlIdentifier)ObjectUtils.tryCast((Object)this.getNameElement(), SqlIdentifier.class);
        if (nameElement == null) {
            return null;
        }
        PsiReferenceBase ref = PsiReferenceBase.createSelfReference((PsiElement)this, (PsiElement)this);
        ref.setRangeInElement(nameElement.getNameRange().shiftRight(nameElement.getStartOffsetInParent()));
        return ref;
    }

    public boolean isNameQuoted() {
        return DbSqlUtil.isQuoted(this.getNameElement());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/sql/psi/stubs/SqlStubbedDefinitionImpl";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "def";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/sql/psi/stubs/SqlStubbedDefinitionImpl";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayOrder";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDasChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setName";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getParentImpl";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

