/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson;

import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NullableFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstalledPackageVersion {
    private final VirtualFile myPackageDir;
    private final VirtualFile myPackageJson;
    private final SemVer myVersion;

    public InstalledPackageVersion(@NotNull VirtualFile packageDir, @Nullable VirtualFile packageJson, @Nullable SemVer version) {
        if (packageDir == null) {
            InstalledPackageVersion.$$$reportNull$$$0(0);
        }
        this.myPackageDir = packageDir;
        this.myPackageJson = packageJson;
        this.myVersion = version;
    }

    public VirtualFile getPackageDir() {
        return this.myPackageDir;
    }

    public VirtualFile getPackageJson() {
        return this.myPackageJson;
    }

    @Nullable
    public SemVer getVersion() {
        return this.myVersion;
    }

    @NotNull
    public static NullableFunction<String, InstalledPackageVersion> createProducer(@NotNull Project project, @NotNull VirtualFile packageJson) {
        if (project == null) {
            InstalledPackageVersion.$$$reportNull$$$0(1);
        }
        if (packageJson == null) {
            InstalledPackageVersion.$$$reportNull$$$0(2);
        }
        ArrayList nodeModulesDirs = ContainerUtil.newArrayList();
        ReadAction.run(() -> {
            if (project == null) {
                InstalledPackageVersion.$$$reportNull$$$0(6);
            }
            if (packageJson == null) {
                InstalledPackageVersion.$$$reportNull$$$0(7);
            }
            NodeModuleSearchUtil.processUpNodeModulesDirs(project, packageJson, (Processor<VirtualFile>)((Processor)nodeModulesDir -> {
                nodeModulesDirs.add(nodeModulesDir);
                return true;
            }));
        });
        NullableFunction nullableFunction = packageName -> InstalledPackageVersion.findInstalledPackage(nodeModulesDirs, packageName);
        if (nullableFunction == null) {
            InstalledPackageVersion.$$$reportNull$$$0(3);
        }
        return nullableFunction;
    }

    @Nullable
    private static InstalledPackageVersion findInstalledPackage(@NotNull List<VirtualFile> nodeModulesDirs, @NotNull String packageName) {
        if (nodeModulesDirs == null) {
            InstalledPackageVersion.$$$reportNull$$$0(4);
        }
        if (packageName == null) {
            InstalledPackageVersion.$$$reportNull$$$0(5);
        }
        for (VirtualFile nodeModulesDir : nodeModulesDirs) {
            VirtualFile packageDir = nodeModulesDir.findFileByRelativePath(packageName);
            if (packageDir == null || !packageDir.isDirectory() || !packageDir.isValid()) continue;
            VirtualFile packageJson = PackageJsonUtil.findChildPackageJsonFile(packageDir);
            if (packageJson != null) {
                PackageJsonData data = PackageJsonData.getOrCreate(packageJson);
                SemVer version = data.getVersion();
                if (version != null && packageName.equals(data.getName())) {
                    return new InstalledPackageVersion(packageDir, packageJson, version);
                }
                return new InstalledPackageVersion(packageDir, packageJson, null);
            }
            return new InstalledPackageVersion(packageDir, null, null);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageDir";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/InstalledPackageVersion";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModulesDirs";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/InstalledPackageVersion";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createProducer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createProducer";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findInstalledPackage";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createProducer$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

