/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.refactoring;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ui.FormBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ES6MoveSymbolDialog
extends RefactoringDialog {
    public static final String MOVE_ES6_MEMBERS_OPEN_IN_EDITOR = "Move.ES6.Members.OpenInEditor";
    private static final String RECENT_KEYS = "es6.move.members.recent.items";
    @NotNull
    protected final TextFieldWithHistoryWithBrowseButton myModuleField;
    @NotNull
    protected final JPanel myExtraPanel;
    @NotNull
    protected final JPanel myPanel;
    @NotNull
    protected final JBTextField myFromField;
    @NotNull
    private final JCheckBox myOpenEditorCb;

    @NotNull
    public static TextFieldWithHistoryWithBrowseButton createDestinationFileField(@NotNull PsiElement context) {
        if (context == null) {
            ES6MoveSymbolDialog.$$$reportNull$$$0(0);
        }
        TextFieldWithHistoryWithBrowseButton moduleField = new TextFieldWithHistoryWithBrowseButton();
        PsiFile file2 = context.getContainingFile();
        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFileDescriptor((FileType)file2.getFileType());
        descriptor2.setRoots(ProjectRootManager.getInstance((Project)context.getProject()).getContentRoots());
        descriptor2.withTreeRootVisible(true);
        TextComponentAccessor<TextFieldWithHistory> accessor = new TextComponentAccessor<TextFieldWithHistory>(){

            public String getText(TextFieldWithHistory component) {
                return component.getText();
            }

            public void setText(TextFieldWithHistory component, @NotNull String text) {
                if (text == null) {
                    1.$$$reportNull$$$0(0);
                }
                component.setTextAndAddToHistory(text);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/lang/ecmascript6/refactoring/ES6MoveSymbolDialog$1", "setText"));
            }
        };
        String message = JSBundle.message((String)"es6.move.module.members.refactoring.dialog.move.member.to", (Object[])new Object[0]);
        moduleField.addBrowseFolderListener(message, null, context.getProject(), descriptor2, (TextComponentAccessor)accessor);
        List entries = RecentsManager.getInstance((Project)context.getProject()).getRecentEntries(RECENT_KEYS);
        TextFieldWithHistory textFieldWithHistory = (TextFieldWithHistory)moduleField.getChildComponent();
        if (entries != null) {
            textFieldWithHistory.setHistory(entries);
        }
        moduleField.setTextFieldPreferredWidth(70);
        TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton = moduleField;
        if (textFieldWithHistoryWithBrowseButton == null) {
            ES6MoveSymbolDialog.$$$reportNull$$$0(1);
        }
        return textFieldWithHistoryWithBrowseButton;
    }

    public ES6MoveSymbolDialog(@NotNull Project project, @NotNull String fromPath, @NotNull String toPath, @NotNull PsiElement context) {
        if (project == null) {
            ES6MoveSymbolDialog.$$$reportNull$$$0(2);
        }
        if (fromPath == null) {
            ES6MoveSymbolDialog.$$$reportNull$$$0(3);
        }
        if (toPath == null) {
            ES6MoveSymbolDialog.$$$reportNull$$$0(4);
        }
        if (context == null) {
            ES6MoveSymbolDialog.$$$reportNull$$$0(5);
        }
        super(project, true);
        this.myExtraPanel = new JPanel(new BorderLayout());
        FormBuilder builder = FormBuilder.createFormBuilder();
        this.myFromField = new JBTextField();
        this.myFromField.setText(fromPath);
        this.myFromField.setEnabled(false);
        this.myModuleField = ES6MoveSymbolDialog.createDestinationFileField(context);
        this.myModuleField.setText(toPath);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myModuleField);
        boolean openInEditorDefaultValue = PropertiesComponent.getInstance().getBoolean(MOVE_ES6_MEMBERS_OPEN_IN_EDITOR, true);
        this.myOpenEditorCb = new NonFocusableCheckBox(JSBundle.message((String)"es6.move.module.members.refactoring.dialog.open.in.editor", (Object[])new Object[0]));
        this.myOpenEditorCb.setSelected(openInEditorDefaultValue);
        builder.addLabeledComponent(JSBundle.message((String)"es6.move.module.members.refactoring.dialog.field.from", (Object[])new Object[0]), (JComponent)this.myFromField);
        builder.addLabeledComponent(JSBundle.message((String)"es6.move.module.members.refactoring.dialog.field.to", (Object[])new Object[0]), (JComponent)this.myModuleField);
        String shortcutText = KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("CodeCompletion"));
        builder.addTooltip(RefactoringBundle.message((String)"path.completion.shortcut", (Object[])new Object[]{shortcutText}));
        builder.addComponent((JComponent)this.myExtraPanel);
        builder.addComponent((JComponent)this.myOpenEditorCb);
        JPanel panel = builder.getPanel();
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)panel, "North");
        this.myPanel = wrapper;
    }

    public void saveOpenInEditorOption() {
        PropertiesComponent.getInstance().setValue(MOVE_ES6_MEMBERS_OPEN_IN_EDITOR, this.myOpenEditorCb.isSelected(), true);
    }

    public boolean isOpenInEditor() {
        return this.myOpenEditorCb.isSelected();
    }

    protected void doAction() {
        String text = ((TextFieldWithHistory)this.myModuleField.getChildComponent()).getText();
        if (!StringUtil.isEmpty((String)text)) {
            RecentsManager.getInstance((Project)this.myProject).registerRecentEntry(RECENT_KEYS, text);
        }
        this.close(0);
    }

    protected void init() {
        super.init();
        this.preselectLastPathComponent((TextFieldWithHistory)this.myModuleField.getChildComponent());
    }

    protected void preselectLastPathComponent(@NotNull TextFieldWithHistory field) {
        String text;
        if (field == null) {
            ES6MoveSymbolDialog.$$$reportNull$$$0(6);
        }
        if (StringUtil.isEmpty((String)(text = FileUtil.toCanonicalPath((String)field.getText())))) {
            return;
        }
        int separator = text.lastIndexOf(47);
        int length = text.length();
        if (separator > 0 && separator + 1 < length) {
            JTextField editor = field.getTextEditor();
            editor.select(separator + 1, length);
        }
    }

    @Nullable
    protected JComponent createNorthPanel() {
        return this.myPanel;
    }

    protected JComponent createCenterPanel() {
        return null;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myModuleField;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/refactoring/ES6MoveSymbolDialog";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toPath";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/refactoring/ES6MoveSymbolDialog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createDestinationFileField";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createDestinationFileField";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "preselectLastPathComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

