/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptFileType;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.library.JSLibraryManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.openapi.vfs.impl.http.RemoteFileInfo;
import com.intellij.openapi.vfs.impl.http.RemoteFileState;
import com.intellij.psi.css.MinifiedFilesUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.NotNullProducer;
import com.intellij.util.Producer;
import com.intellij.util.ThreeState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSMinifiedFileUtil {
    private static final Key<CachedMinifiedStatus> CACHED_MINIFIED_STATUS_KEY = Key.create((String)"js.cached.minified.status");
    private static final TokenSet NO_WHITESPACE_REQUIRED_AFTER = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.andNot((TokenSet)JSTokenTypes.OPERATIONS, (TokenSet)JSKeywordSets.IDENTIFIER_NAMES), TokenSet.andNot((TokenSet)JSTokenTypes.COMMENTS, (TokenSet)TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.END_OF_LINE_COMMENT})), TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.LBRACE, JSTokenTypes.RBRACE, JSTokenTypes.LBRACKET, JSTokenTypes.RBRACKET, JSTokenTypes.LPAR, JSTokenTypes.RPAR, JSTokenTypes.DOT, JSTokenTypes.SEMICOLON, JSTokenTypes.ANY_IDENTIFIER})});
    private static final TokenSet NO_WHITESPACE_REQUIRED_BEFORE = TokenSet.orSet((TokenSet[])new TokenSet[]{NO_WHITESPACE_REQUIRED_AFTER, JSTokenTypes.COMMENTS, JSTokenTypes.STRING_LITERALS});
    private static final TokenSet STRING_LITERAL_TYPES = TokenSet.orSet((TokenSet[])new TokenSet[]{JSTokenTypes.STRING_LITERALS, TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.STRING_TEMPLATE_PART})});

    public static boolean isFileMinified(@NotNull VirtualFile file2, @NotNull Project project) {
        JSLibraryManager libraryManager;
        ThreeState isExplicitlyCompact;
        if (file2 == null) {
            JSMinifiedFileUtil.$$$reportNull$$$0(0);
        }
        if (project == null) {
            JSMinifiedFileUtil.$$$reportNull$$$0(1);
        }
        if ((isExplicitlyCompact = (libraryManager = JSLibraryManager.getInstance(project)).getFileState(file2)) == ThreeState.YES) {
            return true;
        }
        if (isExplicitlyCompact == ThreeState.NO) {
            return false;
        }
        return JSMinifiedFileUtil.isFileContentMinified(file2);
    }

    public static boolean isFileContentMinified(@NotNull VirtualFile file2) {
        long documentTimeStamp;
        if (file2 == null) {
            JSMinifiedFileUtil.$$$reportNull$$$0(2);
        }
        if (file2.isDirectory() || !file2.isValid()) {
            return false;
        }
        if (file2 instanceof HttpVirtualFile) {
            RemoteFileInfo info = ((HttpVirtualFile)file2).getFileInfo();
            if (info == null || info.getState() != RemoteFileState.DOWNLOADED) {
                return false;
            }
            VirtualFile localFile = info.getLocalFile();
            if (localFile == null) {
                return false;
            }
            file2 = localFile;
        }
        Document document = FileDocumentManager.getInstance().getCachedDocument(file2);
        CachedMinifiedStatus status = (CachedMinifiedStatus)CACHED_MINIFIED_STATUS_KEY.get((UserDataHolder)file2);
        long l = documentTimeStamp = document != null ? document.getModificationStamp() : -1L;
        if (status == null || status.getFileTimeStamp() != file2.getTimeStamp() || status.getDocumentTimeStamp() != documentTimeStamp) {
            status = new CachedMinifiedStatus(JSMinifiedFileUtil.calcFileContentMinified(file2, document), file2.getTimeStamp(), documentTimeStamp);
            CACHED_MINIFIED_STATUS_KEY.set((UserDataHolder)file2, (Object)status);
        }
        return status.isMinified();
    }

    private static boolean calcFileContentMinified(@NotNull VirtualFile file2, @Nullable Document document) {
        if (file2 == null) {
            JSMinifiedFileUtil.$$$reportNull$$$0(3);
        }
        return JSMinifiedFileUtil.isFileContentMinified(file2.getName(), (Producer<CharSequence>)((NotNullProducer)() -> {
            if (file2 == null) {
                JSMinifiedFileUtil.$$$reportNull$$$0(6);
            }
            if (document != null) {
                return document.getCharsSequence();
            }
            return LoadTextUtil.loadText((VirtualFile)file2, (int)0x100000);
        }));
    }

    public static boolean isFileContentMinified(@NotNull String fileName, @NotNull Producer<CharSequence> fileContent) {
        if (fileName == null) {
            JSMinifiedFileUtil.$$$reportNull$$$0(4);
        }
        if (fileContent == null) {
            JSMinifiedFileUtil.$$$reportNull$$$0(5);
        }
        if (FileTypeRegistry.getInstance().getFileTypeByFileName(fileName) != JavaScriptFileType.INSTANCE) {
            return false;
        }
        if (fileName.contains(".min.")) {
            return true;
        }
        if (fileName.contains(".dev.")) {
            return false;
        }
        ParserDefinition def = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage((Language)JavascriptLanguage.INSTANCE);
        CharSequence content = (CharSequence)fileContent.produce();
        if (content == null) {
            return false;
        }
        return MinifiedFilesUtil.isMinified((CharSequence)content, (ParserDefinition)def, (TokenSet)NO_WHITESPACE_REQUIRED_BEFORE, (TokenSet)NO_WHITESPACE_REQUIRED_AFTER, (TokenSet)STRING_LITERAL_TYPES);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileContent";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/JSMinifiedFileUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileMinified";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isFileContentMinified";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "calcFileContentMinified";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$calcFileContentMinified$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CachedMinifiedStatus {
        private final boolean myMinified;
        private final long myFileTimeStamp;
        private final long myDocumentTimeStamp;

        public CachedMinifiedStatus(boolean minified, long fileTimeStamp, long documentTimeStamp) {
            this.myMinified = minified;
            this.myFileTimeStamp = fileTimeStamp;
            this.myDocumentTimeStamp = documentTimeStamp;
        }

        public boolean isMinified() {
            return this.myMinified;
        }

        public long getFileTimeStamp() {
            return this.myFileTimeStamp;
        }

        public long getDocumentTimeStamp() {
            return this.myDocumentTimeStamp;
        }

        public String toString() {
            return "minified: " + this.myMinified + ", fileTimeStamp: " + this.myFileTimeStamp + ", documentTimeStamp: " + this.myDocumentTimeStamp;
        }
    }
}

