/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateFileFromTemplateAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.json.JsonFileType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleTypeWithWebFeatures;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCreateConfigFileAction
extends AnAction
implements DumbAware {
    public static final String TSCONFIG_JSON = "tsconfig.json";

    public TypeScriptCreateConfigFileAction() {
        super("tsconfig.json File", "Creates a new tsconfig.json file", JsonFileType.INSTANCE.getIcon());
    }

    public void actionPerformed(AnActionEvent e) {
        PsiDirectory psiDir = TypeScriptCreateConfigFileAction.getPsiDirectory(e);
        if (psiDir != null) {
            TypeScriptCreateConfigFileAction.createConfigFile(psiDir);
        }
    }

    private static PsiFile createConfigFile(PsiDirectory psiDir) {
        FileTemplate template = FileTemplateManager.getInstance((Project)psiDir.getProject()).getInternalTemplate(TSCONFIG_JSON);
        return CreateFileFromTemplateAction.createFileFromTemplate((String)TSCONFIG_JSON, (FileTemplate)template, (PsiDirectory)psiDir, null, (boolean)true);
    }

    public void update(AnActionEvent e) {
        VirtualFile virtualDir;
        PsiDirectory psiDir;
        Module module = (Module)LangDataKeys.MODULE.getData(e.getDataContext());
        if (module == null || !ModuleTypeWithWebFeatures.isAvailable((Module)module)) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        boolean available = false;
        Project project = e.getProject();
        if (project != null && (psiDir = TypeScriptCreateConfigFileAction.getPsiDirectory(e)) != null && (virtualDir = psiDir.getVirtualFile()).isDirectory() && virtualDir.findChild(TSCONFIG_JSON) == null) {
            available = true;
        }
        e.getPresentation().setEnabledAndVisible(available);
    }

    @Nullable
    private static PsiDirectory getPsiDirectory(AnActionEvent e) {
        PsiDirectory[] directories;
        DataContext dataContext = e.getDataContext();
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view != null && (directories = view.getDirectories()).length == 1) {
            return directories[0];
        }
        return null;
    }
}

