/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.boilerplate;

import com.google.common.io.Files;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.TextConsoleBuilderImpl;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.ide.file.BatchFileChangeListener;
import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.ide.util.projectWizard.ModuleNameLocationSettings;
import com.intellij.ide.util.projectWizard.SettingsStep;
import com.intellij.ide.util.projectWizard.WebProjectTemplate;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.packageJson.PackageJsonDependenciesExternalUpdateManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.lang.javascript.boilerplate.NpxPackageDescriptor;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsService;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.linter.JSLinterGuesser;
import com.intellij.lang.javascript.modules.ConsoleProgress;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ProjectTemplate;
import com.intellij.platform.WebProjectGenerator;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.content.Content;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NpmPackageProjectGenerator
extends WebProjectTemplate<Settings>
implements ProjectTemplate {
    private static final String ID = "none";
    private static final Logger LOG = Logger.getInstance(NpmPackageProjectGenerator.class);
    private static final Key<Boolean> GENERATING = Key.create((String)(NpmPackageProjectGenerator.class.getSimpleName() + ".generating"));

    @NotNull
    protected abstract Filter[] filters(@NotNull Project var1, @NotNull VirtualFile var2);

    @NotNull
    protected String executable(String path) {
        String string = this.executable(new NodePackage(path));
        if (string == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    protected String executable(@NotNull NodePackage pkg) {
        File file2;
        if (pkg == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(1);
        }
        String string = (file2 = pkg.findBinFile()) != null ? file2.getAbsolutePath() : "";
        if (string == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    protected abstract String[] generatorArgs(@NotNull Project var1, @NotNull VirtualFile var2);

    protected abstract void customizeModule(@NotNull VirtualFile var1, ContentEntry var2);

    @NotNull
    protected abstract String packageName();

    @NotNull
    protected abstract String presentablePackageName();

    @NotNull
    protected List<NpxPackageDescriptor.NpxCommand> getNpxCommands() {
        List<NpxPackageDescriptor.NpxCommand> list = Collections.emptyList();
        if (list == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(3);
        }
        return list;
    }

    private void generateApp(@NotNull NodeJsLocalInterpreter node, @NotNull Settings settings, @NotNull VirtualFile baseDir, @NotNull Project project) throws ExecutionException {
        if (node == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(4);
        }
        if (settings == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(5);
        }
        if (baseDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(6);
        }
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(7);
        }
        File workingDir = this.workingDir(baseDir);
        NpmPackageProjectGenerator.generate(node, settings.myPackage, (Function<NodePackage, String>)((Function)pkg -> this.executable((NodePackage)pkg)), baseDir, workingDir, project, this.postInstall(project, baseDir, workingDir), this.filters(project, baseDir), this.generatorArgs(project, baseDir, settings));
    }

    protected String[] generatorArgs(Project project, VirtualFile dir, Settings settings) {
        return this.generatorArgs(project, dir);
    }

    @NotNull
    protected Runnable postInstall(@NotNull NodeJsLocalInterpreter node, @NotNull Project project, @NotNull VirtualFile baseDir, File workingDir) {
        if (node == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(8);
        }
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(9);
        }
        if (baseDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(10);
        }
        Runnable runnable = this.postInstall(project, baseDir, workingDir);
        if (runnable == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(11);
        }
        return runnable;
    }

    @NotNull
    protected Runnable postInstall(@NotNull Project project, @NotNull VirtualFile baseDir, File workingDir) {
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(12);
        }
        if (baseDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(13);
        }
        Runnable runnable = () -> {
            if (baseDir == null) {
                NpmPackageProjectGenerator.$$$reportNull$$$0(46);
            }
            if (project == null) {
                NpmPackageProjectGenerator.$$$reportNull$$$0(47);
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                if (baseDir == null) {
                    NpmPackageProjectGenerator.$$$reportNull$$$0(48);
                }
                if (project == null) {
                    NpmPackageProjectGenerator.$$$reportNull$$$0(49);
                }
                if (this.generateInTemp()) {
                    try {
                        FileUtil.copyDir((File)new File(workingDir, baseDir.getName()), (File)VfsUtilCore.virtualToIoFile((VirtualFile)baseDir));
                        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{baseDir});
                    }
                    catch (IOException e) {
                        throw new Error(e);
                    }
                }
                NpmPackageProjectGenerator.initBuildfiles(project);
            });
        };
        if (runnable == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(14);
        }
        return runnable;
    }

    private static void initBuildfiles(@NotNull Project project) {
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(15);
        }
        if (!project.isDisposed()) {
            NpmScriptsService instance = NpmScriptsService.getInstance();
            List<VirtualFile> buildfiles = instance.detectAllBuildfiles(project);
            ApplicationManager.getApplication().invokeLater(() -> {
                if (project == null) {
                    NpmPackageProjectGenerator.$$$reportNull$$$0(45);
                }
                for (VirtualFile buildfile : buildfiles) {
                    instance.getFileManager(project).addBuildfile(buildfile);
                }
                instance.getToolWindowManager(project).setAvailable();
                JSLinterGuesser.guessLinters(project);
            }, project.getDisposed());
        }
    }

    public static void generate(@NotNull NodeJsLocalInterpreter node, @NotNull String path, @NotNull VirtualFile baseDir, @NotNull File workingDir, @NotNull Project project, @Nullable Runnable callback, @NotNull Filter[] filters, String ... args) throws ExecutionException {
        VirtualFile file2;
        if (node == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(16);
        }
        if (path == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(17);
        }
        if (baseDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(18);
        }
        if (workingDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(19);
        }
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(20);
        }
        if (filters == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(21);
        }
        VirtualFile packageJson = (file2 = LocalFileSystem.getInstance().findFileByPath(path)) != null ? PackageJsonUtil.findUpPackageJson(file2) : null;
        VirtualFile dir = packageJson != null ? packageJson.getParent() : null;
        NodePackage pkg = dir != null ? new NodePackage(dir.getPath()) : new NodePackage(path);
        NpmPackageProjectGenerator.generate(node, pkg, (Function<NodePackage, String>)((Function)p -> {
            if (path == null) {
                NpmPackageProjectGenerator.$$$reportNull$$$0(44);
            }
            return path;
        }), baseDir, workingDir, project, callback, filters, args);
    }

    public static void generate(@NotNull NodeJsLocalInterpreter node, @NotNull NodePackage pkg, @NotNull Function<NodePackage, String> binFilePathProvider, final @NotNull VirtualFile baseDir, @NotNull File workingDir, final @NotNull Project project, final @Nullable Runnable callback, @NotNull Filter[] filters, String ... args) throws ExecutionException {
        if (node == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(22);
        }
        if (pkg == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(23);
        }
        if (binFilePathProvider == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(24);
        }
        if (baseDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(25);
        }
        if (workingDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(26);
        }
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(27);
        }
        if (filters == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(28);
        }
        final Runnable done = PackageJsonDependenciesExternalUpdateManager.getInstance(project).externalUpdateStarted(null, null);
        GENERATING.set((UserDataHolder)project, (Object)Boolean.TRUE);
        ArrayList<Object> arguments = new ArrayList<Object>();
        arguments.add(node.getInterpreterSystemDependentPath());
        if (pkg instanceof NpxPackageDescriptor.NpxNodePackage) {
            arguments.addAll(((NpxPackageDescriptor.NpxNodePackage)pkg).getArguments(node));
        } else {
            arguments.add(binFilePathProvider.fun((Object)pkg));
        }
        ContainerUtil.addAll(arguments, (Object[])args);
        GeneralCommandLine commandLine = new GeneralCommandLine(arguments);
        commandLine.setWorkDirectory(workingDir.getPath());
        commandLine.setCharset(CharsetToolkit.UTF8_CHARSET);
        NodeCommandLineUtil.configureUsefulEnvironment(commandLine);
        final KillableColoredProcessHandler handler = new KillableColoredProcessHandler(commandLine);
        TextConsoleBuilderImpl builder = new TextConsoleBuilderImpl(project);
        builder.setUsePredefinedMessageFilter(false);
        for (Filter filter : filters) {
            builder.addFilter(filter);
        }
        ConsoleView console = builder.getConsole();
        console.attachToProcess((ProcessHandler)handler);
        ConsoleProgress.install(console, (ProcessHandler)handler);
        ((BatchFileChangeListener)BackgroundTaskUtil.syncPublisher((Topic)BatchFileChangeListener.TOPIC)).batchChangeStarted(project, "project generation");
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                baseDir.refresh(false, true);
                baseDir.getChildren();
                handler.notifyTextAvailable("Done\n", ProcessOutputTypes.SYSTEM);
                done.run();
                GENERATING.set((UserDataHolder)project, null);
                if (callback != null) {
                    callback.run();
                }
                ((BatchFileChangeListener)BackgroundTaskUtil.syncPublisher((Topic)BatchFileChangeListener.TOPIC)).batchChangeCompleted(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator$1", "processTerminated"));
            }
        });
        Executor defaultExecutor = DefaultRunExecutor.getRunExecutorInstance();
        String title = "Generating " + baseDir.getName();
        RunnerLayoutUi ui = RunnerLayoutUi.Factory.getInstance((Project)project).create(ID, title, title, (Disposable)project);
        Content consoleContent = ui.createContent(ID, console.getComponent(), title, null, console.getPreferredFocusableComponent());
        ui.addContent(consoleContent);
        RunContentDescriptor descriptor2 = new RunContentDescriptor((ExecutionConsole)console, (ProcessHandler)handler, console.getComponent(), title);
        ExecutionManager.getInstance((Project)project).getContentManager().showRunContent(defaultExecutor, descriptor2);
        handler.startNotify();
    }

    public void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull Settings settings, @NotNull Module module) {
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(29);
        }
        if (baseDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(30);
        }
        if (settings == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(31);
        }
        if (module == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(32);
        }
        NodeJsInterpreter interpreter = settings.myInterpreterRef.resolve(project);
        NodeJsLocalInterpreter local = NodeJsLocalInterpreter.tryCast(interpreter);
        assert (local != null);
        GENERATING.set((UserDataHolder)project, (Object)Boolean.TRUE);
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(() -> {
            if (project == null) {
                NpmPackageProjectGenerator.$$$reportNull$$$0(39);
            }
            if (settings == null) {
                NpmPackageProjectGenerator.$$$reportNull$$$0(40);
            }
            if (baseDir == null) {
                NpmPackageProjectGenerator.$$$reportNull$$$0(41);
            }
            if (module == null) {
                NpmPackageProjectGenerator.$$$reportNull$$$0(42);
            }
            try {
                NodeJsInterpreterManager.getInstance(project).setInterpreterRef(settings.myInterpreterRef);
                this.generateApp(local, settings, baseDir, project);
                ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
                ContentEntry entry = MarkRootActionBase.findContentEntry((ModuleRootModel)model, (VirtualFile)baseDir);
                this.customizeModule(baseDir, entry);
                ApplicationManager.getApplication().runWriteAction(() -> {
                    if (project == null) {
                        NpmPackageProjectGenerator.$$$reportNull$$$0(43);
                    }
                    model.commit();
                    project.save();
                });
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
        });
    }

    @NotNull
    public WebProjectGenerator.GeneratorPeer<Settings> createPeer() {
        NpmPackageGeneratorPeer npmPackageGeneratorPeer = new NpmPackageGeneratorPeer();
        if (npmPackageGeneratorPeer == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(33);
        }
        return npmPackageGeneratorPeer;
    }

    @NotNull
    private File workingDir(@NotNull VirtualFile baseDir) {
        if (baseDir == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(34);
        }
        if (this.generateInTemp()) {
            File file2 = Files.createTempDir();
            if (file2 == null) {
                NpmPackageProjectGenerator.$$$reportNull$$$0(35);
            }
            return file2;
        }
        File file3 = VfsUtilCore.virtualToIoFile((VirtualFile)baseDir);
        if (file3 == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(36);
        }
        return file3;
    }

    protected boolean generateInTemp() {
        return false;
    }

    protected String validateProjectPath(@NotNull String path) {
        if (path == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(37);
        }
        return null;
    }

    public static boolean isGenerating(@NotNull Project project) {
        if (project == null) {
            NpmPackageProjectGenerator.$$$reportNull$$$0(38);
        }
        return GENERATING.get((UserDataHolder)project) == Boolean.TRUE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator";
                break;
            }
            case 1: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 4: 
            case 8: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: 
            case 31: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 6: 
            case 10: 
            case 13: 
            case 18: 
            case 25: 
            case 30: 
            case 34: 
            case 41: 
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 7: 
            case 9: 
            case 12: 
            case 15: 
            case 20: 
            case 27: 
            case 29: 
            case 38: 
            case 39: 
            case 43: 
            case 45: 
            case 47: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 17: 
            case 37: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 19: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 21: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binFilePathProvider";
                break;
            }
            case 32: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "executable";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getNpxCommands";
                break;
            }
            case 11: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "postInstall";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "createPeer";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "workingDir";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "executable";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "generateApp";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "postInstall";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "initBuildfiles";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "generate";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "generateProject";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "workingDir";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "validateProjectPath";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isGenerating";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "lambda$generateProject$6";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$5";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lambda$generate$4";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "lambda$initBuildfiles$3";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "lambda$postInstall$2";
                break;
            }
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class NpmPackageGeneratorPeer
    implements WebProjectGenerator.GeneratorPeer<Settings> {
        private final JPanel myPanel;
        @NotNull
        private final List<String> myPackageNames;
        @NotNull
        private final String myPresentablePackageName;
        @NotNull
        private final Convertor<String, String> myValidator;
        private NodeJsInterpreterField myInterpreterField;
        private NodePackageField myPackageField;
        private TextAccessor myLocation;

        public NpmPackageGeneratorPeer() {
            this.myPackageNames = Collections.singletonList(NpmPackageProjectGenerator.this.packageName());
            this.myPresentablePackageName = NpmPackageProjectGenerator.this.presentablePackageName();
            this.myValidator = path -> NpmPackageProjectGenerator.this.validateProjectPath((String)path);
            this.myPanel = this.createPanel();
        }

        protected JPanel createPanel() {
            JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
            this.myInterpreterField = this.createAndInitInterpreterField(ProjectManager.getInstance().getDefaultProject());
            LabeledComponent component = LabeledComponent.create((JComponent)((Object)this.myInterpreterField), (String)"Node &interpreter:");
            component.setLabelLocation("West");
            panel.add((Component)component);
            this.myPackageField = this.createAndInitPackageField();
            component = LabeledComponent.create((JComponent)((Object)this.myPackageField), (String)this.myPresentablePackageName);
            component.setAnchor((JComponent)panel.getComponent(0));
            component.setLabelLocation("West");
            panel.add((Component)component);
            return panel;
        }

        @NotNull
        private NodeJsInterpreterField createAndInitInterpreterField(Project project) {
            NodeJsInterpreterField interpreter = new NodeJsInterpreterField(project, false){

                @Override
                public boolean isDefaultProjectInterpreterField() {
                    return true;
                }
            };
            interpreter.setInterpreterRef(NodeJsInterpreterManager.getInstance(project).getInterpreterRef());
            NodeJsInterpreterField nodeJsInterpreterField = interpreter;
            if (nodeJsInterpreterField == null) {
                NpmPackageGeneratorPeer.$$$reportNull$$$0(0);
            }
            return nodeJsInterpreterField;
        }

        @NotNull
        private NodePackageField createAndInitPackageField() {
            NpxPackageDescriptor.NpxNodePackage npxPackage;
            List<NpxPackageDescriptor.NpxCommand> npxCommands = NpmPackageProjectGenerator.this.getNpxCommands();
            NodePackageField packageField = new NodePackageField(this.myInterpreterField, new NpxPackageDescriptor(this.myPackageNames, npxCommands), null);
            NodeJsInterpreter interpreter = this.myInterpreterField.getInterpreter();
            NodePackage pkg = NodePackage.findPreferredPackage(this.myInterpreterField.getProject(), this.myPackageNames, interpreter);
            NpxPackageDescriptor.NpxCommand npxCommand = (NpxPackageDescriptor.NpxCommand)ContainerUtil.getFirstItem(npxCommands);
            if (pkg.isEmptyPath() && npxCommand != null && (npxPackage = NpxPackageDescriptor.createIfAvailable(interpreter, npxCommand)) != null) {
                pkg = npxPackage;
            }
            packageField.setSelected(pkg);
            NodePackageField nodePackageField = packageField;
            if (nodePackageField == null) {
                NpmPackageGeneratorPeer.$$$reportNull$$$0(1);
            }
            return nodePackageField;
        }

        @NotNull
        public JComponent getComponent() {
            JPanel jPanel = this.myPanel;
            if (jPanel == null) {
                NpmPackageGeneratorPeer.$$$reportNull$$$0(2);
            }
            return jPanel;
        }

        public void buildUI(@NotNull SettingsStep settingsStep) {
            ModuleNameLocationSettings field;
            if (settingsStep == null) {
                NpmPackageGeneratorPeer.$$$reportNull$$$0(3);
            }
            if ((field = settingsStep.getModuleNameLocationSettings()) != null) {
                this.myLocation = new TextAccessor(){

                    public void setText(String text) {
                        field.setModuleName(text);
                    }

                    public String getText() {
                        return field.getModuleName();
                    }
                };
            }
            settingsStep.addSettingsField(UIUtil.replaceMnemonicAmpersand((String)"Node &interpreter:"), (JComponent)((Object)this.myInterpreterField));
            settingsStep.addSettingsField(UIUtil.replaceMnemonicAmpersand((String)this.myPresentablePackageName), (JComponent)((Object)this.myPackageField));
        }

        @NotNull
        public Settings getSettings() {
            Settings settings = new Settings(this.myInterpreterField.getInterpreterRef(), this.myPackageField.getSelected());
            if (settings == null) {
                NpmPackageGeneratorPeer.$$$reportNull$$$0(4);
            }
            return settings;
        }

        @Nullable
        public ValidationInfo validate() {
            String validateMessage;
            NodeJsInterpreter interpreter = this.myInterpreterField.getInterpreter();
            String error = NodeJsLocalInterpreter.getErrorMessage(interpreter);
            if (error != null) {
                return new ValidationInfo(error);
            }
            String pkgError = this.myPackageField.getSelected().getErrorMessage(UIUtil.replaceMnemonicAmpersand((String)this.myPresentablePackageName));
            if (pkgError != null) {
                return new ValidationInfo(pkgError);
            }
            if (this.myLocation == null) {
                Component component = this.myInterpreterField.getParent().getParent().getComponent(0);
                JComponent innerComponent = component instanceof LabeledComponent ? ((LabeledComponent)component).getComponent() : null;
                this.myLocation = innerComponent instanceof TextAccessor ? (TextAccessor)innerComponent : null;
            }
            String string = validateMessage = this.myLocation != null ? (String)this.myValidator.convert((Object)this.myLocation.getText()) : null;
            if (validateMessage != null) {
                return new ValidationInfo(validateMessage);
            }
            return null;
        }

        public boolean isBackgroundJobRunning() {
            return false;
        }

        public void addSettingsStateListener(@NotNull WebProjectGenerator.SettingsStateListener listener2) {
            if (listener2 == null) {
                NpmPackageGeneratorPeer.$$$reportNull$$$0(5);
            }
            this.myInterpreterField.addChangeListener(interpreter -> {
                if (listener2 == null) {
                    NpmPackageGeneratorPeer.$$$reportNull$$$0(7);
                }
                listener2.stateChanged(this.validate() == null);
            });
            this.myPackageField.addSelectionListener((Consumer<NodePackage>)((Consumer)newPackage -> {
                if (listener2 == null) {
                    NpmPackageGeneratorPeer.$$$reportNull$$$0(6);
                }
                listener2.stateChanged(this.validate() == null);
            }));
            listener2.stateChanged(this.validate() == null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator$NpmPackageGeneratorPeer";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "settingsStep";
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createAndInitInterpreterField";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createAndInitPackageField";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getComponent";
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator$NpmPackageGeneratorPeer";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSettings";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "buildUI";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "addSettingsStateListener";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$addSettingsStateListener$2";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$addSettingsStateListener$1";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: 
                case 5: 
                case 6: 
                case 7: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class Settings
    extends UserDataHolderBase {
        public NodeJsInterpreterRef myInterpreterRef;
        public NodePackage myPackage;

        public Settings(@NotNull NodeJsInterpreterRef interpreter, @NotNull NodePackage pkg) {
            if (interpreter == null) {
                Settings.$$$reportNull$$$0(0);
            }
            if (pkg == null) {
                Settings.$$$reportNull$$$0(1);
            }
            this.myInterpreterRef = interpreter;
            this.myPackage = pkg;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "interpreter";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pkg";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/boilerplate/NpmPackageProjectGenerator$Settings";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

