/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.gulp.rc;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.lang.javascript.buildTools.gulp.GulpService;
import com.intellij.lang.javascript.buildTools.gulp.codeInsight.GulpfilePsiStructure;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpConfigurationType;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunConfiguration;
import com.intellij.lang.javascript.buildTools.gulp.rc.GulpRunSettings;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ObjectUtils;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GulpRunConfigurationProducer
extends RunConfigurationProducer<GulpRunConfiguration> {
    protected GulpRunConfigurationProducer() {
        super((ConfigurationType)GulpConfigurationType.getInstance());
    }

    protected boolean setupConfigurationFromContext(GulpRunConfiguration configuration, ConfigurationContext context, Ref<PsiElement> sourceElement) {
        GulpRunSettings runSettings = GulpRunConfigurationProducer.createRunSettingsFromContext(configuration.getRunSettings(), context, sourceElement);
        if (runSettings == null) {
            return false;
        }
        GulpRunConfigurationProducer.setupConfigurationFromSettings(configuration, runSettings);
        return true;
    }

    public static void setupConfigurationFromSettings(@NotNull GulpRunConfiguration configuration, @NotNull GulpRunSettings runSettings) {
        if (configuration == null) {
            GulpRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        if (runSettings == null) {
            GulpRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        configuration.setRunSettings(runSettings);
        configuration.setName(GulpRunConfigurationProducer.buildName(runSettings.getTasks()));
    }

    public boolean isConfigurationFromContext(GulpRunConfiguration configuration, ConfigurationContext context) {
        GulpRunSettings thisRunSettings = GulpRunConfigurationProducer.createRunSettingsFromContext(configuration.getRunSettings(), context, null);
        if (thisRunSettings == null) {
            return false;
        }
        return GulpService.getInstance().isConfigurationMatched((RunConfiguration)configuration, thisRunSettings);
    }

    @Nullable
    private static GulpRunSettings createRunSettingsFromContext(@NotNull GulpRunSettings templateRunSettings, @NotNull ConfigurationContext context, @Nullable Ref<PsiElement> sourceElement) {
        JSFile leastEnclosingElement;
        PsiElement element;
        if (templateRunSettings == null) {
            GulpRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (context == null) {
            GulpRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if ((element = GulpRunConfigurationProducer.getElement(context)) == null || !element.isValid()) {
            return null;
        }
        JSFile psiGulpfile = GulpRunConfigurationProducer.getGulpfile(element);
        if (psiGulpfile == null) {
            return null;
        }
        VirtualFile virtualGulpfile = psiGulpfile.getVirtualFile();
        if (virtualGulpfile == null) {
            return null;
        }
        Pair<String, JSCallExpression> taskPair = GulpfilePsiStructure.findEnclosingTask(element, psiGulpfile);
        GulpRunSettings.Builder builder = new GulpRunSettings.Builder(templateRunSettings);
        builder.setGulpfilePath(FileUtil.toSystemDependentName((String)virtualGulpfile.getPath()));
        if (taskPair != null) {
            builder.setTasks(Collections.singletonList(taskPair.getFirst()));
            leastEnclosingElement = (PsiElement)taskPair.getSecond();
        } else {
            builder.setTasks(Collections.singletonList("default"));
            leastEnclosingElement = psiGulpfile;
        }
        if (sourceElement != null) {
            sourceElement.set((Object)leastEnclosingElement);
        }
        return builder.build();
    }

    @Nullable
    private static PsiElement getElement(@NotNull ConfigurationContext context) {
        Location location;
        if (context == null) {
            GulpRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        return (location = context.getLocation()) != null ? location.getPsiElement() : null;
    }

    @Nullable
    private static JSFile getGulpfile(@NotNull PsiElement element) {
        VirtualFile file2;
        if (element == null) {
            GulpRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        JSFile jsFile = element instanceof PsiFile ? (JSFile)ObjectUtils.tryCast((Object)element, JSFile.class) : (JSFile)ObjectUtils.tryCast((Object)element.getContainingFile(), JSFile.class);
        VirtualFile virtualFile = file2 = jsFile != null ? jsFile.getVirtualFile() : null;
        if (file2 != null && GulpService.getInstance().isBuildfile(file2)) {
            return jsFile;
        }
        return null;
    }

    private static String buildName(@NotNull List<String> tasks) {
        if (tasks == null) {
            GulpRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (tasks.isEmpty()) {
            return "default";
        }
        return StringUtil.join(tasks, (String)", ");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runSettings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "templateRunSettings";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/buildTools/gulp/rc/GulpRunConfigurationProducer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "setupConfigurationFromSettings";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createRunSettingsFromContext";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getElement";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getGulpfile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "buildName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

