/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm;

import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtSortingMode;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsService;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsStructure;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="JsBuildToolPackageJson", storages={@Storage(value="$WORKSPACE_FILE$")})
public class PackageJsonFileManager
extends JsbtFileManager
implements PersistentStateComponent<Element> {
    private static final String DETECTION_DONE_ATTR = "detection-done";
    private static final String SORTING_ATTR = "sorting";
    private static final String PACKAGE_JSON_TAG = "package-json";

    public PackageJsonFileManager(@NotNull Project project) {
        if (project == null) {
            PackageJsonFileManager.$$$reportNull$$$0(0);
        }
        super(project, NpmScriptsService.getInstance());
    }

    @NotNull
    public static PackageJsonFileManager getInstance(@NotNull Project project) {
        if (project == null) {
            PackageJsonFileManager.$$$reportNull$$$0(1);
        }
        PackageJsonFileManager packageJsonFileManager = (PackageJsonFileManager)ServiceManager.getService((Project)project, PackageJsonFileManager.class);
        if (packageJsonFileManager == null) {
            PackageJsonFileManager.$$$reportNull$$$0(2);
        }
        return packageJsonFileManager;
    }

    @Override
    @Nullable
    public NpmScriptsStructure getCachedStructure(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            PackageJsonFileManager.$$$reportNull$$$0(3);
        }
        return (NpmScriptsStructure)super.getCachedStructure(packageJson);
    }

    @Override
    protected boolean shouldSaveAllDocumentBeforeFetch() {
        return false;
    }

    @Nullable
    public Element getState() {
        Element parent = new Element("package-json-files");
        if (this.isDetectionDone()) {
            parent.setAttribute(DETECTION_DONE_ATTR, Boolean.TRUE.toString());
        }
        parent.setAttribute(SORTING_ATTR, this.getSortingMode().name());
        List paths = ContainerUtil.map(this.getBuildfiles(), file2 -> file2.getPath());
        JDOMExternalizerUtil.addChildrenWithValueAttribute((Element)parent, (String)PACKAGE_JSON_TAG, (List)paths);
        return parent;
    }

    public void loadState(@NotNull Element parent) {
        if (parent == null) {
            PackageJsonFileManager.$$$reportNull$$$0(4);
        }
        if (parent == null) {
            return;
        }
        this.clearAllBuildfiles();
        if (Boolean.parseBoolean(parent.getAttributeValue(DETECTION_DONE_ATTR))) {
            this.setDetectionDone();
        }
        this.setSortingMode(JsbtSortingMode.findByName(parent.getAttributeValue(SORTING_ATTR), JsbtSortingMode.DEFINITION_ORDER));
        List paths = JDOMExternalizerUtil.getChildrenValueAttributes((Element)parent, (String)PACKAGE_JSON_TAG);
        for (String path : paths) {
            VirtualFile packageJson;
            if (!StringUtil.isNotEmpty((String)path) || (packageJson = LocalFileSystem.getInstance().findFileByPath(path)) == null || !packageJson.isValid() || packageJson.isDirectory()) continue;
            this.addBuildfileStructure(new NpmScriptsStructure(packageJson));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/PackageJsonFileManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/PackageJsonFileManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCachedStructure";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

