/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.ecmascript6.TypeScriptQualifiedNameResolver;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptType;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.JSImportHandler;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.resolve.accessibility.TypeScriptModuleAccessibilityChecker;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class TypeScriptImportHandler
extends JSImportHandler {
    private static final TypeScriptImportHandler INSTANCE = new TypeScriptImportHandler();

    protected TypeScriptImportHandler() {
    }

    public static TypeScriptImportHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public JSTypeResolveResult resolveMainElementName(@NotNull String type, @NotNull PsiElement context) {
        if (type == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(0);
        }
        if (context == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(1);
        }
        return TypeScriptImportHandler.resolveNameImpl(type, context, true, false);
    }

    @Override
    public JSTypeResolveResult resolveTypeName(@NotNull String type, @NotNull PsiElement context) {
        if (type == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(2);
        }
        if (context == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(3);
        }
        return TypeScriptImportHandler.resolveNameImpl(type, context, true, true);
    }

    @Override
    @NotNull
    public JSTypeResolveResult resolveName(@NotNull String type, @NotNull PsiElement source) {
        if (type == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(4);
        }
        if (source == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(5);
        }
        JSTypeResolveResult jSTypeResolveResult = TypeScriptImportHandler.resolveNameImpl(type, source, false, true);
        if (jSTypeResolveResult == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(6);
        }
        return jSTypeResolveResult;
    }

    @NotNull
    private static JSTypeResolveResult resolveNameImpl(@NotNull String type, @NotNull PsiElement sourceRaw, boolean typeContext, boolean includeAugmentations) {
        PsiElement source;
        if (type == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(7);
        }
        if (sourceRaw == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(8);
        }
        if ((source = TypeScriptImportHandler.getSourceElement(sourceRaw)) == null) {
            source = sourceRaw;
        }
        if (!DialectDetector.isTypeScript(source)) {
            JSTypeResolveResult jSTypeResolveResult = new JSTypeResolveResult(type, null);
            if (jSTypeResolveResult == null) {
                TypeScriptImportHandler.$$$reportNull$$$0(9);
            }
            return jSTypeResolveResult;
        }
        List elements = TypeScriptImportHandler.resolveTypeElements(type, source, typeContext, includeAugmentations);
        PsiElement finalSource = source;
        if ((elements = ContainerUtil.filter(elements, element -> TypeScriptConfigService.Provider.isAccessible(finalSource, element) && TypeScriptImportHandler.checkModulesAccess(finalSource, element))).isEmpty()) {
            JSTypeResolveResult jSTypeResolveResult = new JSTypeResolveResult(type, null);
            if (jSTypeResolveResult == null) {
                TypeScriptImportHandler.$$$reportNull$$$0(10);
            }
            return jSTypeResolveResult;
        }
        String qName = TypeScriptImportHandler.getQualifiedName(elements);
        JSTypeResolveResult jSTypeResolveResult = new JSTypeResolveResult(qName, elements);
        if (jSTypeResolveResult == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(11);
        }
        return jSTypeResolveResult;
    }

    @NotNull
    private static String getQualifiedName(@NotNull Collection<? extends PsiElement> elements) {
        if (elements == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(12);
        }
        for (PsiElement psiElement : elements) {
            if (!(psiElement instanceof JSQualifiedNamedElement) || TypeScriptPsiUtil.isFromAugmentationModule(psiElement)) continue;
            String string = StringUtil.notNullize((String)((JSQualifiedNamedElement)psiElement).getQualifiedName());
            if (string == null) {
                TypeScriptImportHandler.$$$reportNull$$$0(13);
            }
            return string;
        }
        PsiElement element = (PsiElement)ContainerUtil.getFirstItem(elements);
        String string = element instanceof JSQualifiedNamedElement ? StringUtil.notNullize((String)((JSQualifiedNamedElement)element).getQualifiedName()) : "";
        if (string == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(14);
        }
        return string;
    }

    private static PsiElement getSourceElement(@NotNull PsiElement sourceRaw) {
        PsiElement type;
        if (sourceRaw == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(15);
        }
        if (sourceRaw instanceof TypeScriptType) {
            sourceRaw = sourceRaw.getContext();
        }
        if (TypeScriptPsiUtil.isTopLevelContainer(type = PsiTreeUtil.getContextOfType((PsiElement)sourceRaw, (boolean)false, (Class[])new Class[]{JSSourceElement.class})) || type == null) {
            return type;
        }
        PsiElement parent = type.getContext();
        if (type instanceof JSBlockStatement) {
            if (parent instanceof JSFunction) {
                return parent;
            }
            return type;
        }
        if (parent != null && TypeScriptPsiUtil.isTopLevelContainer(parent)) {
            return parent;
        }
        return type;
    }

    @NotNull
    private static Collection<PsiElement> resolveTypeElements(@NotNull String qName, @NotNull PsiElement source, boolean typeContext, boolean includeAugmentations) {
        if (qName == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(16);
        }
        if (source == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(17);
        }
        Collection<PsiElement> collection = new TypeScriptQualifiedNameResolver(source, typeContext, includeAugmentations, (Set<Pair<String, PsiElement>>)new THashSet()).resolveQualifiedName(qName);
        if (collection == null) {
            TypeScriptImportHandler.$$$reportNull$$$0(18);
        }
        return collection;
    }

    public static boolean checkModulesAccess(PsiElement source, PsiElement element) {
        return TypeScriptModuleAccessibilityChecker.INSTANCE.check(source, element) == null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler";
                break;
            }
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRaw";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptImportHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveName";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveNameImpl";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getQualifiedName";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTypeElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resolveMainElementName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveName";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 18: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "resolveNameImpl";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSourceElement";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "resolveTypeElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

