/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.formatter.blocks;

import com.intellij.embedding.EmbeddingElementType;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.BlockEx;
import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSNodeVisitor;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.flow.FlowJSElementTypes;
import com.intellij.lang.javascript.formatter.JSBlockContext;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.formatter.JSFormatterUtil;
import com.intellij.lang.javascript.formatter.JSSpacingProcessor;
import com.intellij.lang.javascript.formatter.JavascriptFormattingModelBuilder;
import com.intellij.lang.javascript.formatter.blocks.CompositeJSBlock;
import com.intellij.lang.javascript.formatter.blocks.JSBlock;
import com.intellij.lang.javascript.formatter.blocks.JSDocCommentBlock;
import com.intellij.lang.javascript.formatter.blocks.alignment.ASTNodeBasedAlignmentFactory;
import com.intellij.lang.javascript.formatter.blocks.alignment.JSLocalAlignmentFactory;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSIfStatement;
import com.intellij.lang.javascript.psi.JSLoopStatement;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.types.JSAttributeListElementType;
import com.intellij.lang.javascript.types.JSClassElementTypeBase;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.lang.javascript.types.JSPropertyElementType;
import com.intellij.lang.typescript.TypeScriptElementTypes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.WrappingUtil;
import com.intellij.psi.formatter.xml.XmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.formatter.xml.XmlTagBlock;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SubBlockVisitor
extends JSNodeVisitor {
    private static final TokenSet IMPORT_EXPORT_SPECIFIERS = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.EXPORT_SPECIFIER, ES6ElementTypes.IMPORT_SPECIFIER});
    private static final TokenSet IMPORT_EXPORT_DECLARATIONS = TokenSet.create((IElementType[])new IElementType[]{ES6ElementTypes.EXPORT_DECLARATION, ES6ElementTypes.IMPORT_DECLARATION});
    private static final TokenSet EXTENDS_IMPLEMENTS_KEYWORDS = TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.EXTENDS_KEYWORD, JSTokenTypes.IMPLEMENTS_KEYWORD});
    List<Block> myBlocks;
    protected final CommonCodeStyleSettings mySettings;
    private final Language myDialect;
    protected final JSCodeStyleSettings myJSCodeStyleSettings;
    private final JSBlock myBlock;
    private final JSLocalAlignmentFactory myAlignmentFactory;
    private final JSBlockContext myBlockContext;
    private final FormattingMode myFormattingMode;

    public SubBlockVisitor(@Nullable JSBlock block, @Nullable ASTNodeBasedAlignmentFactory alignmentFactory, @NotNull JSBlockContext jsBlockContext) {
        if (jsBlockContext == null) {
            SubBlockVisitor.$$$reportNull$$$0(0);
        }
        this.myBlocks = new ArrayList<Block>();
        this.myBlock = block;
        this.myBlockContext = jsBlockContext;
        this.myDialect = jsBlockContext.getDialect();
        this.mySettings = jsBlockContext.getCommonSettings();
        this.myJSCodeStyleSettings = jsBlockContext.getDialectSettings();
        this.myFormattingMode = jsBlockContext.getFormattingMode();
        this.myAlignmentFactory = this.createLocalAlignmentFactory(jsBlockContext.getTopSettings());
        this.myAlignmentFactory.setSharedAlignmentFactory(alignmentFactory);
    }

    protected JSLocalAlignmentFactory createLocalAlignmentFactory(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            SubBlockVisitor.$$$reportNull$$$0(1);
        }
        return new JSLocalAlignmentFactory(this.mySettings, this.myFormattingMode);
    }

    public List<Block> getBlocks() {
        return this.myBlocks;
    }

    @Override
    public void visitElement(ASTNode node) {
        List<ASTNode> children = SubBlockVisitor.getNonEmptyNodes(node);
        if (SubBlockVisitor.requiresCompositeBlockForBody(node.getElementType())) {
            this.generateBlocksForClassNode(node, children);
        } else {
            Indent sharedSmartIndent = Indent.getSmartIndent((Indent.Type)Indent.Type.CONTINUATION);
            Wrap sharedChildWrap = JSFormatterUtil.createSharedWrapForChildren(node, this.mySettings, this.myJSCodeStyleSettings);
            for (ASTNode child : children) {
                this.addBlock(this.createBlockForNode(child, this.getWrap(node, child, sharedChildWrap), this.getIndent(node, child, sharedSmartIndent)));
            }
        }
    }

    @NotNull
    private Block createBlockForNode(@NotNull ASTNode child, @Nullable Wrap wrap, @Nullable Indent childIndent) {
        if (child == null) {
            SubBlockVisitor.$$$reportNull$$$0(2);
        }
        Alignment childAlignment = this.myAlignmentFactory.getAlignment(child);
        Block block = this.myBlockContext.createBlock(child, wrap, childAlignment, childIndent, this.myAlignmentFactory.getSharedAlignmentFactory(), this.myBlock);
        if (block == null) {
            SubBlockVisitor.$$$reportNull$$$0(3);
        }
        return block;
    }

    private void generateBlocksForClassNode(@NotNull ASTNode node, @NotNull List<ASTNode> children) {
        if (node == null) {
            SubBlockVisitor.$$$reportNull$$$0(4);
        }
        if (children == null) {
            SubBlockVisitor.$$$reportNull$$$0(5);
        }
        Indent sharedSmartIndent = Indent.getSmartIndent((Indent.Type)Indent.Type.CONTINUATION);
        boolean isInClassBlock = false;
        ArrayList classBody = ContainerUtil.newArrayList();
        for (ASTNode child : children) {
            Block childBlock = this.createBlockForNode(child, this.getWrap(node, child, null), this.getIndent(node, child, sharedSmartIndent));
            if (child.getElementType() == JSTokenTypes.LBRACE) {
                isInClassBlock = true;
                classBody.add(childBlock);
                continue;
            }
            if (child.getElementType() == JSTokenTypes.RBRACE) {
                Indent indent = this.mySettings.CLASS_BRACE_STYLE == 4 || this.mySettings.CLASS_BRACE_STYLE == 3 ? Indent.getNormalIndent() : Indent.getNoneIndent();
                classBody.add(childBlock);
                isInClassBlock = false;
                if (classBody.isEmpty()) continue;
                this.addBlock((Block)new CompositeJSBlock((List<Block>)ContainerUtil.immutableList((List)classBody), this.myBlock.getSpacingStrategy(), indent, node.getElementType(), this.myJSCodeStyleSettings));
                classBody = ContainerUtil.newArrayList();
                continue;
            }
            if (isInClassBlock) {
                classBody.add(childBlock);
                continue;
            }
            this.addBlock(childBlock);
        }
        classBody.forEach(this::addBlock);
    }

    @NotNull
    private static List<ASTNode> getNonEmptyNodes(@NotNull ASTNode node) {
        if (node == null) {
            SubBlockVisitor.$$$reportNull$$$0(6);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (PsiElement elt = node.getPsi().getFirstChild(); elt != null; elt = elt.getNextSibling()) {
            ASTNode child = elt.getNode();
            assert (child != null);
            if (child.getElementType() == JSTokenTypes.WHITE_SPACE || child.getTextRange().getLength() <= 0) continue;
            result2.add(child);
        }
        ArrayList arrayList = result2;
        if (arrayList == null) {
            SubBlockVisitor.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Override
    public void visitDocComment(ASTNode node) {
        ASTNode child = node.getFirstChildNode();
        if (child != null && child.getElementType() == JSTokenTypes.DOC_COMMENT) {
            this.visit(child);
        } else {
            super.visitDocComment(node);
        }
    }

    @Override
    public void visitComment(ASTNode node) {
        if (this.myJSCodeStyleSettings.REFORMAT_C_STYLE_COMMENTS) {
            this.buildCommentBlocks(node);
        }
    }

    protected void addBlock(Block block) {
        this.myBlocks.add(block);
    }

    private void buildCommentBlocks(ASTNode node) {
        String commentText = node.getText();
        int pos = 0;
        while (pos < commentText.length()) {
            int nextPos = commentText.indexOf(10, pos);
            if (nextPos < 0) {
                nextPos = commentText.length();
            }
            if (pos != nextPos) {
                Indent childIndent = pos == 0 ? Indent.getNoneIndent() : Indent.getSpaceIndent((int)1);
                this.addBlock(new JSDocCommentBlock(node, pos, nextPos, childIndent));
            }
            for (pos = nextPos + 1; pos < commentText.length() && (commentText.charAt(pos) == ' ' || commentText.charAt(pos) == '\t' || commentText.charAt(pos) == '\n'); ++pos) {
            }
        }
    }

    @Nullable
    protected Indent getIndent(ASTNode node, ASTNode child, @Nullable Indent sharedSmartIndent) {
        ASTNode prevSibling;
        int braceStyle;
        ASTNode prevNode;
        IElementType parentNodeType;
        IElementType nodeElementType = node.getElementType();
        if (nodeElementType instanceof JSFileElementType || nodeElementType instanceof EmbeddingElementType || node.getPsi() instanceof JSFile) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType == JSTokenTypes.DOC_COMMENT) {
            ASTNode treePrev = child.getTreePrev();
            if (treePrev != null && treePrev.getPsi() instanceof PsiWhiteSpace && treePrev.textContains('\n')) {
                return Indent.getSpaceIndent((int)1);
            }
            return Indent.getNoneIndent();
        }
        if (nodeElementType == JSElementTypes.CONDITIONAL_EXPRESSION && child != node.getFirstChildNode()) {
            return sharedSmartIndent;
        }
        if (nodeElementType == ES6ElementTypes.IMPORT_DECLARATION && child.getElementType() == ES6ElementTypes.NAMED_IMPORTS) {
            return Indent.getNoneIndent();
        }
        IElementType childElementType = child.getElementType();
        ASTNode parentNode = node.getTreeParent();
        IElementType iElementType = parentNodeType = parentNode != null ? parentNode.getElementType() : null;
        if (childElementType == JSTokenTypes.END_OF_LINE_COMMENT && (prevNode = child.getTreePrev()) != null && prevNode.getPsi() instanceof PsiWhiteSpace && prevNode.getText().endsWith("\n") && this.mySettings.KEEP_FIRST_COLUMN_COMMENT) {
            return Indent.getAbsoluteNoneIndent();
        }
        if (nodeElementType == JSStubElementTypes.RETURN_STATEMENT) {
            if (node.getFirstChildNode() == child) {
                return Indent.getNoneIndent();
            }
            return Indent.getIndent((Indent.Type)Indent.Type.CONTINUATION, (boolean)false, (boolean)false);
        }
        if (nodeElementType == ES6ElementTypes.EXPORT_DEFAULT_ASSIGNMENT) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType == TypeScriptElementTypes.TYPESCRIPT_GLOBAL_MODULE_EXPORT) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType == JSStubElementTypes.DESTRUCTURING_OBJECT) {
            if (childElementType == JSTokenTypes.LBRACE || childElementType == JSTokenTypes.RBRACE) {
                return Indent.getNoneIndent();
            }
            return Indent.getNormalIndent();
        }
        if (nodeElementType == ES6ElementTypes.CLASS && (childElementType == JSStubElementTypes.CALL_SIGNATURE || childElementType == JSStubElementTypes.FUNCTION_SIGNATURE || childElementType == FlowJSElementTypes.FUNCTION_SIGNATURE || childElementType == TypeScriptElementTypes.PROPERTY_SIGNATURE)) {
            return Indent.getNormalIndent();
        }
        if (JSExtendedLanguagesTokenSetProvider.CLASSES.contains(nodeElementType) && JSElementTypes.EXTENDS_IMPLEMENTS_LISTS.contains(childElementType)) {
            return Indent.getContinuationIndent();
        }
        if ((JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(nodeElementType) || nodeElementType == TypeScriptElementTypes.OBJECT_TYPE) && (braceStyle = this.getBraceStyle(parentNode)) == 3) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType == JSStubElementTypes.OBJECT_LITERAL_EXPRESSION || nodeElementType == TypeScriptElementTypes.OBJECT_TYPE || IMPORT_EXPORT_DECLARATIONS.contains(nodeElementType) || ES6ElementTypes.NAMED_IMPORTS == nodeElementType) {
            if (childElementType == JSTokenTypes.RBRACE || childElementType == JSTokenTypes.LBRACE || childElementType == JSTokenTypes.OR_RBRACE || childElementType == JSTokenTypes.LBRACE_OR || childElementType == JSTokenTypes.IMPORT_KEYWORD || childElementType == JSTokenTypes.EXPORT_KEYWORD) {
                return Indent.getNoneIndent();
            }
            if (childElementType == JSTokenTypes.COMMA) {
                return this.getCommaIndent(Indent.Type.NORMAL);
            }
            return Indent.getIndent((Indent.Type)Indent.Type.NORMAL, (boolean)false, (boolean)true);
        }
        if (JSElementTypes.FUNCTION_EXPRESSIONS.contains(nodeElementType) && parentNodeType == JSElementTypes.ARGUMENT_LIST) {
            if (childElementType == JSTokenTypes.FUNCTION_KEYWORD || JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(childElementType)) {
                return Indent.getNoneIndent();
            }
            ASTNode next = TreeUtil.skipElements((ASTNode)child.getTreeNext(), (TokenSet)TokenSet.create((IElementType[])new IElementType[]{JSTokenTypes.WHITE_SPACE}));
            if (next != null && next.getElementType() == JSTokenTypes.EQGT) {
                return Indent.getNoneIndent();
            }
        }
        if (JSElementTypes.FUNCTION_DECLARATIONS.contains(nodeElementType)) {
            if (childElementType == JSTokenTypes.COLON || TypeScriptElementTypes.TYPESCRIPT_TYPES.contains(childElementType)) {
                return Indent.getContinuationIndent();
            }
            if (!JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(childElementType)) {
                return Indent.getNoneIndent();
            }
        }
        if (JSElementTypes.FUNCTION_EXPRESSIONS.contains(nodeElementType) && childElementType == JSTokenTypes.FUNCTION_KEYWORD) {
            return Indent.getNoneIndent();
        }
        if (JSElementTypes.PARAMETER_LISTS.contains(nodeElementType)) {
            if (JSFormatterUtil.isEnterAtNewArgument(this.myFormattingMode, child)) {
                return sharedSmartIndent;
            }
            if (childElementType == JSTokenTypes.RPAR || node.getFirstChildNode() == child) {
                return Indent.getNoneIndent();
            }
            return sharedSmartIndent;
        }
        if (nodeElementType == JSElementTypes.ARGUMENT_LIST) {
            if (JSFormatterUtil.isEnterAtNewArgument(this.myFormattingMode, child)) {
                return sharedSmartIndent;
            }
            if (childElementType == JSTokenTypes.LPAR || childElementType == JSTokenTypes.RPAR) {
                return Indent.getNoneIndent();
            }
            return sharedSmartIndent;
        }
        if (nodeElementType == JSStubElementTypes.PACKAGE_STATEMENT && !JSSpacingProcessor.NOT_A_PACKAGE_CONTENT.contains(childElementType)) {
            if (this.myJSCodeStyleSettings.INDENT_PACKAGE_CHILDREN == 1) {
                return Indent.getNormalIndent();
            }
            return Indent.getNoneIndent();
        }
        if (JSStubElementTypes.ATTRIBUTE_LISTS.contains(nodeElementType) || JSStubElementTypes.ATTRIBUTE_LISTS.contains(childElementType)) {
            return Indent.getNoneIndent();
        }
        if ((nodeElementType instanceof JSPropertyElementType || JSElementTypes.FUNCTION_PROPERTIES.contains(nodeElementType)) && (child == ((JSProperty)node.getPsi()).getNameIdentifier() || childElementType == ES6ElementTypes.COMPUTED_NAME || JSTokenTypes.COMMENTS.contains(childElementType) || child.getPsi() instanceof JSReferenceExpression)) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType == JSElementTypes.SPREAD_EXPRESSION && childElementType == JSTokenTypes.DOT_DOT_DOT) {
            return Indent.getNoneIndent();
        }
        if (JSElementTypes.VAR_STATEMENTS.contains(nodeElementType)) {
            if (JSTokenTypes.VAR_MODIFIERS.contains(childElementType) || SubBlockVisitor.isStatementLevelComment(child) || childElementType == JSTokenTypes.SEMICOLON) {
                return Indent.getNoneIndent();
            }
            if (parentNodeType == JSStubElementTypes.TYPESCRIPT_ENUM) {
                return Indent.getNoneIndent();
            }
            if (JSElementTypes.BODY_VARIABLES.contains(childElementType)) {
                IElementType prevElementType;
                ASTNode prev = child.getTreePrev();
                IElementType iElementType2 = prevElementType = prev != null ? prev.getElementType() : null;
                if (prev == null || parentNodeType instanceof JSClassElementTypeBase && !JavaScriptSupportLoader.ECMA_SCRIPT_L4.is(this.myDialect) || prevElementType instanceof JSAttributeListElementType || JSTokenTypes.VAR_MODIFIERS.contains(prevElementType)) {
                    return Indent.getNoneIndent();
                }
            }
            if (childElementType == JSTokenTypes.COMMA) {
                return this.getCommaIndent(Indent.Type.CONTINUATION);
            }
            return sharedSmartIndent;
        }
        if (JSElementTypes.BODY_VARIABLES.contains(nodeElementType) && childElementType == JSTokenTypes.IDENTIFIER) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType == JSStubElementTypes.TYPESCRIPT_INTERFACE && childElementType == TypeScriptElementTypes.OBJECT_TYPE) {
            braceStyle = this.getBraceStyle(node);
            if (braceStyle == 3 || braceStyle == 4) {
                return Indent.getNormalIndent();
            }
            return Indent.getNoneIndent();
        }
        if (JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(childElementType)) {
            braceStyle = this.getBraceStyle(node);
            if (braceStyle == 3 || braceStyle == 4) {
                return Indent.getNormalIndent();
            }
            if (JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(nodeElementType) || nodeElementType instanceof JSClassElementTypeBase || nodeElementType == JSStubElementTypes.TYPESCRIPT_INTERFACE || nodeElementType == JSStubElementTypes.TYPESCRIPT_ENUM || nodeElementType == JSStubElementTypes.TYPESCRIPT_MODULE) {
                return Indent.getNormalIndent();
            }
            return Indent.getNoneIndent();
        }
        if (childElementType == JSElementTypes.CATCH_BLOCK) {
            return Indent.getNoneIndent();
        }
        if (JSExtendedLanguagesTokenSetProvider.CASE_CLAUSES.contains(childElementType)) {
            return this.mySettings.INDENT_CASE_FROM_SWITCH ? Indent.getNormalIndent() : Indent.getNoneIndent();
        }
        if (JSExtendedLanguagesTokenSetProvider.CASE_CLAUSES.contains(nodeElementType)) {
            if (JSExtendedLanguagesTokenSetProvider.STATEMENTS.contains(childElementType) || JSTokenTypes.COMMENTS.contains(childElementType)) {
                return Indent.getNormalIndent();
            }
            return Indent.getNoneIndent();
        }
        if (nodeElementType == JSElementTypes.SWITCH_STATEMENT && (childElementType == JSTokenTypes.RBRACE || childElementType == JSTokenTypes.LBRACE)) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType == JSElementTypes.IF_STATEMENT) {
            if (childElementType == JSTokenTypes.LPAR || childElementType == JSTokenTypes.RPAR || childElementType == JSTokenTypes.IF_KEYWORD) {
                return Indent.getNoneIndent();
            }
            if (FormatterUtil.isPrecededBy((ASTNode)child, (IElementType)JSTokenTypes.LPAR)) {
                return Indent.getContinuationIndent();
            }
            if (childElementType == JSTokenTypes.ELSE_KEYWORD || JSTokenTypes.COMMENTS.contains(childElementType)) {
                return Indent.getNoneIndent();
            }
            if (childElementType == JSElementTypes.IF_STATEMENT && this.mySettings.SPECIAL_ELSE_IF_TREATMENT && ((JSIfStatement)node.getPsi()).getElse() == child.getPsi()) {
                return Indent.getNoneIndent();
            }
            if (JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS.contains(childElementType)) {
                return Indent.getNormalIndent();
            }
        }
        if (nodeElementType == JSElementTypes.FOR_STATEMENT) {
            if (childElementType == JSTokenTypes.LPAR || childElementType == JSTokenTypes.RPAR || childElementType == JSTokenTypes.FOR_KEYWORD) {
                return Indent.getNoneIndent();
            }
            if (node.getLastChildNode() == child) {
                return JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(childElementType) ? Indent.getNoneIndent() : Indent.getNormalIndent();
            }
            return Indent.getContinuationIndent();
        }
        if (nodeElementType == JSElementTypes.WITH_STATEMENT && JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS.contains(childElementType)) {
            return Indent.getNormalIndent();
        }
        if (nodeElementType == JSElementTypes.DOWHILE_STATEMENT && childElementType == JSTokenTypes.WHILE_KEYWORD) {
            return Indent.getNoneIndent();
        }
        if ((nodeElementType == JSElementTypes.DOWHILE_STATEMENT || nodeElementType == JSElementTypes.WHILE_STATEMENT) && (prevSibling = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)child)) != null && prevSibling.getElementType() == JSTokenTypes.LPAR) {
            return sharedSmartIndent;
        }
        if (nodeElementType == JSElementTypes.TRY_STATEMENT && childElementType == JSTokenTypes.FINALLY_KEYWORD) {
            return Indent.getNoneIndent();
        }
        if (JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(nodeElementType) || nodeElementType instanceof JSClassElementTypeBase || nodeElementType == JSStubElementTypes.PACKAGE_STATEMENT || nodeElementType == JSStubElementTypes.TYPESCRIPT_MODULE || nodeElementType == JSStubElementTypes.TYPESCRIPT_ENUM || nodeElementType == JSStubElementTypes.TYPESCRIPT_INTERFACE) {
            if (SubBlockVisitor.requiresCompositeBlockForBody(nodeElementType) && (childElementType == JSTokenTypes.LBRACE || childElementType == JSTokenTypes.RBRACE || this.mySettings.CLASS_BRACE_STYLE == 3)) {
                return Indent.getNoneIndent();
            }
            if (JSExtendedLanguagesTokenSetProvider.SOURCE_ELEMENTS.contains(childElementType) || JSTokenTypes.COMMENTS.contains(childElementType) && (childElementType != JSTokenTypes.DOC_COMMENT || node.getFirstChildNode() != child)) {
                return Indent.getNormalIndent();
            }
            if (child instanceof OuterLanguageElement) {
                return Indent.getNormalIndent();
            }
            return Indent.getNoneIndent();
        }
        if (node.getPsi() instanceof JSLoopStatement && child.getPsi() == ((JSLoopStatement)node.getPsi()).getBody()) {
            if (JSExtendedLanguagesTokenSetProvider.BLOCK_STATEMENTS.contains(childElementType)) {
                return Indent.getNoneIndent();
            }
            return Indent.getNormalIndent();
        }
        if (nodeElementType == JSElementTypes.ARRAY_LITERAL_EXPRESSION || nodeElementType == JSStubElementTypes.DESTRUCTURING_ARRAY) {
            if (childElementType == JSTokenTypes.LBRACKET || childElementType == JSTokenTypes.RBRACKET) {
                return Indent.getNoneIndent();
            }
            return Indent.getNormalIndent();
        }
        if (nodeElementType == JSStubElementTypes.OBJECT_LITERAL_EXPRESSION) {
            if (childElementType == JSTokenTypes.LBRACE || childElementType == JSTokenTypes.RBRACE) {
                return Indent.getNoneIndent();
            }
            return Indent.getNormalIndent();
        }
        if (nodeElementType == JSElementTypes.EMBEDDED_EXPRESSION) {
            if (childElementType == JSTokenTypes.LBRACE || childElementType == JSTokenTypes.RBRACE) {
                return Indent.getNoneIndent();
            }
            return Indent.getNormalIndent();
        }
        if (nodeElementType == JSStubElementTypes.ASSIGNMENT_EXPRESSION) {
            return Indent.getContinuationWithoutFirstIndent();
        }
        if (nodeElementType == JSElementTypes.EXPRESSION_STATEMENT) {
            return Indent.getNoneIndent();
        }
        if (nodeElementType == JSElementTypes.PARENTHESIZED_EXPRESSION || nodeElementType == FlowJSElementTypes.TYPE_CAST) {
            if (childElementType == JSTokenTypes.LPAR || childElementType == JSTokenTypes.RPAR) {
                return Indent.getNoneIndent();
            }
            if (SubBlockVisitor.shouldIndentParenthesized(node)) {
                return Indent.getIndent((Indent.Type)Indent.Type.CONTINUATION, (boolean)false, (boolean)true);
            }
        }
        if (nodeElementType == JSElementTypes.BINARY_EXPRESSION && childElementType != JSElementTypes.BINARY_EXPRESSION) {
            return Indent.getNoneIndent();
        }
        if (childElementType == JSTokenTypes.GET_KEYWORD || childElementType == JSTokenTypes.SET_KEYWORD) {
            return Indent.getNoneIndent();
        }
        if (childElementType == JSElementTypes.ARGUMENT_LIST || childElementType == JSElementTypes.BINARY_EXPRESSION) {
            return Indent.getNoneIndent();
        }
        return null;
    }

    public static boolean shouldIndentParenthesized(@NotNull ASTNode node) {
        ASTNode prev;
        ASTNode lastChild;
        if (node == null) {
            SubBlockVisitor.$$$reportNull$$$0(8);
        }
        return (lastChild = node.getLastChildNode()) != null && lastChild.getElementType() == JSTokenTypes.RPAR && (prev = lastChild.getTreePrev()) != null && prev.getPsi() instanceof PsiWhiteSpace && prev.textContains('\n');
    }

    private static boolean requiresCompositeBlockForBody(@Nullable IElementType nodeElementType) {
        return nodeElementType instanceof JSClassElementTypeBase || nodeElementType == JSStubElementTypes.PACKAGE_STATEMENT || nodeElementType == JSStubElementTypes.TYPESCRIPT_MODULE || nodeElementType == JSStubElementTypes.TYPESCRIPT_ENUM;
    }

    private static boolean isStatementLevelComment(@NotNull ASTNode child) {
        if (child == null) {
            SubBlockVisitor.$$$reportNull$$$0(9);
        }
        if (JSTokenTypes.COMMENTS.contains(child.getElementType())) {
            ASTNode parent = child.getTreeParent();
            return parent == null || parent.getFirstChildNode() == child;
        }
        return false;
    }

    @Nullable
    protected Wrap getWrap(ASTNode node, ASTNode child, @Nullable Wrap sharedWrap) {
        WrapType wrapType = null;
        IElementType nodeElementType = node.getElementType();
        if (child.getElementType() == JSTokenTypes.COMMA && !this.myJSCodeStyleSettings.COMMA_ON_NEW_LINE) {
            wrapType = WrapType.NONE;
        } else if (nodeElementType == JSStubElementTypes.ASSIGNMENT_EXPRESSION) {
            JSAssignmentExpression assignment = (JSAssignmentExpression)node.getPsi();
            if (child.getElementType() == assignment.getOperationSign() && this.mySettings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE || child.getPsi() == assignment.getROperand() && !this.mySettings.PLACE_ASSIGNMENT_SIGN_ON_NEXT_LINE) {
                wrapType = WrappingUtil.getWrapType((int)this.mySettings.ASSIGNMENT_WRAP);
            }
        } else if (nodeElementType == JSElementTypes.BINARY_EXPRESSION) {
            JSBinaryExpression binary = (JSBinaryExpression)node.getPsi();
            if (child.getElementType() == binary.getOperationSign() && this.mySettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE || child.getPsi() == binary.getROperand() && !this.mySettings.BINARY_OPERATION_SIGN_ON_NEXT_LINE) {
                return this.getCurrentWrap(sharedWrap, this.mySettings.BINARY_OPERATION_WRAP);
            }
        } else if (nodeElementType == JSElementTypes.PARENTHESIZED_EXPRESSION) {
            if (FormatterUtil.isPrecededBy((ASTNode)child, (IElementType)JSTokenTypes.LPAR)) {
                wrapType = this.mySettings.PARENTHESES_EXPRESSION_LPAREN_WRAP ? WrapType.ALWAYS : WrapType.NONE;
            } else if (child == node.findChildByType(JSTokenTypes.RPAR)) {
                wrapType = this.mySettings.PARENTHESES_EXPRESSION_RPAREN_WRAP ? WrapType.ALWAYS : WrapType.NONE;
            }
        } else if (nodeElementType == JSElementTypes.ARRAY_LITERAL_EXPRESSION) {
            IElementType childType = child.getElementType();
            if (childType != JSTokenTypes.LBRACKET && childType != JSTokenTypes.RBRACKET && !FormatterUtil.isPrecededBy((ASTNode)child, (IElementType)JSTokenTypes.LBRACKET)) {
                return this.getCurrentWrap(sharedWrap, this.mySettings.ARRAY_INITIALIZER_WRAP);
            }
        } else if (nodeElementType == JSElementTypes.CONDITIONAL_EXPRESSION) {
            IElementType elementType = child.getElementType();
            if (this.mySettings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE && (elementType == JSTokenTypes.QUEST || elementType == JSTokenTypes.COLON) || !this.mySettings.TERNARY_OPERATION_SIGNS_ON_NEXT_LINE && child.getPsi() instanceof JSExpression && node.getFirstChildNode() != child) {
                return this.getCurrentWrap(sharedWrap, this.mySettings.TERNARY_OPERATION_WRAP);
            }
        } else if (JSElementTypes.PARAMETER_LISTS.contains(nodeElementType) && WrappingUtil.shouldWrap((int)this.mySettings.METHOD_PARAMETERS_WRAP)) {
            if (!this.myJSCodeStyleSettings.COMMA_ON_NEW_LINE ? !FormatterUtil.isPrecededBy((ASTNode)child, (IElementType)JSTokenTypes.LPAR) && child.getElementType() != JSTokenTypes.LPAR && child.getElementType() != JSTokenTypes.RPAR : child.getElementType() == JSTokenTypes.COMMA) {
                return this.getCurrentWrap(sharedWrap, this.mySettings.METHOD_PARAMETERS_WRAP);
            }
        } else if (nodeElementType == JSElementTypes.FOR_STATEMENT || nodeElementType == JSElementTypes.FOR_IN_STATEMENT) {
            if (!FormatterUtil.isPrecededBy((ASTNode)child, (IElementType)JSTokenTypes.LPAR) && JSExtendedLanguagesTokenSetProvider.EXPRESSIONS.contains(child.getElementType())) {
                return this.getCurrentWrap(sharedWrap, this.mySettings.FOR_STATEMENT_WRAP);
            }
        } else if (nodeElementType == JSStubElementTypes.OBJECT_LITERAL_EXPRESSION) {
            if (this.hasWrapInBraces(child, JSExtendedLanguagesTokenSetProvider.PROPERTIES)) {
                return this.getCurrentWrap(sharedWrap, this.myJSCodeStyleSettings.OBJECT_LITERAL_WRAP);
            }
        } else if (IMPORT_EXPORT_DECLARATIONS.contains(nodeElementType) && child.getElementType() == ES6ElementTypes.FROM_CLAUSE) {
            if (!FormatterUtil.isPrecededBy((ASTNode)child, (IElementType)ES6ElementTypes.NAMED_IMPORTS) && this.myJSCodeStyleSettings.IMPORTS_WRAP != 0) {
                return Wrap.createWrap((WrapType)WrapType.NORMAL, (boolean)true);
            }
        } else if (nodeElementType == ES6ElementTypes.NAMED_IMPORTS || nodeElementType == ES6ElementTypes.EXPORT_DECLARATION) {
            if (this.hasWrapInBraces(child, IMPORT_EXPORT_SPECIFIERS)) {
                return this.getCurrentWrap(sharedWrap, this.myJSCodeStyleSettings.IMPORTS_WRAP);
            }
        } else if (JSElementTypes.EXTENDS_IMPLEMENTS_LISTS.contains(nodeElementType)) {
            if (child.getElementType() == JSStubElementTypes.EXTENDS_LIST_MEMBER && !FormatterUtil.isPrecededBy((ASTNode)child, (TokenSet)EXTENDS_IMPLEMENTS_KEYWORDS)) {
                return this.getCurrentWrap(sharedWrap, this.mySettings.EXTENDS_LIST_WRAP);
            }
            if (EXTENDS_IMPLEMENTS_KEYWORDS.contains(child.getElementType())) {
                return Wrap.createWrap((int)this.mySettings.EXTENDS_KEYWORD_WRAP, (boolean)true);
            }
        } else if (JSStubElementTypes.VAR_STATEMENT == nodeElementType && JSElementTypes.BODY_VARIABLES.contains(child.getElementType()) && !FormatterUtil.isPrecededBy((ASTNode)child, (TokenSet)JSTokenTypes.VAR_MODIFIERS)) {
            IElementType parentElementType;
            ASTNode parentNode = node.getTreeParent();
            IElementType iElementType = parentElementType = parentNode != null ? parentNode.getElementType() : null;
            if ((parentElementType == JSElementTypes.FOR_IN_STATEMENT || parentElementType == JSElementTypes.FOR_STATEMENT) && this.mySettings.FOR_STATEMENT_WRAP == 0) {
                return null;
            }
            return this.getCurrentWrap(sharedWrap, this.myJSCodeStyleSettings.VAR_DECLARATION_WRAP);
        }
        return wrapType == null ? null : Wrap.createWrap((WrapType)wrapType, (boolean)true);
    }

    private boolean hasWrapInBraces(ASTNode child, TokenSet properties) {
        return !this.myJSCodeStyleSettings.COMMA_ON_NEW_LINE ? !FormatterUtil.isPrecededBy((ASTNode)child, (IElementType)JSTokenTypes.LBRACE) && properties.contains(child.getElementType()) : child.getElementType() == JSTokenTypes.COMMA;
    }

    private int getBraceStyle(@Nullable ASTNode node) {
        IElementType nodeElementType;
        IElementType iElementType = nodeElementType = node != null ? node.getElementType() : null;
        if (JSElementTypes.FUNCTION_DECLARATIONS.contains(nodeElementType)) {
            return this.mySettings.METHOD_BRACE_STYLE;
        }
        if (JSElementTypes.FUNCTION_EXPRESSIONS.contains(nodeElementType)) {
            return this.myJSCodeStyleSettings.FUNCTION_EXPRESSION_BRACE_STYLE;
        }
        if (nodeElementType instanceof JSClassElementTypeBase || JSStubElementTypes.TYPESCRIPT_INTERFACE == nodeElementType) {
            return this.mySettings.CLASS_BRACE_STYLE;
        }
        return this.mySettings.BRACE_STYLE;
    }

    protected Wrap getCurrentWrap(@Nullable Wrap sharedWrap, int type) {
        return (Wrap)ObjectUtils.coalesce((Object)sharedWrap, (Object)Wrap.createWrap((int)type, (boolean)true));
    }

    private Indent getCommaIndent(Indent.Type baseType) {
        int indentSize;
        int commaIndentSize;
        CommonCodeStyleSettings.IndentOptions indentOptions;
        if (this.myJSCodeStyleSettings.COMMA_ON_NEW_LINE && (baseType == Indent.Type.CONTINUATION || baseType == Indent.Type.NORMAL) && (indentOptions = this.mySettings.getIndentOptions()) != null && (commaIndentSize = (indentSize = baseType == Indent.Type.CONTINUATION ? indentOptions.CONTINUATION_INDENT_SIZE : indentOptions.INDENT_SIZE) - (this.mySettings.SPACE_AFTER_COMMA ? 1 : 0) - 1) >= 0) {
            return Indent.getIndent((Indent.Type)Indent.Type.SPACES, (int)commaIndentSize, (boolean)false, (boolean)false);
        }
        return Indent.getIndent((Indent.Type)baseType, (boolean)false, (boolean)false);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsBlockContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/formatter/blocks/SubBlockVisitor";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/formatter/blocks/SubBlockVisitor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createBlockForNode";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonEmptyNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createLocalAlignmentFactory";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createBlockForNode";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "generateBlocksForClassNode";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNonEmptyNodes";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "shouldIndentParenthesized";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isStatementLevelComment";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class JSXmlBlock
    extends XmlBlock
    implements BlockEx {
        private final Wrap myWrap;
        private final Alignment myAlignment;
        private final Indent myIndent;
        @Nullable
        private final JSBlock myOuterJsBlock;

        public JSXmlBlock(ASTNode child, Wrap wrap, Alignment alignment, Indent indent, XmlFormattingPolicy policy, boolean preserveSpace, @Nullable JSBlock outerJsBlock) {
            super(child, wrap, alignment, policy, indent, null, preserveSpace);
            this.myWrap = wrap;
            this.myAlignment = alignment;
            this.myIndent = indent;
            this.myOuterJsBlock = outerJsBlock;
        }

        @Nullable
        public Language getLanguage() {
            return this.myOuterJsBlock instanceof BlockEx ? ((BlockEx)this.myOuterJsBlock).getLanguage() : JavascriptLanguage.INSTANCE;
        }

        protected List<Block> splitAttribute(ASTNode node, XmlFormattingPolicy formattingPolicy) {
            ASTNode child = node.getFirstChildNode();
            if (child != null && child.getElementType() == JSTokenTypes.XML_JS_SCRIPT && this.myOuterJsBlock != null) {
                Block block = this.myOuterJsBlock.myBlockContext.createBlock(child, this.myWrap, this.myAlignment, this.myIndent, this.myOuterJsBlock.mySharedAlignmentFactory, this.myOuterJsBlock);
                return Collections.singletonList(block);
            }
            return super.splitAttribute(node, formattingPolicy);
        }

        protected XmlBlock createSimpleChild(ASTNode child, Indent indent, Wrap wrap, Alignment alignment) {
            return new JSXmlBlock(child, wrap, alignment, indent, this.myXmlFormattingPolicy, this.isPreserveSpace(), this.myOuterJsBlock);
        }
    }

    public static class JSXmlTagBlock
    extends XmlTagBlock {
        @Nullable
        private final JSBlock myOuterJsBlock;

        public JSXmlTagBlock(ASTNode child, Wrap wrap, Alignment childAlignment, XmlFormattingPolicy policy, Indent childIndent, @Nullable JSBlock outerJSBlock) {
            this(child, wrap, childAlignment, policy, childIndent, false, outerJSBlock);
        }

        private JSXmlTagBlock(ASTNode child, Wrap wrap, Alignment alignment, XmlFormattingPolicy policy, Indent indent, boolean space, @Nullable JSBlock outerJsBlock) {
            super(child, wrap, alignment, policy, indent, space);
            this.myOuterJsBlock = outerJsBlock;
        }

        protected XmlTagBlock createTagBlock(ASTNode child, Indent indent, Wrap wrap, Alignment alignment) {
            return new JSXmlTagBlock(child, wrap, alignment, this.myXmlFormattingPolicy, indent != null ? indent : Indent.getNoneIndent(), this.isPreserveSpace(), this.myOuterJsBlock);
        }

        protected XmlBlock createSimpleChild(ASTNode child, Indent indent, Wrap wrap, Alignment alignment) {
            return new JSXmlBlock(child, wrap, alignment, indent, this.myXmlFormattingPolicy, this.isPreserveSpace(), this.myOuterJsBlock);
        }

        protected boolean useMyFormatter(Language myLanguage, Language childLanguage, PsiElement childPsi) {
            IElementType type = childPsi.getNode().getElementType();
            if (type == JSTokenTypes.XML_JS_SCRIPT) {
                return false;
            }
            if (childPsi instanceof XmlElement) {
                return true;
            }
            return super.useMyFormatter(myLanguage, childLanguage, childPsi);
        }

        protected Alignment chooseAlignment(ASTNode child, Alignment attrAlignment, Alignment textAlignment) {
            ASTNode startEnd;
            if (child.getElementType() == JSTokenTypes.XML_JS_SCRIPT && child.getTreeParent().getElementType() == JSElementTypes.XML_LITERAL_EXPRESSION && ((startEnd = XmlChildRole.START_TAG_END_FINDER.findChild(child.getTreeParent())) == null || startEnd.getStartOffset() >= child.getTextRange().getEndOffset())) {
                Alignment alignment = this.myXmlFormattingPolicy.getShouldAlignAttributes() ? attrAlignment : null;
                child.putUserData(JavascriptFormattingModelBuilder.BLOCK_ALIGNMENT, (Object)alignment);
                return alignment;
            }
            return super.chooseAlignment(child, attrAlignment, textAlignment);
        }

        @Nullable
        protected ASTNode processChild(List<Block> result2, ASTNode child, Wrap wrap, Alignment alignment, Indent indent) {
            if (child.getElementType() == JSTokenTypes.XML_START_TAG_LIST || child.getElementType() == JSTokenTypes.XML_END_TAG_LIST) {
                indent = Indent.getNoneIndent();
            }
            return super.processChild(result2, child, wrap, alignment, indent);
        }
    }
}

