/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.frameworks.react;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.psi.ES6Class;
import com.intellij.lang.ecmascript6.psi.JSExportAssignment;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.dialects.JSXHarmonyLanguageDialect;
import com.intellij.lang.javascript.documentation.JSDocumentationUtils;
import com.intellij.lang.javascript.frameworks.react.JSXPropTypesUtil;
import com.intellij.lang.javascript.frameworks.react.ReactXmlExtension;
import com.intellij.lang.javascript.index.FrameworkIndexingHandler;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSElementBase;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.resolve.JSClassResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.stubs.impl.JSElementIndexingDataImpl;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitElementImpl;
import com.intellij.lang.javascript.psi.types.JSContext;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.JSTypeCastUtil;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.types.JSFileElementType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactFrameworkIndexingHandler
extends FrameworkIndexingHandler {
    public static final String REACT_COMPOSITE_COMPONENT = "ReactCompositeComponent";
    public static final String REACT_COMPONENT = "ReactComponent";
    public static final String PROPS = "props";
    public static final String STATE = "state";
    public static final String WRAPPED_COMPONENT_NAME = "wrapped.component.name";
    public static final String PROP_TYPES = "propTypes";

    @Override
    public void processCallExpression(@NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outData) {
        if (callExpression == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(0);
        }
        if (outData == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(1);
        }
        if (callExpression.getContext() instanceof JSExportAssignment) {
            ReactFrameworkIndexingHandler.processExportAssignmentCall(callExpression, outData);
        }
        if (!JSXHarmonyLanguageDialect.isReactComponent((JSExpression)callExpression)) {
            return;
        }
        ReactFrameworkIndexingHandler.addClassFromVariable(callExpression, outData);
    }

    private static void processExportAssignmentCall(@NotNull JSCallExpression callExpression, @NotNull JSElementIndexingData outData) {
        JSExpression[] arguments;
        if (callExpression == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(2);
        }
        if (outData == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(3);
        }
        for (JSExpression argument : arguments = callExpression.getArguments()) {
            String name;
            JSReferenceExpression ref;
            JSExpression qualifier;
            if (!(argument instanceof JSReferenceExpression) || (qualifier = (ref = (JSReferenceExpression)argument).getQualifier()) != null || !ReactXmlExtension.isComponentName(name = ref.getReferenceName())) continue;
            outData.putUserString(WRAPPED_COMPONENT_NAME, name);
        }
    }

    @Override
    @Nullable
    public JSElementIndexingDataImpl processClass(@NotNull JSClass jsClass, @Nullable JSElementIndexingDataImpl data) {
        JSReferenceList list;
        String name;
        if (jsClass == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(4);
        }
        if (jsClass instanceof ES6Class && (name = jsClass.getQualifiedName()) != null && (list = jsClass.getExtendsList()) != null) {
            for (JSReferenceListMember member : list.getMembers()) {
                String text = member.getReferenceText();
                JSTypeDeclaration[] arguments = member.getTypeArguments();
                if (text == null || !JSXPropTypesUtil.isPossibleReactClassName(text) || arguments.length <= 0) continue;
                JSImplicitElementImpl.Builder clazz = ReactFrameworkIndexingHandler.buildClassProperty(jsClass, name, PROPS);
                if (data == null) {
                    data = new JSElementIndexingDataImpl();
                }
                data.addImplicitElement((JSImplicitElement)clazz.toImplicitElement());
                if (arguments.length > 1) {
                    data.addImplicitElement((JSImplicitElement)ReactFrameworkIndexingHandler.buildClassProperty(jsClass, name, STATE).toImplicitElement());
                }
                return data;
            }
        }
        return super.processClass(jsClass, data);
    }

    @NotNull
    private static JSImplicitElementImpl.Builder buildClassProperty(@NotNull JSClass jsClass, @NotNull String parentQualifier, @NotNull String name) {
        if (jsClass == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(5);
        }
        if (parentQualifier == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(6);
        }
        if (name == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(7);
        }
        JSImplicitElementImpl.Builder builder = new JSImplicitElementImpl.Builder(name, (PsiElement)jsClass).setNamespace(JSQualifiedNameImpl.fromQualifiedName(parentQualifier)).setAccessType(JSAttributeList.AccessType.PUBLIC).setType(JSImplicitElement.Type.Property);
        if (builder == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(8);
        }
        return builder;
    }

    private static void addClassFromVariable(JSCallExpression callExpression, @NotNull JSElementIndexingData outData) {
        JSQualifiedNamedElement variable;
        if (outData == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(9);
        }
        if ((variable = (JSQualifiedNamedElement)PsiTreeUtil.getParentOfType((PsiElement)callExpression, JSVariable.class)) == null) {
            JSAssignmentExpression assignment = (JSAssignmentExpression)PsiTreeUtil.getParentOfType((PsiElement)callExpression, JSAssignmentExpression.class);
            JSDefinitionExpression jSDefinitionExpression = variable = assignment != null ? assignment.getDefinitionExpression() : null;
        }
        if (variable != null) {
            String name = variable.getName();
            if (name == null) {
                return;
            }
            if (JSDocumentationUtils.isClassOrInterface(variable) == JSElementBase.ClassOrInterface.NONE) {
                JSImplicitElementImpl.Builder clazz = new JSImplicitElementImpl.Builder(name, (PsiElement)callExpression).setNamespace(variable.getNamespace()).setType(JSImplicitElement.Type.Class).setTypeString(REACT_COMPOSITE_COMPONENT);
                outData.addImplicitElement((JSImplicitElement)clazz.toImplicitElement());
            }
        }
    }

    @Override
    public void addContextNames(PsiElement context, List<String> names) {
        if (context == null) {
            return;
        }
        JSCallExpression call = (JSCallExpression)PsiTreeUtil.getParentOfType((PsiElement)context, JSCallExpression.class);
        if (call != null && JSXHarmonyLanguageDialect.isReactComponent((JSExpression)call)) {
            names.add(REACT_COMPONENT);
        }
        if (this.hasPropTypes(context)) {
            names.add(REACT_COMPONENT);
        }
    }

    @Override
    @Nullable
    public JSElementIndexingData processAnyProperty(@NotNull JSProperty property, @Nullable JSElementIndexingData outData) {
        boolean isPropTypesNamespace;
        if (property == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(10);
        }
        JSQualifiedName namespace = property.getNamespace();
        String name = property.getName();
        if (name == null) {
            return outData;
        }
        boolean bl = isPropTypesNamespace = namespace != null && PROP_TYPES.equals(namespace.getName());
        if (isPropTypesNamespace || ReactFrameworkIndexingHandler.shouldCreateImplicitElement(property)) {
            JSQualifiedName parent;
            JSQualifiedName jSQualifiedName = parent = isPropTypesNamespace ? namespace.getParent() : null;
            if (outData == null) {
                outData = new JSElementIndexingDataImpl();
            }
            JSQualifiedNameImpl props = JSQualifiedNameImpl.create(PROPS, parent);
            JSQualifiedNameImpl prop = JSQualifiedNameImpl.create(name, props);
            JSImplicitElementImpl element = JSXPropTypesUtil.createImplicitReactPropsElement(property, prop);
            outData.addImplicitElement((JSImplicitElement)element);
            PsiElement object = property.getParent();
            if (isPropTypesNamespace && object instanceof JSObjectLiteralExpression && ((JSObjectLiteralExpression)object).getFirstProperty() == property) {
                JSImplicitElementImpl.Builder propsBuilder = new JSImplicitElementImpl.Builder(props, (PsiElement)property).setNamespace(parent).setTypeString(props.getQualifiedName()).setType(JSImplicitElement.Type.Property);
                outData.addImplicitElement((JSImplicitElement)propsBuilder.toImplicitElement());
            }
        }
        return outData;
    }

    private static boolean shouldCreateImplicitElement(@NotNull JSProperty property) {
        JSExpression value;
        if (property == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(11);
        }
        if ((value = property.getValue()) instanceof JSReferenceExpression) {
            JSExpression qualifier = ((JSReferenceExpression)value).getQualifier();
            while (qualifier instanceof JSReferenceExpression) {
                if ("PropTypes".equals(((JSReferenceExpression)qualifier).getReferenceName())) {
                    return true;
                }
                qualifier = ((JSReferenceExpression)qualifier).getQualifier();
            }
        }
        return false;
    }

    @Override
    public boolean addTypeFromResolveResult(JSTypeEvaluator evaluator, PsiElement result2) {
        if (result2 instanceof JSElement && DialectDetector.isJSX(result2) && !DialectDetector.isTypeScript(result2)) {
            if (result2 instanceof JSParameter && PROPS.equals(((JSElement)result2).getName())) {
                String qualifiedName;
                JSFunction function = ((JSParameter)result2).getDeclaringFunction();
                String string = qualifiedName = function != null ? function.getQualifiedName() : null;
                if (function != null && ReactXmlExtension.isComponentName(function.getName())) {
                    JSTypeSource source = JSTypeSourceFactory.createTypeSource(result2);
                    JSType type = JSNamedType.createType(qualifiedName + "." + PROPS, source, JSContext.INSTANCE);
                    evaluator.addType(type, result2);
                    return true;
                }
            } else if (result2 instanceof JSImplicitElement) {
                JSType resultType;
                String name = ((JSImplicitElement)result2).getName();
                PsiElement parent = result2.getParent();
                boolean isState = STATE.equals(name);
                if (parent instanceof JSClass && (isState || PROPS.equals(name)) && (resultType = JSXPropTypesUtil.getFlowGenericTypes((JSClass)parent, isState)) != null) {
                    JSRecordType recordType = resultType.asRecordType();
                    evaluator.addType((JSType)(recordType != JSTypeCastUtil.NO_RECORD_TYPE ? recordType : resultType), result2);
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean shouldCreateStubForCallExpression(ASTNode node) {
        IElementType type;
        ASTNode treeParent;
        ASTNode parent = node.getTreeParent();
        if (parent.getElementType() == ES6ElementTypes.EXPORT_DEFAULT_ASSIGNMENT && (treeParent = parent.getTreeParent()) != null && (type = treeParent.getElementType()) instanceof JSFileElementType) {
            Language language = type.getLanguage();
            return language == JavaScriptSupportLoader.TYPESCRIPT_JSX || language.isKindOf((Language)JavaScriptSupportLoader.JSX_HARMONY);
        }
        return super.shouldCreateStubForCallExpression(node);
    }

    @Override
    public int getVersion() {
        return 7;
    }

    protected boolean hasPropTypes(PsiElement context) {
        JSClass clazz = DialectDetector.isES6(context) ? (JSClass)PsiTreeUtil.getParentOfType((PsiElement)context, JSClass.class) : null;
        GlobalSearchScope scope = JSResolveUtil.getResolveScope(context);
        String name = clazz != null ? clazz.getQualifiedName() + ".propTypes" : null;
        List propTypes = name != null ? JSClassResolver.getInstance().findElementsByQNameIncludingImplicit(name, scope) : Collections.emptyList();
        return !propTypes.isEmpty();
    }

    @Override
    @Nullable
    public JSType getExportsInnerAliasType(@NotNull JSExpression expression) {
        if (expression == null) {
            ReactFrameworkIndexingHandler.$$$reportNull$$$0(12);
        }
        if (JSSymbolUtil.isAccurateReferenceExpressionName(expression, "react")) {
            return JSNamedType.createType("React", JSTypeSource.EMPTY, JSTypeContext.STATIC);
        }
        if (JSSymbolUtil.isAccurateReferenceExpressionName(expression, "reactDom")) {
            return JSNamedType.createType("ReactDOM", JSTypeSource.EMPTY, JSTypeContext.STATIC);
        }
        return null;
    }

    static {
        JSImplicitElement.ourUserStringsRegistry.registerUserString("r");
        JSElementIndexingData.ourUserStringKeysRegisty.registerUserString(WRAPPED_COMPONENT_NAME);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callExpression";
                break;
            }
            case 1: 
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outData";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentQualifier";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/frameworks/react/ReactFrameworkIndexingHandler";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/frameworks/react/ReactFrameworkIndexingHandler";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "buildClassProperty";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processCallExpression";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processExportAssignmentCall";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processClass";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildClassProperty";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addClassFromVariable";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processAnyProperty";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "shouldCreateImplicitElement";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getExportsInnerAliasType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

