/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.generation;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.generation.BaseJSGenerateHandler;
import com.intellij.lang.javascript.generation.JSChooserElementNode;
import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.JSConstructorChecker;
import com.intellij.lang.javascript.validation.fixes.BaseCreateMembersFix;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JavaScriptGenerateConstructorHandler
extends BaseJSGenerateHandler {
    @Override
    protected String getTitleKey() {
        return "generate.constructor.fields.chooser.title";
    }

    @Override
    protected BaseCreateMembersFix createFix(final PsiElement jsClass) {
        return new BaseCreateMembersFix<JSVariable>(jsClass){

            @Override
            public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
                if (project == null) {
                    1.$$$reportNull$$$0(0);
                }
                JSCodeStyleSettings codeStyleSettings = (JSCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(JSCodeStyleSettings.class);
                this.evalAnchor(editor, file2);
                StringBuilder functionText = new StringBuilder(JSClassUtils.createConstructorSignatureForClass((JSClass)jsClass, true));
                functionText.append('(');
                StringBuilder initialization = new StringBuilder();
                boolean first = true;
                String semicolon = JSCodeStyleSettings.getSemicolon((PsiElement)file2);
                Set<JSVariable> toProcess = this.getElementsToProcess();
                Iterator<JSVariable> variableIterator = toProcess.iterator();
                boolean hadSuperClassConstructorInitializationBefore = false;
                boolean hadSuperClassConstructorInitialization = false;
                HashSet names = ContainerUtil.newHashSet((int)toProcess.size());
                while (variableIterator.hasNext()) {
                    boolean mangle;
                    boolean isDuplicateName;
                    JSVariable var = variableIterator.next();
                    String name = var.getName();
                    boolean bl = isDuplicateName = !names.add(name);
                    if (name == null) continue;
                    if (!first && !isDuplicateName) {
                        functionText.append(", ");
                    }
                    first = false;
                    String parameterName = JSRefactoringUtil.transformVarNameToAccessorName(name, codeStyleSettings);
                    boolean bl2 = mangle = !JSRefactoringUtil.isValidIdentifier(parameterName, project);
                    if (mangle) {
                        parameterName = JavaScriptGenerateConstructorHandler.mangleParameterName(parameterName);
                    }
                    String insertedOwnName = JSSymbolUtil.handleSpecialPropertyNames(name, JSCodeStyleSettings.getQuoteChar((PsiElement)file2));
                    boolean hasBracket = insertedOwnName.startsWith("[");
                    String typeString = BaseCreateMembersFix.getProcessedType(var.getType(), jsClass, (PsiElement)var);
                    if (!isDuplicateName) {
                        functionText.append(parameterName);
                        if (typeString != null) {
                            functionText.append(':').append(typeString);
                        }
                    }
                    if (JSResolveUtil.findParent((PsiElement)var) == jsClass) {
                        if (hadSuperClassConstructorInitializationBefore) {
                            initialization.append(')').append(semicolon).append('\n');
                            hadSuperClassConstructorInitializationBefore = false;
                        }
                        if (parameterName.equals(name)) {
                            initialization.append(mangle ? (hasBracket ? "this" : "this[") : (JSUtils.isPrivateSharpItem((PsiElement)var) ? "this.#" : "this."));
                        } else {
                            String qualifier = JSClassUtils.getDefaultFieldQualifier(jsClass, true);
                            if (qualifier != null) {
                                if (mangle && qualifier.length() > 1) {
                                    initialization.append(qualifier, 0, qualifier.length() - 1);
                                    if (!hasBracket) {
                                        initialization.append("[");
                                    }
                                } else {
                                    initialization.append(qualifier);
                                }
                            }
                        }
                        initialization.append(insertedOwnName).append(mangle && !hasBracket ? "]" : "").append(" = ").append(parameterName).append(semicolon).append("\n");
                        continue;
                    }
                    initialization.append(hadSuperClassConstructorInitializationBefore ? ", " : "super(").append(parameterName);
                    hadSuperClassConstructorInitializationBefore = true;
                    hadSuperClassConstructorInitialization = true;
                }
                if (hadSuperClassConstructorInitializationBefore) {
                    initialization.append(")").append(semicolon).append("\n");
                } else if (DialectDetector.isJavaScriptFamily(jsClass) && !hadSuperClassConstructorInitialization && ((JSClass)jsClass).getSuperClasses().length > 0) {
                    initialization.insert(0, "super()" + semicolon + "\n");
                }
                functionText.append(") {\n");
                functionText.append((CharSequence)initialization);
                functionText.append("}");
                this.doAddOneMethod(project, functionText.toString(), this.anchor);
            }

            @Override
            public Set<JSVariable> getElementsToProcess() {
                LinkedHashSet<JSVariable> vars = new LinkedHashSet<JSVariable>();
                JSFunction nontrivialSuperClassConstructor = JSConstructorChecker.getNontrivialSuperClassConstructor((JSClass)jsClass);
                if (nontrivialSuperClassConstructor != null) {
                    ContainerUtil.addAll(vars, (Object[])nontrivialSuperClassConstructor.getParameterVariables());
                }
                vars.addAll(super.getElementsToProcess());
                return vars;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/generation/JavaScriptGenerateConstructorHandler$1", "invoke"));
            }
        };
    }

    private static String mangleParameterName(String name) {
        StringBuilder builder = new StringBuilder();
        if (name.startsWith("[") && name.endsWith("]")) {
            name = name.substring(1, name.length() - 1);
        }
        for (int i = 0; i < name.length(); ++i) {
            char iChar = name.charAt(i);
            if (i == 0 && !Character.isJavaIdentifierStart(iChar) || i != 0 && !Character.isJavaIdentifierPart(iChar)) {
                builder.append('_');
                continue;
            }
            if (i == 0 && Character.isUpperCase(iChar)) {
                iChar = Character.toLowerCase(iChar);
            }
            builder.append(iChar);
        }
        return builder.toString();
    }

    @Override
    protected void collectCandidates(PsiElement clazz, Collection<JSChooserElementNode> candidates) {
        JavaScriptGenerateConstructorHandler.collectJSVariables(clazz, candidates, false, false, true, true, false, false);
    }

    @Override
    protected boolean isValidForTarget(PsiElement jsClass) {
        return jsClass instanceof JSClass && !((JSClass)jsClass).isInterface();
    }

    @Override
    protected boolean canHaveEmptySelectedElements() {
        return true;
    }
}

