/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.highlighting;

import com.intellij.lang.javascript.JSDocElementType;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.ECMAL4LanguageDialect;
import com.intellij.lang.javascript.highlighting.JSHighlighter;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlTokenType;
import gnu.trove.THashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class ECMAL4Highlighter
extends JSHighlighter {
    private static final Map<IElementType, TextAttributesKey> ourAttributeMap;
    private static final Map<IElementType, TextAttributesKey> ourDocAttributeMap;
    private static final Map<TextAttributesKey, TextAttributesKey> ourJsToEcmaKeyMap;
    public static final TextAttributesKey ECMAL4_KEYWORD;
    public static final TextAttributesKey ECMAL4_STRING;
    public static final TextAttributesKey ECMAL4_NUMBER;
    public static final TextAttributesKey ECMAL4_REGEXP;
    public static final TextAttributesKey ECMAL4_LINE_COMMENT;
    public static final TextAttributesKey ECMAL4_BLOCK_COMMENT;
    public static final TextAttributesKey ECMAL4_DOC_COMMENT;
    public static final TextAttributesKey ECMAL4_OPERATION_SIGN;
    public static final TextAttributesKey ECMAL4_PARENTHS;
    public static final TextAttributesKey ECMAL4_BRACKETS;
    public static final TextAttributesKey ECMAL4_BRACES;
    public static final TextAttributesKey ECMAL4_COMMA;
    public static final TextAttributesKey ECMAL4_DOT;
    public static final TextAttributesKey ECMAL4_SEMICOLON;
    public static final TextAttributesKey ECMAL4_BAD_CHARACTER;
    public static final TextAttributesKey ECMAL4_DOC_TAG;
    public static final TextAttributesKey ECMAL4_DOC_MARKUP;
    public static final TextAttributesKey ECMAL4_VALID_STRING_ESCAPE;
    public static final TextAttributesKey ECMAL4_INVALID_STRING_ESCAPE;
    public static final TextAttributesKey ECMAL4_LOCAL_VARIABLE;
    public static final TextAttributesKey ECMAL4_PARAMETER;
    public static final TextAttributesKey ECMAL4_INSTANCE_MEMBER_VARIABLE;
    public static final TextAttributesKey ECMAL4_STATIC_MEMBER_VARIABLE;
    public static final TextAttributesKey ECMAL4_GLOBAL_VARIABLE;
    public static final TextAttributesKey ECMAL4_GLOBAL_FUNCTION;
    public static final TextAttributesKey ECMAL4_STATIC_MEMBER_FUNCTION;
    public static final TextAttributesKey ECMAL4_INSTANCE_MEMBER_FUNCTION;
    public static final TextAttributesKey ECMAL4_METADATA;
    public static final TextAttributesKey ECMAL4_CLASS;
    public static final TextAttributesKey ECMAL4_INTERFACE;

    public ECMAL4Highlighter() {
        super(ECMAL4LanguageDialect.DIALECT_OPTION_HOLDER);
    }

    @Override
    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        if (ourDocAttributeMap.containsKey(tokenType)) {
            TextAttributesKey[] textAttributesKeyArray = ECMAL4Highlighter.pack((TextAttributesKey)ourAttributeMap.get(JSDocTokenTypes.DOC_TAG_VALUE), (TextAttributesKey)ourDocAttributeMap.get(tokenType));
            if (textAttributesKeyArray == null) {
                ECMAL4Highlighter.$$$reportNull$$$0(0);
            }
            return textAttributesKeyArray;
        }
        if (ourAttributeMap.containsKey(tokenType)) {
            TextAttributesKey[] textAttributesKeyArray = ECMAL4Highlighter.pack((TextAttributesKey)ourAttributeMap.get(tokenType));
            if (textAttributesKeyArray == null) {
                ECMAL4Highlighter.$$$reportNull$$$0(1);
            }
            return textAttributesKeyArray;
        }
        TextAttributesKey[] textAttributesKeyArray = super.getTokenHighlights(tokenType);
        if (textAttributesKeyArray == null) {
            ECMAL4Highlighter.$$$reportNull$$$0(2);
        }
        return textAttributesKeyArray;
    }

    @Override
    public TextAttributesKey getMappedKey(TextAttributesKey original) {
        return ourJsToEcmaKeyMap.getOrDefault(original, original);
    }

    @Override
    @NotNull
    public TokenSet getKeywords() {
        TokenSet tokenSet = TokenSet.EMPTY;
        if (tokenSet == null) {
            ECMAL4Highlighter.$$$reportNull$$$0(3);
        }
        return tokenSet;
    }

    static {
        IElementType[] javadoc;
        ourAttributeMap = new THashMap();
        ourDocAttributeMap = new THashMap();
        ourJsToEcmaKeyMap = new THashMap();
        ECMAL4_KEYWORD = TextAttributesKey.createTextAttributesKey((String)"ECMAL4.KEYWORD", (TextAttributesKey)JSHighlighter.JS_KEYWORD);
        ECMAL4_STRING = TextAttributesKey.createTextAttributesKey((String)"ECMAL4.STRING", (TextAttributesKey)JSHighlighter.JS_STRING);
        ECMAL4_NUMBER = TextAttributesKey.createTextAttributesKey((String)"ECMAL4.NUMBER", (TextAttributesKey)JSHighlighter.JS_NUMBER);
        ECMAL4_REGEXP = TextAttributesKey.createTextAttributesKey((String)"ECMAL4.REGEXP", (TextAttributesKey)JSHighlighter.JS_REGEXP);
        ECMAL4_LINE_COMMENT = TextAttributesKey.createTextAttributesKey((String)"ECMAL4.LINE_COMMENT", (TextAttributesKey)JSHighlighter.JS_LINE_COMMENT);
        ECMAL4_BLOCK_COMMENT = TextAttributesKey.createTextAttributesKey((String)"ECMAL4.BLOCK_COMMENT", (TextAttributesKey)JSHighlighter.JS_BLOCK_COMMENT);
        ECMAL4_DOC_COMMENT = TextAttributesKey.createTextAttributesKey((String)"ECMAL4.DOC_COMMENT", (TextAttributesKey)JSHighlighter.JS_DOC_COMMENT);
        ECMAL4_OPERATION_SIGN = TextAttributesKey.createTextAttributesKey((String)"ECMAL4.OPERATION_SIGN", (TextAttributesKey)JSHighlighter.JS_OPERATION_SIGN);
        ECMAL4_PARENTHS = TextAttributesKey.createTextAttributesKey((String)"ECMAL4.PARENTHS", (TextAttributesKey)JSHighlighter.JS_PARENTHS);
        ECMAL4_BRACKETS = TextAttributesKey.createTextAttributesKey((String)"ECMAL4.BRACKETS", (TextAttributesKey)JSHighlighter.JS_BRACKETS);
        ECMAL4_BRACES = TextAttributesKey.createTextAttributesKey((String)"ECMAL4.BRACES", (TextAttributesKey)JSHighlighter.JS_BRACES);
        ECMAL4_COMMA = TextAttributesKey.createTextAttributesKey((String)"ECMAL4.COMMA", (TextAttributesKey)JSHighlighter.JS_COMMA);
        ECMAL4_DOT = TextAttributesKey.createTextAttributesKey((String)"ECMAL4.DOT", (TextAttributesKey)JSHighlighter.JS_DOT);
        ECMAL4_SEMICOLON = TextAttributesKey.createTextAttributesKey((String)"ECMAL4.SEMICOLON", (TextAttributesKey)JSHighlighter.JS_SEMICOLON);
        ECMAL4_BAD_CHARACTER = TextAttributesKey.createTextAttributesKey((String)"ECMAL4.BADCHARACTER", (TextAttributesKey)JSHighlighter.JS_BAD_CHARACTER);
        ECMAL4_DOC_TAG = TextAttributesKey.createTextAttributesKey((String)"ECMAL4.DOC_TAG", (TextAttributesKey)JSHighlighter.JS_DOC_TAG);
        ECMAL4_DOC_MARKUP = TextAttributesKey.createTextAttributesKey((String)"ECMAL4.DOC_MARKUP", (TextAttributesKey)JSHighlighter.JS_DOC_MARKUP);
        ECMAL4_VALID_STRING_ESCAPE = TextAttributesKey.createTextAttributesKey((String)"ECMAL4.VALID_STRING_ESCAPE", (TextAttributesKey)JSHighlighter.JS_VALID_STRING_ESCAPE);
        ECMAL4_INVALID_STRING_ESCAPE = TextAttributesKey.createTextAttributesKey((String)"ECMAL4.INVALID_STRING_ESCAPE", (TextAttributesKey)JSHighlighter.JS_INVALID_STRING_ESCAPE);
        ECMAL4_LOCAL_VARIABLE = TextAttributesKey.createTextAttributesKey((String)"ECMAL4.AL4.LOCAL_VARIABLE", (TextAttributesKey)JSHighlighter.JS_LOCAL_VARIABLE);
        ECMAL4_PARAMETER = TextAttributesKey.createTextAttributesKey((String)"ECMAL4.PARAMETER", (TextAttributesKey)JSHighlighter.JS_PARAMETER);
        ECMAL4_INSTANCE_MEMBER_VARIABLE = TextAttributesKey.createTextAttributesKey((String)"ECMAL4.INSTANCE_MEMBER_VARIABLE", (TextAttributesKey)JSHighlighter.JS_INSTANCE_MEMBER_VARIABLE);
        ECMAL4_STATIC_MEMBER_VARIABLE = TextAttributesKey.createTextAttributesKey((String)"ECMAL4.STATIC_MEMBER_VARIABLE", (TextAttributesKey)JSHighlighter.JS_STATIC_MEMBER_VARIABLE);
        ECMAL4_GLOBAL_VARIABLE = TextAttributesKey.createTextAttributesKey((String)"ECMAL4.GLOBAL_VARIABLE", (TextAttributesKey)JSHighlighter.JS_GLOBAL_VARIABLE);
        ECMAL4_GLOBAL_FUNCTION = TextAttributesKey.createTextAttributesKey((String)"ECMAL4.GLOBAL_FUNCTION", (TextAttributesKey)JSHighlighter.JS_GLOBAL_FUNCTION);
        ECMAL4_STATIC_MEMBER_FUNCTION = TextAttributesKey.createTextAttributesKey((String)"ECMAL4.STATIC_MEMBER_FUNCTION", (TextAttributesKey)JSHighlighter.JS_STATIC_MEMBER_FUNCTION);
        ECMAL4_INSTANCE_MEMBER_FUNCTION = TextAttributesKey.createTextAttributesKey((String)"ECMAL4.INSTANCE_MEMBER_FUNCTION", (TextAttributesKey)JSHighlighter.JS_INSTANCE_MEMBER_FUNCTION);
        ECMAL4_METADATA = TextAttributesKey.createTextAttributesKey((String)"ECMAL4.ATTRIBUTE", (TextAttributesKey)DefaultLanguageHighlighterColors.METADATA);
        ECMAL4_CLASS = TextAttributesKey.createTextAttributesKey((String)"ECMAL4.CLASS", (TextAttributesKey)DefaultLanguageHighlighterColors.CLASS_NAME);
        ECMAL4_INTERFACE = TextAttributesKey.createTextAttributesKey((String)"ECMAL4.INTERFACE", (TextAttributesKey)DefaultLanguageHighlighterColors.INTERFACE_NAME);
        ECMAL4Highlighter.fillMap(ourAttributeMap, (TokenSet)OPERATORS_LIKE, (TextAttributesKey)ECMAL4_OPERATION_SIGN);
        ECMAL4Highlighter.fillMap(ourAttributeMap, (TokenSet)JSKeywordSets.AS_KEYWORDS, (TextAttributesKey)ECMAL4_KEYWORD);
        ourAttributeMap.put(StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN, ECMAL4_VALID_STRING_ESCAPE);
        ourAttributeMap.put(StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN, ECMAL4_INVALID_STRING_ESCAPE);
        ourAttributeMap.put(StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN, ECMAL4_INVALID_STRING_ESCAPE);
        ourAttributeMap.put(JSTokenTypes.NUMERIC_LITERAL, ECMAL4_NUMBER);
        ourAttributeMap.put(JSTokenTypes.STRING_LITERAL, ECMAL4_STRING);
        ourAttributeMap.put(JSTokenTypes.SINGLE_QUOTE_STRING_LITERAL, ECMAL4_STRING);
        ourAttributeMap.put(JSTokenTypes.REGEXP_LITERAL, ECMAL4_REGEXP);
        ourAttributeMap.put(JSTokenTypes.LPAR, ECMAL4_PARENTHS);
        ourAttributeMap.put(JSTokenTypes.RPAR, ECMAL4_PARENTHS);
        ourAttributeMap.put(JSTokenTypes.LBRACE, ECMAL4_BRACES);
        ourAttributeMap.put(JSTokenTypes.RBRACE, ECMAL4_BRACES);
        ourAttributeMap.put(JSTokenTypes.LBRACKET, ECMAL4_BRACKETS);
        ourAttributeMap.put(JSTokenTypes.RBRACKET, ECMAL4_BRACKETS);
        ourAttributeMap.put(JSTokenTypes.COMMA, ECMAL4_COMMA);
        ourAttributeMap.put(JSTokenTypes.DOT, ECMAL4_DOT);
        ourAttributeMap.put(JSTokenTypes.SEMICOLON, ECMAL4_SEMICOLON);
        ourAttributeMap.put(JSTokenTypes.C_STYLE_COMMENT, ECMAL4_BLOCK_COMMENT);
        ourAttributeMap.put(JSTokenTypes.XML_STYLE_COMMENT, ECMAL4_BLOCK_COMMENT);
        ourAttributeMap.put(JSTokenTypes.DOC_COMMENT, ECMAL4_DOC_COMMENT);
        ourAttributeMap.put(JSTokenTypes.END_OF_LINE_COMMENT, ECMAL4_LINE_COMMENT);
        ourAttributeMap.put(JSTokenTypes.BAD_CHARACTER, ECMAL4_BAD_CHARACTER);
        for (IElementType type2 : javadoc = IElementType.enumerate(type -> type instanceof JSDocElementType)) {
            ourAttributeMap.put(type2, ECMAL4_DOC_COMMENT);
        }
        ourAttributeMap.put(JSDocTokenTypes.DOC_TAG_VALUE, ECMAL4_DOC_COMMENT);
        ourAttributeMap.put(JSDocTokenTypes.DOC_TAG_NAMEPATH, ECMAL4_DOC_COMMENT);
        ourDocAttributeMap.put(JSDocTokenTypes.DOC_TAG_NAME, ECMAL4_DOC_TAG);
        IElementType[] javaDocMarkup = new IElementType[]{XmlTokenType.XML_START_TAG_START, XmlTokenType.XML_END_TAG_START, XmlTokenType.XML_TAG_END, XmlTokenType.XML_EMPTY_ELEMENT_END, XmlTokenType.TAG_WHITE_SPACE, XmlTokenType.XML_TAG_NAME, XmlTokenType.XML_NAME, XmlTokenType.XML_ENTITY_REF_TOKEN, XmlTokenType.XML_CHAR_ENTITY_REF, XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN, XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER, XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER, XmlTokenType.XML_EQ};
        IElementType[] javaDocMarkup2 = new IElementType[]{XmlTokenType.XML_DATA_CHARACTERS, XmlTokenType.XML_REAL_WHITE_SPACE, XmlTokenType.TAG_WHITE_SPACE};
        ECMAL4Highlighter.fillMap(ourDocAttributeMap, (TokenSet)TokenSet.create((IElementType[])javaDocMarkup), (TextAttributesKey)ECMAL4_DOC_MARKUP);
        ECMAL4Highlighter.fillMap(ourDocAttributeMap, (TokenSet)TokenSet.create((IElementType[])javaDocMarkup2), (TextAttributesKey)ECMAL4_DOC_COMMENT);
        ourJsToEcmaKeyMap.put(JS_PARAMETER, ECMAL4_PARAMETER);
        ourJsToEcmaKeyMap.put(JS_INSTANCE_MEMBER_VARIABLE, ECMAL4_INSTANCE_MEMBER_VARIABLE);
        ourJsToEcmaKeyMap.put(JS_LOCAL_VARIABLE, ECMAL4_LOCAL_VARIABLE);
        ourJsToEcmaKeyMap.put(JS_GLOBAL_VARIABLE, ECMAL4_GLOBAL_VARIABLE);
        ourJsToEcmaKeyMap.put(JS_GLOBAL_FUNCTION, ECMAL4_GLOBAL_FUNCTION);
        ourJsToEcmaKeyMap.put(JS_INSTANCE_MEMBER_FUNCTION, ECMAL4_INSTANCE_MEMBER_FUNCTION);
        ourJsToEcmaKeyMap.put(JS_STATIC_MEMBER_FUNCTION, ECMAL4_STATIC_MEMBER_FUNCTION);
        ourJsToEcmaKeyMap.put(JS_STATIC_MEMBER_VARIABLE, ECMAL4_STATIC_MEMBER_VARIABLE);
        ourJsToEcmaKeyMap.put(JS_CLASS, ECMAL4_CLASS);
        ourJsToEcmaKeyMap.put(JS_INTERFACE, ECMAL4_INTERFACE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/javascript/highlighting/ECMAL4Highlighter";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenHighlights";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeywords";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

