/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.inspections;

import com.intellij.codeInspection.BatchQuickFix;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.ES6ExportDefaultAssignment;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.inspections.NewLineEraser;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSNamedElement;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSNamedElementKind;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.lang.javascript.refactoring.util.JSRefactoringUtil;
import com.intellij.lang.javascript.validation.fixes.FixAndIntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.source.tree.TreeUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.refactoring.safeDelete.SafeDeleteHandler;
import com.intellij.util.DocumentUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRemoveElementLocalQuickFix
extends FixAndIntentionAction
implements BatchQuickFix<CommonProblemDescriptor> {
    private static final Logger LOG = Logger.getInstance(JSRemoveElementLocalQuickFix.class);
    private final String myName;
    private final JSNamedElementKind myKind;

    public JSRemoveElementLocalQuickFix(JSNamedElementKind kind, String name) {
        this.myKind = kind;
        this.myName = name;
    }

    @NotNull
    public String getName() {
        String type = StringUtil.decapitalize((String)JSBundle.message((String)this.myKind.humanReadableKey(), (Object[])new Object[0]));
        String string = StringUtil.isEmptyOrSpaces((String)this.myName) ? JSBundle.message((String)"js.unused.symbol.remove.unnamed", (Object[])new Object[]{type}) : JSBundle.message((String)"js.unused.symbol.remove", (Object[])new Object[]{type, this.myName});
        if (string == null) {
            JSRemoveElementLocalQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    protected void applyFix(Project project, PsiElement psiElement, PsiFile file2, Editor editor) {
        Document document;
        PsiElement element = JSRemoveElementLocalQuickFix.walkUpToDeleteTarget(psiElement);
        if (element == null) {
            return;
        }
        editor = editor == null ? PsiUtilBase.findEditor((PsiElement)psiElement) : editor;
        Document document2 = document = editor != null ? editor.getDocument() : null;
        if (document == null) {
            return;
        }
        MyPostRemover replacer = new MyPostRemover(element, document);
        Runnable afterRefactoring = () -> DocumentUtil.writeInRunUndoTransparentAction(() -> replacer.replaceAndReformat());
        SafeDeleteHandler.invoke((Project)project, (PsiElement[])new PsiElement[]{element}, null, (boolean)false, null, (Runnable)afterRefactoring);
    }

    public void applyFix(@NotNull Project project, @NotNull CommonProblemDescriptor[] descriptors, @NotNull List<PsiElement> psiElementsToIgnore, @Nullable Runnable refreshViews) {
        if (project == null) {
            JSRemoveElementLocalQuickFix.$$$reportNull$$$0(1);
        }
        if (descriptors == null) {
            JSRemoveElementLocalQuickFix.$$$reportNull$$$0(2);
        }
        if (psiElementsToIgnore == null) {
            JSRemoveElementLocalQuickFix.$$$reportNull$$$0(3);
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
        SmartList postRemovers = new SmartList();
        SmartList toDelete = new SmartList();
        for (CommonProblemDescriptor descriptor2 : descriptors) {
            Document document;
            PsiElement element = ((ProblemDescriptor)descriptor2).getPsiElement();
            if (element == null || (element = JSRemoveElementLocalQuickFix.walkUpToDeleteTarget(element)) == null || (document = psiDocumentManager.getDocument(element.getContainingFile())) == null) continue;
            toDelete.add(element);
            postRemovers.add(new MyPostRemover(element, document));
        }
        psiElementsToIgnore.addAll((Collection<PsiElement>)toDelete);
        Runnable afterRefactoring = () -> JSRemoveElementLocalQuickFix.lambda$applyFix$4((List)postRemovers, refreshViews);
        SafeDeleteHandler.invoke((Project)project, (PsiElement[])PsiUtilCore.toPsiElementArray((Collection)toDelete), (boolean)false, (Runnable)afterRefactoring);
    }

    private static PsiElement walkUpToDeleteTarget(@NotNull PsiElement psiElement) {
        PsiElement element;
        if (psiElement == null) {
            JSRemoveElementLocalQuickFix.$$$reportNull$$$0(4);
        }
        for (element = psiElement; element != null && !(element instanceof JSNamedElement) && !(element instanceof ES6ExportDefaultAssignment); element = element.getParent()) {
        }
        if (element == null) {
            LOG.info("Was not able to remove element: " + psiElement.getText());
        }
        if (element != null && element.getParent() instanceof ES6ExportDefaultAssignment) {
            element = element.getParent();
        }
        return element;
    }

    private static /* synthetic */ void lambda$applyFix$4(List postRemovers, @Nullable Runnable refreshViews) {
        DocumentUtil.writeInRunUndoTransparentAction(() -> {
            postRemovers.forEach(r -> r.replaceAndReformat());
            if (refreshViews != null) {
                refreshViews.run();
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/inspections/JSRemoveElementLocalQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElementsToIgnore";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/inspections/JSRemoveElementLocalQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "walkUpToDeleteTarget";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyLeftRightContext {
        @Nullable
        private PsiElement myLeft;
        @Nullable
        private PsiElement myRight;
        private final boolean myLeftWasComma;
        private final boolean myRightWasComma;
        @Nullable
        private final PsiElement myParent;
        private final boolean myInline;

        public MyLeftRightContext(@NotNull PsiElement element, @NotNull Document document) {
            if (element == null) {
                MyLeftRightContext.$$$reportNull$$$0(0);
            }
            if (document == null) {
                MyLeftRightContext.$$$reportNull$$$0(1);
            }
            this.myLeft = JSPsiImplUtils.getPrevSiblingIgnoreWhitespace(element);
            boolean bl = this.myLeftWasComma = this.myLeft != null && this.myLeft.getNode().getElementType() == JSTokenTypes.COMMA;
            if (this.myLeftWasComma) {
                this.myLeft = JSPsiImplUtils.getPrevSiblingIgnoreWhitespace(this.myLeft);
            }
            this.myRight = JSPsiImplUtils.getNextSiblingIgnoreWhitespace(element);
            boolean bl2 = this.myRightWasComma = this.myRight != null && this.myRight.getNode().getElementType() == JSTokenTypes.COMMA;
            if (this.myRightWasComma) {
                this.myRight = JSPsiImplUtils.getNextSiblingIgnoreWhitespace(this.myRight);
            }
            this.myParent = element.getParent();
            this.myInline = this.myLeft != null && this.myRight != null && document.getLineNumber(this.myLeft.getTextRange().getEndOffset()) == document.getLineNumber(this.myRight.getTextRange().getStartOffset());
        }

        boolean isInline() {
            return this.myInline;
        }

        @Nullable
        PsiElement getParent() {
            return this.myParent;
        }

        @Nullable
        TextRange getTextRangeIfValid() {
            int endOffset;
            PsiElement previous;
            PsiElement next;
            boolean nextValid;
            if (this.myParent == null || !this.myParent.isValid()) {
                return null;
            }
            boolean prevValid = this.myLeft != null && this.myLeft.isValid();
            boolean bl = nextValid = this.myRight != null && this.myRight.isValid();
            if (prevValid && this.myLeftWasComma && (next = this.myLeft.getNextSibling()) != null && next.isValid() && next.getNode().getElementType() == JSTokenTypes.COMMA) {
                this.myLeft = next;
            }
            if (nextValid && this.myRightWasComma && (previous = this.myRight.getPrevSibling()) != null && previous.isValid() && previous.getNode().getElementType() == JSTokenTypes.COMMA) {
                this.myRight = previous;
            }
            int startOffset = prevValid ? this.myLeft.getTextRange().getEndOffset() : this.myParent.getTextRange().getStartOffset();
            int n = endOffset = nextValid ? this.myRight.getTextRange().getStartOffset() : this.myParent.getTextRange().getEndOffset();
            if (startOffset > endOffset) {
                return new TextRange(startOffset, startOffset);
            }
            return new TextRange(startOffset, endOffset);
        }

        boolean isWholeFile() {
            return this.myParent instanceof PsiFile && this.myLeft == null && this.myRight == null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "element";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "document";
                    break;
                }
            }
            objectArray[1] = "com/intellij/lang/javascript/inspections/JSRemoveElementLocalQuickFix$MyLeftRightContext";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class MyPostRemover {
        private final List<MyLeftRightContext> myContexts;
        private final PsiFile myContainingFile;
        @NotNull
        private final PsiElement myElement;
        @NotNull
        private final Document myDocument;
        @NotNull
        private final NewLineEraser myEraser;
        @Nullable
        private final PsiElement myElementToReplace;
        @NotNull
        private final PsiElement myScope;

        public MyPostRemover(@NotNull PsiElement element, @NotNull Document document) {
            if (element == null) {
                MyPostRemover.$$$reportNull$$$0(0);
            }
            if (document == null) {
                MyPostRemover.$$$reportNull$$$0(1);
            }
            this.myElement = element;
            this.myDocument = document;
            this.myContexts = MyPostRemover.createContextList(element, document);
            this.myContainingFile = element.getContainingFile();
            this.myScope = JSChangeUtil.getScopeElementInFile(element);
            this.myEraser = new NewLineEraser(element);
            this.myElementToReplace = MyPostRemover.createElementToReplace(element.getProject(), element);
        }

        public void replaceAndReformat() {
            if (this.myElementToReplace == null) {
                PsiDocumentManager.getInstance((Project)this.myScope.getProject()).doPostponedOperationsAndUnblockDocument(this.myDocument);
                this.reformat();
                return;
            }
            PsiElement inserted = this.insertReplacerIntoContext(this.myElementToReplace);
            if (inserted != null) {
                this.myEraser.process(inserted);
                return;
            }
            this.myScope.add(this.myElementToReplace);
        }

        @NotNull
        public PsiElement getElement() {
            PsiElement psiElement = this.myElement;
            if (psiElement == null) {
                MyPostRemover.$$$reportNull$$$0(2);
            }
            return psiElement;
        }

        private void reformat() {
            if (this.myElement.isValid()) {
                return;
            }
            MyLeftRightContext context = this.getRemainingContext();
            if (context == null) {
                return;
            }
            TextRange range = context.getTextRangeIfValid();
            assert (range != null);
            if (context.isInline()) {
                FormatFixer.create(this.myContainingFile, range, FormatFixer.Mode.Reformat).fixFormat();
            } else if (!range.isEmpty()) {
                Project project = this.myContainingFile.getProject();
                if (context.isWholeFile() || range.getStartOffset() == 0) {
                    this.myDocument.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)"");
                    PsiDocumentManager.getInstance((Project)project).commitDocument(this.myDocument);
                } else {
                    this.myDocument.replaceString(range.getStartOffset(), range.getEndOffset(), (CharSequence)"\n");
                    PsiDocumentManager.getInstance((Project)project).commitDocument(this.myDocument);
                    CodeStyleManager.getInstance((Project)project).adjustLineIndent(this.myContainingFile, range);
                }
            }
        }

        public PsiElement insertReplacerIntoContext(@NotNull PsiElement replacer) {
            MyLeftRightContext remainingContext;
            if (replacer == null) {
                MyPostRemover.$$$reportNull$$$0(3);
            }
            if ((remainingContext = this.getRemainingContext()) != null && remainingContext.myParent != null) {
                if (remainingContext.myRight != null) {
                    return JSChangeUtil.doDoAddBefore(remainingContext.myParent, replacer, remainingContext.myRight);
                }
                if (remainingContext.myLeft != null) {
                    return JSChangeUtil.doAddAfter(remainingContext.myParent, replacer, remainingContext.myLeft);
                }
                if (remainingContext.myParent.getNode().getElementType().equals(replacer.getNode().getElementType())) {
                    return remainingContext.myParent.replace(replacer);
                }
            }
            return null;
        }

        @Nullable
        private MyLeftRightContext getRemainingContext() {
            return this.myContexts.stream().filter(c -> c.getTextRangeIfValid() != null).findFirst().orElse(null);
        }

        @NotNull
        private static List<MyLeftRightContext> createContextList(@NotNull PsiElement element, @NotNull Document document) {
            MyLeftRightContext context;
            if (element == null) {
                MyPostRemover.$$$reportNull$$$0(4);
            }
            if (document == null) {
                MyPostRemover.$$$reportNull$$$0(5);
            }
            SmartList result2 = new SmartList();
            PsiElement current = element;
            while (current != null && !(current instanceof PsiFile) && !(current instanceof JSEmbeddedContent) && (context = new MyLeftRightContext(current, document)).getParent() != null) {
                result2.add(context);
                current = context.getParent();
            }
            SmartList smartList = result2;
            if (smartList == null) {
                MyPostRemover.$$$reportNull$$$0(6);
            }
            return smartList;
        }

        @Nullable
        private static PsiElement createElementToReplace(Project project, PsiElement element) {
            String name;
            JSNamedElement expression;
            JSFunction function;
            if (element instanceof JSParameter && (function = ((JSParameter)element).getDeclaringFunction()) != null) {
                JSParameterList list = function.getParameterList();
                if (JSPsiImplUtils.isArrowFunction(function) && list != null && TreeUtil.findChildBackward((ASTNode)list.getNode(), (IElementType)JSTokenTypes.RPAR) == null) {
                    JSFunctionExpression dummyFunction = (JSFunctionExpression)Objects.requireNonNull(JSChangeUtil.createExpressionWithContext("() => {}", element)).getPsi(JSFunctionExpression.class);
                    return dummyFunction.getParameterList();
                }
            }
            if (element instanceof ES6ExportDefaultAssignment && (expression = (JSNamedElement)ObjectUtils.tryCast((Object)((ES6ExportDefaultAssignment)element).getExpression(), JSNamedElement.class)) != null && !StringUtil.isEmptyOrSpaces((String)(name = expression.getName()))) {
                if (expression instanceof JSFunction) {
                    return JSRefactoringUtil.functionDeclarationFromFunctionExpression(project, (JSFunction)expression, name, false);
                }
                if (expression instanceof JSClass) {
                    return JSRefactoringUtil.classDeclarationFromClassExpression(project, (JSClass)expression, name, false);
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/inspections/JSRemoveElementLocalQuickFix$MyPostRemover";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "replacer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/inspections/JSRemoveElementLocalQuickFix$MyPostRemover";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getElement";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createContextList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 6: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "insertReplacerIntoContext";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "createContextList";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

