/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.json;

import com.intellij.codeInsight.daemon.impl.AnnotationHolderImpl;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProxyingAnnotationHolder
extends AnnotationHolderImpl {
    private final ProblemsHolder myProblemsHolder;
    private final PsiFile myFile;
    @NotNull
    private final String myPrefix;

    public ProxyingAnnotationHolder(@NotNull AnnotationSession session, @NotNull ProblemsHolder holder, @Nullable String prefix) {
        if (session == null) {
            ProxyingAnnotationHolder.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            ProxyingAnnotationHolder.$$$reportNull$$$0(1);
        }
        super(session);
        this.myProblemsHolder = holder;
        this.myFile = session.getFile();
        this.myPrefix = StringUtil.notNullize((String)prefix);
    }

    public Annotation createAnnotation(@NotNull HighlightSeverity severity, @NotNull TextRange range, @Nullable String message, @Nullable String tooltip) {
        if (severity == null) {
            ProxyingAnnotationHolder.$$$reportNull$$$0(2);
        }
        if (range == null) {
            ProxyingAnnotationHolder.$$$reportNull$$$0(3);
        }
        Annotation annotation = super.createAnnotation(severity, range, message, tooltip);
        PsiElement element = ProxyingAnnotationHolder.findElementInRange(this.myFile, annotation);
        this.myProblemsHolder.registerProblem(element, this.myPrefix + annotation.getMessage(), ProxyingAnnotationHolder.convertFix(annotation.getQuickFixes()));
        return annotation;
    }

    private static PsiElement findElementInRange(@NotNull PsiFile file2, Annotation next) {
        PsiElement current;
        if (file2 == null) {
            ProxyingAnnotationHolder.$$$reportNull$$$0(4);
        }
        TextRange range = new TextRange(next.getStartOffset(), next.getEndOffset());
        for (current = file2.findElementAt(next.getStartOffset()); current != null && current.getParent() != null; current = current.getParent()) {
            if (range.equals((Object)current.getParent().getTextRange())) {
                return current.getParent();
            }
            if (!current.getParent().getTextRange().contains(range)) continue;
            return current;
        }
        return current;
    }

    private static LocalQuickFix[] convertFix(@Nullable List<Annotation.QuickFixInfo> info) {
        if (info == null || info.isEmpty()) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        return info.stream().map(i -> (LocalQuickFix)i.quickFix).collect(Collectors.toList()).toArray(LocalQuickFix.EMPTY_ARRAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProxyingAnnotationHolder getOrCreate(@NotNull AnnotationSession session, @NotNull ProblemsHolder holder, @NotNull String prefix, @NotNull String name) {
        if (session == null) {
            ProxyingAnnotationHolder.$$$reportNull$$$0(5);
        }
        if (holder == null) {
            ProxyingAnnotationHolder.$$$reportNull$$$0(6);
        }
        if (prefix == null) {
            ProxyingAnnotationHolder.$$$reportNull$$$0(7);
        }
        if (name == null) {
            ProxyingAnnotationHolder.$$$reportNull$$$0(8);
        }
        Key key = Key.create((String)("ProxyingAnnotationHolder." + name));
        AnnotationSession annotationSession = session;
        synchronized (annotationSession) {
            HashMap map = (HashMap)session.getUserData(key);
            if (map == null) {
                map = new HashMap();
                session.putUserDataIfAbsent(key, map);
            }
            return (ProxyingAnnotationHolder)((Object)ContainerUtil.getOrCreate(map, (Object)holder, () -> {
                if (session == null) {
                    ProxyingAnnotationHolder.$$$reportNull$$$0(9);
                }
                if (holder == null) {
                    ProxyingAnnotationHolder.$$$reportNull$$$0(10);
                }
                if (prefix == null) {
                    ProxyingAnnotationHolder.$$$reportNull$$$0(11);
                }
                return new ProxyingAnnotationHolder(session, holder, prefix);
            }));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 1: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "severity";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/json/ProxyingAnnotationHolder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "createAnnotation";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementInRange";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getOrCreate";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getOrCreate$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

