/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter;

import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.lang.javascript.linter.JSLinterDescriptor;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.DirectoryProjectConfigurator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLinterGuesser
implements DirectoryProjectConfigurator {
    public static final Logger LOG = Logger.getInstance(JSLinterGuesser.class);
    public static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.logOnlyGroup((String)"Linters");

    public void configureProject(Project project, @NotNull VirtualFile baseDir, Ref<Module> moduleRef) {
        if (baseDir == null) {
            JSLinterGuesser.$$$reportNull$$$0(0);
        }
        if (project.isDefault()) {
            return;
        }
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized((Runnable)((DumbAwareRunnable)() -> JSLinterGuesser.guessLinters(project)));
    }

    public static void guessLinters(@NotNull Project project) {
        if (project == null) {
            JSLinterGuesser.$$$reportNull$$$0(1);
        }
        PackageJsonData packageJson = PackageJsonUtil.getTopLevelPackageJsonData(project);
        List descriptors = Arrays.stream(JSLinterDescriptor.EP_NAME.getExtensions()).sorted(Comparator.comparing(t -> t.getPriority().value)).collect(Collectors.toList());
        for (JSLinterDescriptor descriptor2 : descriptors) {
            EnableCase enableCase = null;
            String packageName = descriptor2.packageName();
            if (packageJson != null) {
                if (packageJson.getAllDependencies().contains(packageName)) {
                    enableCase = EnableCase.dependency;
                }
                if (packageJson.getTopLevelProperties().contains(descriptor2.packageJsonSectionName())) {
                    enableCase = EnableCase.configSection;
                }
            }
            if (enableCase == null && descriptor2.hasConfigFiles(project)) {
                enableCase = EnableCase.configFile;
            }
            if (enableCase == null || !JSLinterGuesser.checkAdditionalEnableConditions(project, enableCase, descriptor2) || !descriptor2.enable(project)) continue;
            JSLinterGuesser.doLog(project, enableCase, descriptor2);
            descriptor2.postEnable(project, enableCase);
        }
    }

    private static boolean checkAdditionalEnableConditions(@NotNull Project project, @NotNull EnableCase enableCase, @NotNull JSLinterDescriptor descriptor2) {
        if (project == null) {
            JSLinterGuesser.$$$reportNull$$$0(2);
        }
        if (enableCase == null) {
            JSLinterGuesser.$$$reportNull$$$0(3);
        }
        if (descriptor2 == null) {
            JSLinterGuesser.$$$reportNull$$$0(4);
        }
        if (EnableCase.configFile.equals((Object)enableCase) || EnableCase.configSection.equals((Object)enableCase)) {
            String packageName = descriptor2.packageName();
            if (packageName == null) {
                return true;
            }
            NodeJsInterpreter interpreter = ApplicationManager.getApplication().isUnitTestMode() ? NodeJsInterpreterManager.getInstance(project).getInterpreter() : NodeJsLocalInterpreterManager.getInstance().detectMostRelevant();
            List<NodePackage> available = new NodePackageDescriptor(packageName).listAvailable(project, interpreter, project.getBaseDir());
            LocalFileSystem lfs = LocalFileSystem.getInstance();
            Iterator<NodePackage> iterator = available.iterator();
            while (iterator.hasNext()) {
                NodePackage nodePackage = iterator.next();
                if (lfs.refreshAndFindFileByPath(nodePackage.getSystemIndependentPath()) != null) continue;
                iterator.remove();
            }
            if (!available.isEmpty()) {
                LOG.info(String.format("For %s %s found, and linter in %s.", descriptor2.getDisplayName(), enableCase.name(), available.get(0).getSystemDependentPath()));
            }
            return !available.isEmpty();
        }
        return true;
    }

    private static void doLog(final @NotNull Project project, @NotNull EnableCase enableCase, final @NotNull JSLinterDescriptor descriptor2) {
        if (project == null) {
            JSLinterGuesser.$$$reportNull$$$0(5);
        }
        if (enableCase == null) {
            JSLinterGuesser.$$$reportNull$$$0(6);
        }
        if (descriptor2 == null) {
            JSLinterGuesser.$$$reportNull$$$0(7);
        }
        String message = enableCase.getMessage(descriptor2);
        NOTIFICATION_GROUP.createNotification(message, MessageType.INFO).addAction((AnAction)new NotificationAction("Disable " + descriptor2.getDisplayName()){

            public void actionPerformed(@NotNull AnActionEvent e, @NotNull Notification notification2) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (notification2 == null) {
                    1.$$$reportNull$$$0(1);
                }
                LOG.info(descriptor2.getDisplayName() + " disabled by user");
                descriptor2.disable(project);
                NOTIFICATION_GROUP.createNotification(JSBundle.message((String)"js.linter.guesser.linter.disabled", (Object[])new Object[]{descriptor2.getDisplayName()}), MessageType.INFO).notify(project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/linter/JSLinterGuesser$1";
                objectArray[2] = "actionPerformed";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }).notify(project);
        LOG.info(message);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 1: 
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enableCase";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterGuesser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "configureProject";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "guessLinters";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAdditionalEnableConditions";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "doLog";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum EnableCase {
        dependency("js.linter.guesser.linter.enabled.because.of.dependency", JSLinterDescriptor::packageName),
        configSection("js.linter.guesser.linter.enabled.because.of.package.json.section", JSLinterDescriptor::packageJsonSectionName),
        configFile("js.linter.guesser.linter.enabled.because.of.config.file", null);

        private final String myMessageKey;
        @Nullable
        private final Function<JSLinterDescriptor, String> mySecondArgument;

        private EnableCase(String key, Function<JSLinterDescriptor, String> argument) {
            if (key == null) {
                EnableCase.$$$reportNull$$$0(0);
            }
            this.myMessageKey = key;
            this.mySecondArgument = argument;
        }

        public String getMessage(@NotNull JSLinterDescriptor descriptor2) {
            if (descriptor2 == null) {
                EnableCase.$$$reportNull$$$0(1);
            }
            if (this.mySecondArgument == null) {
                return JSBundle.message((String)this.myMessageKey, (Object[])new Object[]{descriptor2.getDisplayName()});
            }
            return JSBundle.message((String)this.myMessageKey, (Object[])new Object[]{descriptor2.getDisplayName(), this.mySecondArgument.apply(descriptor2)});
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/linter/JSLinterGuesser$EnableCase";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getMessage";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

