/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.linter.jslint;

import com.google.common.collect.Maps;
import com.intellij.lang.javascript.linter.jslint.JSLintOption;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLintOptionsState {
    private final Map<JSLintOption, Object> myValueByOptionMap;

    private JSLintOptionsState(@NotNull Map<JSLintOption, Object> valueByOptionMap) {
        if (valueByOptionMap == null) {
            JSLintOptionsState.$$$reportNull$$$0(0);
        }
        this.myValueByOptionMap = Maps.newEnumMap(valueByOptionMap);
    }

    @NotNull
    public Set<JSLintOption> getOptions() {
        Set<JSLintOption> set = this.myValueByOptionMap.keySet();
        if (set == null) {
            JSLintOptionsState.$$$reportNull$$$0(1);
        }
        return set;
    }

    @Nullable
    public Object getValue(@NotNull JSLintOption option) {
        if (option == null) {
            JSLintOptionsState.$$$reportNull$$$0(2);
        }
        return this.myValueByOptionMap.get((Object)option);
    }

    public boolean getBoolean(@NotNull JSLintOption option) {
        Object obj;
        if (option == null) {
            JSLintOptionsState.$$$reportNull$$$0(3);
        }
        if ((obj = this.myValueByOptionMap.get((Object)option)) == null) {
            return false;
        }
        return (Boolean)obj;
    }

    public int getIntValue(@NotNull JSLintOption option, int defaultValue) {
        if (option == null) {
            JSLintOptionsState.$$$reportNull$$$0(4);
        }
        if (option.getType() != JSLintOption.Type.INTEGER) {
            throw new RuntimeException("option " + (Object)((Object)option) + " is not an integer option");
        }
        Object obj = this.myValueByOptionMap.get((Object)option);
        if (obj == null) {
            return defaultValue;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        throw new RuntimeException((Object)((Object)option) + " option has value " + obj + " of class " + obj.getClass());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSLintOptionsState that = (JSLintOptionsState)o;
        return this.myValueByOptionMap.equals(that.myValueByOptionMap);
    }

    public int hashCode() {
        return this.myValueByOptionMap.hashCode();
    }

    public String toString() {
        return this.myValueByOptionMap.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueByOptionMap";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/linter/jslint/JSLintOptionsState";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/linter/jslint/JSLintOptionsState";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getBoolean";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIntValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Builder {
        private final EnumMap<JSLintOption, Object> myValueByOptionMap;

        public Builder() {
            this.myValueByOptionMap = Maps.newEnumMap(JSLintOption.class);
        }

        public Builder(@NotNull JSLintOptionsState optionsState) {
            if (optionsState == null) {
                Builder.$$$reportNull$$$0(0);
            }
            this.myValueByOptionMap = Maps.newEnumMap((Map)optionsState.myValueByOptionMap);
        }

        public Builder put(@NotNull JSLintOption option, @NotNull Object value) {
            JSLintOption.Type optionType;
            if (option == null) {
                Builder.$$$reportNull$$$0(1);
            }
            if (value == null) {
                Builder.$$$reportNull$$$0(2);
            }
            if (!(optionType = option.getType()).isProperValue(value)) {
                String message = String.format("Attempt to set value of JSLint option '%s' to '%s' (value class is %s)!", option.getOptionName(), value, value.getClass());
                throw new RuntimeException(message);
            }
            Object prevValue = this.myValueByOptionMap.get((Object)option);
            if (prevValue != null || !optionType.isDefault(value)) {
                this.myValueByOptionMap.put(option, value);
            }
            return this;
        }

        @NotNull
        public JSLintOptionsState build() {
            JSLintOptionsState jSLintOptionsState = new JSLintOptionsState(this.myValueByOptionMap);
            if (jSLintOptionsState == null) {
                Builder.$$$reportNull$$$0(3);
            }
            return jSLintOptionsState;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "optionsState";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "option";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "value";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/linter/jslint/JSLintOptionsState$Builder";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/linter/jslint/JSLintOptionsState$Builder";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "build";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "put";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

