/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConsoleProgress {
    private static final long DELAY_MILLIS = 250L;
    private final ConsoleViewImpl myConsoleView;
    private Alarm myAlarm;
    private int myCounter;
    private int myPrevOffset;
    private boolean myDocumentProgressBeingUpdated;
    private DocumentListener myDocumentListener;

    public ConsoleProgress(@NotNull ConsoleViewImpl consoleView, @NotNull ProcessHandler processHandler) {
        if (consoleView == null) {
            ConsoleProgress.$$$reportNull$$$0(0);
        }
        if (processHandler == null) {
            ConsoleProgress.$$$reportNull$$$0(1);
        }
        this.myAlarm = null;
        this.myCounter = 0;
        this.myPrevOffset = -1;
        this.myDocumentProgressBeingUpdated = false;
        this.myConsoleView = consoleView;
        if (!processHandler.isProcessTerminated()) {
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void startNotified(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    ApplicationManager.getApplication().invokeLater(() -> ConsoleProgress.this.start(), ModalityState.any());
                }

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    ApplicationManager.getApplication().invokeLater(() -> ConsoleProgress.this.stop(), ModalityState.any());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "event";
                    objectArray2[1] = "com/intellij/lang/javascript/modules/ConsoleProgress$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "startNotified";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processTerminated";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }
    }

    @Nullable
    public static ConsoleProgress install(@NotNull ConsoleView consoleView, @NotNull ProcessHandler processHandler) {
        if (consoleView == null) {
            ConsoleProgress.$$$reportNull$$$0(2);
        }
        if (processHandler == null) {
            ConsoleProgress.$$$reportNull$$$0(3);
        }
        if (consoleView instanceof ConsoleViewImpl) {
            ConsoleViewImpl view = (ConsoleViewImpl)consoleView;
            return new ConsoleProgress(view, processHandler);
        }
        return null;
    }

    private char nextChar() {
        ++this.myCounter;
        return this.getCurrentChar();
    }

    private char getCurrentChar() {
        return "-\\|/".charAt(this.myCounter % 4);
    }

    private void start() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myAlarm != null) {
            return;
        }
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        final Runnable updateRunnable = new Runnable(){

            @Override
            public void run() {
                ConsoleProgress.this.updateProgress();
                ConsoleProgress.this.myAlarm.addRequest((Runnable)this, 250L, ModalityState.any());
            }
        };
        this.myAlarm.addRequest(updateRunnable, 250L, ModalityState.any());
        ApplicationManager.getApplication().runWriteAction(() -> {
            Document document = this.getDocument();
            if (document != null) {
                this.myDocumentListener = new DocumentListener(){

                    public void beforeDocumentChange(DocumentEvent event) {
                        if (!ConsoleProgress.this.myDocumentProgressBeingUpdated && !ConsoleProgress.this.myAlarm.isDisposed()) {
                            ConsoleProgress.this.myAlarm.cancelAllRequests();
                            ConsoleProgress.this.myAlarm.addRequest(updateRunnable, 0, ModalityState.any());
                        }
                    }
                };
                document.addDocumentListener(this.myDocumentListener);
            }
        });
    }

    private void updateProgress() {
        ApplicationManager.getApplication().runWriteAction(() -> {
            Document document = this.getDocument();
            if (document != null) {
                this.hideProgress(document);
                int offset = document.getTextLength();
                char ch = this.nextChar();
                try {
                    this.myDocumentProgressBeingUpdated = true;
                    document.insertString(offset, (CharSequence)Character.toString(ch));
                }
                finally {
                    this.myDocumentProgressBeingUpdated = false;
                }
                this.myPrevOffset = offset;
            }
        });
    }

    @Nullable
    private Document getDocument() {
        Editor editor = this.myConsoleView.getEditor();
        if (editor != null) {
            return editor.getDocument();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hideProgress(@NotNull Document document) {
        char ch;
        if (document == null) {
            ConsoleProgress.$$$reportNull$$$0(4);
        }
        CharSequence sequence = document.getCharsSequence();
        if (this.myPrevOffset >= 0 && this.myPrevOffset < sequence.length() && (ch = sequence.charAt(this.myPrevOffset)) == this.getCurrentChar()) {
            try {
                this.myDocumentProgressBeingUpdated = true;
                document.deleteString(this.myPrevOffset, this.myPrevOffset + 1);
            }
            finally {
                this.myDocumentProgressBeingUpdated = false;
            }
        }
        this.myPrevOffset = -1;
    }

    private void stop() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myAlarm != null) {
            this.myAlarm.cancelAllRequests();
            Disposer.dispose((Disposable)this.myAlarm);
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            Document document = this.getDocument();
            if (document != null) {
                this.hideProgress(document);
                if (this.myDocumentListener != null) {
                    document.removeDocumentListener(this.myDocumentListener);
                    this.myDocumentListener = null;
                }
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/modules/ConsoleProgress";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "install";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hideProgress";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

