/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.navigation;

import com.intellij.codeInsight.navigation.MethodNavigationOffsetProvider;
import com.intellij.codeInsight.navigation.MethodUpDownUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class JSMethodNavigationOffsetProvider
implements MethodNavigationOffsetProvider {
    public int[] getMethodNavigationOffsets(PsiFile file2, int caretOffset) {
        PsiElement elementAtCaret;
        JSEmbeddedContent embeddedContent;
        PsiFile rootElement = null;
        if (file2 instanceof JSFile) {
            rootElement = file2;
        } else if (file2 instanceof XmlFile && (embeddedContent = (JSEmbeddedContent)PsiTreeUtil.getParentOfType((PsiElement)(elementAtCaret = file2.findElementAt(caretOffset)), JSEmbeddedContent.class)) != null) {
            rootElement = embeddedContent;
        }
        if (rootElement == null) {
            return null;
        }
        final ArrayList array = new ArrayList();
        rootElement.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){

            public void visitJSClass(JSClass aClass) {
                array.add(aClass);
                ASTNode rBrace = aClass.getNode().findChildByType(JSTokenTypes.RBRACE);
                if (rBrace != null) {
                    array.add(rBrace.getPsi());
                }
                super.visitJSClass(aClass);
            }

            public void visitJSFunctionDeclaration(@NotNull JSFunction node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                array.add(node);
            }

            public void visitJSFunctionExpression(@NotNull JSFunctionExpression node) {
                PsiElement parent;
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((parent = node.getParent()) instanceof JSArgumentList || parent instanceof JSExpression && !(parent instanceof JSAssignmentExpression)) {
                    return;
                }
                array.add(node);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "com/intellij/lang/javascript/navigation/JSMethodNavigationOffsetProvider$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionDeclaration";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitJSFunctionExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return MethodUpDownUtil.offsetsFromElements(array);
    }
}

