/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.ecma6.impl;

import com.intellij.lang.ASTNode;
import com.intellij.lang.ecmascript6.psi.stubs.ES6ReferenceListStub;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeEvaluationResult;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.ES6ReferenceList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterList;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeParameterListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceList;
import com.intellij.lang.javascript.psi.ecmal4.JSReferenceListMember;
import com.intellij.lang.javascript.psi.ecmal4.impl.JSReferenceListImpl;
import com.intellij.lang.javascript.psi.resolve.JSEvaluateContext;
import com.intellij.lang.javascript.psi.resolve.JSImportHandler;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.lang.javascript.psi.resolve.JSTypeResolveResult;
import com.intellij.lang.javascript.psi.types.JSFunctionTypeImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSNamedType;
import com.intellij.lang.javascript.psi.types.TypeScriptTypeParser;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ReferenceListImpl
extends JSReferenceListImpl<ES6ReferenceListStub>
implements ES6ReferenceList {
    public static final Key<ParameterizedCachedValue<ClassExpressionResolve, PsiElement>> CACHE_KEY = Key.create((String)"ES6.Ref.list");
    public static final Condition<JSType> FUNCTION_TYPE_FILTER = type -> {
        JSFunctionTypeImpl jsType = ES6ReferenceListImpl.asFunctionType(type);
        return jsType != null;
    };
    public static final ClassExpressionResolve NO_CONSTRUCTOR = ES6ReferenceListImpl.create(ES6ReferenceList.Errors.NO_CONSTRUCTOR);
    public static final ClassExpressionResolve CIRCLE_ERROR = ES6ReferenceListImpl.create(ES6ReferenceList.Errors.CIRCLE);
    public static final ParameterizedCachedValueProvider<ClassExpressionResolve, PsiElement> CACHED_VALUE_PROVIDER = new ParameterizedCachedValueProvider<ClassExpressionResolve, PsiElement>(){

        @Nullable
        public CachedValueProvider.Result<ClassExpressionResolve> compute(PsiElement expressionToResolve) {
            Pair typeWithSource = ES6ReferenceListImpl.getExpressionType(expressionToResolve);
            if (typeWithSource != null) {
                JSType type = JSTypeUtils.getValuableType((JSType)typeWithSource.first);
                if (type instanceof JSNamedType && ES6ReferenceListImpl.isCycleDefs(type, expressionToResolve)) {
                    return CachedValueProvider.Result.create((Object)CIRCLE_ERROR, (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
                }
                if (DialectDetector.isES6(expressionToResolve) && typeWithSource.second != null) {
                    return CachedValueProvider.Result.create((Object)new ClassExpressionResolve(null, (JSClass)typeWithSource.second, ES6ReferenceList.Errors.NO_ERROR), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
                }
                if (type != null) {
                    ClassExpressionResolve pair = ES6ReferenceListImpl.getConstructorSignatureType(type, expressionToResolve);
                    return CachedValueProvider.Result.create((Object)pair, (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
                }
                ClassExpressionResolve value = new ClassExpressionResolve(null, (JSClass)typeWithSource.second, null);
                return CachedValueProvider.Result.create((Object)value, (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
            }
            return CachedValueProvider.Result.create((Object)NO_CONSTRUCTOR, (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
        }
    };

    @Nullable
    public static JSFunctionTypeImpl asFunctionType(@Nullable JSType type) {
        if (type instanceof JSFunctionTypeImpl) {
            return (JSFunctionTypeImpl)type;
        }
        if (type instanceof JSGenericTypeImpl) {
            JSType jsType = ((JSGenericTypeImpl)type).getType();
            return jsType instanceof JSFunctionTypeImpl ? (JSFunctionTypeImpl)jsType : null;
        }
        return null;
    }

    private static ClassExpressionResolve create(@Nullable ES6ReferenceList.Errors constructorError) {
        return new ClassExpressionResolve(null, null, constructorError);
    }

    public static boolean isCycleDefs(@NotNull JSType type, @NotNull PsiElement expressionToResolve) {
        PsiElement parentClass;
        if (type == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(0);
        }
        if (expressionToResolve == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(1);
        }
        Collection<? extends PsiElement> elements = TypeScriptTypeParser.resolveElementsByType(type);
        PsiElement refList = PsiTreeUtil.getParentOfType((PsiElement)expressionToResolve, JSReferenceList.class);
        return refList != null && ES6ReferenceListImpl.matchCycleDefs(elements, parentClass = refList.getParent(), ContainerUtil.newHashSet());
    }

    public ES6ReferenceListImpl(ASTNode node) {
        super(node);
    }

    public ES6ReferenceListImpl(ES6ReferenceListStub stub) {
        super(stub);
    }

    @Override
    @NotNull
    public JSClass[] getReferencedClasses() {
        JSReferenceListMember[] members = this.getMembers();
        if (members.length == 0) {
            if (JSClass.EMPTY_ARRAY == null) {
                ES6ReferenceListImpl.$$$reportNull$$$0(2);
            }
            return JSClass.EMPTY_ARRAY;
        }
        JSImportHandler importHandler = this.getImportHandler();
        ArrayList<JSClass> supers = new ArrayList<JSClass>(members.length);
        for (JSReferenceListMember member : members) {
            String text = member.getReferenceText();
            if (text != null) {
                Collection<JSClass> classes = ES6ReferenceListImpl.resolveTextReferenceClasses(importHandler, text, (PsiElement)this);
                if (classes.isEmpty() && !DialectDetector.isTypeScript((PsiElement)this)) {
                    classes = this.resolveDirectlyToClasses(text);
                }
                if (classes.size() > 0) {
                    supers.addAll(classes);
                    continue;
                }
            }
            JSExpression element = member.getExpression();
            ES6ReferenceListImpl.resolveExpression((PsiElement)element, supers);
        }
        JSClass[] jSClassArray = supers.isEmpty() ? JSClass.EMPTY_ARRAY : (JSClass[])ContainerUtil.toArray(supers, (Object[])new JSClass[supers.size()]);
        if (jSClassArray == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(3);
        }
        return jSClassArray;
    }

    private static void resolveExpression(PsiElement element, Collection<JSClass> supers) {
        ClassExpressionResolve classExpressionResolve = ES6ReferenceListImpl.resolveExpression(element);
        if (classExpressionResolve.hasError()) {
            return;
        }
        if (classExpressionResolve.resolveElement != null) {
            supers.add(classExpressionResolve.resolveElement);
        }
        if (classExpressionResolve.types != null) {
            JSType functionType = (JSType)ContainerUtil.getFirstItem(classExpressionResolve.types);
            JSType returnType = ES6ReferenceListImpl.getReturnType(functionType);
            Collection<? extends PsiElement> elements = TypeScriptTypeParser.resolveElementsByType(returnType);
            for (PsiElement psiElement : elements) {
                if (!(psiElement instanceof JSClass)) continue;
                supers.add((JSClass)psiElement);
            }
        }
    }

    @Nullable
    private static Pair<JSType, JSClass> getExpressionType(PsiElement element) {
        JSType type = null;
        if (element instanceof JSExpression) {
            JSTypeEvaluationResult typeResult = JSTypeEvaluator.getExpressionType((JSExpression)element);
            if (typeResult != null) {
                type = typeResult.getType();
                Optional<JSClass> possibleClass = typeResult.getResults().stream().map(el -> el.getSource()).filter(el -> el instanceof JSClass).map(el -> (JSClass)el).findAny();
                return Pair.create((Object)type, possibleClass.orElse(null));
            }
        } else {
            type = JSTypeUtils.getTypeOfElement(element);
        }
        return type == null ? null : Pair.create((Object)type, null);
    }

    @NotNull
    public static ClassExpressionResolve resolveExpression(@NotNull PsiElement expression) {
        if (expression == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(4);
        }
        Ref ref = Ref.create();
        JSTypeEvaluator.processWithEvaluationGuard(expression, JSEvaluateContext.JSEvaluationPlace.CLASS_REFERENCE_LIST, el -> {
            if (expression == null) {
                ES6ReferenceListImpl.$$$reportNull$$$0(22);
            }
            ClassExpressionResolve result2 = (ClassExpressionResolve)CachedValuesManager.getManager((Project)expression.getProject()).getParameterizedCachedValue((UserDataHolder)el, CACHE_KEY, CACHED_VALUE_PROVIDER, false, el);
            ref.set((Object)result2);
        });
        if (ref.isNull()) {
            ClassExpressionResolve classExpressionResolve = NO_CONSTRUCTOR;
            if (classExpressionResolve == null) {
                ES6ReferenceListImpl.$$$reportNull$$$0(5);
            }
            return classExpressionResolve;
        }
        ClassExpressionResolve classExpressionResolve = (ClassExpressionResolve)ref.get();
        if (classExpressionResolve == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(6);
        }
        return classExpressionResolve;
    }

    @NotNull
    public static ClassExpressionResolve getConstructorSignatureType(@Nullable JSType type, @Nullable PsiElement element) {
        Collection allFunctionTypes;
        if (type == null) {
            ClassExpressionResolve classExpressionResolve = NO_CONSTRUCTOR;
            if (classExpressionResolve == null) {
                ES6ReferenceListImpl.$$$reportNull$$$0(7);
            }
            return classExpressionResolve;
        }
        if (type instanceof JSGenericTypeImpl) {
            type = type.asRecordType();
        }
        if ((allFunctionTypes = (Collection)JSTypeUtils.getFunctionType(type, true).collect(Collectors.toList())).isEmpty()) {
            ClassExpressionResolve classExpressionResolve = new ClassExpressionResolve(ContainerUtil.createMaybeSingletonList((Object)type), null, ES6ReferenceList.Errors.NO_CONSTRUCTOR);
            if (classExpressionResolve == null) {
                ES6ReferenceListImpl.$$$reportNull$$$0(8);
            }
            return classExpressionResolve;
        }
        List types = ContainerUtil.filter((Collection)allFunctionTypes, FUNCTION_TYPE_FILTER);
        if (types.isEmpty()) {
            ClassExpressionResolve classExpressionResolve = new ClassExpressionResolve(ContainerUtil.createMaybeSingletonList((Object)type), null, ES6ReferenceList.Errors.NO_CONSTRUCTOR);
            if (classExpressionResolve == null) {
                ES6ReferenceListImpl.$$$reportNull$$$0(9);
            }
            return classExpressionResolve;
        }
        List matched = ContainerUtil.newSmartList();
        List<JSType> argumentsForExpression = ContainerUtil.emptyList();
        if (element instanceof JSExpression) {
            argumentsForExpression = TypeScriptGenericTypesEvaluator.getTypeArgumentsForDeclarations(TypeScriptPsiUtil.getNestedTypeArguments(element.getParent()), null);
        }
        int argSize = argumentsForExpression.size();
        for (JSType constructorType : types) {
            JSType returnType;
            JSFunctionTypeImpl functionType = ES6ReferenceListImpl.asFunctionType(constructorType);
            if (functionType == null || (returnType = functionType.getReturnType()) == null || argSize != ES6ReferenceListImpl.getParameterListSize(constructorType)) continue;
            matched.add(constructorType);
        }
        if (matched.isEmpty()) {
            ClassExpressionResolve classExpressionResolve = new ClassExpressionResolve(ContainerUtil.createMaybeSingletonList((Object)type), null, ES6ReferenceList.Errors.NO_COUNT_TYPE_ARGUMENTS);
            if (classExpressionResolve == null) {
                ES6ReferenceListImpl.$$$reportNull$$$0(10);
            }
            return classExpressionResolve;
        }
        if (matched.size() > 1) {
            JSType item = ES6ReferenceListImpl.getReturnType((JSType)ContainerUtil.getFirstItem((Collection)matched));
            assert (item != null);
            boolean isFirst = true;
            for (JSType jsType : matched) {
                if (isFirst) {
                    isFirst = false;
                    continue;
                }
                if (item.isEquivalentTo(ES6ReferenceListImpl.getReturnType(jsType), null)) continue;
                ClassExpressionResolve classExpressionResolve = new ClassExpressionResolve(ContainerUtil.createMaybeSingletonList((Object)type), null, ES6ReferenceList.Errors.MANY_CONSTRUCTORS_WITH_DIFF_TYPES);
                if (classExpressionResolve == null) {
                    ES6ReferenceListImpl.$$$reportNull$$$0(11);
                }
                return classExpressionResolve;
            }
        }
        ClassExpressionResolve classExpressionResolve = new ClassExpressionResolve(matched, null, ES6ReferenceList.Errors.NO_ERROR);
        if (classExpressionResolve == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(12);
        }
        return classExpressionResolve;
    }

    private static int getParameterListSize(JSType constructorType) {
        PsiElement sourceElement = constructorType.getSource().getSourceElement();
        if (!(sourceElement instanceof TypeScriptTypeParameterListOwner)) {
            return 0;
        }
        TypeScriptTypeParameterListOwner owner = (TypeScriptTypeParameterListOwner)sourceElement;
        TypeScriptTypeParameterList list = owner.getTypeParameterList();
        if (list == null) {
            return 0;
        }
        return list.getTypeParameters().length;
    }

    private static boolean matchCycleDefs(@NotNull Collection<? extends PsiElement> elements, @Nullable PsiElement toFind, @NotNull Collection<PsiElement> visited) {
        if (elements == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(13);
        }
        if (visited == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(14);
        }
        if (!elements.isEmpty() && toFind != null) {
            for (PsiElement psiElement : elements) {
                Object[] classes;
                JSClass jsClass;
                if (!visited.add(psiElement)) {
                    return true;
                }
                if (psiElement.isEquivalentTo(toFind)) {
                    return true;
                }
                if (!(psiElement instanceof JSClass) || (jsClass = (JSClass)psiElement).isInterface() || (classes = jsClass.getSuperClasses()).length <= 0 || !ES6ReferenceListImpl.matchCycleDefs(ContainerUtil.newArrayList((Object[])classes), toFind, visited)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @NotNull
    public Collection<Pair<JSReferenceListMember, Collection<JSClass>>> getResolvedExpressions() {
        JSReferenceListMember[] members = this.getMembers();
        if (members.length == 0) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                ES6ReferenceListImpl.$$$reportNull$$$0(15);
            }
            return list;
        }
        JSImportHandler handler = this.getImportHandler();
        List resolvedList = ContainerUtil.newSmartList();
        for (JSReferenceListMember member : members) {
            String text = member.getReferenceText();
            if (text != null) {
                Collection<JSClass> classes = ES6ReferenceListImpl.resolveTextReferenceClasses(handler, text, (PsiElement)this);
                if (classes.isEmpty() && !DialectDetector.isTypeScript((PsiElement)this)) {
                    classes = this.resolveDirectlyToClasses(text);
                }
                if (classes.size() > 0) {
                    resolvedList.add(Pair.create((Object)member, classes));
                    continue;
                }
            }
            List expectedClasses = ContainerUtil.newSmartList();
            ES6ReferenceListImpl.resolveExpression((PsiElement)member.getExpression(), expectedClasses);
            resolvedList.add(Pair.create((Object)member, (Object)expectedClasses));
        }
        List list = resolvedList;
        if (list == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    public static Collection<JSClass> resolveTextReferenceClasses(@NotNull JSImportHandler importHandler, @Nullable String text, @NotNull PsiElement thisElement) {
        if (importHandler == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(17);
        }
        if (thisElement == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(18);
        }
        if (text == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                ES6ReferenceListImpl.$$$reportNull$$$0(19);
            }
            return list;
        }
        JSTypeResolveResult result2 = importHandler.resolveName(text, thisElement);
        if (result2.hasElements()) {
            List resultClasses = ContainerUtil.newSmartList();
            for (PsiElement psiElement : result2.getElements()) {
                if (!(psiElement instanceof JSClass)) continue;
                resultClasses.add((JSClass)psiElement);
            }
            if (resultClasses.size() > 0) {
                List list = resultClasses;
                if (list == null) {
                    ES6ReferenceListImpl.$$$reportNull$$$0(20);
                }
                return list;
            }
        }
        List list = ContainerUtil.emptyList();
        if (list == null) {
            ES6ReferenceListImpl.$$$reportNull$$$0(21);
        }
        return list;
    }

    @Nullable
    private static JSType getReturnType(@Nullable JSType type) {
        return type instanceof JSFunctionTypeImpl ? ((JSFunctionTypeImpl)type).getReturnType() : type;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expressionToResolve";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl";
                break;
            }
            case 4: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importHandler";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/ecma6/impl/ES6ReferenceListImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencedClasses";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveExpression";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getConstructorSignatureType";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedExpressions";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveTextReferenceClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isCycleDefs";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveExpression";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "matchCycleDefs";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resolveTextReferenceClasses";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$resolveExpression$4";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class ClassExpressionResolve {
        @Nullable
        public final Collection<JSType> types;
        @Nullable
        public final JSClass resolveElement;
        @Nullable
        public final ES6ReferenceList.Errors constructorError;

        public ClassExpressionResolve(@Nullable Collection<JSType> types, @Nullable JSClass resolve, @Nullable ES6ReferenceList.Errors constructorError) {
            this.types = types;
            this.resolveElement = resolve;
            this.constructorError = constructorError;
        }

        public boolean hasError() {
            return this.constructorError != null && this.constructorError != ES6ReferenceList.Errors.NO_ERROR;
        }
    }
}

