/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.resolve;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSCollectMembersToImplementProcessor;
import com.intellij.lang.javascript.psi.resolve.JSOverrideHandler;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.resolve.ResolveProcessor;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.ResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.javascript.psi.stubs.JSSuperClassIndex;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.javascript.search.JSClassSearch;
import com.intellij.lang.javascript.search.JSFunctionsSearch;
import com.intellij.lang.javascript.validation.JSFunctionCollector;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.CommonProcessors;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PairFunction;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSInheritanceUtil {
    private static final ThreadLocal<GlobalSearchScope> ourEnforcedScope = new ThreadLocal();

    public static <T extends JSPsiElementBase> boolean iterateOverriddenMembersUp(@NotNull JSPsiElementBase method, boolean recursive, @NotNull PairFunction<List<T>, String, Boolean> methodsProcessor, boolean onlyFunctions) {
        if (method == null) {
            JSInheritanceUtil.$$$reportNull$$$0(0);
        }
        if (methodsProcessor == null) {
            JSInheritanceUtil.$$$reportNull$$$0(1);
        }
        return JSInheritanceUtil.iterateOverriddenMembersUp(method, recursive, methodsProcessor, (Set<String>)new THashSet(), onlyFunctions);
    }

    private static <T extends JSPsiElementBase> boolean iterateOverriddenMembersUp(@NotNull JSPsiElementBase member, final boolean recursive, final @NotNull PairFunction<List<T>, String, Boolean> membersProcessor, final @NotNull Set<String> visitedTypes, final boolean onlyFunctions) {
        if (member == null) {
            JSInheritanceUtil.$$$reportNull$$$0(2);
        }
        if (membersProcessor == null) {
            JSInheritanceUtil.$$$reportNull$$$0(3);
        }
        if (visitedTypes == null) {
            JSInheritanceUtil.$$$reportNull$$$0(4);
        }
        String qName = JSResolveUtil.getQNameToStartHierarchySearch(member);
        String methodName = member.getName();
        if (qName != null && methodName != null) {
            boolean nodeIsMember;
            PsiElement parent = JSResolveUtil.findParent((PsiElement)member);
            boolean bl = nodeIsMember = !qName.endsWith(methodName);
            if (!nodeIsMember) {
                return true;
            }
            return JSResolveUtil.iterateType(member, (PsiElement)(parent instanceof JSClass ? parent : member.getContainingFile()), qName, new JSOverrideHandler(){

                @Override
                public boolean process(@NotNull List<JSPsiElementBase> elements, PsiElement scope, String className) {
                    if (elements == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!visitedTypes.add(className)) {
                        return true;
                    }
                    ArrayList<JSPsiElementBase> results = new ArrayList<JSPsiElementBase>(elements.size());
                    for (PsiElement psiElement : elements) {
                        results.add((JSPsiElementBase)psiElement);
                    }
                    if (!((Boolean)membersProcessor.fun(results, (Object)className)).booleanValue()) {
                        return false;
                    }
                    if (recursive) {
                        for (PsiElement psiElement : elements) {
                            if (onlyFunctions && !(psiElement instanceof JSFunctionItem) || JSInheritanceUtil.iterateOverriddenMembersUp((JSPsiElementBase)psiElement, true, membersProcessor, visitedTypes, onlyFunctions)) continue;
                            return false;
                        }
                    }
                    return true;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil$1", "process"));
                }
            }, onlyFunctions);
        }
        return true;
    }

    public static boolean iterateOverriddenMethodsUp(@NotNull JSFunction method, @NotNull Processor<JSFunction> methodsProcessor) {
        if (method == null) {
            JSInheritanceUtil.$$$reportNull$$$0(5);
        }
        if (methodsProcessor == null) {
            JSInheritanceUtil.$$$reportNull$$$0(6);
        }
        return JSInheritanceUtil.iterateOverriddenMemberUp((JSPsiElementBase)method, (Processor<JSPsiElementBase>)((Processor)el -> {
            if (methodsProcessor == null) {
                JSInheritanceUtil.$$$reportNull$$$0(98);
            }
            return methodsProcessor.process((Object)((JSFunction)el));
        }));
    }

    public static boolean iterateOverriddenMemberUp(@NotNull JSPsiElementBase el, @NotNull Processor<JSPsiElementBase> methodsProcessor) {
        if (el == null) {
            JSInheritanceUtil.$$$reportNull$$$0(7);
        }
        if (methodsProcessor == null) {
            JSInheritanceUtil.$$$reportNull$$$0(8);
        }
        boolean onlyFunctions = el instanceof JSFunction;
        return JSInheritanceUtil.iterateOverriddenMembersUp(el, true, (jsNamedElements, s) -> {
            if (methodsProcessor == null) {
                JSInheritanceUtil.$$$reportNull$$$0(97);
            }
            if (jsNamedElements.isEmpty()) {
                return false;
            }
            JSPsiElementBase toProcess = (JSPsiElementBase)ContainerUtil.getFirstItem((List)jsNamedElements);
            if (onlyFunctions && !(toProcess instanceof JSFunction)) {
                return false;
            }
            if (!methodsProcessor.process((Object)toProcess)) {
                return false;
            }
            return true;
        }, onlyFunctions);
    }

    public static Collection<JSFunction> findImplementedMethods(@NotNull JSFunction implementingFunction) {
        if (implementingFunction == null) {
            JSInheritanceUtil.$$$reportNull$$$0(9);
        }
        return JSInheritanceUtil.findImplementedMembers((JSQualifiedNamedElement)implementingFunction).stream().filter(el -> el instanceof JSFunction).map(el -> (JSFunction)el).collect(Collectors.toList());
    }

    @NotNull
    public static Collection<JSPsiElementBase> findImplementedMembers(@NotNull JSQualifiedNamedElement implementingMember) {
        if (implementingMember == null) {
            JSInheritanceUtil.$$$reportNull$$$0(10);
        }
        if (!(implementingMember instanceof JSAttributeListOwner) || !(implementingMember instanceof TypeScriptTypeMember) && !JSInheritanceUtil.canHaveSuperMember(((JSAttributeListOwner)implementingMember).getAttributeList())) {
            List<JSPsiElementBase> list = Collections.emptyList();
            if (list == null) {
                JSInheritanceUtil.$$$reportNull$$$0(11);
            }
            return list;
        }
        final JSClass containingClass = JSUtils.getMemberContainingClass((PsiElement)implementingMember);
        if (containingClass == null) {
            List<JSPsiElementBase> list = Collections.emptyList();
            if (list == null) {
                JSInheritanceUtil.$$$reportNull$$$0(12);
            }
            return list;
        }
        final HashSet collectedObjects = ContainerUtil.newHashSet();
        final String name = implementingMember.getName();
        if (name == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                JSInheritanceUtil.$$$reportNull$$$0(13);
            }
            return list;
        }
        JSCollectMembersToImplementProcessor processor = new JSCollectMembersToImplementProcessor((PsiElement)implementingMember, true){

            @Override
            protected void processMembers(@NotNull List<PsiElement> processorResults) {
                if (processorResults == null) {
                    2.$$$reportNull$$$0(0);
                }
                collectedObjects.addAll(processorResults);
            }

            @Override
            @NotNull
            protected ResultSink createResultSink() {
                ResolveResultSink resolveResultSink = new ResolveResultSink(this.place, name);
                if (resolveResultSink == null) {
                    2.$$$reportNull$$$0(1);
                }
                return resolveResultSink;
            }

            @Override
            protected boolean shouldProcessClass(@NotNull JSClass jsClass) {
                if (jsClass == null) {
                    2.$$$reportNull$$$0(2);
                }
                return !DialectDetector.isTypeScript((PsiElement)jsClass) || containingClass.isEquivalentTo((PsiElement)jsClass) || jsClass.findFunctionByName(name) == null && jsClass.findFieldByName(name) == null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "processorResults";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil$2";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "jsClass";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createResultSink";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "processMembers";
                        break;
                    }
                    case 1: {
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "shouldProcessClass";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        JSResolveUtil.processInterfaceMembers(containingClass, processor);
        Collection collection = collectedObjects.stream().map(el -> (JSPsiElementBase)el).collect(Collectors.toList());
        if (collection == null) {
            JSInheritanceUtil.$$$reportNull$$$0(14);
        }
        return collection;
    }

    @NotNull
    public static Collection<JSPsiElementBase> findNearestOverriddenMembers(@NotNull JSPsiElementBase method, boolean onlyFunctions) {
        if (method == null) {
            JSInheritanceUtil.$$$reportNull$$$0(15);
        }
        THashSet result2 = new THashSet();
        JSInheritanceUtil.iterateOverriddenMembersUp(method, false, (arg_0, arg_1) -> JSInheritanceUtil.lambda$findNearestOverriddenMembers$5((Collection)result2, arg_0, arg_1), onlyFunctions);
        THashSet tHashSet = result2;
        if (tHashSet == null) {
            JSInheritanceUtil.$$$reportNull$$$0(16);
        }
        return tHashSet;
    }

    public static boolean processNearestOverriddenMethods(@NotNull JSFunctionItem method, @NotNull Processor<JSFunction> processor) {
        if (method == null) {
            JSInheritanceUtil.$$$reportNull$$$0(17);
        }
        if (processor == null) {
            JSInheritanceUtil.$$$reportNull$$$0(18);
        }
        Ref result2 = Ref.create((Object)Boolean.TRUE);
        JSInheritanceUtil.iterateOverriddenMembersUp((JSPsiElementBase)method, false, (functions, s) -> {
            if (processor == null) {
                JSInheritanceUtil.$$$reportNull$$$0(96);
            }
            for (JSPsiElementBase function : functions) {
                JSFunction overridden = JSPsiImplUtils.getPossibleFunction((PsiElement)function);
                if (processor.process((Object)overridden)) continue;
                result2.set((Object)Boolean.FALSE);
                return false;
            }
            return true;
        }, true);
        return (Boolean)result2.get();
    }

    @Nullable
    public static JSClass findSomeDeclaringClass(@NotNull JSQualifiedNamedElement method) {
        if (method == null) {
            JSInheritanceUtil.$$$reportNull$$$0(19);
        }
        return (JSClass)ContainerUtil.getFirstItem(JSInheritanceUtil.findDeclaringClasses(method), null);
    }

    public static Map<JSClass, JSPsiElementBase> findDeclaringClassesMap(@NotNull JSQualifiedNamedElement method) {
        if (method == null) {
            JSInheritanceUtil.$$$reportNull$$$0(20);
        }
        LinkedHashMap result2 = ContainerUtil.newLinkedHashMap();
        Collection<JSPsiElementBase> topMethods = JSInheritanceUtil.findTopMembers(method);
        for (JSPsiElementBase topMethod : topMethods) {
            JSClass containingClass = JSUtils.getMemberContainingClass((PsiElement)topMethod);
            if (containingClass == null) continue;
            result2.put(containingClass, topMethod);
        }
        return result2;
    }

    public static Collection<JSClass> findDeclaringClasses(@NotNull JSQualifiedNamedElement method) {
        if (method == null) {
            JSInheritanceUtil.$$$reportNull$$$0(21);
        }
        return JSInheritanceUtil.findDeclaringClassesMap(method).keySet();
    }

    @NotNull
    public static Collection<JSPsiElementBase> findTopMembers(@NotNull JSQualifiedNamedElement member) {
        Collection<JSPsiElementBase> implementedMembers;
        if (member == null) {
            JSInheritanceUtil.$$$reportNull$$$0(22);
        }
        JSQualifiedNamedElement currentMember = member;
        JSPsiElementBase topParent = JSInheritanceUtil.findTopOverriddenMember((JSPsiElementBase)member);
        if (topParent != null) {
            currentMember = topParent;
        }
        if (!(implementedMembers = JSInheritanceUtil.findImplementedMembers(currentMember)).isEmpty()) {
            ArrayList result2 = ContainerUtil.newArrayListWithCapacity((int)implementedMembers.size());
            for (JSPsiElementBase implementedMember : implementedMembers) {
                JSPsiElementBase toOverriddenForInterface = JSInheritanceUtil.findTopOverriddenMember(implementedMember);
                result2.add(toOverriddenForInterface != null ? toOverriddenForInterface : implementedMember);
            }
            ArrayList arrayList = result2;
            if (arrayList == null) {
                JSInheritanceUtil.$$$reportNull$$$0(23);
            }
            return arrayList;
        }
        List<JSQualifiedNamedElement> list = Collections.singletonList(currentMember);
        if (list == null) {
            JSInheritanceUtil.$$$reportNull$$$0(24);
        }
        return list;
    }

    public static Collection<JSFunction> findTopMethods(@NotNull JSFunction method) {
        if (method == null) {
            JSInheritanceUtil.$$$reportNull$$$0(25);
        }
        return JSInheritanceUtil.findTopMembers((JSQualifiedNamedElement)method).stream().filter(el -> el instanceof JSFunction).map(el -> (JSFunction)el).collect(Collectors.toList());
    }

    @Nullable
    public static JSPsiElementBase findTopOverriddenMember(@NotNull JSPsiElementBase member) {
        if (member == null) {
            JSInheritanceUtil.$$$reportNull$$$0(26);
        }
        Ref result2 = new Ref();
        JSInheritanceUtil.iterateOverriddenMemberUp(member, (Processor<JSPsiElementBase>)((Processor)currentMember -> {
            result2.set(currentMember);
            return true;
        }));
        return (JSPsiElementBase)result2.get();
    }

    @Nullable
    public static JSFunction findTopOverriddenMethod(@NotNull JSFunction method) {
        if (method == null) {
            JSInheritanceUtil.$$$reportNull$$$0(27);
        }
        Ref result2 = new Ref();
        JSInheritanceUtil.iterateOverriddenMethodsUp(method, (Processor<JSFunction>)((Processor)function -> {
            result2.set(function);
            return true;
        }));
        return (JSFunction)result2.get();
    }

    public static Collection<JSClass> findAllParentsForClass(@NotNull JSClass clazz, boolean includeNotProject) {
        if (clazz == null) {
            JSInheritanceUtil.$$$reportNull$$$0(28);
        }
        HashSet<JSClass> supers = new HashSet<JSClass>();
        JSInheritanceUtil.findAllParentsForClass(clazz, supers, includeNotProject);
        return supers;
    }

    public static void findAllParentsForClass(@NotNull JSClass clazz, @NotNull Collection<JSClass> result2, boolean includeNotProject) {
        if (clazz == null) {
            JSInheritanceUtil.$$$reportNull$$$0(29);
        }
        if (result2 == null) {
            JSInheritanceUtil.$$$reportNull$$$0(30);
        }
        for (JSClass superClass : clazz.getSupers()) {
            if (!includeNotProject && !clazz.getManager().isInProject((PsiElement)superClass) || superClass.isEquivalentTo((PsiElement)clazz) || JSPsiImplUtils.containsEquivalent(result2, (PsiElement)superClass)) continue;
            if (!JSResolveUtil.isObjectClass(superClass)) {
                result2.add(superClass);
                JSInheritanceUtil.findAllParentsForClass(superClass, result2, includeNotProject);
                continue;
            }
            if (clazz.isInterface()) continue;
            result2.add(superClass);
        }
    }

    public static boolean canBeSuperMethod(@NotNull JSFunction method) {
        if (method == null) {
            JSInheritanceUtil.$$$reportNull$$$0(31);
        }
        return JSInheritanceUtil.canBeSuperMember((JSAttributeListOwner)method);
    }

    public static boolean canBeSuperMember(@NotNull JSAttributeListOwner member) {
        if (member == null) {
            JSInheritanceUtil.$$$reportNull$$$0(32);
        }
        if (member instanceof TypeScriptTypeMember) {
            return true;
        }
        if (member instanceof JSFunction && ((JSFunction)member).isConstructor()) {
            return false;
        }
        return JSInheritanceUtil.canBeSuperMember(member.getAttributeList());
    }

    private static boolean canBeSuperMember(@Nullable JSAttributeList methodAttributeList) {
        return methodAttributeList == null || !methodAttributeList.hasModifier(JSAttributeList.ModifierType.STATIC) && !methodAttributeList.hasModifier(JSAttributeList.ModifierType.FINAL) && methodAttributeList.getAccessType() != JSAttributeList.AccessType.PRIVATE;
    }

    public static boolean canHaveSuperMember(@NotNull JSAttributeListOwner member) {
        if (member == null) {
            JSInheritanceUtil.$$$reportNull$$$0(33);
        }
        if (member instanceof JSFunction && ((JSFunction)member).isConstructor()) {
            return false;
        }
        return member instanceof TypeScriptTypeMember || JSInheritanceUtil.canHaveSuperMember(member.getAttributeList());
    }

    public static boolean canHaveSuperMethod(@NotNull JSFunction method) {
        if (method == null) {
            JSInheritanceUtil.$$$reportNull$$$0(34);
        }
        return JSInheritanceUtil.canHaveSuperMember((JSAttributeListOwner)method);
    }

    @Contract(value="null -> false")
    public static boolean canHaveSuperMember(@Nullable JSAttributeList methodAttributeList) {
        if (methodAttributeList != null) {
            return !methodAttributeList.hasModifier(JSAttributeList.ModifierType.STATIC);
        }
        return false;
    }

    @Nullable
    public static JSClass findNearestBaseClass(@NotNull JSClass aClass, boolean includeNonProject) {
        JSClass[] supers;
        if (aClass == null) {
            JSInheritanceUtil.$$$reportNull$$$0(35);
        }
        if ((supers = aClass.getSupers()).length > 0) {
            JSClass superClass = supers[0];
            if (JSResolveUtil.isObjectClass(superClass) && supers.length > 1) {
                superClass = supers[1];
            }
            if (includeNonProject || superClass.getManager().isInProject((PsiElement)superClass)) {
                return superClass;
            }
        }
        return null;
    }

    public static boolean isMemberOfSubclass(@NotNull JSClass superClass, @NotNull JSElement classMember, boolean allowSuperClass) {
        JSClass memberClass;
        if (superClass == null) {
            JSInheritanceUtil.$$$reportNull$$$0(36);
        }
        if (classMember == null) {
            JSInheritanceUtil.$$$reportNull$$$0(37);
        }
        if ((memberClass = JSUtils.getMemberContainingClass((PsiElement)classMember)) == null) {
            return false;
        }
        if (superClass.isEquivalentTo((PsiElement)memberClass)) {
            return allowSuperClass;
        }
        return JSInheritanceUtil.isParentClass(memberClass, superClass);
    }

    public static Collection<JSClass> findDirectSubClasses(@NotNull JSClass jsClass, boolean skipSubInterfaces) {
        if (jsClass == null) {
            JSInheritanceUtil.$$$reportNull$$$0(38);
        }
        ArrayList<JSClass> result2 = new ArrayList<JSClass>();
        if (!jsClass.isInterface() || !skipSubInterfaces) {
            JSClassSearch.searchClassInheritors(jsClass, false).forEach(jsClass1 -> {
                if (!JSPsiImplUtils.containsEquivalent(result2, (PsiElement)jsClass1)) {
                    result2.add((JSClass)jsClass1);
                }
                return true;
            });
        }
        if (jsClass.isInterface()) {
            JSClassSearch.searchInterfaceImplementations(jsClass, false).forEach(candidate -> {
                if (jsClass == null) {
                    JSInheritanceUtil.$$$reportNull$$$0(95);
                }
                if ((skipSubInterfaces || JSPsiImplUtils.containsEquivalent((PsiElement[])candidate.getSupers(), (PsiElement)jsClass)) && !JSPsiImplUtils.containsEquivalent(result2, (PsiElement)candidate)) {
                    result2.add((JSClass)candidate);
                }
                return true;
            });
        }
        return result2;
    }

    public static boolean isParentClass(@NotNull JSClass clazz, @NotNull JSClass parentClass, boolean strict) {
        if (clazz == null) {
            JSInheritanceUtil.$$$reportNull$$$0(39);
        }
        if (parentClass == null) {
            JSInheritanceUtil.$$$reportNull$$$0(40);
        }
        return JSInheritanceUtil.isParentClass(clazz, parentClass, strict, JSResolveUtil.getResolveScope((PsiElement)clazz));
    }

    public static boolean isParentClass(@NotNull JSClass clazz, @NotNull JSClass parentClass, boolean strict, @Nullable PsiElement context) {
        if (clazz == null) {
            JSInheritanceUtil.$$$reportNull$$$0(41);
        }
        if (parentClass == null) {
            JSInheritanceUtil.$$$reportNull$$$0(42);
        }
        return JSInheritanceUtil.isParentClass(clazz, parentClass, strict, JSResolveUtil.getResolveScope((PsiElement)(context != null ? context : clazz)));
    }

    public static boolean isParentClass(@NotNull JSClass clazz, @NotNull JSClass parentClass, boolean strict, @NotNull GlobalSearchScope resolveScope) {
        if (clazz == null) {
            JSInheritanceUtil.$$$reportNull$$$0(43);
        }
        if (parentClass == null) {
            JSInheritanceUtil.$$$reportNull$$$0(44);
        }
        if (resolveScope == null) {
            JSInheritanceUtil.$$$reportNull$$$0(45);
        }
        if (!strict && clazz.isEquivalentTo((PsiElement)parentClass)) {
            return true;
        }
        if (DialectDetector.isActionScript((PsiElement)clazz)) {
            return (Boolean)JSInheritanceUtil.withEnforcedScope(() -> {
                if (clazz == null) {
                    JSInheritanceUtil.$$$reportNull$$$0(93);
                }
                if (parentClass == null) {
                    JSInheritanceUtil.$$$reportNull$$$0(94);
                }
                return JSInheritanceUtil.isParentClass(clazz, parentClass, (Set<JSClass>)new THashSet());
            }, resolveScope);
        }
        return JSInheritanceUtil.isParentClass(clazz, parentClass, (Set<JSClass>)new THashSet());
    }

    public static boolean isParentClass(@NotNull JSClass clazz, @NotNull JSClass parentClass) {
        if (clazz == null) {
            JSInheritanceUtil.$$$reportNull$$$0(46);
        }
        if (parentClass == null) {
            JSInheritanceUtil.$$$reportNull$$$0(47);
        }
        return JSInheritanceUtil.isParentClass(clazz, parentClass, true);
    }

    @Nullable
    public static JSFunction findMethodInClass(@Nullable JSFunction pattern, @NotNull JSClass aClass, boolean lookInSupers) {
        if (aClass == null) {
            JSInheritanceUtil.$$$reportNull$$$0(48);
        }
        if (pattern == null) {
            return null;
        }
        JSFunction method = aClass.findFunctionByNameAndKind(pattern.getName(), pattern.getKind());
        if (method != null) {
            return method;
        }
        if (lookInSupers && JSInheritanceUtil.canHaveSuperMethod(pattern)) {
            final Ref result2 = new Ref();
            JSResolveUtil.iterateType((JSPsiElementBase)pattern, (PsiElement)aClass, aClass.getQualifiedName(), new JSOverrideHandler(){

                @Override
                public boolean process(@NotNull List<JSPsiElementBase> elements, PsiElement scope, String className) {
                    if (elements == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    result2.set((Object)((JSFunction)elements.iterator().next()));
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil$3", "process"));
                }
            }, true);
            return (JSFunction)result2.get();
        }
        return null;
    }

    public static boolean participatesInHierarchy(JSFunction fun) {
        return !JSInheritanceUtil.processHierarchy(fun, (Processor<JSFunction>)((Processor)jsFunction -> false));
    }

    public static boolean participatesInMemberHierarchy(JSQualifiedNamedElement el) {
        return !JSInheritanceUtil.processMemberHierarchy(el, (Processor<JSPsiElementBase>)((Processor)possibleElement -> false));
    }

    public static boolean processHierarchy(@NotNull JSFunction fun, @NotNull Processor<JSFunction> processor) {
        if (fun == null) {
            JSInheritanceUtil.$$$reportNull$$$0(49);
        }
        if (processor == null) {
            JSInheritanceUtil.$$$reportNull$$$0(50);
        }
        if (JSUtils.getMemberContainingClass((PsiElement)fun) == null) {
            return true;
        }
        if (!ContainerUtil.process(JSInheritanceUtil.findImplementedMethods(fun), processor)) {
            return false;
        }
        if (!JSInheritanceUtil.iterateOverriddenMethodsUp(fun, processor)) {
            return false;
        }
        return JSInheritanceUtil.iterateMethodsDown(fun, processor);
    }

    public static boolean processMemberHierarchy(@NotNull JSQualifiedNamedElement member, @NotNull Processor<JSPsiElementBase> processor) {
        if (member == null) {
            JSInheritanceUtil.$$$reportNull$$$0(51);
        }
        if (processor == null) {
            JSInheritanceUtil.$$$reportNull$$$0(52);
        }
        if (JSUtils.getMemberContainingClass((PsiElement)member) == null) {
            return true;
        }
        if (!ContainerUtil.process(JSInheritanceUtil.findImplementedMembers(member), processor)) {
            return false;
        }
        if (!JSInheritanceUtil.iterateOverriddenMemberUp((JSPsiElementBase)member, processor)) {
            return false;
        }
        Processor functionProcessor = el -> {
            if (processor == null) {
                JSInheritanceUtil.$$$reportNull$$$0(92);
            }
            return processor.process(el);
        };
        return !(member instanceof JSFunction) || JSInheritanceUtil.iterateMethodsDown((JSFunction)member, (Processor<JSFunction>)functionProcessor);
    }

    public static boolean iterateMethodsDown(@NotNull JSFunction fun, @NotNull Processor<JSFunction> processor) {
        if (fun == null) {
            JSInheritanceUtil.$$$reportNull$$$0(53);
        }
        if (processor == null) {
            JSInheritanceUtil.$$$reportNull$$$0(54);
        }
        return JSInheritanceUtil.iterateMethodsDown(fun, processor, false);
    }

    public static boolean iterateMethodsDown(@NotNull JSFunction fun, @NotNull Processor<JSFunction> processor, boolean checkOverrideModifier) {
        if (fun == null) {
            JSInheritanceUtil.$$$reportNull$$$0(55);
        }
        if (processor == null) {
            JSInheritanceUtil.$$$reportNull$$$0(56);
        }
        Processor p = checkOverrideModifier ? jsFunction -> {
            JSAttributeList attributeList;
            if (processor == null) {
                JSInheritanceUtil.$$$reportNull$$$0(91);
            }
            if ((attributeList = jsFunction.getAttributeList()) == null || !attributeList.hasModifier(JSAttributeList.ModifierType.OVERRIDE)) {
                return true;
            }
            return processor.process(jsFunction);
        } : processor;
        if (!JSFunctionsSearch.searchOverridingFunctions(fun, true).forEach(p)) {
            return false;
        }
        return JSFunctionsSearch.searchImplementingFunctions(fun, true).forEach(processor);
    }

    public static boolean hasSuperMethods(@NotNull JSFunction method) {
        if (method == null) {
            JSInheritanceUtil.$$$reportNull$$$0(57);
        }
        return !JSInheritanceUtil.iterateOverriddenMethodsUp(method, (Processor<JSFunction>)((Processor)jsFunction -> false));
    }

    public static Collection<JSFunction> collectFunctionsToOverride(@NotNull JSClass clazz) {
        if (clazz == null) {
            JSInheritanceUtil.$$$reportNull$$$0(58);
        }
        if (clazz.isInterface()) {
            return Collections.emptyList();
        }
        JSFunctionCollector _functionsToOverride = null;
        Predicate<JSFunction> functionFilter = function -> {
            JSAttributeList attributeList;
            if (clazz == null) {
                JSInheritanceUtil.$$$reportNull$$$0(90);
            }
            if ((attributeList = function.getAttributeList()) != null && (attributeList.hasModifier(JSAttributeList.ModifierType.STATIC) || attributeList.hasModifier(JSAttributeList.ModifierType.FINAL) || attributeList.getAccessType() == JSAttributeList.AccessType.PRIVATE)) {
                return false;
            }
            return JSResolveUtil.isAccessibleFromCurrentPackage((PsiElement)function, (PsiElement)clazz);
        };
        for (JSClass superClazz : clazz.getSuperClasses()) {
            _functionsToOverride = JSFunctionCollector.collectAllVisibleClassFunctions(superClazz, _functionsToOverride, functionFilter);
        }
        final JSFunctionCollector functionsToOverride = _functionsToOverride;
        ResolveProcessor collectOwnFunctions = new ResolveProcessor(null, (PsiElement)clazz){
            {
                super(name, _place);
                this.setToProcessMembers(true);
                this.setToProcessHierarchy(false);
                this.setLocalResolve(true);
            }

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    4.$$$reportNull$$$0(1);
                }
                if (element instanceof JSFunction) {
                    JSFunction function = (JSFunction)element;
                    if (function.isConstructor() || functionsToOverride == null) {
                        return true;
                    }
                    functionsToOverride.removeFunctionByNameAndKind(function.getName(), function.getKind());
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil$4";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        clazz.processDeclarations((PsiScopeProcessor)collectOwnFunctions, ResolveState.initial(), (PsiElement)clazz, (PsiElement)clazz);
        return functionsToOverride != null ? functionsToOverride.getFunctions() : Collections.emptyList();
    }

    public static Collection<JSCallExpression> findSuperConstructorCalls(@NotNull JSFunction constructor) {
        JSClass clazz;
        if (constructor == null) {
            JSInheritanceUtil.$$$reportNull$$$0(59);
        }
        return (clazz = JSUtils.getMemberContainingClass((PsiElement)constructor)) != null ? JSInheritanceUtil.findSuperConstructorCalls(clazz) : Collections.emptyList();
    }

    public static Collection<JSCallExpression> findSuperConstructorCalls(@NotNull JSClass clazz) {
        if (clazz == null) {
            JSInheritanceUtil.$$$reportNull$$$0(60);
        }
        ArrayList<JSCallExpression> result2 = new ArrayList<JSCallExpression>();
        Processor p = jsCallExpression -> {
            result2.add((JSCallExpression)jsCallExpression);
            return true;
        };
        Collection<JSClass> subClasses = JSInheritanceUtil.findDirectSubClasses(clazz, true);
        for (JSClass subClass : subClasses) {
            JSInheritanceUtil.processSuperCallsIn(subClass, (Processor<JSCallExpression>)p);
        }
        return result2;
    }

    public static boolean processSuperCallsIn(@NotNull JSClass subClass, @NotNull Processor<JSCallExpression> processor) {
        JSFunction subClassConstructor;
        if (subClass == null) {
            JSInheritanceUtil.$$$reportNull$$$0(61);
        }
        if (processor == null) {
            JSInheritanceUtil.$$$reportNull$$$0(62);
        }
        if ((subClassConstructor = subClass.getConstructor()) != null) {
            SuperCallSearcher superCallSearcher = new SuperCallSearcher();
            subClassConstructor.accept((PsiElementVisitor)superCallSearcher);
            if (superCallSearcher.myResult != null && !processor.process((Object)superCallSearcher.myResult)) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    private static SinkResolveProcessor<?> createFindSuperMemberByNameProcessor(@NotNull String name, final @Nullable String namespace, final @Nullable PsiElement context, final boolean onlyFunctions) {
        if (name == null) {
            JSInheritanceUtil.$$$reportNull$$$0(63);
        }
        SinkResolveProcessor<ResolveResultSink> resolveProcessor = new SinkResolveProcessor<ResolveResultSink>(name, context, new ResolveResultSink(context, name)){

            @Override
            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (state == null) {
                    5.$$$reportNull$$$0(1);
                }
                if (!onlyFunctions && element instanceof JSField || element instanceof JSFunction) {
                    if (!JSInheritanceUtil.isRealOverride((JSAttributeListOwner)element, namespace, context)) {
                        return true;
                    }
                    return super.execute(element, state);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "element";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "state";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil$5";
                objectArray[2] = "execute";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        resolveProcessor.setToProcessHierarchy(true);
        resolveProcessor.setLocalResolve(true);
        resolveProcessor.setSkipImplicitDeclarations(true);
        SinkResolveProcessor<ResolveResultSink> sinkResolveProcessor = resolveProcessor;
        if (sinkResolveProcessor == null) {
            JSInheritanceUtil.$$$reportNull$$$0(64);
        }
        return sinkResolveProcessor;
    }

    public static boolean isRealOverride(@NotNull JSAttributeListOwner member, @Nullable String namespace, @Nullable PsiElement context) {
        JSAttributeList attributeList;
        if (member == null) {
            JSInheritanceUtil.$$$reportNull$$$0(65);
        }
        if ((attributeList = member.getAttributeList()) != null) {
            JSAttributeList.AccessType type = attributeList.getAccessType();
            if (type == JSAttributeList.AccessType.PRIVATE) {
                return false;
            }
            if (type == JSAttributeList.AccessType.PACKAGE_LOCAL && attributeList.getNamespace() == null && !(member.getParent() instanceof JSFile)) {
                return JSResolveUtil.isAccessibleFromCurrentPackage((PsiElement)member, context);
            }
        }
        String elementNs = JSResolveUtil.getNamespaceValue(attributeList);
        return (namespace != null || elementNs == null) && (namespace == null || namespace.equals(elementNs));
    }

    public static boolean processOverrides(JSClass clazz, JSOverrideHandler handler, @NotNull String name, String namespace, PsiElement context, boolean onlyFunctions) {
        if (name == null) {
            JSInheritanceUtil.$$$reportNull$$$0(66);
        }
        SinkResolveProcessor<?> resolveProcessor = JSInheritanceUtil.createFindSuperMemberByNameProcessor(name, namespace, context, onlyFunctions);
        for (JSClass superClazz : clazz.getSuperClasses()) {
            List<PsiElement> unfilteredResults;
            List results;
            JSClass resultMemberContainingClass;
            PsiElement element;
            if (superClazz == clazz) break;
            boolean b = superClazz.processDeclarations(resolveProcessor, ResolveState.initial(), (PsiElement)superClazz, context);
            if (b || (element = resolveProcessor.getResult()) == null || (resultMemberContainingClass = JSUtils.getMemberContainingClass(element)) == null || handler.process(results = ContainerUtil.mapNotNull((Collection)ContainerUtil.notNullize(unfilteredResults = resolveProcessor.getResults()), el -> (JSPsiElementBase)ObjectUtils.tryCast((Object)el, JSPsiElementBase.class)), (PsiElement)superClazz, resultMemberContainingClass.getQualifiedName())) continue;
            return false;
        }
        return true;
    }

    private static boolean searchClassInHierarchy(@NotNull JSClass classToSearch, @NotNull Ref<JSPsiElementBase> overriddenMember) {
        if (classToSearch == null) {
            JSInheritanceUtil.$$$reportNull$$$0(67);
        }
        if (overriddenMember == null) {
            JSInheritanceUtil.$$$reportNull$$$0(68);
        }
        Ref success = Ref.create();
        JSInheritanceUtil.iterateOverriddenMemberUp((JSPsiElementBase)overriddenMember.get(), (Processor<JSPsiElementBase>)((Processor)el -> {
            JSClass containingClass;
            if (classToSearch == null) {
                JSInheritanceUtil.$$$reportNull$$$0(88);
            }
            if (overriddenMember == null) {
                JSInheritanceUtil.$$$reportNull$$$0(89);
            }
            if (classToSearch.isEquivalentTo((PsiElement)(containingClass = JSUtils.getMemberContainingClass((PsiElement)el)))) {
                success.set((Object)true);
                return false;
            }
            overriddenMember.set(el);
            JSAttributeList attributeList = el instanceof JSAttributeListOwner ? ((JSAttributeListOwner)el).getAttributeList() : null;
            return attributeList != null && attributeList.hasModifier(JSAttributeList.ModifierType.OVERRIDE);
        }));
        return !success.isNull();
    }

    public static boolean checkMemberHierarchyIncludeClass(@NotNull JSPsiElementBase resolvedElement, @NotNull JSClass elementParent) {
        Ref topOverriddenMember;
        if (resolvedElement == null) {
            JSInheritanceUtil.$$$reportNull$$$0(69);
        }
        if (elementParent == null) {
            JSInheritanceUtil.$$$reportNull$$$0(70);
        }
        if (JSInheritanceUtil.searchClassInHierarchy(elementParent, (Ref<JSPsiElementBase>)(topOverriddenMember = new Ref((Object)resolvedElement)))) {
            return true;
        }
        Collection<JSPsiElementBase> implementedMembers = JSInheritanceUtil.findImplementedMembers((JSQualifiedNamedElement)topOverriddenMember.get());
        for (JSPsiElementBase member : implementedMembers) {
            JSClass containingClass = JSUtils.getMemberContainingClass((PsiElement)member);
            if (elementParent.isEquivalentTo((PsiElement)containingClass)) {
                return true;
            }
            if (!JSInheritanceUtil.searchClassInHierarchy(elementParent, (Ref<JSPsiElementBase>)Ref.create((Object)member))) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static JSQualifiedNamedElement findMember(@NotNull String name, @NotNull JSClass jsClass, @NotNull SearchedMemberType searchedMemberType, @Nullable JSFunction.FunctionKind limitByFunctionKind, boolean lookInSupers) {
        if (name == null) {
            JSInheritanceUtil.$$$reportNull$$$0(71);
        }
        if (jsClass == null) {
            JSInheritanceUtil.$$$reportNull$$$0(72);
        }
        if (searchedMemberType == null) {
            JSInheritanceUtil.$$$reportNull$$$0(73);
        }
        return JSInheritanceUtil.findMember(name, jsClass, searchedMemberType, limitByFunctionKind, lookInSupers, (Set<JSClass>)(lookInSupers ? new THashSet() : Collections.emptySet()));
    }

    @Nullable
    private static JSQualifiedNamedElement findMember(@NotNull String name, @NotNull JSClass jsClass, @NotNull SearchedMemberType memberType, @Nullable JSFunction.FunctionKind limitByFunctionKind, boolean lookInSuperClasses, @NotNull Set<JSClass> visited) {
        JSField field;
        if (name == null) {
            JSInheritanceUtil.$$$reportNull$$$0(74);
        }
        if (jsClass == null) {
            JSInheritanceUtil.$$$reportNull$$$0(75);
        }
        if (memberType == null) {
            JSInheritanceUtil.$$$reportNull$$$0(76);
        }
        if (visited == null) {
            JSInheritanceUtil.$$$reportNull$$$0(77);
        }
        if (visited.contains(jsClass)) {
            return null;
        }
        if ((memberType == SearchedMemberType.Fields || memberType == SearchedMemberType.FieldsAndMethods) && (field = jsClass.findFieldByName(name)) != null) {
            return field;
        }
        if (memberType == SearchedMemberType.Methods || memberType == SearchedMemberType.FieldsAndMethods) {
            JSFunction function;
            JSFunction jSFunction = function = limitByFunctionKind == null ? jsClass.findFunctionByName(name) : jsClass.findFunctionByNameAndKind(name, limitByFunctionKind);
            if (function != null) {
                return function;
            }
        }
        if (lookInSuperClasses) {
            visited.add(jsClass);
            for (JSClass superClass : jsClass.getSuperClasses()) {
                JSQualifiedNamedElement inSuper = JSInheritanceUtil.findMember(name, superClass, memberType, limitByFunctionKind, true, visited);
                if (inSuper == null) continue;
                return inSuper;
            }
        }
        return null;
    }

    private static boolean isParentClass(@NotNull JSClass aClass, @Nullable JSClass parent, @NotNull Set<JSClass> visited) {
        if (aClass == null) {
            JSInheritanceUtil.$$$reportNull$$$0(78);
        }
        if (visited == null) {
            JSInheritanceUtil.$$$reportNull$$$0(79);
        }
        if (visited.contains(aClass)) {
            return false;
        }
        for (JSClass superClazz : aClass.getSupers()) {
            if (superClazz.isEquivalentTo((PsiElement)parent)) {
                return true;
            }
            visited.add(aClass);
            if (!JSInheritanceUtil.isParentClass(superClazz, parent, visited)) continue;
            return true;
        }
        return false;
    }

    public static <T> T withEnforcedScope(Computable<T> r, GlobalSearchScope scope) {
        assert (JSInheritanceUtil.getEnforcedScope() == null);
        ourEnforcedScope.set(scope);
        try {
            Object object = r.compute();
            return (T)object;
        }
        finally {
            ourEnforcedScope.set(null);
        }
    }

    public static GlobalSearchScope getEnforcedScope() {
        return ourEnforcedScope.get();
    }

    @Nullable
    public static JSParameter findMatchedSuperParameter(@NotNull JSParameter parameter, @NotNull JSFunction function) {
        if (parameter == null) {
            JSInheritanceUtil.$$$reportNull$$$0(80);
        }
        if (function == null) {
            JSInheritanceUtil.$$$reportNull$$$0(81);
        }
        int _parameterIndex = Integer.MAX_VALUE;
        JSParameter[] parameters = function.getParameterVariables();
        for (int i = 0; i < parameters.length; ++i) {
            if (parameters[i] != parameter) continue;
            _parameterIndex = i;
            break;
        }
        int parameterIndex = _parameterIndex;
        Ref matchedSuperParameter = Ref.create(null);
        JSInheritanceUtil.processNearestOverriddenMethods((JSFunctionItem)function, (Processor<JSFunction>)((Processor)overridden -> {
            if (overridden == null) {
                return true;
            }
            JSParameter[] overriddenParameters = overridden.getParameterVariables();
            if (parameterIndex < overriddenParameters.length) {
                matchedSuperParameter.set((Object)overriddenParameters[parameterIndex]);
                return false;
            }
            return true;
        }));
        return (JSParameter)matchedSuperParameter.get();
    }

    public static boolean iterateAllMethodsInHierarchy(@NotNull JSFunction function, @NotNull Processor<JSFunction> processor) {
        if (function == null) {
            JSInheritanceUtil.$$$reportNull$$$0(82);
        }
        if (processor == null) {
            JSInheritanceUtil.$$$reportNull$$$0(83);
        }
        CommonProcessors.UniqueProcessor uniqueProcessor = new CommonProcessors.UniqueProcessor(processor);
        Collection<JSFunction> topMethods = JSInheritanceUtil.findTopMethods(function);
        for (JSFunction topMethod : topMethods) {
            if (uniqueProcessor.process((Object)topMethod) && JSInheritanceUtil.iterateMethodsDown(topMethod, (Processor<JSFunction>)uniqueProcessor)) continue;
            return false;
        }
        return true;
    }

    public static boolean isParentClass(@NotNull String className, @NotNull String parentClassName, @NotNull PsiElement context) {
        if (className == null) {
            JSInheritanceUtil.$$$reportNull$$$0(84);
        }
        if (parentClassName == null) {
            JSInheritanceUtil.$$$reportNull$$$0(85);
        }
        if (context == null) {
            JSInheritanceUtil.$$$reportNull$$$0(86);
        }
        THashSet visited = new THashSet();
        ArrayDeque<String> queue = new ArrayDeque<String>();
        queue.add(className);
        while (!queue.isEmpty()) {
            String currentName = (String)queue.poll();
            boolean result2 = StubIndex.getInstance().processElements(JSSuperClassIndex.KEY, (Object)currentName, context.getProject(), JSResolveUtil.getResolveScope(context), JSClass.class, arg_0 -> JSInheritanceUtil.lambda$isParentClass$24((Set)visited, parentClassName, queue, arg_0));
            if (result2) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$isParentClass$24(Set visited, @NotNull String parentClassName, Queue queue, JSClass element) {
        String qName;
        if (parentClassName == null) {
            JSInheritanceUtil.$$$reportNull$$$0(87);
        }
        if ((qName = element.getQualifiedName()) != null && visited.add(qName)) {
            if (parentClassName.equals(qName)) {
                return false;
            }
            queue.offer(qName);
        }
        return true;
    }

    private static /* synthetic */ Boolean lambda$findNearestOverriddenMembers$5(Collection result2, List functions, String s) {
        result2.addAll(functions);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 23: 
            case 24: 
            case 64: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 23: 
            case 24: 
            case 64: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 97: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodsProcessor";
                break;
            }
            case 2: 
            case 22: 
            case 26: 
            case 32: 
            case 33: 
            case 51: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "member";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "membersProcessor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitedTypes";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementingFunction";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "implementingMember";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 23: 
            case 24: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil";
                break;
            }
            case 18: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 62: 
            case 83: 
            case 91: 
            case 92: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 28: 
            case 29: 
            case 39: 
            case 41: 
            case 43: 
            case 46: 
            case 58: 
            case 60: 
            case 90: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 35: 
            case 48: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superClass";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classMember";
                break;
            }
            case 38: 
            case 72: 
            case 75: 
            case 95: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsClass";
                break;
            }
            case 40: 
            case 42: 
            case 44: 
            case 47: 
            case 94: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClass";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveScope";
                break;
            }
            case 49: 
            case 53: 
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fun";
                break;
            }
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constructor";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subClass";
                break;
            }
            case 63: 
            case 66: 
            case 71: 
            case 74: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 67: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classToSearch";
                break;
            }
            case 68: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overriddenMember";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedElement";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementParent";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchedMemberType";
                break;
            }
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "memberType";
                break;
            }
            case 77: 
            case 79: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameter";
                break;
            }
            case 81: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 85: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentClassName";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "findImplementedMembers";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "findNearestOverriddenMembers";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "findTopMembers";
                break;
            }
            case 64: {
                objectArray = objectArray2;
                objectArray2[1] = "createFindSuperMemberByNameProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "iterateOverriddenMembersUp";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "iterateOverriddenMethodsUp";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "iterateOverriddenMemberUp";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findImplementedMethods";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findImplementedMembers";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 23: 
            case 24: 
            case 64: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findNearestOverriddenMembers";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processNearestOverriddenMethods";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "findSomeDeclaringClass";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findDeclaringClassesMap";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findDeclaringClasses";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findTopMembers";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "findTopMethods";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findTopOverriddenMember";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "findTopOverriddenMethod";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "findAllParentsForClass";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "canBeSuperMethod";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "canBeSuperMember";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "canHaveSuperMember";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "canHaveSuperMethod";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "findNearestBaseClass";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "isMemberOfSubclass";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "findDirectSubClasses";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 78: 
            case 79: 
            case 84: 
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "isParentClass";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "findMethodInClass";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "processHierarchy";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "processMemberHierarchy";
                break;
            }
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "iterateMethodsDown";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "hasSuperMethods";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "collectFunctionsToOverride";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "findSuperConstructorCalls";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "processSuperCallsIn";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "createFindSuperMemberByNameProcessor";
                break;
            }
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "isRealOverride";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "processOverrides";
                break;
            }
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "searchClassInHierarchy";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "checkMemberHierarchyIncludeClass";
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "findMember";
                break;
            }
            case 80: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "findMatchedSuperParameter";
                break;
            }
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "iterateAllMethodsInHierarchy";
                break;
            }
            case 87: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isParentClass$24";
                break;
            }
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "lambda$searchClassInHierarchy$22";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "lambda$collectFunctionsToOverride$19";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "lambda$iterateMethodsDown$17";
                break;
            }
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processMemberHierarchy$16";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "lambda$isParentClass$13";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findDirectSubClasses$12";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processNearestOverriddenMethods$6";
                break;
            }
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "lambda$iterateOverriddenMemberUp$1";
                break;
            }
            case 98: {
                objectArray = objectArray;
                objectArray[2] = "lambda$iterateOverriddenMethodsUp$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 23: 
            case 24: 
            case 64: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class CacheByEnforcedResolveScope<T> {
        private static final GlobalSearchScope NO_ENFORCED_SCOPE_MARKER = new NoEnforcedScopeMarker();
        private final Map<GlobalSearchScope, T> myCache = ContainerUtil.newConcurrentMap();

        public T compute() {
            GlobalSearchScope enforcedScope = JSInheritanceUtil.getEnforcedScope();
            GlobalSearchScope key = enforcedScope != null ? enforcedScope : NO_ENFORCED_SCOPE_MARKER;
            T value = this.myCache.get(key);
            if (value == null) {
                value = this.computeForScope(enforcedScope);
                this.myCache.put(key, value);
            }
            return value;
        }

        protected abstract T computeForScope(@Nullable GlobalSearchScope var1);

        private static class NoEnforcedScopeMarker
        extends GlobalSearchScope {
            private NoEnforcedScopeMarker() {
            }

            public boolean contains(@NotNull VirtualFile file2) {
                if (file2 == null) {
                    NoEnforcedScopeMarker.$$$reportNull$$$0(0);
                }
                return false;
            }

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                if (file1 == null) {
                    NoEnforcedScopeMarker.$$$reportNull$$$0(1);
                }
                if (file2 == null) {
                    NoEnforcedScopeMarker.$$$reportNull$$$0(2);
                }
                return 0;
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    NoEnforcedScopeMarker.$$$reportNull$$$0(3);
                }
                return false;
            }

            public boolean isSearchInLibraries() {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file1";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file2";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "aModule";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/lang/javascript/psi/resolve/JSInheritanceUtil$CacheByEnforcedResolveScope$NoEnforcedScopeMarker";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "contains";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "compare";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isSearchInModuleContent";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static class SuperCallSearcher
    extends JSRecursiveElementVisitor {
        private JSCallExpression myResult;

        private SuperCallSearcher() {
        }

        public void visitJSCallExpression(JSCallExpression node) {
            if (node.getMethodExpression() instanceof JSSuperExpression) {
                this.myResult = node;
            }
        }
    }

    public static enum SearchedMemberType {
        Fields,
        Methods,
        FieldsAndMethods;

    }
}

