/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator;

import com.intellij.lang.javascript.psi.impl.JSChangeUtil;
import com.intellij.lang.javascript.refactoring.extractMethod.signatureGenerator.JSFunctionSignatureInfo;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSFunctionSignatureGenerator {
    public StringBuilder getSignature(@NotNull JSFunctionSignatureInfo info, PsiElement context) {
        if (info == null) {
            JSFunctionSignatureGenerator.$$$reportNull$$$0(0);
        }
        StringBuilder result2 = new StringBuilder();
        this.appendFunctionNameWithModifiers(info, result2, context);
        this.appendFunctionParameters(info, result2);
        this.appendFunctionEnding(info, result2);
        return result2;
    }

    protected void appendFunctionNameWithModifiers(JSFunctionSignatureInfo info, StringBuilder result2, PsiElement context) {
        if (info.isFunctionExpression()) {
            JSFunctionSignatureGenerator.appendFunctionExpression(context, info, result2);
        } else {
            if (info.isStatic()) {
                result2.append("static ");
            }
            if (info.isAsync()) {
                result2.append("async ");
            }
            if (info.getScope() != JSFunctionSignatureInfo.Scope.CLASS && info.getScope() != JSFunctionSignatureInfo.Scope.JS_OBJECT) {
                result2.append("function ");
            }
            if (info.isGetter()) {
                result2.append("get ");
            } else if (info.isSetter()) {
                result2.append("set ");
            }
            result2.append(info.getFunctionName());
        }
    }

    protected static void appendFunctionExpression(@Nullable PsiElement context, JSFunctionSignatureInfo info, StringBuilder result2) {
        boolean isObjectScope;
        boolean bl = isObjectScope = info.getScope() == JSFunctionSignatureInfo.Scope.JS_OBJECT;
        if (!isObjectScope) {
            if (info.getFunctionAnchor() != null) {
                result2.append(info.getFunctionAnchor()).append(".");
            } else {
                result2.append(JSChangeUtil.getVariablePrefix(context));
                result2.append(" ");
            }
        }
        result2.append(info.getFunctionName()).append(isObjectScope ? ":" : " = ");
        if (info.isAsync()) {
            result2.append("async ");
        }
        result2.append("function ");
    }

    protected void appendFunctionParameters(JSFunctionSignatureInfo info, StringBuilder result2) {
        result2.append("(");
        result2.append(StringUtil.join(info.getParameters(), couple -> this.getFunctionParameter((Couple<String>)couple), (String)","));
        result2.append(")");
    }

    @NotNull
    protected String getFunctionParameter(Couple<String> parameterWithType) {
        String string = (String)parameterWithType.first;
        if (string == null) {
            JSFunctionSignatureGenerator.$$$reportNull$$$0(1);
        }
        return string;
    }

    protected void appendFunctionEnding(JSFunctionSignatureInfo info, StringBuilder result2) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/refactoring/extractMethod/signatureGenerator/JSFunctionSignatureGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/refactoring/extractMethod/signatureGenerator/JSFunctionSignatureGenerator";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionParameter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSignature";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

