/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.ui;

import com.intellij.ide.actions.ShowSettingsUtilImpl;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigService;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import java.util.Collection;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptCompilerEditorNotificationProvider
extends EditorNotifications.Provider {
    private static final Key<EditorNotificationPanel> KEY = Key.create((String)"TypeScriptCompilerEditorNotificationProvider");
    private static final ExtensionPointName EDITOR_NOTIFICATION_EP = ExtensionPointName.create((String)"com.intellij.editorNotificationProvider");
    public static final String TS_SHOW_COMPILER_NOTIFICATION = "typescript-compiler-editor-notification";
    protected final Project myProject;
    protected final EditorNotifications myNotifications;

    @NotNull
    public Key getKey() {
        Key<EditorNotificationPanel> key = KEY;
        if (key == null) {
            TypeScriptCompilerEditorNotificationProvider.$$$reportNull$$$0(0);
        }
        return key;
    }

    public TypeScriptCompilerEditorNotificationProvider(Project project, EditorNotifications notifications) {
        this.myProject = project;
        this.myNotifications = notifications;
    }

    @Nullable
    public JComponent createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor) {
        if (file2 == null) {
            TypeScriptCompilerEditorNotificationProvider.$$$reportNull$$$0(1);
        }
        if (fileEditor == null) {
            TypeScriptCompilerEditorNotificationProvider.$$$reportNull$$$0(2);
        }
        if (this.hasOverride() || !this.showCompilerNotification(file2)) {
            return null;
        }
        return new CompilerEditorNotificationPanel(file2);
    }

    protected boolean hasOverride() {
        for (Object extension : EDITOR_NOTIFICATION_EP.getExtensions((AreaInstance)this.myProject)) {
            if (!(extension instanceof NotificationOverride)) continue;
            return true;
        }
        return false;
    }

    protected boolean showCompilerNotification(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptCompilerEditorNotificationProvider.$$$reportNull$$$0(3);
        }
        return TypeScriptCompilerEditorNotificationProvider.isTypeScriptFile(file2) && !JsbtUtil.hasBuildTool(this.myProject) && file2.isInLocalFileSystem() && this.hasNodeInterpreter() && this.isProjectFile(file2) && this.isCompilerDisabled() && this.noConfigsOrHasConfigWithCompileOnSave() && !TypeScriptUtil.isDefinitionFile(file2) && !this.isSuppressedByDismissButton();
    }

    protected boolean noConfigsOrHasConfigWithCompileOnSave() {
        Collection<TypeScriptConfig> configs = TypeScriptConfigService.Provider.getConfigFiles(this.myProject);
        if (configs.isEmpty()) {
            return true;
        }
        return configs.stream().anyMatch(el -> el.isCompileOnSave() && el.hasExplicitCompileOnSave());
    }

    private boolean hasNodeInterpreter() {
        return !StringUtil.isEmptyOrSpaces((String)TypeScriptLanguageServiceUtil.getNodeInterpreterPath(this.myProject));
    }

    private boolean isSuppressedByDismissButton() {
        return !PropertiesComponent.getInstance((Project)this.myProject).getBoolean(TS_SHOW_COMPILER_NOTIFICATION, true);
    }

    private boolean isCompilerDisabled() {
        return !TypeScriptCompilerSettings.getSettings(this.myProject).isRecompileOnChanges();
    }

    private static boolean isTypeScriptFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptCompilerEditorNotificationProvider.$$$reportNull$$$0(4);
        }
        return TypeScriptCompilerSettings.acceptFileType(file2.getFileType());
    }

    private boolean isProjectFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            TypeScriptCompilerEditorNotificationProvider.$$$reportNull$$$0(5);
        }
        return GlobalSearchScope.projectScope((Project)this.myProject).accept(file2);
    }

    private void enableCompilerForFile(VirtualFile file2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        TypeScriptCompilerSettings settings = TypeScriptCompilerSettings.getSettings(this.myProject);
        settings.setUseServiceForProjectsWithoutConfig(true);
        settings.setRecompileOnChanges(true);
        settings.setUseService(true);
        ApplicationManager.getApplication().saveAll();
        TypeScriptCompilerService.restartServices(this.myProject);
        this.myNotifications.updateAllNotifications();
    }

    @NotNull
    protected Runnable getDismissAction() {
        Runnable runnable = () -> {
            PropertiesComponent.getInstance((Project)this.myProject).setValue(TS_SHOW_COMPILER_NOTIFICATION, Boolean.FALSE.toString());
            this.myNotifications.updateAllNotifications();
        };
        if (runnable == null) {
            TypeScriptCompilerEditorNotificationProvider.$$$reportNull$$$0(6);
        }
        return runnable;
    }

    @NotNull
    protected Runnable getConfigureAction() {
        Runnable runnable = () -> {
            ShowSettingsUtilImpl.showSettingsDialog((Project)this.myProject, (String)"settings.typescriptcompiler", (String)"");
            this.myNotifications.updateAllNotifications();
        };
        if (runnable == null) {
            TypeScriptCompilerEditorNotificationProvider.$$$reportNull$$$0(7);
        }
        return runnable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/compiler/ui/TypeScriptCompilerEditorNotificationProvider";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/compiler/ui/TypeScriptCompilerEditorNotificationProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDismissAction";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigureAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createNotificationPanel";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "showCompilerNotification";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isTypeScriptFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isProjectFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected class CompilerEditorNotificationPanel
    extends EditorNotificationPanel {
        public CompilerEditorNotificationPanel(VirtualFile file2) {
            super(EditorColors.GUTTER_BACKGROUND);
            this.setText(JSBundle.message((String)"typescript.compiler.name.enable.message", (Object[])new Object[0]));
            this.createActionLabel(JSBundle.message((String)"typescript.compiler.notification.editor.enable", (Object[])new Object[0]), () -> TypeScriptCompilerEditorNotificationProvider.this.enableCompilerForFile(file2));
            this.createActionLabel(JSBundle.message((String)"typescript.compiler.notification.editor.no", (Object[])new Object[0]), TypeScriptCompilerEditorNotificationProvider.this.getDismissAction());
            this.createActionLabel(JSBundle.message((String)"typescript.compiler.notification.editor.configure", (Object[])new Object[0]), TypeScriptCompilerEditorNotificationProvider.this.getConfigureAction());
        }
    }

    public static interface NotificationOverride {
    }
}

