/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.imports;

import com.intellij.codeInspection.SuppressionUtil;
import com.intellij.lang.ecmascript6.psi.ES6ImportDeclaration;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifier;
import com.intellij.lang.ecmascript6.psi.ES6ImportSpecifierAlias;
import com.intellij.lang.ecmascript6.psi.ES6ImportedBinding;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.inspections.ES6UnusedImportsInspection;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSRecursiveElementVisitor;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImportStatement;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.ResolveResultSink;
import com.intellij.lang.javascript.psi.resolve.SinkResolveProcessor;
import com.intellij.lang.typescript.imports.JSXNamespaceProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.ParameterizedCachedValueProvider;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6UnusedImportsHelper {
    private static final ParameterizedCachedValueProvider<Pair<String, Collection<String>>, JSElement> PROVIDER_JSX_TAGS = new ParameterizedCachedValueProvider<Pair<String, Collection<String>>, JSElement>(){

        @NotNull
        public CachedValueProvider.Result<Pair<String, Collection<String>>> compute(JSElement param) {
            Collection tags = ES6UnusedImportsHelper.calcUsedJSXTags(param);
            String namespace = JSXNamespaceProvider.getDefaultNamespace((PsiElement)param);
            CachedValueProvider.Result result2 = CachedValueProvider.Result.create((Object)Pair.create((Object)namespace, (Object)tags), (Object[])new Object[]{JSTypeUtils.getTypeInvalidationDependency()});
            if (result2 == null) {
                1.$$$reportNull$$$0(0);
            }
            return result2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/imports/ES6UnusedImportsHelper$1", "compute"));
        }
    };
    public static final Key<ParameterizedCachedValue<Pair<String, Collection<String>>, JSElement>> TAGS_JSX_KEY = Key.create((String)"typescript.possible.tags");

    public static boolean isES6SuppressedUnused(@NotNull ES6ImportDeclaration importDeclaration) {
        if (importDeclaration == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(0);
        }
        return SuppressionUtil.isSuppressedInStatement((PsiElement)importDeclaration, (String)ES6UnusedImportsInspection.SHORT_NAME, ES6ImportDeclaration.class);
    }

    public static boolean isTypeScriptSuppressedUnused(@NotNull TypeScriptImportStatement importDeclaration) {
        if (importDeclaration == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(1);
        }
        return SuppressionUtil.isSuppressedInStatement((PsiElement)importDeclaration, (String)ES6UnusedImportsInspection.SHORT_NAME, TypeScriptImportStatement.class);
    }

    @NotNull
    public static UnusedInfo getInfo(@NotNull ES6ImportDeclaration declaration) {
        if (declaration == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(2);
        }
        UnusedInfo info = new UnusedInfo(declaration);
        info.fillUsages();
        UnusedInfo unusedInfo = info;
        if (unusedInfo == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(3);
        }
        return unusedInfo;
    }

    public static boolean isUnusedTypeScriptImport(@NotNull TypeScriptImportStatement statement) {
        if (statement == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(4);
        }
        if (statement.isExported()) {
            return false;
        }
        String name = statement.getName();
        if (StringUtil.isEmpty((String)name)) {
            return false;
        }
        if (statement.getExternalModuleReference() == null && statement.getInternalModuleReference() == null) {
            return false;
        }
        return ES6UnusedImportsHelper.isUnusedInContainer(name, (PsiElement)statement);
    }

    private static boolean isUnusedAlias(@NotNull ES6ImportSpecifierAlias alias) {
        if (alias == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(5);
        }
        return ES6UnusedImportsHelper.isUnusedInContainer(alias.getName(), (PsiElement)alias);
    }

    private static boolean isUnusedSpecifier(@NotNull ES6ImportSpecifier specifier) {
        List results;
        if (specifier == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(6);
        }
        if ((results = ContainerUtil.filter((Object[])specifier.multiResolve(false), el -> ES6UnusedImportsHelper.isValid(el))).size() == 0) {
            return false;
        }
        JSElement container = ES6PsiUtil.getExportScope((PsiElement)specifier);
        if (container == null) {
            return false;
        }
        if (ES6UnusedImportsHelper.hasJSXReference(specifier.getReferenceName(), container)) {
            return false;
        }
        for (ResolveResult result2 : results) {
            PsiElement element = result2.getElement();
            assert (element != null);
            Collection<PsiReference> references = ES6UnusedImportsHelper.getLocalReferences(element, (PsiElement)container);
            for (PsiReference reference : references) {
                JSElement containerForReference;
                PsiElement referenceElement = reference.getElement();
                if (referenceElement instanceof ES6ImportSpecifier && container == (containerForReference = ES6PsiUtil.getExportScope(referenceElement)) || referenceElement == null || !ES6UnusedImportsHelper.isReferenceCanBeResolvedToSpecifier(referenceElement, (PsiElement)specifier, reference.getCanonicalText())) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isValid(@NotNull ResolveResult result2) {
        JSResolveResult jsResolveResult;
        String key;
        PsiElement element;
        if (result2 == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(7);
        }
        if ((element = result2.getElement()) == null) {
            return false;
        }
        if (result2.isValidResult()) {
            return true;
        }
        return result2 instanceof JSResolveResult && (key = (jsResolveResult = (JSResolveResult)result2).getResolveProblemKey()) == "javascript.element.need.to.be.included.to.config";
    }

    private static boolean isUnusedImportedBinding(@NotNull ES6ImportedBinding binding) {
        if (binding == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(8);
        }
        String name = binding.getName();
        return ES6UnusedImportsHelper.isUnusedInContainer(name, (PsiElement)binding);
    }

    private static boolean isReferenceCanBeResolvedToSpecifier(@NotNull PsiElement refElement, @NotNull PsiElement importSpecifier, @NotNull String name) {
        if (refElement == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(9);
        }
        if (importSpecifier == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(10);
        }
        if (name == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(11);
        }
        ResolveResultSink sink = new ResolveResultSink(refElement, name);
        SinkResolveProcessor<ResolveResultSink> processor = new SinkResolveProcessor<ResolveResultSink>(sink);
        processor.setTypeContext(true);
        processor.setLocalResolve(true);
        return !processor.execute(importSpecifier, ResolveState.initial());
    }

    public static boolean isUnusedInContainer(@Nullable String name, @NotNull PsiElement refElement) {
        JSElement container;
        if (refElement == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(12);
        }
        if ((container = ES6PsiUtil.getExportScope(refElement)) == null) {
            return false;
        }
        if (ES6UnusedImportsHelper.hasJSXReference(name, container)) {
            return false;
        }
        return ES6UnusedImportsHelper.getLocalReferences(refElement, (PsiElement)container).isEmpty();
    }

    private static boolean hasJSXReference(@Nullable String name, @NotNull JSElement container) {
        if (container == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(13);
        }
        if (name == null || !DialectDetector.isJSX((PsiElement)container)) {
            return false;
        }
        Pair<String, Collection<String>> info = ES6UnusedImportsHelper.getUsedJSXInfo(container);
        Collection tags = (Collection)info.second;
        String namespace = (String)info.first;
        return "React".equals(name) || namespace.equals(name) || tags.contains(name);
    }

    @NotNull
    private static Collection<PsiReference> getLocalReferences(@NotNull PsiElement refElement, @NotNull PsiElement container) {
        if (refElement == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(14);
        }
        if (container == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(15);
        }
        LocalSearchScope scope = new LocalSearchScope(container);
        Collection collection = ReferencesSearch.search((PsiElement)refElement, (SearchScope)scope, (boolean)true).findAll();
        if (collection == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(16);
        }
        return collection;
    }

    @NotNull
    public static Pair<String, Collection<String>> getUsedJSXInfo(@NotNull JSElement element) {
        Pair value;
        if (element == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(17);
        }
        Pair pair = (value = (Pair)CachedValuesManager.getManager((Project)element.getProject()).getParameterizedCachedValue((UserDataHolder)element, TAGS_JSX_KEY, PROVIDER_JSX_TAGS, false, (Object)element)) == null ? Pair.create((Object)"React", (Object)ContainerUtil.emptyList()) : value;
        if (pair == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(18);
        }
        return pair;
    }

    @NotNull
    private static Collection<String> calcUsedJSXTags(@NotNull JSElement container) {
        if (container == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(19);
        }
        final HashSet results = ContainerUtil.newHashSet();
        container.accept((PsiElementVisitor)new JSRecursiveElementVisitor(){

            public void visitJSLiteralExpression(JSLiteralExpression node) {
                List strings;
                String name;
                if (node instanceof XmlTag && !StringUtil.isEmpty((String)(name = node.getName())) && (strings = StringUtil.split((String)name, (String)".")).size() > 0) {
                    results.add(ContainerUtil.getFirstItem((List)strings));
                }
                super.visitJSLiteralExpression(node);
            }

            public void visitES6ImportDeclaration(ES6ImportDeclaration importDeclaration) {
            }
        });
        HashSet hashSet = results;
        if (hashSet == null) {
            ES6UnusedImportsHelper.$$$reportNull$$$0(20);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 16: 
            case 18: 
            case 20: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 16: 
            case 18: 
            case 20: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importDeclaration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
            case 3: 
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/typescript/imports/ES6UnusedImportsHelper";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statement";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alias";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "specifier";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "binding";
                break;
            }
            case 9: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importSpecifier";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 13: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/typescript/imports/ES6UnusedImportsHelper";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInfo";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalReferences";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsedJSXInfo";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "calcUsedJSXTags";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isES6SuppressedUnused";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isTypeScriptSuppressedUnused";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getInfo";
                break;
            }
            case 3: 
            case 16: 
            case 18: 
            case 20: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isUnusedTypeScriptImport";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isUnusedAlias";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isUnusedSpecifier";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isValid";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isUnusedImportedBinding";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceCanBeResolvedToSpecifier";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isUnusedInContainer";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hasJSXReference";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getLocalReferences";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getUsedJSXInfo";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "calcUsedJSXTags";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 16: 
            case 18: 
            case 20: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class UnusedInfo {
        @NotNull
        private final ES6ImportDeclaration myDeclaration;
        private final Collection<ES6ImportedBinding> myUnusedBindings;
        private final Collection<ES6ImportSpecifier> myUnusedSpecifiers;
        private boolean myIsUnused;
        private boolean mySideEffectImport;

        @NotNull
        public ES6ImportDeclaration getDeclaration() {
            ES6ImportDeclaration eS6ImportDeclaration = this.myDeclaration;
            if (eS6ImportDeclaration == null) {
                UnusedInfo.$$$reportNull$$$0(0);
            }
            return eS6ImportDeclaration;
        }

        @NotNull
        public Collection<ES6ImportedBinding> getUnusedBindings() {
            Collection<ES6ImportedBinding> collection = this.myUnusedBindings;
            if (collection == null) {
                UnusedInfo.$$$reportNull$$$0(1);
            }
            return collection;
        }

        @NotNull
        public Collection<ES6ImportSpecifier> getUnusedSpecifiers() {
            Collection<ES6ImportSpecifier> collection = this.myUnusedSpecifiers;
            if (collection == null) {
                UnusedInfo.$$$reportNull$$$0(2);
            }
            return collection;
        }

        public boolean isAllUnused() {
            return this.myIsUnused;
        }

        public UnusedInfo(@NotNull ES6ImportDeclaration declaration) {
            if (declaration == null) {
                UnusedInfo.$$$reportNull$$$0(3);
            }
            this.myUnusedBindings = ContainerUtil.newHashSet();
            this.myUnusedSpecifiers = ContainerUtil.newHashSet();
            this.myDeclaration = declaration;
        }

        public boolean isEmpty() {
            return this.myDeclaration.getImportSpecifiers().length == 0 && this.myDeclaration.getImportedBindings().length == 0;
        }

        public boolean isSideEffectImport() {
            return this.mySideEffectImport;
        }

        private void fillUsages() {
            ES6ImportedBinding[] bindings;
            ES6ImportSpecifier[] specifiers;
            boolean hasUsages = false;
            for (ES6ImportSpecifier specifier : specifiers = this.myDeclaration.getImportSpecifiers()) {
                ES6ImportSpecifierAlias alias = specifier.getAlias();
                if (alias != null && ES6UnusedImportsHelper.isUnusedAlias(alias) || alias == null && ES6UnusedImportsHelper.isUnusedSpecifier(specifier)) {
                    this.myUnusedSpecifiers.add(specifier);
                    continue;
                }
                hasUsages = true;
            }
            for (ES6ImportedBinding binding : bindings = this.myDeclaration.getImportedBindings()) {
                if (ES6UnusedImportsHelper.isUnusedImportedBinding(binding)) {
                    this.myUnusedBindings.add(binding);
                    continue;
                }
                hasUsages = true;
            }
            this.mySideEffectImport = !StringUtil.isEmpty((String)this.myDeclaration.getImportModuleText());
            this.myIsUnused = !this.mySideEffectImport && !hasUsages;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/typescript/imports/ES6UnusedImportsHelper$UnusedInfo";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "declaration";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDeclaration";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnusedBindings";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnusedSpecifiers";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/typescript/imports/ES6UnusedImportsHelper$UnusedInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

