/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.ant;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.CompositeGenerator;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.Generator;
import com.intellij.compiler.ant.LibraryDefinitionsGeneratorFactory;
import com.intellij.compiler.ant.Tag;
import com.intellij.compiler.ant.taskdefs.PathElement;
import com.intellij.compiler.ant.taskdefs.PathRef;
import com.intellij.compiler.ant.taskdefs.Target;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.ant.GwtBuildProperties;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.run.GwtClasspathUtil;
import com.intellij.gwt.sdk.GwtVersion;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class RunGwtCompilerTarget
extends Target {
    private final GwtFacet myFacet;
    private final GwtFacetConfiguration myConfiguration;

    public RunGwtCompilerTarget(GwtFacet facet, GenerationOptions genOptions) {
        super(GwtBuildProperties.getRunGwtCompilerTargetName(facet), null, GwtBundle.message("ant.target.name.run.gwt.compiler", new Object[0]), null);
        this.myFacet = facet;
        this.myConfiguration = (GwtFacetConfiguration)this.myFacet.getConfiguration();
        this.addJavaTag(genOptions);
    }

    private void addJavaTag(GenerationOptions genOptions) {
        Module module = this.myFacet.getModule();
        ArrayList<Couple> options = new ArrayList<Couple>();
        options.add(RunGwtCompilerTarget.pair((String)"fork", (String)"true"));
        String chunkName = genOptions.getChunkByModule(module).getName();
        if (genOptions.forceTargetJdk) {
            options.add(RunGwtCompilerTarget.pair((String)"jvm", (String)(BuildProperties.propertyRef((String)BuildProperties.getModuleChunkJdkBinProperty((String)chunkName)) + "/java")));
        }
        GwtVersion sdkVersion = this.myFacet.getSdkVersion();
        options.add(RunGwtCompilerTarget.pair((String)"classname", (String)sdkVersion.getCompilerClassName()));
        options.add(RunGwtCompilerTarget.pair((String)"failonerror", (String)"true"));
        Tag java = new Tag("java", options.toArray(new Pair[0]));
        java.add((Generator)RunGwtCompilerTarget.jvmarg("-Xmx" + String.valueOf(this.myConfiguration.getCompilerMaxHeapSize()) + "m"));
        String jvmParameters = this.myConfiguration.getAdditionalCompilerVMParameters();
        if (!StringUtil.isEmpty((String)jvmParameters)) {
            java.add((Generator)RunGwtCompilerTarget.jvmarg(jvmParameters));
        }
        Tag classpath = new Tag("classpath", new Pair[0]);
        String gwtDevJarName = this.myFacet.getSdkVersion().isUseSystemIndependentGwtDevJar() ? "gwt-dev.jar" : BuildProperties.propertyRef((String)GwtBuildProperties.getSystemDependentGwtSdkDevJarNameProperty());
        classpath.add((Generator)new PathElement(BuildProperties.propertyRef((String)GwtBuildProperties.getGwtSdkHomeProperty(this.myFacet)) + "/" + gwtDevJarName));
        RunGwtCompilerTarget.collectSourcePaths(genOptions, module, classpath);
        classpath.add((Generator)new PathRef(BuildProperties.getTestClasspathProperty((String)chunkName)));
        java.add((Generator)classpath);
        java.add((Generator)RunGwtCompilerTarget.arg("-logLevel"));
        java.add((Generator)RunGwtCompilerTarget.arg("WARN"));
        java.add((Generator)RunGwtCompilerTarget.arg(sdkVersion.getCompilerOutputDirParameterName()));
        java.add((Generator)RunGwtCompilerTarget.arg(BuildProperties.propertyRef((String)GwtBuildProperties.getGwtCompilerOutputPropertyName(this.myFacet))));
        java.add((Generator)RunGwtCompilerTarget.arg("-style"));
        java.add((Generator)RunGwtCompilerTarget.arg(this.myConfiguration.getOutputStyle().getId()));
        java.add((Generator)RunGwtCompilerTarget.arg(BuildProperties.propertyRef((String)GwtBuildProperties.getGwtModuleParameter())));
        this.add((Generator)java);
    }

    private static void collectSourcePaths(GenerationOptions genOptions, Module module, Tag classpath) {
        LinkedHashSet dependenciesWithGwtFacets = new LinkedHashSet();
        OrderEnumerator enumerator = GwtClasspathUtil.enumerateEntriesWithGwtSourceRoots(module, true);
        enumerator.forEachModule(module1 -> {
            dependenciesWithGwtFacets.add(genOptions.getChunkByModule(module1).getName());
            return true;
        });
        for (String depChunkName : dependenciesWithGwtFacets) {
            classpath.add((Generator)new PathRef(BuildProperties.getSourcepathProperty((String)depChunkName)));
        }
        LinkedHashSet libraries = new LinkedHashSet();
        enumerator.forEachLibrary(library -> {
            libraries.add(library);
            return true;
        });
        File baseDir = BuildProperties.getProjectBaseDir((Project)module.getProject());
        for (Library library2 : libraries) {
            LibraryDefinitionsGeneratorFactory.genLibraryContent((GenerationOptions)genOptions, (Library)library2, (OrderRootType)OrderRootType.SOURCES, (File)baseDir, (CompositeGenerator)classpath);
        }
    }

    private static Tag arg(@NotNull @NonNls String arg) {
        if (arg == null) {
            RunGwtCompilerTarget.$$$reportNull$$$0(0);
        }
        return new Tag("arg", new Pair[]{RunGwtCompilerTarget.pair((String)"value", (String)arg)});
    }

    private static Tag jvmarg(@NotNull @NonNls String arg) {
        if (arg == null) {
            RunGwtCompilerTarget.$$$reportNull$$$0(1);
        }
        return new Tag("jvmarg", new Pair[]{RunGwtCompilerTarget.pair((String)"line", (String)arg)});
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "arg";
        objectArray2[1] = "com/intellij/gwt/ant/RunGwtCompilerTarget";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "arg";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "jvmarg";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

