/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.inspections.BaseGwtLocalQuickFix;
import com.intellij.gwt.module.GwtModulesManager;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.gwt.module.model.GwtRelativePath;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GwtDefaultPackageNotRegisteredInspection
extends BaseGwtInspection {
    @NonNls
    private static final String SOURCE_TAG = "source";

    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (file == null) {
            GwtDefaultPackageNotRegisteredInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            GwtDefaultPackageNotRegisteredInspection.$$$reportNull$$$0(1);
        }
        if (!GwtDefaultPackageNotRegisteredInspection.shouldCheck((PsiElement)file)) {
            return null;
        }
        if (!file.getName().endsWith(".gwt.xml")) {
            return null;
        }
        GwtModule gwtModule = GwtModulesManager.getInstance(file.getProject()).getGwtModule(file);
        if (gwtModule == null) {
            return null;
        }
        SmartList problems = new SmartList();
        List<GwtRelativePath> sources = gwtModule.getSources();
        List<GwtRelativePath> superSources = gwtModule.getSuperSources();
        GwtDefaultPackageNotRegisteredInspection.checkSubPackageWithDefaultNameRegistered(SOURCE_TAG, "client", sources, superSources, gwtModule, file, manager, isOnTheFly, (List<ProblemDescriptor>)problems);
        List<GwtRelativePath> publics = gwtModule.getPublics();
        GwtDefaultPackageNotRegisteredInspection.checkSubPackageWithDefaultNameRegistered("public", "public", publics, Collections.emptyList(), gwtModule, file, manager, isOnTheFly, (List<ProblemDescriptor>)problems);
        return problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static void checkSubPackageWithDefaultNameRegistered(String tagName, String defaultPath, List<GwtRelativePath> paths, List<GwtRelativePath> additionalPaths, GwtModule gwtModule, PsiFile file, InspectionManager manager, boolean isOnTheFly, List<ProblemDescriptor> problems) {
        if (!(paths.isEmpty() && additionalPaths.isEmpty() || GwtDefaultPackageNotRegisteredInspection.containsPath(paths, defaultPath) || GwtDefaultPackageNotRegisteredInspection.containsPath(additionalPaths, defaultPath) || !GwtDefaultPackageNotRegisteredInspection.hasSubPackage(file, defaultPath))) {
            AddPathTagQuickFix fix = new AddPathTagQuickFix(gwtModule, tagName, defaultPath);
            String message = "'" + defaultPath + "' subpackage is not registered as " + tagName + " path in '" + file.getName() + "'";
            GwtRelativePath item = (GwtRelativePath)ContainerUtil.getFirstItem(paths, null);
            if (item == null) {
                item = (GwtRelativePath)ContainerUtil.getFirstItem(additionalPaths, null);
            }
            if (item == null) {
                return;
            }
            problems.add(manager.createProblemDescriptor((PsiElement)item.getXmlTag(), message, (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
        }
    }

    private static boolean hasSubPackage(@NotNull PsiFile file, @NotNull String name) {
        PsiPackage[] subPackages;
        PsiDirectory directory;
        if (file == null) {
            GwtDefaultPackageNotRegisteredInspection.$$$reportNull$$$0(2);
        }
        if (name == null) {
            GwtDefaultPackageNotRegisteredInspection.$$$reportNull$$$0(3);
        }
        if ((directory = file.getContainingDirectory()) == null) {
            return false;
        }
        PsiPackage aPackage = JavaDirectoryService.getInstance().getPackage(directory);
        if (aPackage == null) {
            return false;
        }
        for (PsiPackage subPackage : subPackages = aPackage.getSubPackages(file.getResolveScope())) {
            if (!name.equals(subPackage.getName())) continue;
            return true;
        }
        return false;
    }

    private static boolean containsPath(List<GwtRelativePath> paths, String path) {
        for (GwtRelativePath relativePath : paths) {
            if (!path.equals(relativePath.getPath().getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            GwtDefaultPackageNotRegisteredInspection.$$$reportNull$$$0(4);
        }
        return highlightDisplayLevel;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("'client' package or 'public' directory is not registered in gwt.xml file" == null) {
            GwtDefaultPackageNotRegisteredInspection.$$$reportNull$$$0(5);
        }
        return "'client' package or 'public' directory is not registered in gwt.xml file";
    }

    @NotNull
    public String getShortName() {
        if ("GwtDefaultPackageNotRegistered" == null) {
            GwtDefaultPackageNotRegisteredInspection.$$$reportNull$$$0(6);
        }
        return "GwtDefaultPackageNotRegistered";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/inspections/GwtDefaultPackageNotRegisteredInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/inspections/GwtDefaultPackageNotRegisteredInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasSubPackage";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AddPathTagQuickFix
    extends BaseGwtLocalQuickFix {
        private static final String FAMILY_NAME = GwtBundle.message("quickfix.family.name.register.subpackage", new Object[0]);
        private final GwtModule myGwtModule;
        private final String myTagName;
        private final String myPackageName;

        private AddPathTagQuickFix(GwtModule gwtModule, String tagName, String packageName) {
            super(GwtBundle.message("quickfix.name.register.0.subpackage.as.1.path", packageName, tagName));
            this.myGwtModule = gwtModule;
            this.myTagName = tagName;
            this.myPackageName = packageName;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = FAMILY_NAME;
            if (string == null) {
                AddPathTagQuickFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                AddPathTagQuickFix.$$$reportNull$$$0(1);
            }
            if (descriptor == null) {
                AddPathTagQuickFix.$$$reportNull$$$0(2);
            }
            if (!CommonRefactoringUtil.checkReadOnlyStatus((PsiElement)this.myGwtModule.getModuleXmlFile())) {
                return;
            }
            GwtRelativePath path = this.myTagName.equals(GwtDefaultPackageNotRegisteredInspection.SOURCE_TAG) ? this.myGwtModule.addSource() : this.myGwtModule.addPublic();
            path.getPath().setStringValue(this.myPackageName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/gwt/inspections/GwtDefaultPackageNotRegisteredInspection$AddPathTagQuickFix";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/gwt/inspections/GwtDefaultPackageNotRegisteredInspection$AddPathTagQuickFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

