/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.gwt.GwtBundle;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.inspections.BaseGwtInspection;
import com.intellij.gwt.inspections.BaseGwtLocalQuickFix;
import com.intellij.gwt.rpc.RemoteServiceUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtRawAsyncCallbackInspection
extends BaseGwtInspection {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.inspections.GwtRawAsyncCallbackInspection");

    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, final @NotNull InspectionManager manager, boolean isOnTheFly) {
        GwtFacet gwtFacet;
        if (aClass == null) {
            GwtRawAsyncCallbackInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            GwtRawAsyncCallbackInspection.$$$reportNull$$$0(1);
        }
        if ((gwtFacet = GwtRawAsyncCallbackInspection.getFacet((PsiElement)aClass)) == null || !gwtFacet.getSdkVersion().isGenericsSupported()) {
            return null;
        }
        PsiClass sync = RemoteServiceUtil.findSynchronousInterface(aClass);
        if (sync != null) {
            return GwtRawAsyncCallbackInspection.checkAsynchronousInterface(aClass, sync, manager, isOnTheFly);
        }
        SmartList problems = new SmartList();
        JavaRecursiveElementWalkingVisitor visitor = new JavaRecursiveElementWalkingVisitor((List)problems, isOnTheFly){
            final /* synthetic */ List val$problems;
            final /* synthetic */ boolean val$isOnTheFly;
            {
                this.val$problems = list;
                this.val$isOnTheFly = bl;
            }

            public void visitReferenceExpression(PsiReferenceExpression expression) {
            }

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                PsiClass async;
                PsiClass sync;
                PsiMethod method = expression.resolveMethod();
                if (method != null && (sync = RemoteServiceUtil.findSynchronousInterface(async = method.getContainingClass())) != null) {
                    GwtRawAsyncCallbackInspection.checkAsyncMethod(method, sync, manager, this.val$problems, expression, this.val$isOnTheFly);
                }
            }
        };
        aClass.accept((PsiElementVisitor)visitor);
        return problems.isEmpty() ? null : problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static ProblemDescriptor[] checkAsynchronousInterface(@NotNull PsiClass async, @NotNull PsiClass sync, InspectionManager manager, boolean isOnTheFly) {
        if (async == null) {
            GwtRawAsyncCallbackInspection.$$$reportNull$$$0(2);
        }
        if (sync == null) {
            GwtRawAsyncCallbackInspection.$$$reportNull$$$0(3);
        }
        ArrayList<ProblemDescriptor> problems = new ArrayList<ProblemDescriptor>();
        for (PsiMethod method : async.getMethods()) {
            GwtRawAsyncCallbackInspection.checkAsyncMethod(method, sync, manager, problems, null, isOnTheFly);
        }
        return problems.toArray(ProblemDescriptor.EMPTY_ARRAY);
    }

    private static void checkAsyncMethod(PsiMethod method, PsiClass sync, InspectionManager manager, List<ProblemDescriptor> problems, @Nullable PsiMethodCallExpression expression, boolean onTheFly) {
        PsiReferenceParameterList parameterList;
        PsiAnonymousClass anonymousClass;
        PsiExpression lastArg;
        PsiExpression[] arguments;
        PsiParameter[] parameters = method.getParameterList().getParameters();
        if (parameters.length == 0) {
            return;
        }
        PsiParameter lastParameter = parameters[parameters.length - 1];
        PsiType type = lastParameter.getType();
        if (!(type instanceof PsiClassType)) {
            return;
        }
        PsiClassType classType = (PsiClassType)type;
        PsiClass psiClass = classType.resolve();
        if (psiClass == null || !"com.google.gwt.user.client.rpc.AsyncCallback".equals(psiClass.getQualifiedName())) {
            return;
        }
        PsiMethod syncMethod = RemoteServiceUtil.findMethodInSync(method, sync);
        if (syncMethod == null) {
            return;
        }
        PsiType returnType = syncMethod.getReturnType();
        if (PsiType.VOID.equals((Object)returnType) || returnType == null) {
            return;
        }
        PsiAnonymousClass rawAnonymous = null;
        if (expression != null && (arguments = expression.getArgumentList().getExpressions()).length == parameters.length && (lastArg = arguments[arguments.length - 1]) instanceof PsiNewExpression && (anonymousClass = ((PsiNewExpression)lastArg).getAnonymousClass()) != null && (parameterList = anonymousClass.getBaseClassReference().getParameterList()) != null && parameterList.getTypeParameterElements().length == 0) {
            rawAnonymous = anonymousClass;
        }
        if (classType.isRaw() || rawAnonymous != null) {
            PsiMethod methodToFix = classType.isRaw() ? method : null;
            GenerifyAsyncCallbackFix fix = new GenerifyAsyncCallbackFix(returnType, methodToFix, rawAnonymous);
            String methodDescription = PsiFormatUtil.formatMethod((PsiMethod)method, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)257, (int)2);
            String message = GwtBundle.message("problem.description.raw.use.of.async.callback.interface", methodDescription);
            PsiElement place = rawAnonymous != null ? GwtRawAsyncCallbackInspection.getElementToHighlight(rawAnonymous) : (expression != null ? expression : lastParameter);
            problems.add(manager.createProblemDescriptor(place, message, (LocalQuickFix)fix, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, onTheFly));
        }
    }

    @NotNull
    public String getDisplayName() {
        String string = GwtBundle.message("inspection.name.raw.use.of.async.callback.in.asynchronous.service.interfaces", new Object[0]);
        if (string == null) {
            GwtRawAsyncCallbackInspection.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("gwtRawAsyncCallback" == null) {
            GwtRawAsyncCallbackInspection.$$$reportNull$$$0(5);
        }
        return "gwtRawAsyncCallback";
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            GwtRawAsyncCallbackInspection.$$$reportNull$$$0(6);
        }
        return highlightDisplayLevel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "async";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sync";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/inspections/GwtRawAsyncCallbackInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/inspections/GwtRawAsyncCallbackInspection";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultLevel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkAsynchronousInterface";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class GenerifyAsyncCallbackFix
    extends BaseGwtLocalQuickFix {
        private static final String FAMILY_NAME = GwtBundle.message("quickfix.family.name.replace.async.callback.by.generic.async.callback", new Object[0]);
        private final PsiType myType;
        private final PsiMethod myMethodToFix;
        private final PsiAnonymousClass myAnonymousToFix;

        private GenerifyAsyncCallbackFix(@NotNull PsiType type, @Nullable PsiMethod methodToFix, @Nullable PsiAnonymousClass anonymousToFix) {
            if (type == null) {
                GenerifyAsyncCallbackFix.$$$reportNull$$$0(0);
            }
            super(GwtBundle.message("quickfix.name.replace.async.callback.by.async.callback.0", type.getCanonicalText()));
            this.myType = type;
            this.myMethodToFix = methodToFix;
            this.myAnonymousToFix = anonymousToFix;
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            String string = FAMILY_NAME;
            if (string == null) {
                GenerifyAsyncCallbackFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                GenerifyAsyncCallbackFix.$$$reportNull$$$0(2);
            }
            if (descriptor == null) {
                GenerifyAsyncCallbackFix.$$$reportNull$$$0(3);
            }
            ArrayList<VirtualFile> affectedFiles = new ArrayList<VirtualFile>();
            if (this.myMethodToFix != null) {
                affectedFiles.add(this.myMethodToFix.getContainingFile().getVirtualFile());
            }
            if (this.myAnonymousToFix != null) {
                affectedFiles.add(this.myAnonymousToFix.getContainingFile().getVirtualFile());
            }
            if (ReadonlyStatusHandler.getInstance((Project)project).ensureFilesWritable(VfsUtil.toVirtualFileArray(affectedFiles)).hasReadonlyFiles()) {
                return;
            }
            try {
                PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
                if (this.myMethodToFix != null) {
                    GenerifyAsyncCallbackFix.generifyMethod(this.myMethodToFix, this.myType, elementFactory);
                }
                if (this.myAnonymousToFix != null) {
                    GenerifyAsyncCallbackFix.generifyAnonymous(this.myAnonymousToFix, this.myType, project, elementFactory);
                }
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }

        private static void generifyAnonymous(@NotNull PsiAnonymousClass anonymous, @NotNull PsiType type, Project project, PsiElementFactory elementFactory) throws IncorrectOperationException {
            PsiMethod[] methods;
            PsiReferenceParameterList list;
            if (anonymous == null) {
                GenerifyAsyncCallbackFix.$$$reportNull$$$0(4);
            }
            if (type == null) {
                GenerifyAsyncCallbackFix.$$$reportNull$$$0(5);
            }
            if ((list = anonymous.getBaseClassReference().getParameterList()) != null) {
                list.add((PsiElement)elementFactory.createTypeElement(type));
            }
            for (PsiMethod method : methods = anonymous.findMethodsByName("onSuccess", false)) {
                PsiParameter[] parameters = method.getParameterList().getParameters();
                if (parameters.length != 1) continue;
                PsiParameter parameter = parameters[0];
                if (!PsiType.getJavaLangObject((PsiManager)PsiManager.getInstance((Project)project), (GlobalSearchScope)anonymous.getResolveScope()).equals((Object)parameter.getType())) continue;
                parameter.getTypeElement().replace((PsiElement)elementFactory.createTypeElement(type));
                break;
            }
        }

        private static void generifyMethod(@NotNull PsiMethod method, @NotNull PsiType type, PsiElementFactory elementFactory) throws IncorrectOperationException {
            PsiParameter[] parameters;
            if (method == null) {
                GenerifyAsyncCallbackFix.$$$reportNull$$$0(6);
            }
            if (type == null) {
                GenerifyAsyncCallbackFix.$$$reportNull$$$0(7);
            }
            if ((parameters = method.getParameterList().getParameters()).length == 0) {
                return;
            }
            PsiParameter last = parameters[parameters.length - 1];
            last.getTypeElement().replace((PsiElement)elementFactory.createTypeElement((PsiType)RemoteServiceUtil.createAsyncCallbackType((PsiElement)method, type)));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/gwt/inspections/GwtRawAsyncCallbackInspection$GenerifyAsyncCallbackFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptor";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "anonymous";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/gwt/inspections/GwtRawAsyncCallbackInspection$GenerifyAsyncCallbackFix";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "generifyAnonymous";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "generifyMethod";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

