/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.rpc;

import com.intellij.gwt.rpc.GwtGenericsUtil;
import com.intellij.gwt.sdk.GwtVersion;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteServiceUtil {
    @NonNls
    public static final String REMOTE_SERVICE_INTERFACE_NAME = "com.google.gwt.user.client.rpc.RemoteService";
    @NonNls
    public static final String ASYNC_CALLBACK_INTERFACE_NAME = "com.google.gwt.user.client.rpc.AsyncCallback";
    @NonNls
    public static final String SERVICE_PATH_ANNOTATION_NAME = "com.google.gwt.user.client.rpc.RemoteServiceRelativePath";
    @NonNls
    private static final String REMOTE_SERVICE_SERVLET_NAME = "com.google.gwt.user.server.rpc.RemoteServiceServlet";
    @NonNls
    public static final String ASYNC_SUFFIX = "Async";
    @NonNls
    public static final String IMPL_SERVICE_SUFFIX = "Impl";
    @NonNls
    private static final String VOID_CLASS_NAME = "java.lang.Void";

    private RemoteServiceUtil() {
    }

    public static boolean isMethodPresentedInAsync(@NotNull PsiMethod method, @NotNull PsiClass async) {
        if (method == null) {
            RemoteServiceUtil.$$$reportNull$$$0(0);
        }
        if (async == null) {
            RemoteServiceUtil.$$$reportNull$$$0(1);
        }
        return RemoteServiceUtil.findMethodInAsync(method, async) != null;
    }

    public static boolean isMethodPresentedInSync(@NotNull PsiMethod asyncMethod, @NotNull PsiClass sync) {
        if (asyncMethod == null) {
            RemoteServiceUtil.$$$reportNull$$$0(2);
        }
        if (sync == null) {
            RemoteServiceUtil.$$$reportNull$$$0(3);
        }
        return RemoteServiceUtil.findMethodInSync(asyncMethod, sync) != null;
    }

    @Nullable
    public static PsiMethod findSynchronousMethod(@NotNull PsiMethod asyncMethod) {
        PsiClass syncClass;
        PsiClass asyncClass;
        if (asyncMethod == null) {
            RemoteServiceUtil.$$$reportNull$$$0(4);
        }
        if ((asyncClass = asyncMethod.getContainingClass()) != null && (syncClass = RemoteServiceUtil.findSynchronousInterface(asyncClass)) != null) {
            return RemoteServiceUtil.findMethodInSync(asyncMethod, syncClass);
        }
        return null;
    }

    @Nullable
    public static PsiMethod findMethodInSync(@NotNull PsiMethod asyncMethod, @NotNull PsiClass sync) {
        if (asyncMethod == null) {
            RemoteServiceUtil.$$$reportNull$$$0(5);
        }
        if (sync == null) {
            RemoteServiceUtil.$$$reportNull$$$0(6);
        }
        PsiParameter[] asyncParameters = asyncMethod.getParameterList().getParameters();
        PsiType[] asyncParameterTypes = RemoteServiceUtil.getParameterTypes(asyncParameters, null);
        for (Pair pair : sync.findMethodsAndTheirSubstitutorsByName(asyncMethod.getName(), true)) {
            PsiMethod syncMethod = (PsiMethod)pair.getFirst();
            PsiSubstitutor substitutor = (PsiSubstitutor)pair.getSecond();
            PsiParameter[] syncParameters = syncMethod.getParameterList().getParameters();
            PsiType[] syncParameterTypes = RemoteServiceUtil.getParameterTypes(syncParameters, substitutor);
            if (!RemoteServiceUtil.areParametersCorresponding(syncParameterTypes, asyncParameterTypes, substitutor.substitute(syncMethod.getReturnType()), sync.getProject())) continue;
            return syncMethod;
        }
        return null;
    }

    @Nullable
    public static PsiMethod findMethodInAsync(@NotNull PsiMethod syncMethod, @NotNull PsiClass async) {
        if (syncMethod == null) {
            RemoteServiceUtil.$$$reportNull$$$0(7);
        }
        if (async == null) {
            RemoteServiceUtil.$$$reportNull$$$0(8);
        }
        PsiParameter[] syncParameters = syncMethod.getParameterList().getParameters();
        PsiType[] syncParameterTypes = RemoteServiceUtil.getParameterTypes(syncParameters, null);
        for (Pair pair : async.findMethodsAndTheirSubstitutorsByName(syncMethod.getName(), true)) {
            PsiMethod asyncMethod = (PsiMethod)pair.getFirst();
            PsiSubstitutor substitutor = (PsiSubstitutor)pair.getSecond();
            PsiParameter[] asyncParameters = asyncMethod.getParameterList().getParameters();
            PsiType[] asyncParameterTypes = RemoteServiceUtil.getParameterTypes(asyncParameters, substitutor);
            if (!RemoteServiceUtil.areParametersCorresponding(syncParameterTypes, asyncParameterTypes, syncMethod.getReturnType(), async.getProject())) continue;
            return asyncMethod;
        }
        return null;
    }

    @NotNull
    private static PsiType[] getParameterTypes(PsiParameter[] parameters, PsiSubstitutor substitutor) {
        PsiType[] parameterTypes = PsiType.createArray((int)parameters.length);
        for (int i = 0; i < parameters.length; ++i) {
            parameterTypes[i] = substitutor == null ? parameters[i].getType() : substitutor.substitute(parameters[i].getType());
        }
        if (parameterTypes == null) {
            RemoteServiceUtil.$$$reportNull$$$0(9);
        }
        return parameterTypes;
    }

    private static boolean areParametersCorresponding(PsiType[] syncParameters, PsiType[] asyncParameters, @Nullable PsiType syncReturnType, Project project) {
        PsiClassType boxedType;
        if (asyncParameters.length != syncParameters.length + 1) {
            return false;
        }
        for (int i = 0; i != syncParameters.length; ++i) {
            if (RemoteServiceUtil.areErasuresEqual(syncParameters[i], asyncParameters[i])) continue;
            return false;
        }
        PsiType lastParameterType = asyncParameters[syncParameters.length];
        if (!(lastParameterType instanceof PsiClassType)) {
            return false;
        }
        PsiClassType lastClassType = (PsiClassType)lastParameterType;
        PsiClassType.ClassResolveResult resolveResult = lastClassType.resolveGenerics();
        PsiClass psiClass = resolveResult.getElement();
        if (psiClass == null || !ASYNC_CALLBACK_INTERFACE_NAME.equals(psiClass.getQualifiedName())) {
            return false;
        }
        if (PsiClassType.isRaw((PsiClassType.ClassResolveResult)resolveResult) || !psiClass.hasTypeParameters()) {
            return true;
        }
        PsiType actualTypeParameter = resolveResult.getSubstitutor().substitute(psiClass.getTypeParameters()[0]);
        if (syncReturnType instanceof PsiPrimitiveType && (boxedType = RemoteServiceUtil.getBoxedType((PsiPrimitiveType)syncReturnType, lastParameterType.getResolveScope(), project)) != null) {
            syncReturnType = boxedType;
        }
        return actualTypeParameter != null && syncReturnType != null && RemoteServiceUtil.areErasuresEqual(syncReturnType, actualTypeParameter);
    }

    private static boolean areErasuresEqual(@NotNull PsiType t1, @NotNull PsiType t2) {
        if (t1 == null) {
            RemoteServiceUtil.$$$reportNull$$$0(10);
        }
        if (t2 == null) {
            RemoteServiceUtil.$$$reportNull$$$0(11);
        }
        PsiType type1 = TypeConversionUtil.erasure((PsiType)t1);
        PsiType type2 = TypeConversionUtil.erasure((PsiType)t2);
        return type1.equals(type2);
    }

    public static boolean isRemoteServiceInterface(@Nullable PsiClass aClass) {
        if (aClass == null || !aClass.isInterface()) {
            return false;
        }
        return InheritanceUtil.isInheritor((PsiClass)aClass, (boolean)true, (String)REMOTE_SERVICE_INTERFACE_NAME);
    }

    public static boolean isRemoteServiceImplementation(@Nullable PsiClass aClass) {
        if (aClass == null || aClass.isInterface() || aClass.hasModifierProperty("abstract")) {
            return false;
        }
        return InheritanceUtil.isInheritor((PsiClass)aClass, (boolean)true, (String)REMOTE_SERVICE_SERVLET_NAME);
    }

    @Nullable
    public static PsiClass findRemoteServiceInterface(PsiClass serviceImpl) {
        PsiClass[] interfaces;
        for (PsiClass anInterface : interfaces = serviceImpl.getInterfaces()) {
            if (!RemoteServiceUtil.isRemoteServiceInterface(anInterface)) continue;
            return anInterface;
        }
        return null;
    }

    @Nullable
    public static PsiClass findSynchronousInterface(@Nullable PsiClass asyncInterface) {
        if (asyncInterface == null) {
            return null;
        }
        String name = asyncInterface.getQualifiedName();
        if (name == null || !name.endsWith(ASYNC_SUFFIX)) {
            return null;
        }
        PsiManager psiManager = asyncInterface.getManager();
        GlobalSearchScope scope = asyncInterface.getResolveScope();
        String syncName = name.substring(0, name.length() - ASYNC_SUFFIX.length());
        PsiClass sync = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(syncName, scope);
        if (InheritanceUtil.isInheritor((PsiClass)sync, (boolean)true, (String)REMOTE_SERVICE_INTERFACE_NAME)) {
            return sync;
        }
        return null;
    }

    @Nullable
    public static PsiClass findAsynchronousInterface(@Nullable PsiClass aClass) {
        if (aClass == null) {
            return null;
        }
        return JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass(aClass.getQualifiedName() + ASYNC_SUFFIX, aClass.getResolveScope());
    }

    @Nullable
    public static PsiMethod findAsynchronousMethod(@NotNull PsiMethod method) {
        PsiClass psiClass;
        if (method == null) {
            RemoteServiceUtil.$$$reportNull$$$0(12);
        }
        if ((psiClass = method.getContainingClass()) == null || !RemoteServiceUtil.isRemoteServiceInterface(psiClass)) {
            return null;
        }
        PsiClass asyncClass = RemoteServiceUtil.findAsynchronousInterface(psiClass);
        if (asyncClass == null) {
            return null;
        }
        return RemoteServiceUtil.findMethodInAsync(method, asyncClass);
    }

    public static void copyAllMethodsToAsync(@NotNull PsiClass sync, @NotNull PsiClass async, @NotNull GwtVersion gwtVersion) throws IncorrectOperationException {
        if (sync == null) {
            RemoteServiceUtil.$$$reportNull$$$0(13);
        }
        if (async == null) {
            RemoteServiceUtil.$$$reportNull$$$0(14);
        }
        if (gwtVersion == null) {
            RemoteServiceUtil.$$$reportNull$$$0(15);
        }
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)sync.getProject()).getElementFactory();
        for (PsiMethod method : async.getMethods()) {
            method.delete();
        }
        for (PsiMethod method : sync.getMethods()) {
            RemoteServiceUtil.copyMethodToAsync(method, async, elementFactory, gwtVersion);
        }
    }

    public static PsiMethod copyMethodToAsync(@NotNull PsiMethod method, @NotNull PsiClass async, @NotNull GwtVersion gwtVersion) throws IncorrectOperationException {
        if (method == null) {
            RemoteServiceUtil.$$$reportNull$$$0(16);
        }
        if (async == null) {
            RemoteServiceUtil.$$$reportNull$$$0(17);
        }
        if (gwtVersion == null) {
            RemoteServiceUtil.$$$reportNull$$$0(18);
        }
        return RemoteServiceUtil.copyMethodToAsync(method, async, JavaPsiFacade.getInstance((Project)method.getProject()).getElementFactory(), gwtVersion);
    }

    private static PsiMethod copyMethodToAsync(@NotNull PsiMethod method, @NotNull PsiClass async, @NotNull PsiElementFactory elementFactory, @NotNull GwtVersion gwtVersion) throws IncorrectOperationException {
        if (method == null) {
            RemoteServiceUtil.$$$reportNull$$$0(19);
        }
        if (async == null) {
            RemoteServiceUtil.$$$reportNull$$$0(20);
        }
        if (elementFactory == null) {
            RemoteServiceUtil.$$$reportNull$$$0(21);
        }
        if (gwtVersion == null) {
            RemoteServiceUtil.$$$reportNull$$$0(22);
        }
        PsiClassType asyncCallbackType = !gwtVersion.isGenericsSupported() ? RemoteServiceUtil.createAsyncCallbackType((PsiElement)async, null) : RemoteServiceUtil.createAsyncCallbackType((PsiElement)async, method.getReturnType());
        PsiMethod newMethod = (PsiMethod)method.copy();
        newMethod.getParameterList().add((PsiElement)elementFactory.createParameter("async", (PsiType)asyncCallbackType));
        PsiReferenceList throwsList = newMethod.getThrowsList();
        for (PsiJavaCodeReferenceElement element : throwsList.getReferenceElements()) {
            element.delete();
        }
        GwtGenericsUtil.removeTypeArgsJavadocTags(newMethod);
        PsiTypeElement returnTypeElement = newMethod.getReturnTypeElement();
        assert (returnTypeElement != null);
        returnTypeElement.replace((PsiElement)elementFactory.createTypeElement((PsiType)PsiType.VOID));
        return (PsiMethod)async.add((PsiElement)newMethod);
    }

    public static PsiClassType createAsyncCallbackType(@NotNull PsiElement context, @Nullable PsiType parameter) {
        if (context == null) {
            RemoteServiceUtil.$$$reportNull$$$0(23);
        }
        Project project = context.getProject();
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project);
        GlobalSearchScope scope = context.getResolveScope();
        PsiClass asyncCallbackClass = psiFacade.findClass(ASYNC_CALLBACK_INTERFACE_NAME, scope);
        PsiElementFactory elementFactory = psiFacade.getElementFactory();
        if (asyncCallbackClass == null) {
            return elementFactory.createTypeByFQClassName(ASYNC_CALLBACK_INTERFACE_NAME, scope);
        }
        PsiTypeParameter[] typeParameters = asyncCallbackClass.getTypeParameters();
        if (parameter instanceof PsiPrimitiveType) {
            parameter = RemoteServiceUtil.getBoxedType((PsiPrimitiveType)parameter, scope, project);
        }
        if (parameter == null || typeParameters.length == 0) {
            return elementFactory.createType(asyncCallbackClass);
        }
        return elementFactory.createType(asyncCallbackClass, PsiSubstitutor.EMPTY.put(typeParameters[0], parameter));
    }

    @Nullable
    private static PsiClassType getBoxedType(@NotNull PsiPrimitiveType type, @NotNull GlobalSearchScope scope, @NotNull Project project) {
        if (type == null) {
            RemoteServiceUtil.$$$reportNull$$$0(24);
        }
        if (scope == null) {
            RemoteServiceUtil.$$$reportNull$$$0(25);
        }
        if (project == null) {
            RemoteServiceUtil.$$$reportNull$$$0(26);
        }
        if (TypeConversionUtil.isVoidType((PsiType)type)) {
            return JavaPsiFacade.getInstance((Project)project).getElementFactory().createTypeByFQClassName(VOID_CLASS_NAME, scope);
        }
        return type.getBoxedType(PsiManager.getInstance((Project)project), scope);
    }

    public static PsiMethod copyMethodToSync(PsiMethod method, PsiClass sync) throws IncorrectOperationException {
        PsiTypeElement typeElement;
        Project project = method.getProject();
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        PsiMethod newMethod = (PsiMethod)method.copy();
        PsiParameter[] parameters = newMethod.getParameterList().getParameters();
        PsiClassType newReturnType = PsiType.getJavaLangObject((PsiManager)PsiManager.getInstance((Project)project), (GlobalSearchScope)sync.getResolveScope());
        if (parameters.length > 0) {
            PsiClassType classType;
            PsiClassType.ClassResolveResult resolveResult;
            PsiClass psiClass;
            PsiParameter callbackParameter = parameters[parameters.length - 1];
            PsiType type = method.getParameterList().getParameters()[parameters.length - 1].getType();
            if (type instanceof PsiClassType && (psiClass = (resolveResult = (classType = (PsiClassType)type).resolveGenerics()).getElement()) != null && ASYNC_CALLBACK_INTERFACE_NAME.equals(psiClass.getQualifiedName())) {
                PsiType parameter;
                PsiTypeParameter[] typeParameters = psiClass.getTypeParameters();
                if (typeParameters.length > 0 && (parameter = resolveResult.getSubstitutor().substitute(typeParameters[0])) != null) {
                    PsiPrimitiveType unboxed = RemoteServiceUtil.isBoxedVoidType(parameter) ? PsiType.VOID : PsiPrimitiveType.getUnboxedType((PsiType)parameter);
                    newReturnType = unboxed != null ? unboxed : parameter;
                }
                callbackParameter.delete();
            }
        }
        if ((typeElement = newMethod.getReturnTypeElement()) != null) {
            PsiTypeElement newTypeElement = elementFactory.createTypeElement((PsiType)newReturnType);
            typeElement.replace((PsiElement)newTypeElement);
        }
        return (PsiMethod)sync.add((PsiElement)newMethod);
    }

    private static boolean isBoxedVoidType(PsiType parameter) {
        if (!(parameter instanceof PsiClassType)) {
            return false;
        }
        PsiClass psiClass = ((PsiClassType)parameter).resolve();
        return psiClass != null && VOID_CLASS_NAME.equals(psiClass.getQualifiedName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 1: 
            case 8: 
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "async";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "asyncMethod";
                break;
            }
            case 3: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sync";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "syncMethod";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/gwt/rpc/RemoteServiceUtil";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t1";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t2";
                break;
            }
            case 15: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "gwtVersion";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementFactory";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/gwt/rpc/RemoteServiceUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isMethodPresentedInAsync";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isMethodPresentedInSync";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findSynchronousMethod";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findMethodInSync";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "findMethodInAsync";
                break;
            }
            case 9: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "areErasuresEqual";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findAsynchronousMethod";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "copyAllMethodsToAsync";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "copyMethodToAsync";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createAsyncCallbackType";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getBoxedType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

