/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.ide.util.ModuleRendererFactory;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.components.JBList;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.sun.jdi.Location;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JList;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.KotlinAlternativeSourceNotificationProvider$AlternativeSourceNotificationPanel$$special$;
import org.jetbrains.kotlin.idea.stubindex.PackageIndexUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\r\u000eB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/KotlinAlternativeSourceNotificationProvider;", "Lcom/intellij/ui/EditorNotifications$Provider;", "Lcom/intellij/ui/EditorNotificationPanel;", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createNotificationPanel", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getKey", "Lcom/intellij/openapi/util/Key;", "AlternativeSourceNotificationPanel", "Companion", "idea-jvm"})
public final class KotlinAlternativeSourceNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private final Project myProject;
    private static final Key<EditorNotificationPanel> KEY;
    private static final Key<Boolean> FILE_PROCESSED_KEY;
    public static final Companion Companion;

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        Key key = KotlinAlternativeSourceNotificationProvider.Companion.getKEY();
        Intrinsics.checkExpressionValueIsNotNull((Object)key, (String)"KEY");
        return key;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor) {
        String string;
        void $receiver$iv$iv;
        void $receiver$iv;
        void $receiver$iv2;
        XSourcePosition position2;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)fileEditor, (String)"fileEditor");
        if (!DebuggerSettings.getInstance().SHOW_ALTERNATIVE_SOURCE) {
            return null;
        }
        XDebuggerManager xDebuggerManager = XDebuggerManager.getInstance((Project)this.myProject);
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebuggerManager, (String)"XDebuggerManager.getInstance(myProject)");
        XDebugSession session = xDebuggerManager.getCurrentSession();
        if (session == null) {
            KotlinAlternativeSourceNotificationProvider.Companion.getFILE_PROCESSED_KEY().set((UserDataHolder)file2, null);
            return null;
        }
        XSourcePosition xSourcePosition = position2 = session.getCurrentPosition();
        if (Intrinsics.areEqual((Object)file2, (Object)(xSourcePosition != null ? xSourcePosition.getFile() : null)) ^ true) {
            KotlinAlternativeSourceNotificationProvider.Companion.getFILE_PROCESSED_KEY().set((UserDataHolder)file2, null);
            return null;
        }
        DumbService dumbService = DumbService.getInstance((Project)this.myProject);
        Intrinsics.checkExpressionValueIsNotNull((Object)dumbService, (String)"DumbService.getInstance(myProject)");
        if (dumbService.isDumb()) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file2);
        if (!(psiFile instanceof KtFile)) {
            psiFile = null;
        }
        KtFile ktFile = (KtFile)psiFile;
        if (ktFile == null) {
            return null;
        }
        KtFile ktFile2 = ktFile;
        FqName packageFqName = ktFile2.getPackageFqName();
        String fileName = ktFile2.getName();
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.myProject);
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"GlobalSearchScope.allScope(myProject)");
        Iterable iterable = PackageIndexUtil.findFilesWithExactPackage(packageFqName, globalSearchScope, this.myProject);
        Iterable destination$iv = new HashSet();
        for (Object element$iv : $receiver$iv2) {
            KtFile it = (KtFile)element$iv;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)fileName)) continue;
            destination$iv.add(element$iv);
        }
        HashSet alternativeKtFiles = (HashSet)destination$iv;
        KotlinAlternativeSourceNotificationProvider.Companion.getFILE_PROCESSED_KEY().set((UserDataHolder)file2, (Object)true);
        if (alternativeKtFiles.size() <= 1) {
            return null;
        }
        destination$iv = alternativeKtFiles;
        Collection collection = CollectionsKt.listOf((Object)ktFile2);
        Iterator iterator2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            KtFile it = (KtFile)element$iv$iv;
            if (!(Intrinsics.areEqual((Object)it, (Object)ktFile2) ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        Collection currentFirstAlternatives = CollectionsKt.plus((Collection)collection, (Iterable)list2);
        XStackFrame frame = session.getCurrentStackFrame();
        XStackFrame xStackFrame = frame;
        if (xStackFrame instanceof JavaStackFrame) {
            StackFrameDescriptorImpl stackFrameDescriptorImpl = ((JavaStackFrame)frame).getDescriptor();
            Intrinsics.checkExpressionValueIsNotNull((Object)stackFrameDescriptorImpl, (String)"frame.descriptor");
            Location location2 = stackFrameDescriptorImpl.getLocation();
            Comparable<Location> comparable = location2;
            string = comparable != null && (comparable = comparable.declaringType()) != null ? comparable.name() : null;
        } else {
            string = null;
        }
        String locationDeclName = string;
        return new AlternativeSourceNotificationPanel(currentFirstAlternatives, this.myProject, file2, locationDeclName);
    }

    public KotlinAlternativeSourceNotificationProvider(@NotNull Project myProject) {
        Intrinsics.checkParameterIsNotNull((Object)myProject, (String)"myProject");
        this.myProject = myProject;
    }

    static {
        Companion = new Companion(null);
        KEY = Key.create((String)"KotlinAlternativeSource");
        Key key = Key.findKeyByName((String)"AlternativeSourceCheckDone");
        if (key == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.util.Key<kotlin.Boolean>");
        }
        FILE_PROCESSED_KEY = key;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/KotlinAlternativeSourceNotificationProvider$AlternativeSourceNotificationPanel;", "Lcom/intellij/ui/EditorNotificationPanel;", "alternatives", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "locationDeclName", "", "(Ljava/util/Collection;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;)V", "ComboBoxFileElement", "idea-jvm"})
    private static final class AlternativeSourceNotificationPanel
    extends EditorNotificationPanel {
        /*
         * WARNING - void declaration
         */
        public AlternativeSourceNotificationPanel(@NotNull Collection<? extends KtFile> alternatives, final @NotNull Project project, final @NotNull VirtualFile file2, @Nullable String locationDeclName) {
            ComboBox comboBox;
            Object[] objectArray;
            ComboBoxFileElement comboBoxFileElement;
            Object object;
            void $receiver$iv$iv;
            Iterable $receiver$iv;
            Intrinsics.checkParameterIsNotNull(alternatives, (String)"alternatives");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            this.setText("Alternative source available for file " + file2.getName());
            Iterable iterable = $receiver$iv = (Iterable)alternatives;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
            for (Object item$iv$iv : $receiver$iv$iv) {
                void it;
                KtFile ktFile = (KtFile)item$iv$iv;
                object = destination$iv$iv;
                comboBoxFileElement = new ComboBoxFileElement((KtFile)it);
                object.add(comboBoxFileElement);
            }
            List items = (List)destination$iv$iv;
            $receiver$iv = items;
            object = this.myLinksPanel;
            Iterable thisCollection$iv = $receiver$iv;
            Object[] objectArray2 = thisCollection$iv.toArray(new ComboBoxFileElement[0]);
            if (objectArray2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            Object[] objectArray3 = objectArray = objectArray2;
            ComboBox $receiver = comboBox = new ComboBox(objectArray3);
            $receiver.addActionListener(new ActionListener($receiver, project, locationDeclName, file2){
                final /* synthetic */ ComboBox receiver$0;
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ String $locationDeclName$inlined;
                final /* synthetic */ VirtualFile $file$inlined;
                {
                    this.receiver$0 = comboBox;
                    this.$project$inlined = project;
                    this.$locationDeclName$inlined = string;
                    this.$file$inlined = virtualFile2;
                }

                public final void actionPerformed(ActionEvent it) {
                    DebuggerContextImpl context;
                    DebuggerManagerEx debuggerManagerEx = DebuggerManagerEx.getInstanceEx((Project)this.$project$inlined);
                    Intrinsics.checkExpressionValueIsNotNull((Object)debuggerManagerEx, (String)"DebuggerManagerEx.getInstanceEx(project)");
                    DebuggerContextImpl debuggerContextImpl = context = debuggerManagerEx.getContext();
                    Intrinsics.checkExpressionValueIsNotNull((Object)debuggerContextImpl, (String)"context");
                    DebuggerSession session = debuggerContextImpl.getDebuggerSession();
                    Object object = this.receiver$0.getSelectedItem();
                    if (object == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.debugger.KotlinAlternativeSourceNotificationProvider.AlternativeSourceNotificationPanel.ComboBoxFileElement");
                    }
                    KtFile ktFile = ((ComboBoxFileElement)object).getKtFile();
                    PsiFile psiFile = ktFile.getContainingFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)psiFile, (String)"ktFile.containingFile");
                    VirtualFile vFile = psiFile.getVirtualFile();
                    if (session != null && vFile != null) {
                        DebugProcessImpl debugProcessImpl = session.getProcess();
                        Intrinsics.checkExpressionValueIsNotNull((Object)debugProcessImpl, (String)"session.process");
                        debugProcessImpl.getManagerThread().schedule(new DebuggerCommandImpl(this, vFile, session){
                            final /* synthetic */ AlternativeSourceNotificationPanel$$special$$inlined$apply$lambda$1 this$0;
                            final /* synthetic */ VirtualFile $vFile;
                            final /* synthetic */ DebuggerSession $session;
                            {
                                this.this$0 = $outer;
                                this.$vFile = $captured_local_variable$1;
                                this.$session = $captured_local_variable$2;
                            }

                            protected void action() {
                                if (!StringUtil.isEmpty((String)this.this$0.$locationDeclName$inlined)) {
                                    DebuggerUtilsEx.setAlternativeSourceUrl((String)this.this$0.$locationDeclName$inlined, (String)this.$vFile.getUrl(), (Project)this.this$0.$project$inlined);
                                }
                                DebuggerUIUtil.invokeLater((Runnable)new Runnable(this){
                                    final /* synthetic */ AlternativeSourceNotificationPanel$$special$$inlined$apply$lambda$1$1 this$0;
                                    {
                                        this.this$0 = var1_1;
                                    }

                                    public final void run() {
                                        FileEditorManager.getInstance((Project)this.this$0.this$0.$project$inlined).closeFile(this.this$0.this$0.$file$inlined);
                                        this.this$0.$session.refresh(true);
                                    }
                                });
                            }
                        });
                    } else {
                        FileEditorManager.getInstance((Project)this.$project$inlined).closeFile(this.$file$inlined);
                        ktFile.navigate(true);
                    }
                }
            });
            comboBoxFileElement = comboBox;
            ((Container)object).add((Component)((Object)comboBoxFileElement));
            this.createActionLabel("Disable", new Runnable(){

                @Override
                public final void run() {
                    DebuggerSettings.getInstance().SHOW_ALTERNATIVE_SOURCE = false;
                    Companion.getFILE_PROCESSED_KEY().set((UserDataHolder)file2, null);
                    FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
                    FileEditor editor = fileEditorManager.getSelectedEditor(file2);
                    if (editor != null) {
                        fileEditorManager.removeTopComponent(editor, (JComponent)((Object)this));
                    }
                }
            });
        }

        @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/KotlinAlternativeSourceNotificationProvider$AlternativeSourceNotificationPanel$ComboBoxFileElement;", "", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/psi/KtFile;)V", "getKtFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "label", "", "getLabel", "()Ljava/lang/String;", "label$delegate", "Lkotlin/Lazy;", "toString", "Companion", "idea-jvm"})
        private static final class ComboBoxFileElement {
            static final /* synthetic */ KProperty[] $$delegatedProperties;
            private final Lazy label$delegate;
            @NotNull
            private final KtFile ktFile;
            private static final JBList<KtFile> ourDummyList;
            public static final Companion Companion;

            static {
                $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(ComboBoxFileElement.class), "label", "getLabel()Ljava/lang/String;"))};
                Companion = new Companion(null);
                ourDummyList = new JBList();
            }

            private final String getLabel() {
                Lazy lazy = this.label$delegate;
                ComboBoxFileElement comboBoxFileElement = this;
                KProperty kProperty = $$delegatedProperties[0];
                return (String)lazy.getValue();
            }

            @NotNull
            public String toString() {
                return this.getLabel();
            }

            @NotNull
            public final KtFile getKtFile() {
                return this.ktFile;
            }

            public ComboBoxFileElement(@NotNull KtFile ktFile) {
                Intrinsics.checkParameterIsNotNull((Object)ktFile, (String)"ktFile");
                this.ktFile = ktFile;
                this.label$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<String>(this){
                    final /* synthetic */ ComboBoxFileElement this$0;

                    @NotNull
                    public final String invoke() {
                        ModuleRendererFactory factory2;
                        ModuleRendererFactory moduleRendererFactory = factory2 = ModuleRendererFactory.findInstance((Object)this.this$0.getKtFile());
                        Intrinsics.checkExpressionValueIsNotNull((Object)moduleRendererFactory, (String)"factory");
                        DefaultListCellRenderer moduleRenderer = moduleRendererFactory.getModuleRenderer();
                        moduleRenderer.getListCellRendererComponent((JList<?>)((JList)Companion.access$getOurDummyList$p(ComboBoxFileElement.Companion)), this.this$0.getKtFile(), 1, false, false);
                        DefaultListCellRenderer defaultListCellRenderer = moduleRenderer;
                        Intrinsics.checkExpressionValueIsNotNull((Object)defaultListCellRenderer, (String)"moduleRenderer");
                        String string = defaultListCellRenderer.getText();
                        if (string == null) {
                            string = "";
                        }
                        return string;
                    }
                    {
                        this.this$0 = comboBoxFileElement;
                        super(0);
                    }
                }));
            }

            @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/KotlinAlternativeSourceNotificationProvider$AlternativeSourceNotificationPanel$ComboBoxFileElement$Companion;", "", "()V", "ourDummyList", "Lcom/intellij/ui/components/JBList;", "Lorg/jetbrains/kotlin/psi/KtFile;", "getOurDummyList", "()Lcom/intellij/ui/components/JBList;", "idea-jvm"})
            public static final class Companion {
                private final JBList<KtFile> getOurDummyList() {
                    return ourDummyList;
                }

                private Companion() {
                }

                @NotNull
                public static final /* synthetic */ JBList access$getOurDummyList$p(Companion $this) {
                    return $this.getOurDummyList();
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n0\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/KotlinAlternativeSourceNotificationProvider$Companion;", "", "()V", "FILE_PROCESSED_KEY", "Lcom/intellij/openapi/util/Key;", "", "FILE_PROCESSED_KEY$annotations", "getFILE_PROCESSED_KEY", "()Lcom/intellij/openapi/util/Key;", "KEY", "Lcom/intellij/ui/EditorNotificationPanel;", "kotlin.jvm.PlatformType", "getKEY", "idea-jvm"})
    public static final class Companion {
        private final Key<EditorNotificationPanel> getKEY() {
            return KEY;
        }

        private static /* synthetic */ void FILE_PROCESSED_KEY$annotations() {
        }

        private final Key<Boolean> getFILE_PROCESSED_KEY() {
            return FILE_PROCESSED_KEY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

