/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.impl.EditorTextProvider;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.debugger.KotlinEditorTextProvider;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtImportDirective;
import org.jetbrains.kotlin.psi.KtOperationExpression;
import org.jetbrains.kotlin.psi.KtPackageDirective;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThisExpression;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.kotlin.psi.KtValueArgumentName;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.scopes.receivers.Qualifier;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\u0005H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/KotlinEditorTextProvider;", "Lcom/intellij/debugger/impl/EditorTextProvider;", "()V", "findExpression", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/openapi/util/TextRange;", "elementAtCaret", "allowMethodCalls", "", "getEditorText", "Lcom/intellij/debugger/engine/evaluation/TextWithImports;", "Companion", "idea-jvm"})
public final class KotlinEditorTextProvider
implements EditorTextProvider {
    private static final Class<? extends NavigatablePsiElement>[] NOT_ACCEPTED_AS_CONTEXT_TYPES;
    public static final Companion Companion;

    @Nullable
    public TextWithImports getEditorText(@NotNull PsiElement elementAtCaret) {
        Intrinsics.checkParameterIsNotNull((Object)elementAtCaret, (String)"elementAtCaret");
        KtExpression ktExpression = Companion.findExpressionInner(elementAtCaret, true);
        if (ktExpression == null) {
            return null;
        }
        KtExpression expression2 = ktExpression;
        String expressionText2 = (String)Companion.getElementInfo(expression2, getEditorText.expressionText.1.INSTANCE);
        return (TextWithImports)new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, expressionText2, "", (FileType)KotlinFileType.INSTANCE);
    }

    @Nullable
    public Pair<PsiElement, TextRange> findExpression(@NotNull PsiElement elementAtCaret, boolean allowMethodCalls) {
        Intrinsics.checkParameterIsNotNull((Object)elementAtCaret, (String)"elementAtCaret");
        KtExpression ktExpression = Companion.findExpressionInner(elementAtCaret, allowMethodCalls);
        if (ktExpression == null) {
            return null;
        }
        KtExpression expression2 = ktExpression;
        TextRange expressionRange2 = (TextRange)Companion.getElementInfo(expression2, findExpression.expressionRange.1.INSTANCE);
        return new Pair((Object)expression2, (Object)expressionRange2);
    }

    static {
        Companion = new Companion(null);
        NOT_ACCEPTED_AS_CONTEXT_TYPES = new Class[]{KtUserType.class, KtImportDirective.class, KtPackageDirective.class, KtValueArgumentName.class};
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ-\u0010\u0010\u001a\u0002H\u0011\"\u0004\b\u0000\u0010\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u0002H\u00110\u0014\u00a2\u0006\u0002\u0010\u0015J\u000e\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rR$\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/KotlinEditorTextProvider$Companion;", "", "()V", "NOT_ACCEPTED_AS_CONTEXT_TYPES", "", "Ljava/lang/Class;", "Lcom/intellij/psi/NavigatablePsiElement;", "getNOT_ACCEPTED_AS_CONTEXT_TYPES", "()[Ljava/lang/Class;", "[Ljava/lang/Class;", "findExpressionInner", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "Lcom/intellij/psi/PsiElement;", "allowMethodCalls", "", "getElementInfo", "T", "expr", "f", "Lkotlin/Function1;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "isAcceptedAsCodeFragmentContext", "idea-jvm"})
    public static final class Companion {
        public final <T> T getElementInfo(@NotNull KtExpression expr2, @NotNull Function1<? super PsiElement, ? extends T> f) {
            PsiElement nameIdentifier;
            Intrinsics.checkParameterIsNotNull((Object)expr2, (String)"expr");
            Intrinsics.checkParameterIsNotNull(f, (String)"f");
            Object expressionText2 = f.invoke((Object)expr2);
            if (expr2 instanceof KtProperty && (nameIdentifier = ((KtProperty)expr2).getNameIdentifier()) != null) {
                expressionText2 = f.invoke((Object)nameIdentifier);
            }
            return (T)expressionText2;
        }

        @Nullable
        public final KtExpression findExpressionInner(@NotNull PsiElement element3, boolean allowMethodCalls) {
            BindingContext context;
            Qualifier qualifier;
            KtExpression newExpression2;
            KtElement ktElement;
            block7: {
                block8: {
                    PsiElement pparent;
                    PsiElement psiElement2;
                    PsiElement parent2;
                    PsiElement nameIdentifier;
                    Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
                    if (!this.isAcceptedAsCodeFragmentContext(element3)) {
                        return null;
                    }
                    KtElement ktElement2 = (KtElement)PsiTreeUtil.getParentOfType((PsiElement)element3, KtElement.class);
                    if (ktElement2 == null) {
                        return null;
                    }
                    ktElement = ktElement2;
                    if (ktElement instanceof KtProperty && Intrinsics.areEqual((Object)(nameIdentifier = ((KtProperty)ktElement).getNameIdentifier()), (Object)element3)) {
                        return (KtExpression)ktElement;
                    }
                    KtElement ktElement3 = ktElement;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktElement3, (String)"ktElement");
                    PsiElement psiElement3 = parent2 = ktElement3.getParent();
                    KtExpression ktExpression = psiElement3 instanceof KtThisExpression ? (KtExpression)parent2 : (psiElement3 instanceof KtSuperExpression ? ((psiElement2 = (pparent = ((KtSuperExpression)parent2).getParent())) instanceof KtQualifiedExpression ? (KtExpression)pparent : (KtExpression)parent2) : (psiElement3 instanceof KtReferenceExpression ? ((pparent = ((KtReferenceExpression)parent2).getParent()) instanceof KtQualifiedExpression && Intrinsics.areEqual((Object)((KtQualifiedExpression)pparent).getSelectorExpression(), (Object)parent2) ? (KtExpression)pparent : (KtExpression)parent2) : (psiElement3 instanceof KtQualifiedExpression ? (KtExpression)(Intrinsics.areEqual((Object)((KtQualifiedExpression)parent2).getReceiverExpression(), (Object)ktElement) ^ true ? (KtQualifiedExpression)parent2 : null) : (psiElement3 instanceof KtOperationExpression ? (KtExpression)(Intrinsics.areEqual((Object)((KtOperationExpression)parent2).getOperationReference(), (Object)ktElement) ? (KtOperationExpression)parent2 : null) : (newExpression2 = null)))));
                    if (allowMethodCalls || newExpression2 == null) break block7;
                    findExpressionInner.1 isCall$ = findExpressionInner.1.INSTANCE;
                    if (isCall$.invoke((PsiElement)newExpression2)) break block8;
                    if (!(newExpression2 instanceof KtQualifiedExpression)) break block7;
                    KtExpression ktExpression2 = ((KtQualifiedExpression)newExpression2).getSelectorExpression();
                    if (ktExpression2 == null) {
                        Intrinsics.throwNpe();
                    }
                    if (!isCall$.invoke((PsiElement)ktExpression2)) break block7;
                }
                return null;
            }
            return newExpression2 instanceof KtExpression ? newExpression2 : (ktElement instanceof KtSimpleNameExpression ? (KtExpression)((qualifier = (Qualifier)(context = ResolutionUtils.analyze$default(ktElement, null, 1, null)).get(BindingContext.QUALIFIER, ktElement)) != null && !DescriptorUtils.isObject(qualifier.getDescriptor()) ? null : (KtSimpleNameExpression)ktElement) : null);
        }

        private final Class<? extends NavigatablePsiElement>[] getNOT_ACCEPTED_AS_CONTEXT_TYPES() {
            return NOT_ACCEPTED_AS_CONTEXT_TYPES;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isAcceptedAsCodeFragmentContext(@NotNull PsiElement element3) {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Class<?> clazz = element3.getClass();
            if (clazz == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Class<*>");
            }
            if (ArraysKt.contains((Object[])this.getNOT_ACCEPTED_AS_CONTEXT_TYPES(), clazz)) return false;
            Class<? extends NavigatablePsiElement>[] classArray = this.getNOT_ACCEPTED_AS_CONTEXT_TYPES();
            if (PsiTreeUtil.getParentOfType((PsiElement)element3, (Class[])Arrays.copyOf(classArray, classArray.length)) != null) return false;
            return true;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

