/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.findUsages.dialogs;

import com.intellij.find.FindBundle;
import com.intellij.find.findUsages.FindClassUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.JavaClassFindUsagesOptions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.StateRestoringCheckBox;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.findUsages.KotlinClassFindUsagesOptions;
import org.jetbrains.kotlin.idea.findUsages.dialogs.Utils;
import org.jetbrains.kotlin.idea.refactoring.RenderingUtilsKt;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;

public class KotlinFindClassUsagesDialog
extends FindClassUsagesDialog {
    private StateRestoringCheckBox constructorUsages;
    private StateRestoringCheckBox derivedClasses;
    private StateRestoringCheckBox derivedTraits;
    private static final Key<KtClassOrObject> ORIGINAL_CLASS = Key.create((String)"ORIGINAL_CLASS");

    public KotlinFindClassUsagesDialog(KtClassOrObject classOrObject, Project project, FindUsagesOptions findUsagesOptions, boolean toShowInNewTab, boolean mustOpenInNewTab, boolean isSingleFile, FindUsagesHandler handler2) {
        super((PsiElement)KotlinFindClassUsagesDialog.getRepresentingPsiClass(classOrObject), project, findUsagesOptions, toShowInNewTab, mustOpenInNewTab, isSingleFile, handler2);
    }

    @NotNull
    private static PsiClass getRepresentingPsiClass(@NotNull KtClassOrObject classOrObject) {
        KtClass klass2;
        KtLightClass lightClass2;
        if (classOrObject == null) {
            KotlinFindClassUsagesDialog.$$$reportNull$$$0(0);
        }
        if ((lightClass2 = LightClassUtilsKt.toLightClass(classOrObject)) != null) {
            KtLightClass ktLightClass = lightClass2;
            if (ktLightClass == null) {
                KotlinFindClassUsagesDialog.$$$reportNull$$$0(1);
            }
            return ktLightClass;
        }
        PsiElementFactory factory2 = PsiElementFactory.SERVICE.getInstance((Project)classOrObject.getProject());
        String name2 = classOrObject.getName();
        if (name2 == null || name2.isEmpty()) {
            name2 = "Anonymous";
        }
        PsiClass javaClass = classOrObject instanceof KtClass ? (!(klass2 = (KtClass)classOrObject).isInterface() ? factory2.createClass(name2) : (klass2.isAnnotation() ? factory2.createAnnotationType(name2) : factory2.createInterface(name2))) : factory2.createClass(name2);
        javaClass.getModifierList().setModifierProperty("final", !(classOrObject instanceof KtClass) || !PsiModificationUtilsKt.isInheritable((KtClass)classOrObject));
        javaClass.putUserData(ORIGINAL_CLASS, (Object)classOrObject);
        PsiClass psiClass2 = javaClass;
        if (psiClass2 == null) {
            KotlinFindClassUsagesDialog.$$$reportNull$$$0(2);
        }
        return psiClass2;
    }

    protected JPanel createFindWhatPanel() {
        JPanel findWhatPanel = super.createFindWhatPanel();
        assert (findWhatPanel != null);
        Utils.renameCheckbox(findWhatPanel, FindBundle.message((String)"find.what.methods.usages.checkbox", (Object[])new Object[0]), KotlinBundle.message("find.what.functions.usages.checkbox", new Object[0]));
        Utils.renameCheckbox(findWhatPanel, FindBundle.message((String)"find.what.fields.usages.checkbox", (Object[])new Object[0]), KotlinBundle.message("find.what.properties.usages.checkbox", new Object[0]));
        Utils.removeCheckbox(findWhatPanel, FindBundle.message((String)"find.what.implementing.classes.checkbox", (Object[])new Object[0]));
        Utils.removeCheckbox(findWhatPanel, FindBundle.message((String)"find.what.derived.interfaces.checkbox", (Object[])new Object[0]));
        Utils.removeCheckbox(findWhatPanel, FindBundle.message((String)"find.what.derived.classes.checkbox", (Object[])new Object[0]));
        this.derivedClasses = this.addCheckboxToPanel(KotlinBundle.message("find.what.derived.classes.checkbox", new Object[0]), this.getFindUsagesOptions().isDerivedClasses, findWhatPanel, true);
        this.derivedTraits = this.addCheckboxToPanel(KotlinBundle.message("find.what.derived.interfaces.checkbox", new Object[0]), this.getFindUsagesOptions().isDerivedInterfaces, findWhatPanel, true);
        this.constructorUsages = this.addCheckboxToPanel(KotlinBundle.message("find.what.constructor.usages.checkbox", new Object[0]), this.getFindUsagesOptions().getSearchConstructorUsages(), findWhatPanel, true);
        return findWhatPanel;
    }

    @NotNull
    protected KotlinClassFindUsagesOptions getFindUsagesOptions() {
        KotlinClassFindUsagesOptions kotlinClassFindUsagesOptions = (KotlinClassFindUsagesOptions)super.getFindUsagesOptions();
        if (kotlinClassFindUsagesOptions == null) {
            KotlinFindClassUsagesDialog.$$$reportNull$$$0(3);
        }
        return kotlinClassFindUsagesOptions;
    }

    public void configureLabelComponent(@NotNull SimpleColoredComponent coloredComponent) {
        PsiElement klass2;
        KtClassOrObject originalClass;
        if (coloredComponent == null) {
            KotlinFindClassUsagesDialog.$$$reportNull$$$0(4);
        }
        KtClassOrObject ktClassOrObject = originalClass = (klass2 = LightClassUtilsKt.getUnwrapped(this.getPsiElement())) instanceof KtClassOrObject ? (KtClassOrObject)klass2 : (KtClassOrObject)klass2.getUserData(ORIGINAL_CLASS);
        if (originalClass != null) {
            coloredComponent.append(RenderingUtilsKt.formatClass(originalClass));
        }
    }

    protected void update() {
        super.update();
        if (!this.isOKActionEnabled() && (this.constructorUsages.isSelected() || this.derivedTraits.isSelected() || this.derivedClasses.isSelected())) {
            this.setOKActionEnabled(true);
        }
    }

    public void calcFindUsagesOptions(JavaClassFindUsagesOptions options2) {
        super.calcFindUsagesOptions(options2);
        KotlinClassFindUsagesOptions kotlinOptions = (KotlinClassFindUsagesOptions)options2;
        kotlinOptions.setSearchConstructorUsages(this.constructorUsages.isSelected());
        kotlinOptions.isDerivedClasses = this.derivedClasses.isSelected();
        kotlinOptions.isDerivedInterfaces = this.derivedTraits.isSelected();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classOrObject";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/idea/findUsages/dialogs/KotlinFindClassUsagesDialog";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coloredComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/idea/findUsages/dialogs/KotlinFindClassUsagesDialog";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRepresentingPsiClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFindUsagesOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRepresentingPsiClass";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "configureLabelComponent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

