/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.internal.statistic.AbstractProjectsUsagesCollector;
import com.intellij.internal.statistic.beans.GroupDescriptor;
import com.intellij.internal.statistic.beans.UsageDescriptor;
import com.intellij.internal.statistic.utils.StatisticsUtilKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonBlockKt;
import org.jetbrains.kotlin.idea.formatter.KotlinCommonCodeStyleSettings;
import org.jetbrains.kotlin.idea.formatter.KotlinLanguageCodeStyleSettingsProvider;
import org.jetbrains.kotlin.idea.formatter.KotlinStyleGuideCodeStyle;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\u00020\u0001:\u0002\u000e\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinFormatterUsageCollector;", "Lcom/intellij/internal/statistic/AbstractProjectsUsagesCollector;", "()V", "getEnumStringPropertyUsage", "Lcom/intellij/internal/statistic/beans/UsageDescriptor;", "key", "", "value", "getGroupId", "Lcom/intellij/internal/statistic/beans/GroupDescriptor;", "getProjectUsages", "", "project", "Lcom/intellij/openapi/project/Project;", "Companion", "KotlinFormatterKind", "idea"})
public final class KotlinFormatterUsageCollector
extends AbstractProjectsUsagesCollector {
    private static final String GROUP_ID = "kotlin.formatter";
    private static final CommonCodeStyleSettings KOTLIN_DEFAULT_COMMON;
    private static final Object KOTLIN_DEFAULT_CUSTOM;
    public static final Companion Companion;

    @NotNull
    public GroupDescriptor getGroupId() {
        GroupDescriptor groupDescriptor = GroupDescriptor.create((String)GROUP_ID);
        Intrinsics.checkExpressionValueIsNotNull((Object)groupDescriptor, (String)"GroupDescriptor.create(GROUP_ID)");
        return groupDescriptor;
    }

    @NotNull
    public Set<UsageDescriptor> getProjectUsages(@NotNull Project project) {
        CodeStyleSettings settings2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        KotlinFormatterKind usedFormatter = Companion.getKotlinFormatterKind(project);
        CodeStyleSettings codeStyleSettings = settings2 = CodeStyleSettingsManager.getSettings((Project)project);
        Intrinsics.checkExpressionValueIsNotNull((Object)codeStyleSettings, (String)"settings");
        KotlinCommonCodeStyleSettings kotlinCommonSettings = KotlinCommonBlockKt.getKotlinCommonSettings(codeStyleSettings);
        KotlinCodeStyleSettings kotlinCustomSettings = KotlinCommonBlockKt.getKotlinCustomSettings(settings2);
        Object[] objectArray = new UsageDescriptor[2];
        objectArray[0] = StatisticsUtilKt.getEnumUsage((String)"kotlin.formatter.kind", (Enum)usedFormatter);
        String string = kotlinCustomSettings.CODE_STYLE_DEFAULTS;
        if (string == null) {
            string = kotlinCommonSettings.CODE_STYLE_DEFAULTS;
        }
        objectArray[1] = this.getEnumStringPropertyUsage("kotlin.formatter.defaults", string);
        return SetsKt.setOf((Object[])objectArray);
    }

    private final UsageDescriptor getEnumStringPropertyUsage(String key, String value2) {
        StringBuilder stringBuilder = new StringBuilder().append(key).append(".");
        String string = String.valueOf(value2);
        Locale locale = Locale.ENGLISH;
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"java.util.Locale.ENGLISH");
        Locale locale2 = locale;
        StringBuilder stringBuilder2 = stringBuilder;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.toLowerCase(locale2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
        String string4 = string3;
        int n = 1;
        String string5 = stringBuilder2.append(string4).toString();
        return new UsageDescriptor(string5, n);
    }

    static {
        Object object;
        Companion = new Companion(null);
        CommonCodeStyleSettings it = object = new KotlinLanguageCodeStyleSettingsProvider().getDefaultCommonSettings();
        KotlinStyleGuideCodeStyle.Companion.applyToCommonSettings$default(KotlinStyleGuideCodeStyle.Companion, it, false, 2, null);
        KOTLIN_DEFAULT_COMMON = object;
        CommonCodeStyleSettings commonCodeStyleSettings = it = (object = KotlinCodeStyleSettings.DEFAULT.clone());
        if (commonCodeStyleSettings == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.core.formatter.KotlinCodeStyleSettings");
        }
        KotlinStyleGuideCodeStyle.Companion.applyToKotlinCustomSettings$default(KotlinStyleGuideCodeStyle.Companion, (KotlinCodeStyleSettings)commonCodeStyleSettings, false, 2, null);
        KOTLIN_DEFAULT_CUSTOM = object;
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinFormatterUsageCollector$KotlinFormatterKind;", "", "(Ljava/lang/String;I)V", "IDEA_DEFAULT", "IDEA_CUSTOM", "IDEA_KOTLIN_WITH_CUSTOM", "IDEA_KOTLIN", "PROJECT_DEFAULT", "PROJECT_CUSTOM", "PROJECT_KOTLIN_WITH_CUSTOM", "PROJECT_KOTLIN", "idea"})
    public static final class KotlinFormatterKind
    extends Enum<KotlinFormatterKind> {
        public static final /* enum */ KotlinFormatterKind IDEA_DEFAULT;
        public static final /* enum */ KotlinFormatterKind IDEA_CUSTOM;
        public static final /* enum */ KotlinFormatterKind IDEA_KOTLIN_WITH_CUSTOM;
        public static final /* enum */ KotlinFormatterKind IDEA_KOTLIN;
        public static final /* enum */ KotlinFormatterKind PROJECT_DEFAULT;
        public static final /* enum */ KotlinFormatterKind PROJECT_CUSTOM;
        public static final /* enum */ KotlinFormatterKind PROJECT_KOTLIN_WITH_CUSTOM;
        public static final /* enum */ KotlinFormatterKind PROJECT_KOTLIN;
        private static final /* synthetic */ KotlinFormatterKind[] $VALUES;

        static {
            KotlinFormatterKind[] kotlinFormatterKindArray = new KotlinFormatterKind[8];
            KotlinFormatterKind[] kotlinFormatterKindArray2 = kotlinFormatterKindArray;
            kotlinFormatterKindArray[0] = IDEA_DEFAULT = new KotlinFormatterKind();
            kotlinFormatterKindArray[1] = IDEA_CUSTOM = new KotlinFormatterKind();
            kotlinFormatterKindArray[2] = IDEA_KOTLIN_WITH_CUSTOM = new KotlinFormatterKind();
            kotlinFormatterKindArray[3] = IDEA_KOTLIN = new KotlinFormatterKind();
            kotlinFormatterKindArray[4] = PROJECT_DEFAULT = new KotlinFormatterKind();
            kotlinFormatterKindArray[5] = PROJECT_CUSTOM = new KotlinFormatterKind();
            kotlinFormatterKindArray[6] = PROJECT_KOTLIN_WITH_CUSTOM = new KotlinFormatterKind();
            kotlinFormatterKindArray[7] = PROJECT_KOTLIN = new KotlinFormatterKind();
            $VALUES = kotlinFormatterKindArray;
        }

        public static KotlinFormatterKind[] values() {
            return (KotlinFormatterKind[])$VALUES.clone();
        }

        public static KotlinFormatterKind valueOf(String string) {
            return Enum.valueOf(KotlinFormatterKind.class, string);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/KotlinFormatterUsageCollector$Companion;", "", "()V", "GROUP_ID", "", "KOTLIN_DEFAULT_COMMON", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "getKOTLIN_DEFAULT_COMMON", "()Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings;", "KOTLIN_DEFAULT_CUSTOM", "getKOTLIN_DEFAULT_CUSTOM", "()Ljava/lang/Object;", "getKotlinFormatterKind", "Lorg/jetbrains/kotlin/idea/formatter/KotlinFormatterUsageCollector$KotlinFormatterKind;", "project", "Lcom/intellij/openapi/project/Project;", "idea"})
    public static final class Companion {
        private final CommonCodeStyleSettings getKOTLIN_DEFAULT_COMMON() {
            return KOTLIN_DEFAULT_COMMON;
        }

        private final Object getKOTLIN_DEFAULT_CUSTOM() {
            return KOTLIN_DEFAULT_CUSTOM;
        }

        @NotNull
        public final KotlinFormatterKind getKotlinFormatterKind(@NotNull Project project) {
            CodeStyleSettings it;
            boolean isOnlyKotlinStyle;
            CodeStyleSettings settings2;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            boolean isProject = CodeStyleSettingsManager.getInstance((Project)project).USE_PER_PROJECT_SETTINGS;
            CodeStyleSettings codeStyleSettings = settings2 = CodeStyleSettingsManager.getSettings((Project)project);
            Intrinsics.checkExpressionValueIsNotNull((Object)codeStyleSettings, (String)"settings");
            KotlinCommonCodeStyleSettings kotlinCommonSettings = KotlinCommonBlockKt.getKotlinCommonSettings(codeStyleSettings);
            KotlinCodeStyleSettings kotlinCustomSettings = KotlinCommonBlockKt.getKotlinCustomSettings(settings2);
            boolean isDefaultKotlinCommonSettings = Intrinsics.areEqual((Object)((Object)kotlinCommonSettings), (Object)new KotlinLanguageCodeStyleSettingsProvider().getDefaultCommonSettings());
            boolean isDefaultKotlinCustomSettings = Intrinsics.areEqual((Object)((Object)kotlinCustomSettings), (Object)((Object)KotlinCodeStyleSettings.DEFAULT));
            if (isDefaultKotlinCommonSettings && isDefaultKotlinCustomSettings) {
                return isProject ? KotlinFormatterKind.PROJECT_DEFAULT : KotlinFormatterKind.IDEA_DEFAULT;
            }
            boolean bl = isOnlyKotlinStyle = Intrinsics.areEqual((Object)((Object)kotlinCommonSettings), (Object)this.getKOTLIN_DEFAULT_COMMON()) && Intrinsics.areEqual((Object)((Object)kotlinCustomSettings), (Object)this.getKOTLIN_DEFAULT_CUSTOM());
            if (isOnlyKotlinStyle) {
                return isProject ? KotlinFormatterKind.PROJECT_KOTLIN : KotlinFormatterKind.IDEA_KOTLIN;
            }
            CodeStyleSettings codeStyleSettings2 = settings2.clone();
            CodeStyleSettings codeStyleSettings3 = settings2;
            CodeStyleSettings codeStyleSettings4 = it = codeStyleSettings2;
            Intrinsics.checkExpressionValueIsNotNull((Object)codeStyleSettings4, (String)"it");
            KotlinStyleGuideCodeStyle.Companion.apply(codeStyleSettings4);
            CodeStyleSettings codeStyleSettings5 = codeStyleSettings2;
            boolean isKotlinLikeSettings = Intrinsics.areEqual((Object)codeStyleSettings3, (Object)codeStyleSettings5);
            if (isKotlinLikeSettings) {
                return isProject ? KotlinFormatterKind.PROJECT_KOTLIN_WITH_CUSTOM : KotlinFormatterKind.IDEA_KOTLIN_WITH_CUSTOM;
            }
            return isProject ? KotlinFormatterKind.PROJECT_CUSTOM : KotlinFormatterKind.IDEA_CUSTOM;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

