/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.MayBeConstantInspection$WhenMappings;
import org.jetbrains.kotlin.idea.quickfix.AddConstModifierFix;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.ErrorValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluatorKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.AnnotationUtilKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0002\t\nB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/MayBeConstantInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "Companion", "Status", "idea"})
public final class MayBeConstantInspection
extends AbstractKotlinInspection {
    public static final Companion Companion = new Companion(null);

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return VisitorWrappersKt.propertyVisitor((Function1<? super KtProperty, Unit>)((Function1)new Function1<KtProperty, Unit>(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtProperty property2) {
                Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
                Status status2 = MayBeConstantInspection.Companion.getStatus(property2);
                switch (MayBeConstantInspection$WhenMappings.$EnumSwitchMapping$0[status2.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        return;
                    }
                    case 5: 
                    case 6: {
                        PsiElement psiElement2 = property2.getNameIdentifier();
                        if (psiElement2 == null) {
                            psiElement2 = property2;
                        }
                        this.$holder.registerProblem(psiElement2, status2 == Status.JVM_FIELD_MIGHT_BE_CONST ? "'const' might be used instead of '@JvmField'" : "Might be 'const'", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{(LocalQuickFix)new IntentionWrapper((IntentionAction)new AddConstModifierFix(property2), property2.getContainingFile())});
                    }
                }
            }
            {
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/MayBeConstantInspection$Status;", "", "(Ljava/lang/String;I)V", "NONE", "MIGHT_BE_CONST", "MIGHT_BE_CONST_ERRONEOUS", "JVM_FIELD_MIGHT_BE_CONST", "JVM_FIELD_MIGHT_BE_CONST_NO_INITIALIZER", "JVM_FIELD_MIGHT_BE_CONST_ERRONEOUS", "idea"})
    public static final class Status
    extends Enum<Status> {
        public static final /* enum */ Status NONE;
        public static final /* enum */ Status MIGHT_BE_CONST;
        public static final /* enum */ Status MIGHT_BE_CONST_ERRONEOUS;
        public static final /* enum */ Status JVM_FIELD_MIGHT_BE_CONST;
        public static final /* enum */ Status JVM_FIELD_MIGHT_BE_CONST_NO_INITIALIZER;
        public static final /* enum */ Status JVM_FIELD_MIGHT_BE_CONST_ERRONEOUS;
        private static final /* synthetic */ Status[] $VALUES;

        static {
            Status[] statusArray = new Status[6];
            Status[] statusArray2 = statusArray;
            statusArray[0] = NONE = new Status();
            statusArray[1] = MIGHT_BE_CONST = new Status();
            statusArray[2] = MIGHT_BE_CONST_ERRONEOUS = new Status();
            statusArray[3] = JVM_FIELD_MIGHT_BE_CONST = new Status();
            statusArray[4] = JVM_FIELD_MIGHT_BE_CONST_NO_INITIALIZER = new Status();
            statusArray[5] = JVM_FIELD_MIGHT_BE_CONST_ERRONEOUS = new Status();
            $VALUES = statusArray;
        }

        public static Status[] values() {
            return (Status[])$VALUES.clone();
        }

        public static Status valueOf(String string) {
            return Enum.valueOf(Status.class, string);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/MayBeConstantInspection$Companion;", "", "()V", "getStatus", "Lorg/jetbrains/kotlin/idea/inspections/MayBeConstantInspection$Status;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "idea"})
    public static final class Companion {
        @NotNull
        public final Status getStatus(@NotNull KtProperty $receiver) {
            Status status2;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            if ($receiver.isLocal() || $receiver.isVar() || $receiver.getGetter() != null || $receiver.hasModifier(KtTokens.CONST_KEYWORD) || $receiver.hasModifier(KtTokens.OVERRIDE_KEYWORD)) {
                return Status.NONE;
            }
            if (!$receiver.isTopLevel() && !(KtPsiUtilKt.getContainingClassOrObject($receiver) instanceof KtObjectDeclaration)) {
                return Status.NONE;
            }
            KtExpression initializer2 = $receiver.getInitializer();
            KtExpression ktExpression = initializer2;
            if (ktExpression == null) {
                ktExpression = $receiver;
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"(initializer ?: this)");
            BindingContext context = ResolutionUtils.analyze(ktExpression, BodyResolveMode.PARTIAL);
            DeclarationDescriptor declarationDescriptor = context.get(BindingContext.DECLARATION_TO_DESCRIPTOR, $receiver);
            if (!(declarationDescriptor instanceof VariableDescriptor)) {
                declarationDescriptor = null;
            }
            VariableDescriptor variableDescriptor = (VariableDescriptor)declarationDescriptor;
            if (variableDescriptor == null) {
                return Status.NONE;
            }
            VariableDescriptor propertyDescriptor = variableDescriptor;
            boolean withJvmField = AnnotationUtilKt.hasJvmFieldAnnotation(propertyDescriptor);
            List<KtAnnotationEntry> list2 = $receiver.getAnnotationEntries();
            Intrinsics.checkExpressionValueIsNotNull(list2, (String)"annotationEntries");
            Collection collection = list2;
            if (!collection.isEmpty() && !withJvmField) {
                return Status.NONE;
            }
            if (initializer2 != null) {
                ConstantValue<?> constantValue;
                CompileTimeConstant<?> compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant(initializer2, context);
                if (compileTimeConstant == null) {
                    return Status.NONE;
                }
                CompileTimeConstant<?> compileTimeConstant2 = compileTimeConstant;
                boolean erroneousConstant = compileTimeConstant2.getUsesNonConstValAsConstant();
                KotlinType kotlinType = propertyDescriptor.getType();
                Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"propertyDescriptor.type");
                ConstantValue<?> it = constantValue = compileTimeConstant2.toConstantValue(kotlinType);
                if ((!ConstantExpressionEvaluatorKt.isStandaloneOnlyConstant(it) && !(it instanceof NullValue) && !(it instanceof ErrorValue) ? constantValue : null) == null) {
                    return Status.NONE;
                }
                status2 = withJvmField ? (erroneousConstant ? Status.JVM_FIELD_MIGHT_BE_CONST_ERRONEOUS : Status.JVM_FIELD_MIGHT_BE_CONST) : (erroneousConstant ? Status.MIGHT_BE_CONST_ERRONEOUS : Status.MIGHT_BE_CONST);
            } else {
                status2 = withJvmField ? Status.JVM_FIELD_MIGHT_BE_CONST_NO_INITIALIZER : Status.NONE;
            }
            return status2;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

