/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.formatter.CollectChangesWithoutApplyModelKt;
import org.jetbrains.kotlin.idea.formatter.FormattingChange;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J/\u0010\u0003\u001a\f\u0012\u0006\b\u0001\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010\fJ\u0018\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReformatInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "isEmptyLineReformat", "whitespace", "Lcom/intellij/psi/PsiWhiteSpace;", "change", "Lorg/jetbrains/kotlin/idea/formatter/FormattingChange;", "ReformatQuickFix", "idea"})
public final class ReformatInspection
extends LocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        PsiElement psiElement2;
        PsiElement it;
        Collection collection;
        Iterable $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        if (!(file2 instanceof KtFile) || !ProjectRootsUtil.isInProjectSource((PsiElement)file2)) {
            return null;
        }
        Set<FormattingChange> changes = CollectChangesWithoutApplyModelKt.collectFormattingChanges(file2);
        if (changes.isEmpty()) {
            return null;
        }
        Iterable iterable = $receiver$iv = (Iterable)changes;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            Object object;
            int n;
            FormattingChange formattingChange = (FormattingChange)item$iv$iv;
            collection = destination$iv$iv;
            PsiElement psiElement3 = it;
            if (psiElement3 instanceof FormattingChange.ShiftIndentInsideRange) {
                n = ((FormattingChange.ShiftIndentInsideRange)it).getRange().getStartOffset();
            } else if (psiElement3 instanceof FormattingChange.ReplaceWhiteSpace) {
                n = ((FormattingChange.ReplaceWhiteSpace)it).getTextRange().getStartOffset();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            int rangeOffset = n;
            if (file2.findElementAt(rangeOffset) == null) {
                object = null;
            } else {
                PsiElement leaf;
                PsiElement psiElement4 = leaf;
                Intrinsics.checkExpressionValueIsNotNull((Object)psiElement4, (String)"leaf");
                object = !psiElement4.isValid() ? null : (leaf instanceof PsiWhiteSpace && this.isEmptyLineReformat((PsiWhiteSpace)leaf, (FormattingChange)it) ? null : leaf);
            }
            psiElement2 = object;
            collection.add(psiElement2);
        }
        List elements2 = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
        $receiver$iv$iv = $receiver$iv = (Iterable)elements2;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (PsiElement)item$iv$iv;
            collection = destination$iv$iv;
            psiElement2 = new ProblemDescriptorImpl(it, it, "File is not properly formatted", (LocalQuickFix[])new ReformatQuickFix[]{ReformatQuickFix.INSTANCE}, ProblemHighlightType.WEAK_WARNING, false, null, isOnTheFly);
            collection.add(psiElement2);
        }
        $receiver$iv = (List)destination$iv$iv;
        Iterable thisCollection$iv = $receiver$iv;
        ProblemDescriptorImpl[] problemDescriptorImplArray = thisCollection$iv.toArray(new ProblemDescriptorImpl[0]);
        if (problemDescriptorImplArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return (ProblemDescriptor[])problemDescriptorImplArray;
    }

    private final boolean isEmptyLineReformat(PsiWhiteSpace whitespace, FormattingChange change) {
        char it;
        char element$iv;
        int n;
        if (!(change instanceof FormattingChange.ReplaceWhiteSpace)) {
            return false;
        }
        String beforeText = whitespace.getText();
        String afterText = ((FormattingChange.ReplaceWhiteSpace)change).getWhiteSpace();
        String string = beforeText;
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"beforeText");
        CharSequence $receiver$iv = string;
        int count$iv = 0;
        CharSequence charSequence = $receiver$iv;
        for (n = 0; n < charSequence.length(); ++n) {
            element$iv = charSequence.charAt(n);
            it = element$iv;
            if (!(it == '\n')) continue;
            ++count$iv;
        }
        $receiver$iv = afterText;
        int n2 = count$iv;
        count$iv = 0;
        charSequence = $receiver$iv;
        for (n = 0; n < charSequence.length(); ++n) {
            element$iv = charSequence.charAt(n);
            it = element$iv;
            if (!(it == '\n')) continue;
            ++count$iv;
        }
        int n3 = count$iv;
        return n2 == n3 && Intrinsics.areEqual((Object)StringsKt.substringAfterLast$default((String)beforeText, (char)'\n', null, (int)2, null), (Object)StringsKt.substringAfterLast$default((String)afterText, (char)'\n', null, (int)2, null));
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReformatInspection$ReformatQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "idea"})
    private static final class ReformatQuickFix
    implements LocalQuickFix {
        public static final ReformatQuickFix INSTANCE;

        @NotNull
        public String getFamilyName() {
            return "Reformat File";
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)descriptor2, (String)"descriptor");
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
            PsiElement psiElement2 = descriptor2.getPsiElement();
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"descriptor.psiElement");
            codeStyleManager.reformat((PsiElement)psiElement2.getContainingFile());
        }

        private ReformatQuickFix() {
        }

        static {
            ReformatQuickFix reformatQuickFix;
            INSTANCE = reformatQuickFix = new ReformatQuickFix();
        }
    }
}

