/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.inspections.RemoveRedundantSpreadOperatorQuickfix;
import org.jetbrains.kotlin.idea.intentions.UtilsKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCollectionLiteralExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RemoveRedundantSpreadOperatorInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "idea"})
public final class RemoveRedundantSpreadOperatorInspection
extends AbstractKotlinInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        return VisitorWrappersKt.valueArgumentVisitor((Function1<? super KtValueArgument, Unit>)((Function1)new Function1<KtValueArgument, Unit>(holder, isOnTheFly){
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isOnTheFly;

            public final void invoke(@NotNull KtValueArgument argument2) {
                int n;
                Intrinsics.checkParameterIsNotNull((Object)argument2, (String)"argument");
                LeafPsiElement leafPsiElement = argument2.getSpreadElement();
                if (leafPsiElement == null) {
                    return;
                }
                LeafPsiElement spreadElement = leafPsiElement;
                if (argument2.isNamed()) {
                    return;
                }
                KtExpression ktExpression = argument2.getArgumentExpression();
                if (ktExpression == null) {
                    return;
                }
                KtExpression argumentExpression2 = ktExpression;
                int argumentOffset = PsiUtilsKt.getStartOffset((PsiElement)argument2);
                LeafPsiElement leafPsiElement2 = spreadElement;
                Intrinsics.checkExpressionValueIsNotNull((Object)leafPsiElement2, (String)"spreadElement");
                int startOffset = leafPsiElement2.getStartOffset() - argumentOffset;
                KtExpression ktExpression2 = argumentExpression2;
                if (ktExpression2 instanceof KtCallExpression) {
                    KtExpression ktExpression3 = argumentExpression2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression3, (String)"argumentExpression");
                    if (!UtilsKt.isArrayOfMethod((KtCallExpression)ktExpression3)) {
                        return;
                    }
                    KtExpression ktExpression4 = ((KtCallExpression)argumentExpression2).getCalleeExpression();
                    if (ktExpression4 == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression4, (String)"argumentExpression.calleeExpression!!");
                    n = PsiUtilsKt.getEndOffset((PsiElement)ktExpression4) - argumentOffset;
                } else if (ktExpression2 instanceof KtCollectionLiteralExpression) {
                    n = startOffset + 1;
                } else {
                    return;
                }
                int endOffset = n;
                ProblemDescriptor problemDescriptor = this.$holder.getManager().createProblemDescriptor((PsiElement)argument2, new TextRange(startOffset, endOffset), "Remove redundant spread operator", ProblemHighlightType.LIKE_UNUSED_SYMBOL, this.$isOnTheFly, new LocalQuickFix[]{new RemoveRedundantSpreadOperatorQuickfix()});
                this.$holder.registerProblem(problemDescriptor);
            }
            {
                this.$holder = problemsHolder;
                this.$isOnTheFly = bl;
                super(1);
            }
        }));
    }
}

