/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.analysis.AnalyzerUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.util.psi.patternMatching.KotlinPsiUnifierKt;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0002J!\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u0005H\u0082\u0010J \u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u001b\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006!"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceWithOperatorAssignmentInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtBinaryExpression;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "element", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "buildOperatorAssignment", "buildOperatorAssignmentText", "variableExpression", "Lorg/jetbrains/kotlin/psi/KtNameReferenceExpression;", "expression", "tail", "checkExpressionRepeat", "", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "fixText", "inspectionText", "isApplicable", "isArithmeticOperation", "operationToken", "Lcom/intellij/psi/tree/IElementType;", "isCommutative", "idea"})
public final class ReplaceWithOperatorAssignmentInspection
extends AbstractApplicabilityBasedInspection<KtBinaryExpression> {
    @NotNull
    private final String defaultFixText = "Replace with operator-assignment";

    @Override
    public boolean isApplicable(@NotNull KtBinaryExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (Intrinsics.areEqual((Object)element3.getOperationToken(), (Object)((Object)KtTokens.EQ)) ^ true) {
            return false;
        }
        KtExpression ktExpression = element3.getLeft();
        if (!(ktExpression instanceof KtNameReferenceExpression)) {
            ktExpression = null;
        }
        KtNameReferenceExpression ktNameReferenceExpression = (KtNameReferenceExpression)ktExpression;
        if (ktNameReferenceExpression == null) {
            return false;
        }
        KtNameReferenceExpression left = ktNameReferenceExpression;
        KtExpression ktExpression2 = element3.getRight();
        if (!(ktExpression2 instanceof KtBinaryExpression)) {
            ktExpression2 = null;
        }
        KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)ktExpression2;
        if (ktBinaryExpression == null) {
            return false;
        }
        KtBinaryExpression right = ktBinaryExpression;
        if (right.getLeft() == null || right.getRight() == null) {
            return false;
        }
        BindingContext bindingContext2 = ResolutionUtils.analyze(right, BodyResolveMode.PARTIAL);
        if (!this.checkExpressionRepeat(left, right, bindingContext2)) {
            return false;
        }
        KtBinaryExpression opAssign = this.buildOperatorAssignment(element3);
        KtFile ktFile = opAssign.getContainingKtFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktFile, (String)"opAssign.containingKtFile");
        KtPsiFactoryKt.setDoNotAnalyze(ktFile, null);
        BindingContext newBindingContext = AnalyzerUtilKt.analyzeAsReplacement$default((KtExpression)opAssign, (KtExpression)element3, bindingContext2, null, null, null, 28, null);
        Diagnostics diagnostics2 = newBindingContext.getDiagnostics();
        KtOperationReferenceExpression ktOperationReferenceExpression = opAssign.getOperationReference();
        Intrinsics.checkExpressionValueIsNotNull((Object)ktOperationReferenceExpression, (String)"opAssign.operationReference");
        return diagnostics2.forElement((PsiElement)ktOperationReferenceExpression).isEmpty();
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtBinaryExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        return "Replaceable with operator-assignment";
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return this.defaultFixText;
    }

    @Override
    @NotNull
    public String fixText(@NotNull KtBinaryExpression element3) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        KtSingleValueToken ktSingleValueToken = element3.getOperationReference().getOperationSignTokenType();
        return "Replace with '" + (ktSingleValueToken != null ? ktSingleValueToken.getValue() : null) + "='";
    }

    /*
     * Unable to fully structure code
     */
    private final boolean checkExpressionRepeat(KtNameReferenceExpression variableExpression, KtBinaryExpression expression, BindingContext bindingContext) {
        block5: {
            block7: {
                block6: {
                    block4: {
                        v0 = (DeclarationDescriptor)bindingContext.get(BindingContext.REFERENCE_TARGET, expression.getOperationReference());
                        descriptor = v0 != null ? v0.getContainingDeclaration() : null;
                        isPrimitiveOperation = descriptor instanceof ClassDescriptor != false && KotlinBuiltIns.isPrimitiveType(((ClassDescriptor)descriptor).getDefaultType()) != false;
                        operationToken = expression.getOperationToken();
                        expressionLeft = expression.getLeft();
                        expressionRight = expression.getRight();
                        if (!KotlinPsiUnifierKt.matches((PsiElement)variableExpression, (PsiElement)expressionLeft)) break block4;
                        v1 = operationToken;
                        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"operationToken");
                        v2 = this.isArithmeticOperation(v1);
                        break block5;
                    }
                    if (!KotlinPsiUnifierKt.matches((PsiElement)variableExpression, (PsiElement)expressionRight)) break block6;
                    if (!isPrimitiveOperation) ** GOTO lbl-1000
                    v3 = operationToken;
                    Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"operationToken");
                    if (this.isCommutative(v3)) {
                        v2 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = false;
                    }
                    break block5;
                }
                if (!(expressionLeft instanceof KtBinaryExpression)) break block7;
                if (!Intrinsics.areEqual((Object)((KtBinaryExpression)expressionLeft).getOperationToken(), (Object)operationToken)) ** GOTO lbl-1000
                v4 = operationToken;
                Intrinsics.checkExpressionValueIsNotNull((Object)v4, (String)"operationToken");
                if (this.isCommutative(v4)) {
                    v5 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v5 = sameCommutativeOperation = false;
                }
                v2 = isPrimitiveOperation && sameCommutativeOperation && this.checkExpressionRepeat(variableExpression, (KtBinaryExpression)expressionLeft, bindingContext);
                break block5;
            }
            v2 = false;
        }
        return v2;
    }

    private final boolean isCommutative(IElementType operationToken) {
        return Intrinsics.areEqual((Object)operationToken, (Object)((Object)KtTokens.PLUS)) || Intrinsics.areEqual((Object)operationToken, (Object)((Object)KtTokens.MUL));
    }

    private final boolean isArithmeticOperation(IElementType operationToken) {
        return Intrinsics.areEqual((Object)operationToken, (Object)((Object)KtTokens.PLUS)) || Intrinsics.areEqual((Object)operationToken, (Object)((Object)KtTokens.MINUS)) || Intrinsics.areEqual((Object)operationToken, (Object)((Object)KtTokens.MUL)) || Intrinsics.areEqual((Object)operationToken, (Object)((Object)KtTokens.DIV)) || Intrinsics.areEqual((Object)operationToken, (Object)((Object)KtTokens.PERC));
    }

    @Override
    public void applyTo(@NotNull PsiElement element3, @NotNull Project project, @Nullable Editor editor) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            PsiElement psiElement2 = element3;
            if (!(psiElement2 instanceof KtBinaryExpression)) {
                psiElement2 = null;
            }
            KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)psiElement2;
            if (ktBinaryExpression == null) break block1;
            ktBinaryExpression.replace((PsiElement)this.buildOperatorAssignment((KtBinaryExpression)element3));
        }
    }

    private final KtBinaryExpression buildOperatorAssignment(KtBinaryExpression element3) {
        KtExpression ktExpression = element3.getLeft();
        if (ktExpression == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtNameReferenceExpression");
        }
        KtExpression ktExpression2 = element3.getRight();
        if (ktExpression2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
        }
        String replacement2 = this.buildOperatorAssignmentText((KtNameReferenceExpression)ktExpression, (KtBinaryExpression)ktExpression2, "");
        KtExpression ktExpression3 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)element3, false, 2, null).createExpression(replacement2);
        if (ktExpression3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
        }
        return (KtBinaryExpression)ktExpression3;
    }

    private final String buildOperatorAssignmentText(KtNameReferenceExpression variableExpression, KtBinaryExpression expression2, String tail) {
        String string;
        block7: {
            while (true) {
                KtOperationReferenceExpression ktOperationReferenceExpression = expression2.getOperationReference();
                Intrinsics.checkExpressionValueIsNotNull((Object)ktOperationReferenceExpression, (String)"expression.operationReference");
                String operationText = ktOperationReferenceExpression.getText();
                String variableName = variableExpression.getText();
                Function1<String, String> appendTail$ = new Function1<String, String>(tail){
                    final /* synthetic */ String $tail;

                    @NotNull
                    public final String invoke(@NotNull String $receiver) {
                        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                        CharSequence charSequence = this.$tail;
                        return charSequence.length() == 0 ? $receiver : "" + $receiver + ' ' + this.$tail;
                    }
                    {
                        this.$tail = string;
                        super(1);
                    }
                };
                if (KotlinPsiUnifierKt.matches((PsiElement)variableExpression, (PsiElement)expression2.getLeft())) {
                    StringBuilder stringBuilder = new StringBuilder().append("").append(variableName).append(' ').append(operationText).append("= ");
                    KtExpression ktExpression = expression2.getRight();
                    if (ktExpression == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.right!!");
                    string = appendTail$.invoke(stringBuilder.append(ktExpression.getText()).toString());
                    break block7;
                }
                if (KotlinPsiUnifierKt.matches((PsiElement)variableExpression, (PsiElement)expression2.getRight())) {
                    StringBuilder stringBuilder = new StringBuilder().append("").append(variableName).append(' ').append(operationText).append("= ");
                    KtExpression ktExpression = expression2.getLeft();
                    if (ktExpression == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression, (String)"expression.left!!");
                    string = appendTail$.invoke(stringBuilder.append(ktExpression.getText()).toString());
                    break block7;
                }
                if (!(expression2.getLeft() instanceof KtBinaryExpression)) break;
                KtExpression ktExpression = expression2.getLeft();
                if (ktExpression == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtBinaryExpression");
                }
                KtBinaryExpression ktBinaryExpression = (KtBinaryExpression)ktExpression;
                StringBuilder stringBuilder = new StringBuilder().append("").append(operationText).append(' ');
                KtExpression ktExpression2 = expression2.getRight();
                if (ktExpression2 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"expression.right!!");
                tail = appendTail$.invoke(stringBuilder.append(ktExpression2.getText()).toString());
                expression2 = ktBinaryExpression;
            }
            string = tail;
        }
        return string;
    }

    public ReplaceWithOperatorAssignmentInspection() {
        super(KtBinaryExpression.class);
    }
}

