/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.gradle;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrLiteral;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrString;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrCallExpression;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\n\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\u0005J\u001a\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\tH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/gradle/GradleHeuristicHelper;", "", "()V", "findStatementWithPrefix", "", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/path/GrCallExpression;", "closure", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/blocks/GrClosableBlock;", "prefix", "", "getHeuristicVersionInBuildScriptDependency", "classpathStatement", "resolveVariableInBuildScript", "name", "idea-gradle"})
public final class GradleHeuristicHelper {
    public static final GradleHeuristicHelper INSTANCE;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String getHeuristicVersionInBuildScriptDependency(@NotNull GrCallExpression classpathStatement) {
        GrArgumentList argumentList2;
        GrArgumentList grArgumentList;
        Intrinsics.checkParameterIsNotNull((Object)classpathStatement, (String)"classpathStatement");
        GrCallExpression grCallExpression = classpathStatement;
        if (grCallExpression instanceof GrMethodCall) {
            grArgumentList = ((GrMethodCall)classpathStatement).getArgumentList();
        } else {
            PsiElement $receiver$iv = (PsiElement)classpathStatement;
            PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$receiver$iv, GrCommandArgumentList.class);
            if (psiElementArray == null) {
                psiElementArray = new GrCommandArgumentList[]{};
            }
            grArgumentList = (GrArgumentList)ArraysKt.singleOrNull((Object[])psiElementArray);
        }
        if (grArgumentList == null) return null;
        GrArgumentList grArgumentList2 = argumentList2 = grArgumentList;
        Intrinsics.checkExpressionValueIsNotNull((Object)grArgumentList2, (String)"argumentList");
        PsiElement[] psiElementArray = grArgumentList2.getChildren();
        Intrinsics.checkExpressionValueIsNotNull((Object)psiElementArray, (String)"argumentList.children");
        Object object = ArraysKt.firstOrNull((Object[])psiElementArray);
        if (!(object instanceof GrLiteral)) {
            object = null;
        }
        GrLiteral grLiteral = (GrLiteral)object;
        if (grLiteral == null) return null;
        GrLiteral grLiteral2 = grLiteral;
        if (grLiteral2 instanceof GrString && ((Object[])((GrString)grLiteral2).getInjections()).length == 1) {
            GrReferenceExpression grReferenceExpression;
            GrStringInjection[] grStringInjectionArray = ((GrString)grLiteral2).getInjections();
            Intrinsics.checkExpressionValueIsNotNull((Object)grStringInjectionArray, (String)"grLiteral.injections");
            GrStringInjection grStringInjection = (GrStringInjection)ArraysKt.first((Object[])grStringInjectionArray);
            if (grStringInjection == null) return null;
            GrStringInjection versionInjection = grStringInjection;
            GrExpression grExpression = versionInjection.getExpression();
            if (!(grExpression instanceof GrReferenceExpression)) {
                grExpression = null;
            }
            if ((grReferenceExpression = (GrReferenceExpression)grExpression) == null) {
                GrReferenceExpression[] grReferenceExpressionArray = versionInjection.getClosableBlock();
                GrReferenceExpression[] grReferenceExpressionArray2 = grReferenceExpressionArray;
                if (grReferenceExpressionArray == null) return null;
                PsiElement $receiver$iv = (PsiElement)grReferenceExpressionArray2;
                PsiElement[] psiElementArray2 = PsiTreeUtil.getChildrenOfType((PsiElement)$receiver$iv, GrReferenceExpression.class);
                if (psiElementArray2 == null) {
                    psiElementArray2 = new GrReferenceExpression[]{};
                }
                GrReferenceExpression[] grReferenceExpressionArray3 = (GrReferenceExpression[])psiElementArray2;
                grReferenceExpressionArray2 = grReferenceExpressionArray3;
                if (grReferenceExpressionArray3 == null) return null;
                grReferenceExpression = (GrReferenceExpression)ArraysKt.singleOrNull((Object[])grReferenceExpressionArray2);
            }
            if (grReferenceExpression == null) return null;
            GrReferenceExpression expression2 = grReferenceExpression;
            String string = expression2.getText();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"expression.text");
            return this.resolveVariableInBuildScript(classpathStatement, string);
        }
        Object object2 = grLiteral2.getValue();
        if (object2 == null) return null;
        Object literalValue = object2;
        String versionText = StringsKt.substringAfterLast$default((String)literalValue.toString(), (char)':', null, (int)2, null);
        CharSequence charSequence = versionText;
        if (charSequence.length() == 0) {
            return null;
        }
        boolean bl = false;
        if (!bl) return versionText;
        return null;
    }

    private final String resolveVariableInBuildScript(GrCallExpression classpathStatement, String name2) {
        PsiElement $receiver$iv = (PsiElement)classpathStatement;
        GrClosableBlock grClosableBlock = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, GrClosableBlock.class, (boolean)true);
        if (grClosableBlock == null) {
            return null;
        }
        GrClosableBlock dependenciesClosure = grClosableBlock;
        PsiElement $receiver$iv2 = (PsiElement)dependenciesClosure;
        GrClosableBlock grClosableBlock2 = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv2, GrClosableBlock.class, (boolean)true);
        if (grClosableBlock2 == null) {
            return null;
        }
        GrClosableBlock buildScriptClosure = grClosableBlock2;
        for (PsiElement child : buildScriptClosure.getChildren()) {
            PsiElement psiElement2 = child;
            if (psiElement2 instanceof GrAssignmentExpression) {
                GrExpression assignValue;
                GrExpression grExpression = ((GrAssignmentExpression)child).getLValue();
                Intrinsics.checkExpressionValueIsNotNull((Object)grExpression, (String)"child.lValue");
                if (!Intrinsics.areEqual((Object)grExpression.getText(), (Object)("ext." + name2)) || !((assignValue = ((GrAssignmentExpression)child).getRValue()) instanceof GrLiteral)) continue;
                return String.valueOf(((GrLiteral)assignValue).getValue());
            }
            if (!(psiElement2 instanceof GrVariableDeclaration)) continue;
            GrVariable[] grVariableArray = ((GrVariableDeclaration)child).getVariables();
            int n = grVariableArray.length;
            for (int i = 0; i < n; ++i) {
                GrExpression assignValue;
                GrVariable variable2;
                GrVariable grVariable = variable2 = grVariableArray[i];
                Intrinsics.checkExpressionValueIsNotNull((Object)grVariable, (String)"variable");
                if (!Intrinsics.areEqual((Object)grVariable.getName(), (Object)name2) || !((assignValue = variable2.getInitializerGroovy()) instanceof GrLiteral)) continue;
                return String.valueOf(((GrLiteral)assignValue).getValue());
            }
        }
        return null;
    }

    @NotNull
    public final List<GrCallExpression> findStatementWithPrefix(@NotNull GrClosableBlock closure, @NotNull String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)closure, (String)"closure");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        PsiElement $receiver$iv = (PsiElement)closure;
        PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$receiver$iv, GrCallExpression.class);
        if (psiElementArray == null) {
            psiElementArray = new GrCallExpression[]{};
        }
        GrCallExpression[] applicationStatements = (GrCallExpression[])psiElementArray;
        ArrayList<GrCallExpression> classPathStatements = new ArrayList<GrCallExpression>();
        for (GrCallExpression statement2 : applicationStatements) {
            GrReferenceExpression startExpression;
            PsiElement $receiver$iv2 = (PsiElement)statement2;
            PsiElement[] psiElementArray2 = PsiTreeUtil.getChildrenOfType((PsiElement)$receiver$iv2, GrReferenceExpression.class);
            if (psiElementArray2 == null) {
                psiElementArray2 = new GrReferenceExpression[]{};
            }
            if ((GrReferenceExpression)ArraysKt.firstOrNull((Object[])psiElementArray2) == null) {
                continue;
            }
            if (!Intrinsics.areEqual((Object)prefix, (Object)startExpression.getText())) continue;
            classPathStatements.add(statement2);
        }
        return classPathStatements;
    }

    private GradleHeuristicHelper() {
    }

    static {
        GradleHeuristicHelper gradleHeuristicHelper;
        INSTANCE = gradleHeuristicHelper = new GradleHeuristicHelper();
    }
}

