/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.intentions;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.intentions.SelfTargetingIntention;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\rB\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/MoveLambdaOutsideParenthesesIntention;", "Lorg/jetbrains/kotlin/idea/intentions/SelfTargetingIntention;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "()V", "applyTo", "", "element", "editor", "Lcom/intellij/openapi/editor/Editor;", "isApplicableTo", "", "caretOffset", "", "Companion", "idea"})
public final class MoveLambdaOutsideParenthesesIntention
extends SelfTargetingIntention<KtCallExpression> {
    public static final Companion Companion = new Companion(null);

    @Override
    public boolean isApplicableTo(@NotNull KtCallExpression element3, int caretOffset) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        if (!PsiModificationUtilsKt.canMoveLambdaOutsideParentheses(element3)) {
            return false;
        }
        KtLambdaExpression ktLambdaExpression = PsiModificationUtilsKt.getLastLambdaExpression(element3);
        if (ktLambdaExpression == null) {
            return false;
        }
        KtLambdaExpression lambdaExpression2 = ktLambdaExpression;
        PsiElement $receiver$iv = (PsiElement)lambdaExpression2;
        KtValueArgument ktValueArgument = (KtValueArgument)PsiTreeUtil.getParentOfType((PsiElement)$receiver$iv, KtValueArgument.class, (boolean)true);
        if (ktValueArgument == null) {
            return false;
        }
        KtValueArgument argument2 = ktValueArgument;
        if (caretOffset < PsiUtilsKt.getStartOffset((PsiElement)argument2)) {
            return false;
        }
        KtBlockExpression ktBlockExpression = lambdaExpression2.getBodyExpression();
        if (ktBlockExpression == null || (ktBlockExpression = ktBlockExpression.getTextRange()) == null) {
            return true;
        }
        KtBlockExpression bodyRange = ktBlockExpression;
        return !PsiUtilsKt.containsInside((TextRange)bodyRange, caretOffset);
    }

    @Override
    public void applyTo(@NotNull KtCallExpression element3, @Nullable Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        PsiModificationUtilsKt.moveFunctionLiteralOutsideParentheses(element3);
    }

    public MoveLambdaOutsideParenthesesIntention() {
        super(KtCallExpression.class, "Move lambda argument out of parentheses", null, 4, null);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/intentions/MoveLambdaOutsideParenthesesIntention$Companion;", "", "()V", "moveFunctionLiteralOutsideParenthesesIfPossible", "", "expression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "idea"})
    public static final class Companion {
        public final void moveFunctionLiteralOutsideParenthesesIfPossible(@NotNull KtLambdaExpression expression2) {
            Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
            PsiElement psiElement2 = expression2.getParent();
            if (!(psiElement2 instanceof KtValueArgument)) {
                psiElement2 = null;
            }
            KtValueArgument ktValueArgument = (KtValueArgument)psiElement2;
            Object object = ktValueArgument != null ? ktValueArgument.getParent() : null;
            if (!(object instanceof KtValueArgumentList)) {
                object = null;
            }
            KtValueArgumentList ktValueArgumentList = (KtValueArgumentList)object;
            Object object2 = ktValueArgumentList != null ? ktValueArgumentList.getParent() : null;
            if (!(object2 instanceof KtCallExpression)) {
                object2 = null;
            }
            KtCallExpression ktCallExpression = (KtCallExpression)object2;
            if (ktCallExpression == null) {
                return;
            }
            KtCallExpression call2 = ktCallExpression;
            if (PsiModificationUtilsKt.canMoveLambdaOutsideParentheses(call2)) {
                PsiModificationUtilsKt.moveFunctionLiteralOutsideParentheses(call2);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

