/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\u0014\u0015B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ConvertCollectionFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "element", "type", "Lorg/jetbrains/kotlin/idea/quickfix/ConvertCollectionFix$CollectionType;", "(Lorg/jetbrains/kotlin/psi/KtExpression;Lorg/jetbrains/kotlin/idea/quickfix/ConvertCollectionFix$CollectionType;)V", "getType", "()Lorg/jetbrains/kotlin/idea/quickfix/ConvertCollectionFix$CollectionType;", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "CollectionType", "Companion", "idea"})
public final class ConvertCollectionFix
extends KotlinQuickFixAction<KtExpression> {
    @NotNull
    private final CollectionType type;
    private static final CollectionType[] TYPES;
    public static final Companion Companion;

    @NotNull
    public String getFamilyName() {
        return "Convert to " + this.type.getDisplayName();
    }

    @NotNull
    public String getText() {
        return "Convert expression to '" + this.type.getDisplayName() + "' by inserting '." + this.type.getFunctionCall() + '\'';
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
        block5: {
            Object object;
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            KtExpression ktExpression = (KtExpression)this.getElement();
            if (ktExpression == null) {
                return;
            }
            KtExpression expression2 = ktExpression;
            KtPsiFactory factory2 = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)expression2, false, 2, null);
            PsiElement psiElement2 = (PsiElement)expression2;
            PsiElement newElement$iv = (PsiElement)CreateByPatternKt.createExpressionByPattern$default(factory2, "$0.$1", new Object[]{expression2, this.type.getFunctionCall()}, false, 4, null);
            PsiElement result$iv = $receiver$iv.replace(newElement$iv);
            if (result$iv instanceof KtExpression) {
                object = result$iv;
            } else {
                PsiElement psiElement3 = result$iv;
                if (psiElement3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtParenthesizedExpression");
                }
                object = ((KtParenthesizedExpression)psiElement3).getExpression();
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                }
            }
            KtExpression replaced = (KtExpression)object;
            Editor editor2 = editor;
            if (editor2 == null || (editor2 = editor2.getCaretModel()) == null) break block5;
            editor2.moveToOffset(PsiUtilsKt.getEndOffset((PsiElement)replaced));
        }
    }

    @NotNull
    public final CollectionType getType() {
        return this.type;
    }

    public ConvertCollectionFix(@NotNull KtExpression element3, @NotNull CollectionType type2) {
        Intrinsics.checkParameterIsNotNull((Object)element3, (String)"element");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type2), (String)"type");
        super((PsiElement)element3);
        this.type = type2;
    }

    static {
        Companion = new Companion(null);
        TYPES = CollectionType.values();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0012\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B#\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0000R\u0011\u0010\b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\nR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015j\u0002\b\u0016\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ConvertCollectionFix$CollectionType;", "", "functionCall", "", "fqName", "Lorg/jetbrains/kotlin/name/FqName;", "nameOverride", "(Ljava/lang/String;ILjava/lang/String;Lorg/jetbrains/kotlin/name/FqName;Ljava/lang/String;)V", "displayName", "getDisplayName", "()Ljava/lang/String;", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "getFunctionCall", "specializeFor", "sourceType", "List", "Collection", "Iterable", "MutableList", "Array", "Sequence", "ArrayViaList", "idea"})
    public static final class CollectionType
    extends Enum<CollectionType> {
        public static final /* enum */ CollectionType List;
        public static final /* enum */ CollectionType Collection;
        public static final /* enum */ CollectionType Iterable;
        public static final /* enum */ CollectionType MutableList;
        public static final /* enum */ CollectionType Array;
        public static final /* enum */ CollectionType Sequence;
        public static final /* enum */ CollectionType ArrayViaList;
        private static final /* synthetic */ CollectionType[] $VALUES;
        @NotNull
        private final String functionCall;
        @NotNull
        private final FqName fqName;
        private final String nameOverride;

        static {
            CollectionType[] collectionTypeArray = new CollectionType[7];
            CollectionType[] collectionTypeArray2 = collectionTypeArray;
            collectionTypeArray[0] = List = new CollectionType("List", 0, "toList()", new FqName("kotlin.collections.List"), null, 4, null);
            collectionTypeArray[1] = Collection = new CollectionType("Collection", 1, "toList()", new FqName("kotlin.collections.Collection"), null, 4, null);
            collectionTypeArray[2] = Iterable = new CollectionType("Iterable", 2, "toList()", new FqName("kotlin.collections.Iterable"), null, 4, null);
            collectionTypeArray[3] = MutableList = new CollectionType("MutableList", 3, "toMutableList()", new FqName("kotlin.collections.MutableList"), null, 4, null);
            collectionTypeArray[4] = Array = new CollectionType("Array", 4, "toTypedArray()", new FqName("kotlin.Array"), null, 4, null);
            collectionTypeArray[5] = Sequence = new CollectionType("Sequence", 5, "asSequence()", new FqName("kotlin.sequences.Sequence"), null, 4, null);
            collectionTypeArray[6] = ArrayViaList = new CollectionType("toList().toTypedArray()", new FqName("kotlin.Array"), "Array");
            $VALUES = collectionTypeArray;
        }

        @NotNull
        public final String getDisplayName() {
            String string = this.nameOverride;
            if (string == null) {
                string = this.name();
            }
            return string;
        }

        @NotNull
        public final CollectionType specializeFor(@NotNull CollectionType sourceType) {
            Intrinsics.checkParameterIsNotNull((Object)((Object)sourceType), (String)"sourceType");
            return this == Array && sourceType == Sequence ? ArrayViaList : (this == Array && sourceType == Iterable ? ArrayViaList : this);
        }

        @NotNull
        public final String getFunctionCall() {
            return this.functionCall;
        }

        @NotNull
        public final FqName getFqName() {
            return this.fqName;
        }

        protected CollectionType(@Nullable String functionCall, FqName fqName2, String nameOverride) {
            Intrinsics.checkParameterIsNotNull((Object)functionCall, (String)"functionCall");
            Intrinsics.checkParameterIsNotNull((Object)fqName2, (String)"fqName");
            this.functionCall = functionCall;
            this.fqName = fqName2;
            this.nameOverride = nameOverride;
        }

        /* synthetic */ CollectionType(String string, int n, String string2, FqName fqName2, String string3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                string3 = null;
            }
            this(string2, fqName2, string3);
        }

        public static CollectionType[] values() {
            return (CollectionType[])$VALUES.clone();
        }

        public static CollectionType valueOf(String string) {
            return Enum.valueOf(CollectionType.class, string);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u000e\u0010\r\u001a\u0004\u0018\u00010\u0005*\u00020\u000bH\u0002R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/ConvertCollectionFix$Companion;", "", "()V", "TYPES", "", "Lorg/jetbrains/kotlin/idea/quickfix/ConvertCollectionFix$CollectionType;", "getTYPES", "()[Lorg/jetbrains/kotlin/idea/quickfix/ConvertCollectionFix$CollectionType;", "[Lorg/jetbrains/kotlin/idea/quickfix/ConvertCollectionFix$CollectionType;", "getConversionTypeOrNull", "expressionType", "Lorg/jetbrains/kotlin/types/KotlinType;", "expectedType", "getCollectionType", "idea"})
    public static final class Companion {
        private final CollectionType[] getTYPES() {
            return TYPES;
        }

        @Nullable
        public final CollectionType getConversionTypeOrNull(@NotNull KotlinType expressionType, @NotNull KotlinType expectedType2) {
            Intrinsics.checkParameterIsNotNull((Object)expressionType, (String)"expressionType");
            Intrinsics.checkParameterIsNotNull((Object)expectedType2, (String)"expectedType");
            CollectionType collectionType = this.getCollectionType(expressionType);
            if (collectionType == null) {
                return null;
            }
            CollectionType expressionCollectionType = collectionType;
            CollectionType collectionType2 = this.getCollectionType(expectedType2);
            if (collectionType2 == null) {
                return null;
            }
            CollectionType expectedCollectionType = collectionType2;
            Object object = (TypeProjection)CollectionsKt.singleOrNull(expressionType.getArguments());
            if (object == null || (object = object.getType()) == null) {
                return null;
            }
            Object expressionTypeArg = object;
            Object object2 = (TypeProjection)CollectionsKt.singleOrNull(expectedType2.getArguments());
            if (object2 == null || (object2 = object2.getType()) == null) {
                return null;
            }
            Object expectedTypeArg = object2;
            Object object3 = expressionTypeArg;
            Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"expressionTypeArg");
            Object object4 = expectedTypeArg;
            Intrinsics.checkExpressionValueIsNotNull((Object)object4, (String)"expectedTypeArg");
            if (!TypeUtilsKt.isSubtypeOf((KotlinType)object3, (KotlinType)object4)) {
                return null;
            }
            return expectedCollectionType.specializeFor(expressionCollectionType);
        }

        private final CollectionType getCollectionType(@NotNull KotlinType $receiver) {
            Object object;
            block2: {
                if ($receiver.isMarkedNullable()) {
                    return null;
                }
                for (Object element$iv : (Object[])this.getTYPES()) {
                    CollectionType it = (CollectionType)((Object)element$iv);
                    if (!KotlinBuiltIns.isConstructedFromGivenClass($receiver, it.getFqName())) continue;
                    object = element$iv;
                    break block2;
                }
                object = null;
            }
            return (CollectionType)((Object)object);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

