/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.quickfix;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.command.impl.FinishMarkAction;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.searches.MethodReferencesSearch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.CodeInsightUtils;
import org.jetbrains.kotlin.idea.codeInsight.shorten.DelayedRequestsWaitingSetKt;
import org.jetbrains.kotlin.idea.core.CollectingNameValidator;
import org.jetbrains.kotlin.idea.core.KotlinNameSuggester;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.quickfix.InitializePropertyQuickFixFactory;
import org.jetbrains.kotlin.idea.quickfix.KotlinIntentionActionsFactory;
import org.jetbrains.kotlin.idea.quickfix.KotlinQuickFixAction;
import org.jetbrains.kotlin.idea.refactoring.KotlinRefactoringUtilKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureConfiguration;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinChangeSignatureKt;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinMutableMethodDescriptor;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinParameterInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinTypeInfo;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinValVar;
import org.jetbrains.kotlin.idea.refactoring.changeSignature.KotlinValVarKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.DescriptorKindFilter;
import org.jetbrains.kotlin.resolve.scopes.LexicalScope;
import org.jetbrains.kotlin.resolve.scopes.ResolutionScope;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\r\u000e\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0014J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/InitializePropertyQuickFixFactory;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinIntentionActionsFactory;", "()V", "doCreateActions", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "diagnostic", "Lorg/jetbrains/kotlin/diagnostics/Diagnostic;", "noUsagesExist", "", "affectedFunctions", "", "Lcom/intellij/psi/PsiElement;", "AddInitializerFix", "InitializeWithConstructorParameter", "MoveToConstructorParameters", "idea"})
public final class InitializePropertyQuickFixFactory
extends KotlinIntentionActionsFactory {
    public static final InitializePropertyQuickFixFactory INSTANCE;

    /*
     * WARNING - void declaration
     */
    private final boolean noUsagesExist(Collection<? extends PsiElement> affectedFunctions) {
        boolean bl;
        block4: {
            void $receiver$iv$iv;
            Iterable $receiver$iv = affectedFunctions;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                PsiElement it = (PsiElement)element$iv$iv;
                Iterable list$iv$iv = LightClassUtilsKt.toLightMethods(it);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    PsiMethod it = (PsiMethod)element$iv;
                    if (MethodReferencesSearch.search((PsiMethod)it).findFirst() == null) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    protected List<IntentionAction> doCreateActions(@NotNull Diagnostic diagnostic) {
        Intrinsics.checkParameterIsNotNull((Object)diagnostic, (String)"diagnostic");
        PsiElement psiElement2 = diagnostic.getPsiElement();
        if (!(psiElement2 instanceof KtProperty)) {
            psiElement2 = null;
        }
        KtProperty ktProperty = (KtProperty)psiElement2;
        if (ktProperty == null) return CollectionsKt.emptyList();
        KtProperty property2 = ktProperty;
        if (property2.getReceiverTypeReference() != null) {
            return CollectionsKt.emptyList();
        }
        ArrayList<KotlinQuickFixAction> actions = new ArrayList<KotlinQuickFixAction>(2);
        actions.add(new AddInitializerFix(property2));
        KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject(property2);
        if (!(ktClassOrObject instanceof KtClass)) {
            ktClassOrObject = null;
        }
        KtClass ktClass2 = (KtClass)ktClassOrObject;
        if (ktClass2 == null) return actions;
        KtClass ktClass3 = ktClass2;
        KtClass klass2 = ktClass3;
        if (klass2.isAnnotation()) return actions;
        if (klass2.isInterface()) {
            return actions;
        }
        List<KtPropertyAccessor> list2 = property2.getAccessors();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"property.accessors");
        Collection collection = list2;
        if (!(!collection.isEmpty())) {
            boolean bl;
            block9: {
                Iterable $receiver$iv = klass2.getSecondaryConstructors();
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        KtSecondaryConstructor it = (KtSecondaryConstructor)element$iv;
                        if (!(!it.getDelegationCall().isCallToThis())) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            if (!bl) {
                actions.add(new MoveToConstructorParameters(property2));
                return actions;
            }
        }
        actions.add(new InitializeWithConstructorParameter(property2));
        return actions;
    }

    private InitializePropertyQuickFixFactory() {
    }

    static {
        InitializePropertyQuickFixFactory initializePropertyQuickFixFactory;
        INSTANCE = initializePropertyQuickFixFactory = new InitializePropertyQuickFixFactory();
    }

    public static final /* synthetic */ boolean access$noUsagesExist(InitializePropertyQuickFixFactory $this, @NotNull Collection affectedFunctions) {
        return $this.noUsagesExist(affectedFunctions);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\u0006H\u0016J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0014\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/InitializePropertyQuickFixFactory$AddInitializerFix;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "property", "(Lorg/jetbrains/kotlin/psi/KtProperty;)V", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "idea"})
    public static final class AddInitializerFix
    extends KotlinQuickFixAction<KtProperty> {
        @NotNull
        public String getText() {
            return "Add initializer";
        }

        @NotNull
        public String getFamilyName() {
            return this.getText();
        }

        @Override
        protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            KtProperty ktProperty = (KtProperty)this.getElement();
            if (ktProperty == null) {
                return;
            }
            KtProperty element3 = ktProperty;
            DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default(element3, null, 1, null);
            if (!(declarationDescriptor instanceof PropertyDescriptor)) {
                declarationDescriptor = null;
            }
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)declarationDescriptor;
            if (propertyDescriptor == null) {
                return;
            }
            PropertyDescriptor descriptor2 = propertyDescriptor;
            String string = CodeInsightUtils.defaultInitializer(descriptor2.getType());
            if (string == null) {
                string = "null";
            }
            String initializerText = string;
            KtPsiFactory ktPsiFactory = new KtPsiFactory(project, false, 2, null);
            String string2 = initializerText;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"initializerText");
            KtExpression ktExpression = element3.setInitializer(ktPsiFactory.createExpression(string2));
            if (ktExpression == null) {
                Intrinsics.throwNpe();
            }
            KtExpression initializer2 = ktExpression;
            if (editor != null) {
                PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
                SelectionModel selectionModel = editor.getSelectionModel();
                KtExpression ktExpression2 = initializer2;
                Intrinsics.checkExpressionValueIsNotNull((Object)ktExpression2, (String)"initializer");
                selectionModel.setSelection(PsiUtilsKt.getStartOffset((PsiElement)ktExpression2), PsiUtilsKt.getEndOffset((PsiElement)initializer2));
                editor.getCaretModel().moveToOffset(PsiUtilsKt.getEndOffset((PsiElement)initializer2));
            }
        }

        public AddInitializerFix(@NotNull KtProperty property2) {
            Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
            super((PsiElement)property2);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0016\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/InitializePropertyQuickFixFactory$MoveToConstructorParameters;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "property", "(Lorg/jetbrains/kotlin/psi/KtProperty;)V", "configureChangeSignature", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinChangeSignatureConfiguration;", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "startInWriteAction", "", "idea"})
    public static final class MoveToConstructorParameters
    extends KotlinQuickFixAction<KtProperty> {
        @NotNull
        public String getText() {
            return "Move to constructor parameters";
        }

        @NotNull
        public String getFamilyName() {
            return this.getText();
        }

        @Override
        public boolean startInWriteAction() {
            return false;
        }

        private final KotlinChangeSignatureConfiguration configureChangeSignature(KtProperty property2, PropertyDescriptor propertyDescriptor) {
            return new KotlinChangeSignatureConfiguration(propertyDescriptor, property2){
                final /* synthetic */ PropertyDescriptor $propertyDescriptor;
                final /* synthetic */ KtProperty $property;

                @NotNull
                public KotlinMethodDescriptor configure(@NotNull KotlinMethodDescriptor originalDescriptor) {
                    Intrinsics.checkParameterIsNotNull((Object)originalDescriptor, (String)"originalDescriptor");
                    return KotlinChangeSignatureKt.modify(originalDescriptor, (Function1<? super KotlinMutableMethodDescriptor, Unit>)((Function1)new Function1<KotlinMutableMethodDescriptor, Unit>(this, originalDescriptor){
                        final /* synthetic */ configureChangeSignature.1 this$0;
                        final /* synthetic */ KotlinMethodDescriptor $originalDescriptor;

                        public final void invoke(@NotNull KotlinMutableMethodDescriptor it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            String string = CodeInsightUtils.defaultInitializer(this.this$0.$propertyDescriptor.getType());
                            if (string == null) {
                                string = "null";
                            }
                            String initializerText = string;
                            CallableDescriptor callableDescriptor = this.$originalDescriptor.getBaseDescriptor();
                            String string2 = this.this$0.$propertyDescriptor.getName().asString();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"propertyDescriptor.name.asString()");
                            KotlinTypeInfo kotlinTypeInfo = new KotlinTypeInfo(false, this.this$0.$propertyDescriptor.getType(), null, 4, null);
                            KotlinValVar kotlinValVar = KotlinValVarKt.toValVar(this.this$0.$property.getValOrVarKeyword());
                            KtModifierList ktModifierList = this.this$0.$property.getModifierList();
                            Project project = this.this$0.$property.getProject();
                            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"property.project");
                            KtPsiFactory ktPsiFactory = new KtPsiFactory(project, false, 2, null);
                            String string3 = initializerText;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"initializerText");
                            KtExpression ktExpression = ktPsiFactory.createExpression(string3);
                            KtModifierList ktModifierList2 = ktModifierList;
                            KotlinValVar kotlinValVar2 = kotlinValVar;
                            KotlinParameterInfo newParam = new KotlinParameterInfo(callableDescriptor, 0, string2, kotlinTypeInfo, null, ktExpression, kotlinValVar2, ktModifierList2, 18, null);
                            it.addParameter(newParam);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$originalDescriptor = kotlinMethodDescriptor;
                            super(1);
                        }
                    }));
                }

                public boolean performSilently(@NotNull Collection<? extends PsiElement> affectedFunctions) {
                    Intrinsics.checkParameterIsNotNull(affectedFunctions, (String)"affectedFunctions");
                    return InitializePropertyQuickFixFactory.access$noUsagesExist(InitializePropertyQuickFixFactory.INSTANCE, affectedFunctions);
                }
                {
                    this.$propertyDescriptor = $captured_local_variable$0;
                    this.$property = $captured_local_variable$1;
                }

                public boolean forcePerformForSelectedFunctionOnly() {
                    return KotlinChangeSignatureConfiguration.DefaultImpls.forcePerformForSelectedFunctionOnly(this);
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            KtProperty ktProperty = (KtProperty)this.getElement();
            if (ktProperty == null) {
                return;
            }
            KtProperty element3 = ktProperty;
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject(element3);
            if (ktClassOrObject == null) {
                return;
            }
            KtClassOrObject klass2 = ktClassOrObject;
            DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default(element3, null, 1, null);
            if (!(declarationDescriptor instanceof PropertyDescriptor)) {
                declarationDescriptor = null;
            }
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)declarationDescriptor;
            if (propertyDescriptor == null) {
                return;
            }
            PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
            StartMarkAction startMarkAction = StartMarkAction.canStart((Project)project);
            if (startMarkAction != null) {
                StartMarkAction startMarkAction2;
                StartMarkAction it = startMarkAction2 = startMarkAction;
                return;
            }
            StartMarkAction startMarkAction3 = StartMarkAction.start((Editor)editor, (Project)project, (String)this.getText());
            try {
                PsiElement psiElement2;
                ClassConstructorDescriptor classConstructorDescriptor;
                ClassConstructorDescriptor constructorDescriptor;
                ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes;
                KtPsiFactory ktPsiFactory = new KtPsiFactory(project, false, 2, null);
                String string = element3.getText();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"element.text");
                KtParameter parameterToInsert = ktPsiFactory.createParameter(string);
                ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(element3){
                    final /* synthetic */ KtProperty $element;

                    public final void invoke() {
                        this.$element.delete();
                    }
                    {
                        this.$element = ktProperty;
                        super(0);
                    }
                });
                DeclarationDescriptor declarationDescriptor2 = ResolutionUtils.resolveToDescriptorIfAny$default(klass2, null, 1, null);
                if (!(declarationDescriptor2 instanceof ClassDescriptorWithResolutionScopes)) {
                    declarationDescriptor2 = null;
                }
                if ((ClassDescriptorWithResolutionScopes)declarationDescriptor2 == null) {
                    return;
                }
                ClassDescriptorWithResolutionScopes classDescriptor = classDescriptorWithResolutionScopes;
                if (classDescriptor.getUnsubstitutedPrimaryConstructor() == null) {
                    return;
                }
                ClassConstructorDescriptor classConstructorDescriptor2 = constructorDescriptor = classConstructorDescriptor;
                Intrinsics.checkExpressionValueIsNotNull((Object)classConstructorDescriptor2, (String)"constructorDescriptor");
                SourceElement sourceElement = classConstructorDescriptor2.getSource();
                Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"constructorDescriptor.source");
                if (KotlinSourceElementKt.getPsi(sourceElement) == null) {
                    return;
                }
                PsiElement contextElement = psiElement2;
                SmartPsiElementPointer<PsiElement> constructorPointer = PsiUtilsKt.createSmartPointer(contextElement);
                KotlinChangeSignatureConfiguration config2 = this.configureChangeSignature(element3, propertyDescriptor2);
                Function0 changeSignature2 = (Function0)new Function0<Boolean>(this, project, constructorDescriptor, config2, contextElement){
                    final /* synthetic */ MoveToConstructorParameters this$0;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ ClassConstructorDescriptor $constructorDescriptor;
                    final /* synthetic */ KotlinChangeSignatureConfiguration $config;
                    final /* synthetic */ PsiElement $contextElement;

                    public final boolean invoke() {
                        ClassConstructorDescriptor classConstructorDescriptor = this.$constructorDescriptor;
                        Intrinsics.checkExpressionValueIsNotNull((Object)classConstructorDescriptor, (String)"constructorDescriptor");
                        return KotlinChangeSignatureKt.runChangeSignature(this.$project, classConstructorDescriptor, this.$config, this.$contextElement, this.this$0.getText());
                    }
                    {
                        this.this$0 = moveToConstructorParameters;
                        this.$project = project;
                        this.$constructorDescriptor = classConstructorDescriptor;
                        this.$config = kotlinChangeSignatureConfiguration;
                        this.$contextElement = psiElement2;
                        super(0);
                    }
                };
                KotlinRefactoringUtilKt.runRefactoringWithPostprocessing((Function0<? extends Object>)changeSignature2, project, "refactoring.changeSignature", (Function0<Unit>)((Function0)new Function0<Unit>(constructorPointer, parameterToInsert){
                    final /* synthetic */ SmartPsiElementPointer $constructorPointer;
                    final /* synthetic */ KtParameter $parameterToInsert;

                    public final void invoke() {
                        block3: {
                            KtConstructor constructor2;
                            Object object;
                            KtConstructor ktConstructor;
                            PsiElement constructorOrClass = this.$constructorPointer.getElement();
                            PsiElement psiElement2 = constructorOrClass;
                            if (!(psiElement2 instanceof KtConstructor)) {
                                psiElement2 = null;
                            }
                            if ((ktConstructor = (KtConstructor)psiElement2) == null) {
                                PsiElement psiElement3 = constructorOrClass;
                                if (!(psiElement3 instanceof KtClass)) {
                                    psiElement3 = null;
                                }
                                KtClass ktClass2 = (KtClass)psiElement3;
                                ktConstructor = ktClass2 != null ? ktClass2.getPrimaryConstructor() : null;
                            }
                            if ((object = (constructor2 = ktConstructor)) == null || (object = ((KtConstructor)object).getValueParameters()) == null || (object = (KtParameter)CollectionsKt.lastOrNull((List)object)) == null) break block3;
                            object.replace((PsiElement)this.$parameterToInsert);
                        }
                    }
                    {
                        this.$constructorPointer = smartPsiElementPointer;
                        this.$parameterToInsert = ktParameter;
                        super(0);
                    }
                }));
            }
            finally {
                FinishMarkAction.finish((Project)project, (Editor)editor, (StartMarkAction)startMarkAction3);
            }
        }

        public MoveToConstructorParameters(@NotNull KtProperty property2) {
            Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
            super((PsiElement)property2);
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J\"\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0014J6\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u000e\b\u0002\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/quickfix/InitializePropertyQuickFixFactory$InitializeWithConstructorParameter;", "Lorg/jetbrains/kotlin/idea/quickfix/KotlinQuickFixAction;", "Lorg/jetbrains/kotlin/psi/KtProperty;", "property", "(Lorg/jetbrains/kotlin/psi/KtProperty;)V", "configureChangeSignature", "Lorg/jetbrains/kotlin/idea/refactoring/changeSignature/KotlinChangeSignatureConfiguration;", "propertyDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "getFamilyName", "", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "processConstructors", "descriptorsToProcess", "", "Lorg/jetbrains/kotlin/descriptors/ConstructorDescriptor;", "visitedElements", "", "Lcom/intellij/psi/PsiElement;", "startInWriteAction", "", "idea"})
    public static final class InitializeWithConstructorParameter
    extends KotlinQuickFixAction<KtProperty> {
        @NotNull
        public String getText() {
            return "Initialize with constructor parameter";
        }

        @NotNull
        public String getFamilyName() {
            return this.getText();
        }

        @Override
        public boolean startInWriteAction() {
            return false;
        }

        private final KotlinChangeSignatureConfiguration configureChangeSignature(PropertyDescriptor propertyDescriptor) {
            return new KotlinChangeSignatureConfiguration(this, propertyDescriptor){
                final /* synthetic */ InitializeWithConstructorParameter this$0;
                final /* synthetic */ PropertyDescriptor $propertyDescriptor;

                @NotNull
                public KotlinMethodDescriptor configure(@NotNull KotlinMethodDescriptor originalDescriptor) {
                    Intrinsics.checkParameterIsNotNull((Object)originalDescriptor, (String)"originalDescriptor");
                    return KotlinChangeSignatureKt.modify(originalDescriptor, (Function1<? super KotlinMutableMethodDescriptor, Unit>)((Function1)new Function1<KotlinMutableMethodDescriptor, Unit>(this, originalDescriptor){
                        final /* synthetic */ configureChangeSignature.1 this$0;
                        final /* synthetic */ KotlinMethodDescriptor $originalDescriptor;

                        /*
                         * WARNING - void declaration
                         */
                        public final void invoke(@NotNull KotlinMutableMethodDescriptor it) {
                            Collection<String> collection;
                            void $receiver$iv$iv;
                            Iterable $receiver$iv;
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            DeclarationDescriptor declarationDescriptor = this.this$0.$propertyDescriptor.getContainingDeclaration();
                            if (declarationDescriptor == null) {
                                throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptorWithResolutionScopes");
                            }
                            ClassDescriptorWithResolutionScopes classDescriptor = (ClassDescriptorWithResolutionScopes)declarationDescriptor;
                            LexicalScope constructorScope = classDescriptor.getScopeForClassHeaderResolution();
                            List list2 = this.$originalDescriptor.getParameters();
                            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"originalDescriptor.parameters");
                            Iterable iterable = $receiver$iv = (Iterable)list2;
                            Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                            for (T item$iv$iv : $receiver$iv$iv) {
                                void it2;
                                KotlinParameterInfo kotlinParameterInfo = (KotlinParameterInfo)item$iv$iv;
                                collection = destination$iv$iv;
                                void v2 = it2;
                                Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
                                String string = v2.getName();
                                collection.add(string);
                            }
                            collection = (List)destination$iv$iv;
                            Function1 function1 = (Function1)new Function1<String, Boolean>(constructorScope){
                                final /* synthetic */ LexicalScope $constructorScope;

                                public final boolean invoke(@NotNull String name2) {
                                    boolean bl;
                                    block3: {
                                        Intrinsics.checkParameterIsNotNull((Object)name2, (String)"name");
                                        Iterable $receiver$iv = ResolutionScope.DefaultImpls.getContributedDescriptors$default(this.$constructorScope, DescriptorKindFilter.VARIABLES, null, 2, null);
                                        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                                            bl = true;
                                        } else {
                                            for (T element$iv : $receiver$iv) {
                                                DeclarationDescriptor it = (DeclarationDescriptor)element$iv;
                                                if (!(it instanceof VariableDescriptor) || Intrinsics.areEqual((Object)((VariableDescriptor)it).getName().asString(), (Object)name2) ^ true) continue;
                                                bl = false;
                                                break block3;
                                            }
                                            bl = true;
                                        }
                                    }
                                    return bl;
                                }
                                {
                                    this.$constructorScope = lexicalScope;
                                    super(1);
                                }
                            };
                            Collection collection2 = collection;
                            CollectingNameValidator validator2 = new CollectingNameValidator(collection2, (Function1<? super String, Boolean>)function1);
                            String string = CodeInsightUtils.defaultInitializer(this.this$0.$propertyDescriptor.getType());
                            if (string == null) {
                                string = "null";
                            }
                            String initializerText = string;
                            CallableDescriptor callableDescriptor = this.$originalDescriptor.getBaseDescriptor();
                            String string2 = this.this$0.$propertyDescriptor.getName().asString();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"propertyDescriptor.name.asString()");
                            String string3 = KotlinNameSuggester.INSTANCE.suggestNameByName(string2, (Function1<? super String, Boolean>)((Function1)validator2));
                            KotlinTypeInfo kotlinTypeInfo = new KotlinTypeInfo(false, this.this$0.$propertyDescriptor.getType(), null, 4, null);
                            T t = this.this$0.this$0.getElement();
                            if (t == null) {
                                Intrinsics.throwNpe();
                            }
                            Project project = ((KtProperty)t).getProject();
                            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"element!!.project");
                            KtPsiFactory ktPsiFactory = new KtPsiFactory(project, false, 2, null);
                            String string4 = initializerText;
                            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"initializerText");
                            KotlinParameterInfo newParam = new KotlinParameterInfo(callableDescriptor, 0, string3, kotlinTypeInfo, null, ktPsiFactory.createExpression(string4), null, null, 210, null);
                            it.addParameter(newParam);
                        }
                        {
                            this.this$0 = var1_1;
                            this.$originalDescriptor = kotlinMethodDescriptor;
                            super(1);
                        }
                    }));
                }

                public boolean performSilently(@NotNull Collection<? extends PsiElement> affectedFunctions) {
                    Intrinsics.checkParameterIsNotNull(affectedFunctions, (String)"affectedFunctions");
                    return InitializePropertyQuickFixFactory.access$noUsagesExist(InitializePropertyQuickFixFactory.INSTANCE, affectedFunctions);
                }
                {
                    this.this$0 = $outer;
                    this.$propertyDescriptor = $captured_local_variable$1;
                }

                public boolean forcePerformForSelectedFunctionOnly() {
                    return KotlinChangeSignatureConfiguration.DefaultImpls.forcePerformForSelectedFunctionOnly(this);
                }
            };
        }

        private final void processConstructors(Project project, PropertyDescriptor propertyDescriptor, Iterator<? extends ConstructorDescriptor> descriptorsToProcess, Set<PsiElement> visitedElements) {
            Object t = this.getElement();
            if (t == null) {
                Intrinsics.throwNpe();
            }
            KtProperty element3 = (KtProperty)t;
            if (!descriptorsToProcess.hasNext()) {
                return;
            }
            ConstructorDescriptor descriptor2 = descriptorsToProcess.next();
            SourceElement sourceElement = descriptor2.getSource();
            Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"descriptor.source");
            PsiElement psiElement2 = KotlinSourceElementKt.getPsi(sourceElement);
            SmartPsiElementPointer<PsiElement> constructorPointer = psiElement2 != null ? PsiUtilsKt.createSmartPointer(psiElement2) : null;
            KotlinChangeSignatureConfiguration config2 = this.configureChangeSignature(propertyDescriptor);
            Function0 changeSignature2 = (Function0)new Function0<Boolean>(this, project, descriptor2, config2, element3){
                final /* synthetic */ InitializeWithConstructorParameter this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ ConstructorDescriptor $descriptor;
                final /* synthetic */ KotlinChangeSignatureConfiguration $config;
                final /* synthetic */ KtProperty $element;

                public final boolean invoke() {
                    CallableDescriptor callableDescriptor = this.$descriptor;
                    KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject(this.$element);
                    if (ktClassOrObject == null) {
                        Intrinsics.throwNpe();
                    }
                    return KotlinChangeSignatureKt.runChangeSignature(this.$project, callableDescriptor, this.$config, ktClassOrObject, this.this$0.getText());
                }
                {
                    this.this$0 = initializeWithConstructorParameter;
                    this.$project = project;
                    this.$descriptor = constructorDescriptor;
                    this.$config = kotlinChangeSignatureConfiguration;
                    this.$element = ktProperty;
                    super(0);
                }
            };
            KotlinRefactoringUtilKt.runRefactoringWithPostprocessing((Function0<? extends Object>)changeSignature2, project, "refactoring.changeSignature", (Function0<Unit>)((Function0)new Function0<Unit>(this, constructorPointer, visitedElements, project, element3, propertyDescriptor, descriptorsToProcess){
                final /* synthetic */ InitializeWithConstructorParameter this$0;
                final /* synthetic */ SmartPsiElementPointer $constructorPointer;
                final /* synthetic */ Set $visitedElements;
                final /* synthetic */ Project $project;
                final /* synthetic */ KtProperty $element;
                final /* synthetic */ PropertyDescriptor $propertyDescriptor;
                final /* synthetic */ Iterator $descriptorsToProcess;

                public final void invoke() {
                    block11: {
                        KtElement ktElement;
                        block9: {
                            KtPsiFactory psiFactory;
                            KtParameter newParam;
                            block10: {
                                KtParameter ktParameter;
                                KtConstructor constructor2;
                                KtConstructor ktConstructor;
                                SmartPsiElementPointer smartPsiElementPointer = this.$constructorPointer;
                                Object constructorOrClass = smartPsiElementPointer != null ? smartPsiElementPointer.getElement() : null;
                                PsiElement psiElement2 = constructorOrClass;
                                if (!(psiElement2 instanceof KtConstructor)) {
                                    psiElement2 = null;
                                }
                                if ((ktConstructor = (KtConstructor)psiElement2) == null) {
                                    PsiElement psiElement3 = constructorOrClass;
                                    if (!(psiElement3 instanceof KtClass)) {
                                        psiElement3 = null;
                                    }
                                    KtClass ktClass2 = (KtClass)psiElement3;
                                    ktConstructor = constructor2 = (KtConstructor)(ktClass2 != null ? ktClass2.getPrimaryConstructor() : null);
                                }
                                if (constructor2 == null || !this.$visitedElements.add(constructor2)) {
                                    return;
                                }
                                KtParameter ktParameter2 = (KtParameter)CollectionsKt.lastOrNull(constructor2.getValueParameters());
                                if (ktParameter2 == null) break block9;
                                newParam = ktParameter = ktParameter2;
                                psiFactory = new KtPsiFactory(this.$project, false, 2, null);
                                KtConstructor ktConstructor2 = constructor2;
                                if (!(ktConstructor2 instanceof KtSecondaryConstructor)) {
                                    ktConstructor2 = null;
                                }
                                if ((ktElement = (KtSecondaryConstructor)ktConstructor2) == null || (ktElement = PsiModificationUtilsKt.getOrCreateBody(ktElement)) == null) break block10;
                                StringBuilder stringBuilder = new StringBuilder().append("this.").append(this.$element.getName()).append(" = ");
                                String string = newParam.getName();
                                if (string == null) {
                                    Intrinsics.throwNpe();
                                }
                                if ((ktElement = PsiModificationUtilsKt.appendElement$default((KtBlockExpression)ktElement, psiFactory.createExpression(stringBuilder.append(string).toString()), false, 2, null)) != null) break block11;
                            }
                            String string = newParam.getName();
                            if (string == null) {
                                Intrinsics.throwNpe();
                            }
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"newParam.name!!");
                            ktElement = this.$element.setInitializer(psiFactory.createExpression(string));
                            break block11;
                        }
                        ktElement = null;
                    }
                    InitializeWithConstructorParameter.processConstructors$default(this.this$0, this.$project, this.$propertyDescriptor, this.$descriptorsToProcess, null, 8, null);
                }
                {
                    this.this$0 = initializeWithConstructorParameter;
                    this.$constructorPointer = smartPsiElementPointer;
                    this.$visitedElements = set2;
                    this.$project = project;
                    this.$element = ktProperty;
                    this.$propertyDescriptor = propertyDescriptor;
                    this.$descriptorsToProcess = iterator2;
                    super(0);
                }
            }));
        }

        static /* bridge */ /* synthetic */ void processConstructors$default(InitializeWithConstructorParameter initializeWithConstructorParameter, Project project, PropertyDescriptor propertyDescriptor, Iterator iterator2, Set set2, int n, Object object) {
            if ((n & 8) != 0) {
                set2 = new HashSet();
            }
            initializeWithConstructorParameter.processConstructors(project, propertyDescriptor, iterator2, set2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull KtFile file2) {
            List list2;
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            KtProperty ktProperty = (KtProperty)this.getElement();
            if (ktProperty == null) {
                return;
            }
            KtProperty element3 = ktProperty;
            DeclarationDescriptor declarationDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default(element3, null, 1, null);
            if (!(declarationDescriptor instanceof PropertyDescriptor)) {
                declarationDescriptor = null;
            }
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)declarationDescriptor;
            if (propertyDescriptor == null) {
                return;
            }
            PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
            DeclarationDescriptor declarationDescriptor2 = propertyDescriptor2.getContainingDeclaration();
            if (!(declarationDescriptor2 instanceof ClassDescriptorWithResolutionScopes)) {
                declarationDescriptor2 = null;
            }
            ClassDescriptorWithResolutionScopes classDescriptorWithResolutionScopes = (ClassDescriptorWithResolutionScopes)declarationDescriptor2;
            if (classDescriptorWithResolutionScopes == null) {
                return;
            }
            ClassDescriptorWithResolutionScopes classDescriptor = classDescriptorWithResolutionScopes;
            KtClassOrObject ktClassOrObject = KtPsiUtilKt.getContainingClassOrObject(element3);
            if (ktClassOrObject == null) {
                return;
            }
            KtClassOrObject klass2 = ktClassOrObject;
            if (klass2.hasExplicitPrimaryConstructor() || klass2.getSecondaryConstructors().isEmpty()) {
                ClassConstructorDescriptor classConstructorDescriptor = classDescriptor.getUnsubstitutedPrimaryConstructor();
                if (classConstructorDescriptor == null) {
                    Intrinsics.throwNpe();
                }
                list2 = CollectionsKt.listOf((Object)classConstructorDescriptor);
            } else {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable = $receiver$iv = (Iterable)DescriptorUtilsKt.getSecondaryConstructors(classDescriptor);
                Collection destination$iv$iv = new ArrayList();
                for (Object element$iv$iv : $receiver$iv$iv) {
                    KtSecondaryConstructor constructor2;
                    ClassConstructorDescriptor it = (ClassConstructorDescriptor)element$iv$iv;
                    SourceElement sourceElement = it.getSource();
                    Intrinsics.checkExpressionValueIsNotNull((Object)sourceElement, (String)"it.source");
                    PsiElement psiElement2 = KotlinSourceElementKt.getPsi(sourceElement);
                    if (!(psiElement2 instanceof KtSecondaryConstructor)) {
                        psiElement2 = null;
                    }
                    boolean bl = (constructor2 = (KtSecondaryConstructor)psiElement2) != null && !constructor2.getDelegationCall().isCallToThis();
                    if (!bl) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            }
            List constructorDescriptors = list2;
            DelayedRequestsWaitingSetKt.runRefactoringAndKeepDelayedRequests(project, (Function0<Unit>)((Function0)new Function0<Unit>(this, project, propertyDescriptor2, constructorDescriptors){
                final /* synthetic */ InitializeWithConstructorParameter this$0;
                final /* synthetic */ Project $project;
                final /* synthetic */ PropertyDescriptor $propertyDescriptor;
                final /* synthetic */ List $constructorDescriptors;

                public final void invoke() {
                    InitializeWithConstructorParameter.processConstructors$default(this.this$0, this.$project, this.$propertyDescriptor, this.$constructorDescriptors.iterator(), null, 8, null);
                }
                {
                    this.this$0 = initializeWithConstructorParameter;
                    this.$project = project;
                    this.$propertyDescriptor = propertyDescriptor;
                    this.$constructorDescriptors = list2;
                    super(0);
                }
            }));
        }

        public InitializeWithConstructorParameter(@NotNull KtProperty property2) {
            Intrinsics.checkParameterIsNotNull((Object)property2, (String)"property");
            super((PsiElement)property2);
        }
    }
}

