/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.serialization;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.jcip.annotations.ThreadSafe;
import org.gradle.api.Transformer;
import org.gradle.internal.classloader.ClassLoaderUtils;
import org.gradle.tooling.internal.provider.serialization.ClassLoaderDetails;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafe
public class ClassLoaderCache {
    private final Lock lock = new ReentrantLock();
    private final Cache<ClassLoader, ClassLoaderDetails> classLoaderDetails = CacheBuilder.newBuilder().weakKeys().build();
    private final Cache<UUID, ClassLoader> classLoaderIds = CacheBuilder.newBuilder().softValues().build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getClassLoader(ClassLoaderDetails details, Transformer<ClassLoader, ClassLoaderDetails> factory) {
        this.lock.lock();
        try {
            ClassLoader classLoader = (ClassLoader)this.classLoaderIds.getIfPresent((Object)details.uuid);
            if (classLoader != null) {
                ClassLoader classLoader2 = classLoader;
                return classLoader2;
            }
            classLoader = (ClassLoader)factory.transform((Object)details);
            this.classLoaderIds.put((Object)details.uuid, (Object)classLoader);
            this.classLoaderDetails.put((Object)classLoader, (Object)details);
            ClassLoader classLoader3 = classLoader;
            return classLoader3;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ClassLoaderDetails maybeGetDetails(ClassLoader classLoader) {
        this.lock.lock();
        try {
            ClassLoaderDetails classLoaderDetails = (ClassLoaderDetails)this.classLoaderDetails.getIfPresent((Object)classLoader);
            return classLoaderDetails;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoaderDetails getDetails(ClassLoader classLoader, Transformer<ClassLoaderDetails, ClassLoader> factory) {
        this.lock.lock();
        try {
            ClassLoaderDetails details = (ClassLoaderDetails)this.classLoaderDetails.getIfPresent((Object)classLoader);
            if (details != null) {
                ClassLoaderDetails classLoaderDetails = details;
                return classLoaderDetails;
            }
            details = (ClassLoaderDetails)factory.transform((Object)classLoader);
            this.classLoaderDetails.put((Object)classLoader, (Object)details);
            this.classLoaderIds.put((Object)details.uuid, (Object)classLoader);
            ClassLoaderDetails classLoaderDetails = details;
            return classLoaderDetails;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lock.lock();
        try {
            for (ClassLoader classLoader : this.classLoaderDetails.asMap().keySet()) {
                ClassLoaderUtils.tryClose((ClassLoader)classLoader);
            }
            this.classLoaderDetails.invalidateAll();
            this.classLoaderIds.invalidateAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

