/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.settings;

import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.List;
import java.util.Optional;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.data.BuildParticipant;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.settings.CompositeDefinitionSource;
import org.jetbrains.plugins.gradle.settings.DistributionType;

public class GradleProjectSettings
extends ExternalProjectSettings {
    @Nullable
    private String myGradleHome;
    @Nullable
    private String myGradleJvm = "#USE_PROJECT_JDK";
    @Nullable
    private DistributionType distributionType;
    private boolean disableWrapperSourceDistributionNotification;
    private boolean resolveModulePerSourceSet = true;
    @Nullable
    private CompositeBuild myCompositeBuild;
    private ThreeState storeProjectFilesExternally = ThreeState.NO;

    @Nullable
    public String getGradleHome() {
        return this.myGradleHome;
    }

    public void setGradleHome(@Nullable String gradleHome) {
        this.myGradleHome = gradleHome;
    }

    @Nullable
    public String getGradleJvm() {
        return this.myGradleJvm;
    }

    public void setGradleJvm(@Nullable String gradleJvm) {
        this.myGradleJvm = gradleJvm;
    }

    @Nullable
    public DistributionType getDistributionType() {
        return this.distributionType;
    }

    public void setDistributionType(@Nullable DistributionType distributionType) {
        this.distributionType = distributionType;
    }

    public boolean isDisableWrapperSourceDistributionNotification() {
        return this.disableWrapperSourceDistributionNotification;
    }

    public void setDisableWrapperSourceDistributionNotification(boolean disableWrapperSourceDistributionNotification) {
        this.disableWrapperSourceDistributionNotification = disableWrapperSourceDistributionNotification;
    }

    public boolean isResolveModulePerSourceSet() {
        return this.resolveModulePerSourceSet;
    }

    public void setResolveModulePerSourceSet(boolean useIdeModulePerSourceSet) {
        this.resolveModulePerSourceSet = useIdeModulePerSourceSet;
    }

    @OptionTag(tag="compositeConfiguration", nameAttribute="")
    @Nullable
    public CompositeBuild getCompositeBuild() {
        return this.myCompositeBuild;
    }

    public void setCompositeBuild(@Nullable CompositeBuild compositeBuild) {
        this.myCompositeBuild = compositeBuild;
    }

    @NotNull
    public GradleProjectSettings clone() {
        GradleProjectSettings result = new GradleProjectSettings();
        this.copyTo(result);
        result.myGradleHome = this.myGradleHome;
        result.myGradleJvm = this.myGradleJvm;
        result.distributionType = this.distributionType;
        result.disableWrapperSourceDistributionNotification = this.disableWrapperSourceDistributionNotification;
        result.resolveModulePerSourceSet = this.resolveModulePerSourceSet;
        result.myCompositeBuild = this.myCompositeBuild != null ? this.myCompositeBuild.copy() : null;
        GradleProjectSettings gradleProjectSettings = result;
        if (gradleProjectSettings == null) {
            GradleProjectSettings.$$$reportNull$$$0(0);
        }
        return gradleProjectSettings;
    }

    @Transient
    public ThreeState getStoreProjectFilesExternally() {
        return this.storeProjectFilesExternally;
    }

    public void setStoreProjectFilesExternally(@NotNull ThreeState value) {
        if (value == null) {
            GradleProjectSettings.$$$reportNull$$$0(1);
        }
        this.storeProjectFilesExternally = value;
    }

    @NotNull
    public GradleVersion resolveGradleVersion() {
        GradleVersion version = GradleInstallationManager.getGradleVersion(this);
        GradleVersion gradleVersion = Optional.ofNullable(version).orElseGet(GradleVersion::current);
        if (gradleVersion == null) {
            GradleProjectSettings.$$$reportNull$$$0(2);
        }
        return gradleVersion;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/settings/GradleProjectSettings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "clone";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/settings/GradleProjectSettings";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveGradleVersion";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setStoreProjectFilesExternally";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Tag(value="compositeBuild")
    public static class CompositeBuild {
        @Nullable
        private CompositeDefinitionSource myCompositeDefinitionSource;
        private List<BuildParticipant> myCompositeParticipants = new SmartList();

        @Attribute
        @Nullable
        public CompositeDefinitionSource getCompositeDefinitionSource() {
            return this.myCompositeDefinitionSource;
        }

        public void setCompositeDefinitionSource(@Nullable CompositeDefinitionSource compositeDefinitionSource) {
            this.myCompositeDefinitionSource = compositeDefinitionSource;
        }

        @XCollection(propertyElementName="builds", elementName="build")
        @NotNull
        public List<BuildParticipant> getCompositeParticipants() {
            List<BuildParticipant> list = this.myCompositeParticipants;
            if (list == null) {
                CompositeBuild.$$$reportNull$$$0(0);
            }
            return list;
        }

        public void setCompositeParticipants(List<BuildParticipant> compositeParticipants) {
            this.myCompositeParticipants = compositeParticipants == null ? new SmartList() : ContainerUtil.newArrayList(compositeParticipants);
        }

        @NotNull
        public CompositeBuild copy() {
            CompositeBuild result = new CompositeBuild();
            result.myCompositeParticipants = ContainerUtil.newArrayList();
            for (BuildParticipant participant : this.myCompositeParticipants) {
                result.myCompositeParticipants.add(participant.copy());
            }
            result.myCompositeDefinitionSource = this.myCompositeDefinitionSource;
            CompositeBuild compositeBuild = result;
            if (compositeBuild == null) {
                CompositeBuild.$$$reportNull$$$0(1);
            }
            return compositeBuild;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/plugins/gradle/settings/GradleProjectSettings$CompositeBuild";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCompositeParticipants";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "copy";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

