/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.highlighting.syntax;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.util.TextRange;
import com.intellij.struts.dom.validator.FormValidation;
import com.intellij.struts.dom.validator.Var;
import com.intellij.struts.highlighting.syntax.DomAnnotatorComponentBase;
import com.intellij.struts.highlighting.syntax.DomAnnotatorVisitor;
import com.intellij.util.xml.GenericDomValue;

public class ValidatorSyntaxAnnotator
extends DomAnnotatorComponentBase<FormValidation> {
    public ValidatorSyntaxAnnotator() {
        super(FormValidation.class);
    }

    @Override
    protected DomAnnotatorVisitor buildVisitor(final AnnotationHolder holder) {
        return new DomAnnotatorVisitor(holder){

            public void visitVar(Var var) {
                GenericDomValue<String> varValue = var.getVarValue();
                String value = varValue.getStringValue();
                if (value == null) {
                    return;
                }
                boolean expressionStart = value.startsWith("${");
                boolean expressionEnd = value.endsWith("}");
                if (expressionStart && !expressionEnd || !expressionStart && expressionEnd) {
                    TextRange textRange = varValue.ensureTagExists().getValue().getTextRange();
                    int existingBraceOffset = expressionStart ? textRange.getStartOffset() + 1 : textRange.getEndOffset() - 1;
                    holder.createErrorAnnotation(new TextRange(existingBraceOffset, existingBraceOffset + 1), "Unmatched brace").setTextAttributes(CodeInsightColors.UNMATCHED_BRACE_ATTRIBUTES);
                }
            }
        };
    }
}

