/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts.inplace.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.struts.StrutsBundle;
import com.intellij.struts.StrutsManager;
import com.intellij.struts.StrutsModel;
import com.intellij.struts.ValidationModel;
import com.intellij.struts.dom.Action;
import com.intellij.struts.dom.FormBean;
import com.intellij.struts.dom.validator.Form;
import com.intellij.struts.dom.validator.FormValidation;
import com.intellij.struts.dom.validator.Formset;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ValidatorFormInspection
extends DomElementsInspection<FormValidation> {
    public ValidatorFormInspection() {
        super(FormValidation.class, new Class[0]);
    }

    @NotNull
    public String[] getGroupPath() {
        String[] stringArray = new String[]{"Struts", this.getGroupDisplayName()};
        if (stringArray == null) {
            ValidatorFormInspection.$$$reportNull$$$0(0);
        }
        return stringArray;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("StrutsValidatorFormInspection" == null) {
            ValidatorFormInspection.$$$reportNull$$$0(1);
        }
        return "StrutsValidatorFormInspection";
    }

    public void checkFileElement(DomFileElement<FormValidation> fileElement, DomElementAnnotationHolder holder) {
        XmlFile xmlFile = fileElement.getFile();
        ValidationModel validationModel = StrutsManager.getInstance().getValidation((PsiElement)xmlFile);
        if (validationModel == null) {
            return;
        }
        StrutsModel strutsModel = validationModel.getStrutsModel();
        FormValidation formValidation = (FormValidation)fileElement.getRootElement();
        Project project = xmlFile.getProject();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        GlobalSearchScope scope = GlobalSearchScope.allScope((Project)project);
        PsiClass validatorForm = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass("org.apache.struts.validator.ValidatorForm", scope);
        PsiClass dynaValidatorForm = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass("org.apache.struts.validator.DynaValidatorForm", scope);
        PsiClass validatorActionForm = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass("org.apache.struts.validator.ValidatorActionForm", scope);
        PsiClass dynaValidatorActionForm = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass("org.apache.struts.validator.DynaValidatorActionForm", scope);
        PsiClass beanValidatorForm = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass("org.apache.struts.validator.BeanValidatorForm", scope);
        for (Formset formset : formValidation.getFormsets()) {
            for (Form form : formset.getForms()) {
                FormBean bean;
                Action action;
                String formName = form.getName().getStringValue();
                if (!StringUtil.isNotEmpty((String)formName)) continue;
                GenericAttributeValue<String> element = form.getName();
                if (formName.startsWith("/") && (action = strutsModel.findAction(formName)) != null) {
                    ValidatorFormInspection.checkAction(action, element, holder, validatorActionForm, dynaValidatorActionForm);
                }
                if ((bean = strutsModel.findFormBean(formName)) != null) {
                    ValidatorFormInspection.checkFormBean(bean, element, holder, validatorForm, dynaValidatorForm);
                    continue;
                }
                Action action2 = strutsModel.findAction("/" + formName);
                if (action2 == null) continue;
                ValidatorFormInspection.checkAction(action2, element, holder, beanValidatorForm);
            }
        }
    }

    private static void checkFormBean(FormBean formBean, GenericAttributeValue<String> formName, DomElementAnnotationHolder holder, PsiClass ... requiredClass) {
        PsiClass psiClass = (PsiClass)formBean.getType().getValue();
        if (psiClass == null) {
            holder.createProblem(formName, StrutsBundle.message("inspections.validator.form.not.valid.type", new Object[0]), new LocalQuickFix[0]);
        } else {
            PsiClass wanted = null;
            for (PsiClass required : requiredClass) {
                if (required == null) continue;
                if (!InheritanceUtil.isInheritorOrSelf((PsiClass)psiClass, (PsiClass)required, (boolean)true)) {
                    wanted = required;
                    continue;
                }
                return;
            }
            if (wanted != null) {
                holder.createProblem(formName, StrutsBundle.message("inspections.validator.form.not", wanted.getName()), new LocalQuickFix[0]);
            }
        }
    }

    private static void checkAction(Action action, GenericAttributeValue<String> formName, DomElementAnnotationHolder holder, PsiClass ... requiredClass) {
        FormBean formBean = (FormBean)action.getName().getValue();
        if (formBean == null) {
            holder.createProblem(formName, StrutsBundle.message("inspections.validator.form.no.form.bean", new Object[0]), new LocalQuickFix[0]);
        } else {
            ValidatorFormInspection.checkFormBean(formBean, formName, holder, requiredClass);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/struts/inplace/inspections/ValidatorFormInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupPath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

